/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.PendingIntent;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class RemoteViews
implements Parcelable,
LayoutInflater.Filter {
    public static final String LOG_TAG = "RemoteViews";
    public String mPackage;
    public int mLayoutId;
    public Context mContext;
    public ArrayList<Action> mActions;
    public static final Parcelable.Creator<RemoteViews> CREATOR = new Parcelable.Creator<RemoteViews>(){

        @Override
        public RemoteViews createFromParcel(Parcel parcel) {
            return new RemoteViews(parcel);
        }

        public RemoteViews[] newArray(int size) {
            return new RemoteViews[size];
        }
    };

    public RemoteViews(String packageName, int layoutId) {
        this.mPackage = packageName;
        this.mLayoutId = layoutId;
    }

    public RemoteViews(Parcel parcel) {
        this.mPackage = parcel.readString();
        this.mLayoutId = parcel.readInt();
        int count = parcel.readInt();
        if (count > 0) {
            this.mActions = new ArrayList(count);
            block5: for (int i = 0; i < count; ++i) {
                int tag = parcel.readInt();
                switch (tag) {
                    case 1: {
                        this.mActions.add(new SetOnClickPendingIntent(parcel));
                        continue block5;
                    }
                    case 3: {
                        this.mActions.add(new SetDrawableParameters(parcel));
                        continue block5;
                    }
                    case 2: {
                        this.mActions.add(new ReflectionAction(parcel));
                        continue block5;
                    }
                    default: {
                        throw new ActionException("Tag " + tag + " not found");
                    }
                }
            }
        }
    }

    public String getPackage() {
        return this.mPackage;
    }

    public int getLayoutId() {
        return this.mLayoutId;
    }

    public void addAction(Action a) {
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        this.mActions.add(a);
    }

    public void setViewVisibility(int viewId, int visibility) {
        this.setInt(viewId, "setVisibility", visibility);
    }

    public void setTextViewText(int viewId, CharSequence text) {
        this.setCharSequence(viewId, "setText", text);
    }

    public void setImageViewResource(int viewId, int srcId) {
        this.setInt(viewId, "setImageResource", srcId);
    }

    public void setImageViewUri(int viewId, Uri uri) {
        this.setUri(viewId, "setImageURI", uri);
    }

    public void setImageViewBitmap(int viewId, Bitmap bitmap) {
        this.setBitmap(viewId, "setImageBitmap", bitmap);
    }

    public void setChronometer(int viewId, long base, String format, boolean started) {
        this.setLong(viewId, "setBase", base);
        this.setString(viewId, "setFormat", format);
        this.setBoolean(viewId, "setStarted", started);
    }

    public void setProgressBar(int viewId, int max, int progress, boolean indeterminate) {
        this.setBoolean(viewId, "setIndeterminate", indeterminate);
        if (!indeterminate) {
            this.setInt(viewId, "setMax", max);
            this.setInt(viewId, "setProgress", progress);
        }
    }

    public void setOnClickPendingIntent(int viewId, PendingIntent pendingIntent) {
        this.addAction(new SetOnClickPendingIntent(viewId, pendingIntent));
    }

    public void setDrawableParameters(int viewId, boolean targetBackground, int alpha, int colorFilter, PorterDuff.Mode mode, int level) {
        this.addAction(new SetDrawableParameters(viewId, targetBackground, alpha, colorFilter, mode, level));
    }

    public void setTextColor(int viewId, int color2) {
        this.setInt(viewId, "setTextColor", color2);
    }

    public void setBoolean(int viewId, String methodName, boolean value) {
        this.addAction(new ReflectionAction(viewId, methodName, 1, value));
    }

    public void setByte(int viewId, String methodName, byte value) {
        this.addAction(new ReflectionAction(viewId, methodName, 2, value));
    }

    public void setShort(int viewId, String methodName, short value) {
        this.addAction(new ReflectionAction(viewId, methodName, 3, value));
    }

    public void setInt(int viewId, String methodName, int value) {
        this.addAction(new ReflectionAction(viewId, methodName, 4, value));
    }

    public void setLong(int viewId, String methodName, long value) {
        this.addAction(new ReflectionAction(viewId, methodName, 5, value));
    }

    public void setFloat(int viewId, String methodName, float value) {
        this.addAction(new ReflectionAction(viewId, methodName, 6, Float.valueOf(value)));
    }

    public void setDouble(int viewId, String methodName, double value) {
        this.addAction(new ReflectionAction(viewId, methodName, 7, value));
    }

    public void setChar(int viewId, String methodName, char value) {
        this.addAction(new ReflectionAction(viewId, methodName, 8, Character.valueOf(value)));
    }

    public void setString(int viewId, String methodName, String value) {
        this.addAction(new ReflectionAction(viewId, methodName, 9, value));
    }

    public void setCharSequence(int viewId, String methodName, CharSequence value) {
        this.addAction(new ReflectionAction(viewId, methodName, 10, value));
    }

    public void setUri(int viewId, String methodName, Uri value) {
        this.addAction(new ReflectionAction(viewId, methodName, 11, value));
    }

    public void setBitmap(int viewId, String methodName, Bitmap value) {
        this.addAction(new ReflectionAction(viewId, methodName, 12, value));
    }

    public View apply(Context context, ViewGroup parent) {
        View result = null;
        Context c = this.prepareContext(context);
        Resources r = c.getResources();
        LayoutInflater inflater = (LayoutInflater)c.getSystemService("layout_inflater");
        inflater = inflater.cloneInContext(c);
        inflater.setFilter(this);
        result = inflater.inflate(this.mLayoutId, parent, false);
        this.performApply(result);
        return result;
    }

    public void reapply(Context context, View v) {
        this.prepareContext(context);
        this.performApply(v);
    }

    public void performApply(View v) {
        if (this.mActions != null) {
            int count = this.mActions.size();
            for (int i = 0; i < count; ++i) {
                Action a = this.mActions.get(i);
                a.apply(v);
            }
        }
    }

    public Context prepareContext(Context context) {
        Context c = null;
        String packageName = this.mPackage;
        if (packageName != null) {
            try {
                c = context.createPackageContext(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(LOG_TAG, "Package name " + packageName + " not found");
                c = context;
            }
        } else {
            c = context;
        }
        this.mContext = c;
        return c;
    }

    public boolean onLoadClass(Class clazz) {
        return clazz.isAnnotationPresent(RemoteView.class);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mPackage);
        dest.writeInt(this.mLayoutId);
        int count = this.mActions != null ? this.mActions.size() : 0;
        dest.writeInt(count);
        for (int i = 0; i < count; ++i) {
            Action a = this.mActions.get(i);
            a.writeToParcel(dest, 0);
        }
    }

    public class ReflectionAction
    extends Action {
        public static final int TAG = 2;
        public static final int BOOLEAN = 1;
        public static final int BYTE = 2;
        public static final int SHORT = 3;
        public static final int INT = 4;
        public static final int LONG = 5;
        public static final int FLOAT = 6;
        public static final int DOUBLE = 7;
        public static final int CHAR = 8;
        public static final int STRING = 9;
        public static final int CHAR_SEQUENCE = 10;
        public static final int URI = 11;
        public static final int BITMAP = 12;
        public int viewId;
        public String methodName;
        public int type;
        public Object value;

        public ReflectionAction(int viewId, String methodName, int type, Object value) {
            super(null);
            this.viewId = viewId;
            this.methodName = methodName;
            this.type = type;
            this.value = value;
        }

        public ReflectionAction(Parcel in) {
            super(null);
            this.viewId = in.readInt();
            this.methodName = in.readString();
            this.type = in.readInt();
            switch (this.type) {
                case 1: {
                    this.value = in.readInt() != 0;
                    break;
                }
                case 2: {
                    this.value = in.readByte();
                    break;
                }
                case 3: {
                    this.value = (short)in.readInt();
                    break;
                }
                case 4: {
                    this.value = in.readInt();
                    break;
                }
                case 5: {
                    this.value = in.readLong();
                    break;
                }
                case 6: {
                    this.value = Float.valueOf(in.readFloat());
                    break;
                }
                case 7: {
                    this.value = in.readDouble();
                    break;
                }
                case 8: {
                    this.value = Character.valueOf((char)in.readInt());
                    break;
                }
                case 9: {
                    this.value = in.readString();
                    break;
                }
                case 10: {
                    this.value = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                    break;
                }
                case 11: {
                    this.value = Uri.CREATOR.createFromParcel(in);
                    break;
                }
                case 12: {
                    this.value = Bitmap.CREATOR.createFromParcel(in);
                    break;
                }
            }
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(2);
            out.writeInt(this.viewId);
            out.writeString(this.methodName);
            out.writeInt(this.type);
            switch (this.type) {
                case 1: {
                    out.writeInt((Boolean)this.value != false ? 1 : 0);
                    break;
                }
                case 2: {
                    out.writeByte((Byte)this.value);
                    break;
                }
                case 3: {
                    out.writeInt(((Short)this.value).shortValue());
                    break;
                }
                case 4: {
                    out.writeInt((Integer)this.value);
                    break;
                }
                case 5: {
                    out.writeLong((Long)this.value);
                    break;
                }
                case 6: {
                    out.writeFloat(((Float)this.value).floatValue());
                    break;
                }
                case 7: {
                    out.writeDouble((Double)this.value);
                    break;
                }
                case 8: {
                    out.writeInt(((Character)this.value).charValue());
                    break;
                }
                case 9: {
                    out.writeString((String)this.value);
                    break;
                }
                case 10: {
                    TextUtils.writeToParcel((CharSequence)this.value, out, flags);
                    break;
                }
                case 11: {
                    ((Uri)this.value).writeToParcel(out, flags);
                    break;
                }
                case 12: {
                    ((Bitmap)this.value).writeToParcel(out, flags);
                    break;
                }
            }
        }

        public Class getParameterType() {
            switch (this.type) {
                case 1: {
                    return Boolean.TYPE;
                }
                case 2: {
                    return Byte.TYPE;
                }
                case 3: {
                    return Short.TYPE;
                }
                case 4: {
                    return Integer.TYPE;
                }
                case 5: {
                    return Long.TYPE;
                }
                case 6: {
                    return Float.TYPE;
                }
                case 7: {
                    return Double.TYPE;
                }
                case 8: {
                    return Character.TYPE;
                }
                case 9: {
                    return String.class;
                }
                case 10: {
                    return CharSequence.class;
                }
                case 11: {
                    return Uri.class;
                }
                case 12: {
                    return Bitmap.class;
                }
            }
            return null;
        }

        public void apply(View root) {
            View view = root.findViewById(this.viewId);
            if (view == null) {
                throw new ActionException("can't find view: 0x" + Integer.toHexString(this.viewId));
            }
            Class param = this.getParameterType();
            if (param == null) {
                throw new ActionException("bad type: " + this.type);
            }
            Class<?> klass = view.getClass();
            Method method = null;
            try {
                method = klass.getMethod(this.methodName, this.getParameterType());
            }
            catch (NoSuchMethodException ex) {
                throw new ActionException("view: " + klass.getName() + " doesn't have method: " + this.methodName + "(" + param.getName() + ")");
            }
            if (!method.isAnnotationPresent(RemotableViewMethod.class)) {
                throw new ActionException("view: " + klass.getName() + " can't use method with RemoteViews: " + this.methodName + "(" + param.getName() + ")");
            }
            try {
                method.invoke((Object)view, this.value);
            }
            catch (Exception ex) {
                throw new ActionException(ex);
            }
        }
    }

    public class SetDrawableParameters
    extends Action {
        public int viewId;
        public boolean targetBackground;
        public int alpha;
        public int colorFilter;
        public PorterDuff.Mode filterMode;
        public int level;
        public static final int TAG = 3;

        public SetDrawableParameters(int id2, boolean targetBackground, int alpha, int colorFilter, PorterDuff.Mode mode, int level) {
            super(null);
            this.viewId = id2;
            this.targetBackground = targetBackground;
            this.alpha = alpha;
            this.colorFilter = colorFilter;
            this.filterMode = mode;
            this.level = level;
        }

        public SetDrawableParameters(Parcel parcel) {
            super(null);
            this.viewId = parcel.readInt();
            this.targetBackground = parcel.readInt() != 0;
            this.alpha = parcel.readInt();
            this.colorFilter = parcel.readInt();
            boolean hasMode = parcel.readInt() != 0;
            this.filterMode = hasMode ? PorterDuff.Mode.valueOf(parcel.readString()) : null;
            this.level = parcel.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(3);
            dest.writeInt(this.viewId);
            dest.writeInt(this.targetBackground ? 1 : 0);
            dest.writeInt(this.alpha);
            dest.writeInt(this.colorFilter);
            if (this.filterMode != null) {
                dest.writeInt(1);
                dest.writeString(this.filterMode.toString());
            } else {
                dest.writeInt(0);
            }
            dest.writeInt(this.level);
        }

        public void apply(View root) {
            View target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            Drawable targetDrawable = null;
            if (this.targetBackground) {
                targetDrawable = target.getBackground();
            } else if (target instanceof ImageView) {
                ImageView imageView = (ImageView)target;
                targetDrawable = imageView.getDrawable();
            }
            if (this.alpha != -1) {
                targetDrawable.setAlpha(this.alpha);
            }
            if (this.colorFilter != -1 && this.filterMode != null) {
                targetDrawable.setColorFilter(this.colorFilter, this.filterMode);
            }
            if (this.level != -1) {
                targetDrawable.setLevel(this.level);
            }
        }
    }

    public class SetOnClickPendingIntent
    extends Action {
        public int viewId;
        public PendingIntent pendingIntent;
        public static final int TAG = 1;

        public SetOnClickPendingIntent(int id2, PendingIntent pendingIntent) {
            super(null);
            this.viewId = id2;
            this.pendingIntent = pendingIntent;
        }

        public SetOnClickPendingIntent(Parcel parcel) {
            super(null);
            this.viewId = parcel.readInt();
            this.pendingIntent = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(1);
            dest.writeInt(this.viewId);
            this.pendingIntent.writeToParcel(dest, 0);
        }

        public void apply(View root) {
            View target = root.findViewById(this.viewId);
            if (target != null && this.pendingIntent != null) {
                View.OnClickListener listener = new View.OnClickListener(){

                    public void onClick(View v) {
                        try {
                            SetOnClickPendingIntent.this.pendingIntent.send();
                        }
                        catch (PendingIntent.CanceledException e) {
                            throw new ActionException(e.toString());
                        }
                    }
                };
                target.setOnClickListener(listener);
            }
        }
    }

    public static abstract class Action
    implements Parcelable {
        public Action() {
        }

        public abstract void apply(View var1) throws ActionException;

        public int describeContents() {
            return 0;
        }

        public /* synthetic */ Action(1 x0) {
            this();
        }
    }

    public static class ActionException
    extends RuntimeException {
        public ActionException(Exception ex) {
            super(ex);
        }

        public ActionException(String message) {
            super(message);
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RemoteView {
    }
}

