/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.Checkable;
import android.widget.TextView;
import com.android.internal.R;

public abstract class CheckedTextView
extends TextView
implements Checkable {
    public boolean mChecked;
    public int mCheckMarkResource;
    public Drawable mCheckMarkDrawable;
    public int mBasePaddingRight;
    public int mCheckMarkWidth;
    public static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};

    public CheckedTextView(Context context) {
        this(context, null);
    }

    public CheckedTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CheckedTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CheckedTextView, defStyle, 0);
        Drawable d = a.getDrawable(1);
        if (d != null) {
            this.setCheckMarkDrawable(d);
        }
        boolean checked = a.getBoolean(0, false);
        this.setChecked(checked);
        a.recycle();
    }

    public void toggle() {
        this.setChecked(!this.mChecked);
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            this.refreshDrawableState();
        }
    }

    public void setCheckMarkDrawable(int resid) {
        if (resid != 0 && resid == this.mCheckMarkResource) {
            return;
        }
        this.mCheckMarkResource = resid;
        Drawable d = null;
        if (this.mCheckMarkResource != 0) {
            d = this.getResources().getDrawable(this.mCheckMarkResource);
        }
        this.setCheckMarkDrawable(d);
    }

    public void setCheckMarkDrawable(Drawable d) {
        if (d != null) {
            if (this.mCheckMarkDrawable != null) {
                this.mCheckMarkDrawable.setCallback(null);
                this.unscheduleDrawable(this.mCheckMarkDrawable);
            }
            d.setCallback(this);
            d.setVisible(this.getVisibility() == 0, false);
            d.setState(CHECKED_STATE_SET);
            this.setMinHeight(d.getIntrinsicHeight());
            this.mCheckMarkWidth = d.getIntrinsicWidth();
            this.mPaddingRight = this.mCheckMarkWidth + this.mBasePaddingRight;
            d.setState(this.getDrawableState());
            this.mCheckMarkDrawable = d;
        } else {
            this.mPaddingRight = this.mBasePaddingRight;
        }
        this.requestLayout();
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.mBasePaddingRight = this.mPaddingRight;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Drawable checkMarkDrawable = this.mCheckMarkDrawable;
        if (checkMarkDrawable != null) {
            int verticalGravity = this.getGravity() & 0x70;
            int height = checkMarkDrawable.getIntrinsicHeight();
            int y = 0;
            switch (verticalGravity) {
                case 80: {
                    y = this.getHeight() - height;
                    break;
                }
                case 16: {
                    y = (this.getHeight() - height) / 2;
                }
            }
            int right = this.getWidth();
            checkMarkDrawable.setBounds(right - this.mCheckMarkWidth - this.mBasePaddingRight, y, right - this.mBasePaddingRight, y + height);
            checkMarkDrawable.draw(canvas);
        }
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            CheckedTextView.mergeDrawableStates(drawableState, CHECKED_STATE_SET);
        }
        return drawableState;
    }

    public void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mCheckMarkDrawable != null) {
            int[] myDrawableState = this.getDrawableState();
            this.mCheckMarkDrawable.setState(myDrawableState);
            this.invalidate();
        }
    }
}

