/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import java.util.LinkedList;

public class ByteArrayBuilder {
    public static final int DEFAULT_CAPACITY = 8192;
    public LinkedList<Chunk> mChunks;
    public LinkedList<Chunk> mPool;
    public int mMinCapacity;

    public ByteArrayBuilder() {
        this.init(0);
    }

    public ByteArrayBuilder(int minCapacity) {
        this.init(minCapacity);
    }

    public void init(int minCapacity) {
        this.mChunks = new LinkedList();
        this.mPool = new LinkedList();
        if (minCapacity <= 0) {
            minCapacity = 8192;
        }
        this.mMinCapacity = minCapacity;
    }

    public void append(byte[] array2) {
        this.append(array2, 0, array2.length);
    }

    public synchronized void append(byte[] array2, int offset, int length) {
        while (length > 0) {
            Chunk c = this.appendChunk(length);
            int amount = Math.min(length, c.mArray.length - c.mLength);
            System.arraycopy(array2, offset, c.mArray, c.mLength, amount);
            c.mLength += amount;
            length -= amount;
            offset += amount;
        }
    }

    public synchronized Chunk getFirstChunk() {
        if (this.mChunks.isEmpty()) {
            return null;
        }
        return this.mChunks.removeFirst();
    }

    public synchronized void releaseChunk(Chunk c) {
        c.mLength = 0;
        this.mPool.addLast(c);
    }

    public boolean isEmpty() {
        return this.mChunks.isEmpty();
    }

    public synchronized void clear() {
        Chunk c = this.getFirstChunk();
        while (c != null) {
            this.releaseChunk(c);
            c = this.getFirstChunk();
        }
    }

    public Chunk appendChunk(int length) {
        Chunk c;
        if (length < this.mMinCapacity) {
            length = this.mMinCapacity;
        }
        if (this.mChunks.isEmpty()) {
            c = this.obtainChunk(length);
        } else {
            c = this.mChunks.getLast();
            if (c.mLength == c.mArray.length) {
                c = this.obtainChunk(length);
            }
        }
        return c;
    }

    public Chunk obtainChunk(int length) {
        Chunk c = this.mPool.isEmpty() ? new Chunk(length) : this.mPool.removeFirst();
        this.mChunks.addLast(c);
        return c;
    }

    public static class Chunk {
        public byte[] mArray;
        public int mLength;

        public Chunk(int length) {
            this.mArray = new byte[length];
            this.mLength = 0;
        }
    }
}

