/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.net.ParseException;
import android.net.WebAddress;
import android.net.http.SslCertificate;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.util.TypedValue;
import android.webkit.CacheManager;
import android.webkit.CallbackProxy;
import android.webkit.CookieSyncManager;
import android.webkit.FrameLoader;
import android.webkit.JWebCoreJavaBridge;
import android.webkit.LoadListener;
import android.webkit.PerfChecker;
import android.webkit.URLUtil;
import android.webkit.WebBackForwardList;
import android.webkit.WebHistoryItem;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewCore;
import android.webkit.WebViewDatabase;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.net.URLEncoder;
import java.util.HashMap;

public class BrowserFrame
extends Handler {
    public static final String LOGTAG = "webkit";
    public static final int MAX_OUTSTANDING_REQUESTS = 300;
    public final CallbackProxy mCallbackProxy;
    public final WebSettings mSettings;
    public final Context mContext;
    public final WebViewDatabase mDatabase;
    public final WebViewCore mWebViewCore;
    public boolean mLoadInitFromJava;
    public int mLoadType;
    public boolean mFirstLayoutDone = true;
    public boolean mCommitted = true;
    public boolean mIsMainFrame;
    public HashMap mJSInterfaceMap;
    public static final int FRAME_COMPLETED = 1001;
    public static final int POLICY_FUNCTION = 1003;
    public static final int FRAME_LOADTYPE_STANDARD = 0;
    public static final int FRAME_LOADTYPE_BACK = 1;
    public static final int FRAME_LOADTYPE_FORWARD = 2;
    public static final int FRAME_LOADTYPE_INDEXEDBACKFORWARD = 3;
    public static final int FRAME_LOADTYPE_RELOAD = 4;
    public static final int FRAME_LOADTYPE_RELOADALLOWINGSTALEDATA = 5;
    public static final int FRAME_LOADTYPE_SAME = 6;
    public static final int FRAME_LOADTYPE_REDIRECT = 7;
    public static final int FRAME_LOADTYPE_REPLACE = 8;
    public static final int TRANSITION_SWITCH_THRESHOLD = 75;
    public int mNativeFrame;
    public static JWebCoreJavaBridge sJavaBridge;
    public static final int POLICY_USE = 0;
    public static final int POLICY_IGNORE = 2;
    public static final int NODOMAIN = 1;
    public static final int LOADERROR = 2;

    public BrowserFrame(Context context, WebViewCore w, CallbackProxy proxy, WebSettings settings) {
        if (sJavaBridge == null) {
            sJavaBridge = new JWebCoreJavaBridge();
            sJavaBridge.setCacheSize(0x400000);
            CacheManager.init(context);
            CookieSyncManager.createInstance(context);
        }
        AssetManager am = context.getAssets();
        this.nativeCreateFrame(w, am, proxy.getBackForwardList());
        this.mSettings = settings;
        this.mContext = context;
        this.mCallbackProxy = proxy;
        this.mDatabase = WebViewDatabase.getInstance(context);
        this.mWebViewCore = w;
    }

    public void loadUrl(String url) {
        this.mLoadInitFromJava = true;
        if (URLUtil.isJavaScriptUrl(url)) {
            this.stringByEvaluatingJavaScriptFromString(url.substring("javascript:".length()));
        } else {
            this.nativeLoadUrl(url);
        }
        this.mLoadInitFromJava = false;
    }

    public void loadData(String baseUrl, String data, String mimeType, String encoding, String failUrl) {
        this.mLoadInitFromJava = true;
        if (failUrl == null) {
            failUrl = "";
        }
        if (data == null) {
            data = "";
        }
        if (baseUrl == null || baseUrl.length() == 0) {
            baseUrl = "about:blank";
        }
        if (mimeType == null || mimeType.length() == 0) {
            mimeType = "text/html";
        }
        this.nativeLoadData(baseUrl, data, mimeType, encoding, failUrl);
        this.mLoadInitFromJava = false;
    }

    public void goBackOrForward(int steps) {
        this.mLoadInitFromJava = true;
        this.nativeGoBackOrForward(steps);
        this.mLoadInitFromJava = false;
    }

    public void reportError(int errorCode, String description, String failingUrl) {
        this.resetLoadingStates();
        this.mCallbackProxy.onReceivedError(errorCode, description, failingUrl);
    }

    public void resetLoadingStates() {
        this.mCommitted = true;
        this.mWebViewCore.mEndScaleZoom = !this.mFirstLayoutDone;
        this.mFirstLayoutDone = true;
    }

    public boolean committed() {
        return this.mCommitted;
    }

    public boolean firstLayoutDone() {
        return this.mFirstLayoutDone;
    }

    public int loadType() {
        return this.mLoadType;
    }

    public void didFirstLayout() {
        if (!this.mFirstLayoutDone) {
            this.mFirstLayoutDone = true;
            this.mWebViewCore.contentDraw();
        }
        this.mWebViewCore.mEndScaleZoom = true;
    }

    public void loadStarted(String url, Bitmap favicon, int loadType, boolean isMainFrame) {
        this.mIsMainFrame = isMainFrame;
        if (isMainFrame || loadType == 0) {
            String currentUrl;
            WebHistoryItem h;
            this.mLoadType = loadType;
            if (isMainFrame) {
                this.mCallbackProxy.onPageStarted(url, favicon);
                this.mFirstLayoutDone = false;
                this.mCommitted = false;
                this.mWebViewCore.removeMessages(130);
            }
            if (loadType == 0 && this.mSettings.getSaveFormData() && (h = this.mCallbackProxy.getBackForwardList().getCurrentItem()) != null && (currentUrl = h.getUrl()) != null) {
                this.mDatabase.setFormData(currentUrl, this.getFormTextData());
            }
        }
    }

    public void transitionToCommitted(int loadType, boolean isMainFrame) {
        if (isMainFrame) {
            this.mCommitted = true;
        }
    }

    public void loadFinished(String url, int loadType, boolean isMainFrame) {
        if ((isMainFrame || loadType == 0) && isMainFrame) {
            this.resetLoadingStates();
            this.mCallbackProxy.switchOutDrawHistory();
            this.mCallbackProxy.onPageFinished(url);
        }
    }

    public void certificate(SslCertificate certificate) {
        if (this.mIsMainFrame) {
            this.mCallbackProxy.onReceivedCertificate(certificate);
        }
    }

    public void destroy() {
        this.nativeDestroyFrame();
        this.removeCallbacksAndMessages(null);
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1001: {
                if (this.mSettings.getSavePassword() && this.hasPasswordField()) {
                    WebAddress uri = new WebAddress(this.mCallbackProxy.getBackForwardList().getCurrentItem().getUrl());
                    String schemePlusHost = uri.mScheme + uri.mHost;
                    String[] up = this.mDatabase.getUsernamePassword(schemePlusHost);
                    if (up != null && up[0] != null) {
                        this.setUsernamePassword(up[0], up[1]);
                    }
                }
                CacheManager.trimCacheIfNeeded();
                break;
            }
            case 1003: {
                this.nativeCallPolicyFunction(msg.arg1, msg.arg2);
                break;
            }
        }
    }

    public void setTitle(String title) {
        this.mCallbackProxy.onReceivedTitle(title);
    }

    public void externalRepresentation(Message callback) {
        callback.obj = this.externalRepresentation();
        callback.sendToTarget();
    }

    public String externalRepresentation() {
        return (String)OverrideMethod.invokeA("android.webkit.BrowserFrame#externalRepresentation()Ljava/lang/String;", true, this);
    }

    public void documentAsText(Message callback) {
        callback.obj = this.documentAsText();
        callback.sendToTarget();
    }

    public String documentAsText() {
        return (String)OverrideMethod.invokeA("android.webkit.BrowserFrame#documentAsText()Ljava/lang/String;", true, this);
    }

    public void windowObjectCleared(int nativeFramePointer) {
        if (this.mJSInterfaceMap != null) {
            for (String interfaceName : this.mJSInterfaceMap.keySet()) {
                this.nativeAddJavascriptInterface(nativeFramePointer, this.mJSInterfaceMap.get(interfaceName), interfaceName);
            }
        }
    }

    public boolean handleUrl(String url) {
        if (this.mLoadInitFromJava) {
            return false;
        }
        if (this.mCallbackProxy.shouldOverrideUrlLoading(url)) {
            this.didFirstLayout();
            return true;
        }
        return false;
    }

    public void addJavascriptInterface(Object obj, String interfaceName) {
        if (this.mJSInterfaceMap == null) {
            this.mJSInterfaceMap = new HashMap();
        }
        if (this.mJSInterfaceMap.containsKey(interfaceName)) {
            this.mJSInterfaceMap.remove(interfaceName);
        }
        this.mJSInterfaceMap.put(interfaceName, obj);
    }

    public LoadListener startLoadingResource(int loaderHandle, String url, String method, HashMap headers, byte[] postData, int cacheMode, boolean isHighPriority, boolean synchronous) {
        PerfChecker checker = new PerfChecker();
        if (this.mSettings.getCacheMode() != -1) {
            cacheMode = this.mSettings.getCacheMode();
        }
        if (method.equals("POST")) {
            if (cacheMode == 0) {
                cacheMode = 2;
            }
            if (this.mSettings.getSavePassword() && this.hasPasswordField()) {
                try {
                    String postString;
                    WebAddress uri = new WebAddress(this.mCallbackProxy.getBackForwardList().getCurrentItem().getUrl());
                    String schemePlusHost = uri.mScheme + uri.mHost;
                    String[] ret = this.getUsernamePassword();
                    if (ret != null && postData != null && ret[0].length() > 0 && ret[1].length() > 0 && (postString = new String(postData)).contains(URLEncoder.encode(ret[0])) && postString.contains(URLEncoder.encode(ret[1]))) {
                        String[] saved = this.mDatabase.getUsernamePassword(schemePlusHost);
                        if (saved != null) {
                            if (saved[0] != null) {
                                this.mDatabase.setUsernamePassword(schemePlusHost, ret[0], ret[1]);
                            }
                        } else {
                            this.mCallbackProxy.onSavePassword(schemePlusHost, ret[0], ret[1], null);
                        }
                    }
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
        }
        boolean isMainFramePage = this.mIsMainFrame;
        LoadListener loadListener = LoadListener.getLoadListener(this.mContext, this, url, loaderHandle, synchronous, isMainFramePage);
        this.mCallbackProxy.onLoadResource(url);
        if (LoadListener.getNativeLoaderCount() > 300) {
            loadListener.error(-1, this.mContext.getString(17039447));
            loadListener.notifyError();
            loadListener.tearDown();
            return null;
        }
        if (synchronous) {
            CacheManager.endCacheTransaction();
        }
        FrameLoader loader = new FrameLoader(loadListener, this.mSettings, method, isHighPriority);
        loader.setHeaders(headers);
        loader.setPostData(postData);
        loader.setCacheMode(headers.containsKey("If-Modified-Since") || headers.containsKey("If-None-Match") ? 2 : cacheMode);
        if (!loader.executeLoad()) {
            checker.responseAlert("startLoadingResource fail");
        }
        checker.responseAlert("startLoadingResource succeed");
        if (synchronous) {
            CacheManager.startCacheTransaction();
        }
        return !synchronous ? loadListener : null;
    }

    public void setProgress(int newProgress) {
        this.mCallbackProxy.onProgressChanged(newProgress);
        if (newProgress == 100) {
            this.sendMessageDelayed(this.obtainMessage(1001), 100L);
        }
        if (this.mFirstLayoutDone && newProgress > 75) {
            this.mCallbackProxy.switchOutDrawHistory();
        }
    }

    public void didReceiveIcon(Bitmap icon) {
        this.mCallbackProxy.onReceivedIcon(icon);
    }

    public BrowserFrame createWindow(boolean dialog, boolean userGesture) {
        WebView w = this.mCallbackProxy.createWindow(dialog, userGesture);
        if (w != null) {
            return w.getWebViewCore().getBrowserFrame();
        }
        return null;
    }

    public void requestFocus() {
        this.mCallbackProxy.onRequestFocus();
    }

    public void closeWindow(WebViewCore w) {
        this.mCallbackProxy.onCloseWindow(w.getWebView());
    }

    public void decidePolicyForFormResubmission(int policyFunction) {
        Message dontResend = this.obtainMessage(1003, policyFunction, 2);
        Message resend = this.obtainMessage(1003, policyFunction, 0);
        this.mCallbackProxy.onFormResubmission(dontResend, resend);
    }

    public void updateVisitedHistory(String url, boolean isReload) {
        this.mCallbackProxy.doUpdateVisitedHistory(url, isReload);
    }

    public CallbackProxy getCallbackProxy() {
        return this.mCallbackProxy;
    }

    public String getUserAgentString() {
        return this.mSettings.getUserAgentString();
    }

    public String getRawResFilename(int id2) {
        int resid;
        switch (id2) {
            case 1: {
                resid = 17563650;
                break;
            }
            case 2: {
                resid = 0x10C0001;
                break;
            }
            default: {
                Log.e(LOGTAG, "getRawResFilename got incompatible resource ID");
                return new String();
            }
        }
        TypedValue value = new TypedValue();
        this.mContext.getResources().getValue(resid, value, true);
        return ((Object)value.string).toString();
    }

    public void nativeCreateFrame(WebViewCore webViewCore, AssetManager assetManager, WebBackForwardList webBackForwardList) {
        OverrideMethod.invokeV("android.webkit.BrowserFrame#nativeCreateFrame(Landroid/webkit/WebViewCore;Landroid/content/res/AssetManager;Landroid/webkit/WebBackForwardList;)V", true, this);
    }

    public void nativeDestroyFrame() {
        OverrideMethod.invokeV("android.webkit.BrowserFrame#nativeDestroyFrame()V", true, this);
    }

    public void nativeCallPolicyFunction(int n, int n2) {
        OverrideMethod.invokeV("android.webkit.BrowserFrame#nativeCallPolicyFunction(II)V", true, this);
    }

    public void reload(boolean bl) {
        OverrideMethod.invokeV("android.webkit.BrowserFrame#reload(Z)V", true, this);
    }

    public void nativeGoBackOrForward(int n) {
        OverrideMethod.invokeV("android.webkit.BrowserFrame#nativeGoBackOrForward(I)V", true, this);
    }

    public String stringByEvaluatingJavaScriptFromString(String string2) {
        return (String)OverrideMethod.invokeA("android.webkit.BrowserFrame#stringByEvaluatingJavaScriptFromString(Ljava/lang/String;)Ljava/lang/String;", true, this);
    }

    public void nativeAddJavascriptInterface(int n, Object object, String string2) {
        OverrideMethod.invokeV("android.webkit.BrowserFrame#nativeAddJavascriptInterface(ILjava/lang/Object;Ljava/lang/String;)V", true, this);
    }

    public void setCacheDisabled(boolean bl) {
        OverrideMethod.invokeV("android.webkit.BrowserFrame#setCacheDisabled(Z)V", true, this);
    }

    public boolean cacheDisabled() {
        return OverrideMethod.invokeI("android.webkit.BrowserFrame#cacheDisabled()Z", true, this) != 0;
    }

    public void clearCache() {
        OverrideMethod.invokeV("android.webkit.BrowserFrame#clearCache()V", true, this);
    }

    public void nativeLoadUrl(String string2) {
        OverrideMethod.invokeV("android.webkit.BrowserFrame#nativeLoadUrl(Ljava/lang/String;)V", true, this);
    }

    public void nativeLoadData(String string2, String string3, String string4, String string5, String string6) {
        OverrideMethod.invokeV("android.webkit.BrowserFrame#nativeLoadData(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", true, this);
    }

    public void stopLoading() {
        if (this.mIsMainFrame) {
            this.resetLoadingStates();
        }
        this.nativeStopLoading();
    }

    public void nativeStopLoading() {
        OverrideMethod.invokeV("android.webkit.BrowserFrame#nativeStopLoading()V", true, this);
    }

    public boolean documentHasImages() {
        return OverrideMethod.invokeI("android.webkit.BrowserFrame#documentHasImages()Z", true, this) != 0;
    }

    public boolean hasPasswordField() {
        return OverrideMethod.invokeI("android.webkit.BrowserFrame#hasPasswordField()Z", true, this) != 0;
    }

    public String[] getUsernamePassword() {
        return (String[])OverrideMethod.invokeA("android.webkit.BrowserFrame#getUsernamePassword()[Ljava/lang/String;", true, this);
    }

    public void setUsernamePassword(String string2, String string3) {
        OverrideMethod.invokeV("android.webkit.BrowserFrame#setUsernamePassword(Ljava/lang/String;Ljava/lang/String;)V", true, this);
    }

    public HashMap getFormTextData() {
        return (HashMap)OverrideMethod.invokeA("android.webkit.BrowserFrame#getFormTextData()Ljava/util/HashMap;", true, this);
    }
}

