/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Debug;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRoot;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewDebug {
    public static final boolean TRACE_HIERARCHY = false;
    public static final boolean TRACE_RECYCLER = false;
    public static final String SYSTEM_PROPERTY_CAPTURE_VIEW = "debug.captureview";
    public static final String SYSTEM_PROPERTY_CAPTURE_EVENT = "debug.captureevent";
    public static HashMap<Class<?>, Method[]> mCapturedViewMethodsForClasses = null;
    public static HashMap<Class<?>, Field[]> mCapturedViewFieldsForClasses = null;
    public static final int CAPTURE_TIMEOUT = 4000;
    public static final String REMOTE_COMMAND_CAPTURE = "CAPTURE";
    public static final String REMOTE_COMMAND_DUMP = "DUMP";
    public static final String REMOTE_COMMAND_INVALIDATE = "INVALIDATE";
    public static final String REMOTE_COMMAND_REQUEST_LAYOUT = "REQUEST_LAYOUT";
    public static final String REMOTE_PROFILE = "PROFILE";
    public static HashMap<Class<?>, Field[]> sFieldsForClasses;
    public static HashMap<Class<?>, Method[]> sMethodsForClasses;
    public static HashMap<AccessibleObject, ExportedProperty> sAnnotations;
    public static BufferedWriter sHierarchyTraces;
    public static ViewRoot sHierarhcyRoot;
    public static String sHierarchyTracePrefix;
    public static View sRecyclerOwnerView;
    public static List<View> sRecyclerViews;
    public static List<RecyclerTrace> sRecyclerTraces;
    public static String sRecyclerTracePrefix;

    public static long getViewInstanceCount() {
        return View.sInstanceCount;
    }

    public static long getViewRootInstanceCount() {
        return ViewRoot.getInstanceCount();
    }

    public static void trace(View view, RecyclerTraceType type, int ... parameters) {
        if (sRecyclerOwnerView == null || sRecyclerViews == null) {
            return;
        }
        if (!sRecyclerViews.contains(view)) {
            sRecyclerViews.add(view);
        }
        int index = sRecyclerViews.indexOf(view);
        RecyclerTrace trace = new RecyclerTrace(null);
        trace.view = index;
        trace.type = type;
        trace.position = parameters[0];
        trace.indexOnScreen = parameters[1];
        sRecyclerTraces.add(trace);
    }

    public static void startRecyclerTracing(String prefix, View view) {
    }

    public static void stopRecyclerTracing() {
    }

    public static void trace(View view, HierarchyTraceType type) {
        if (sHierarchyTraces == null) {
            return;
        }
        try {
            sHierarchyTraces.write(type.name());
            sHierarchyTraces.write(32);
            sHierarchyTraces.write(view.getClass().getName());
            sHierarchyTraces.write(64);
            sHierarchyTraces.write(Integer.toHexString(view.hashCode()));
            sHierarchyTraces.newLine();
        }
        catch (IOException e) {
            Log.w("View", "Error while dumping trace of type " + (Object)((Object)type) + " for view " + view);
        }
    }

    public static void startHierarchyTracing(String prefix, View view) {
    }

    public static void stopHierarchyTracing() {
    }

    public static void dispatchCommand(View view, String command, String parameters, OutputStream clientStream) throws IOException {
        view = view.getRootView();
        if (REMOTE_COMMAND_DUMP.equalsIgnoreCase(command)) {
            ViewDebug.dump(view, clientStream);
        } else {
            String[] params = parameters.split(" ");
            if (REMOTE_COMMAND_CAPTURE.equalsIgnoreCase(command)) {
                ViewDebug.capture(view, clientStream, params[0]);
            } else if (REMOTE_COMMAND_INVALIDATE.equalsIgnoreCase(command)) {
                ViewDebug.invalidate(view, params[0]);
            } else if (REMOTE_COMMAND_REQUEST_LAYOUT.equalsIgnoreCase(command)) {
                ViewDebug.requestLayout(view, params[0]);
            } else if (REMOTE_PROFILE.equalsIgnoreCase(command)) {
                ViewDebug.profile(view, clientStream, params[0]);
            }
        }
    }

    public static View findView(View root, String parameter) {
        if (parameter.indexOf(64) != -1) {
            String[] ids = parameter.split("@");
            String className = ids[0];
            int hashCode = Integer.parseInt(ids[1], 16);
            View view = root.getRootView();
            if (view instanceof ViewGroup) {
                return ViewDebug.findView((ViewGroup)view, className, hashCode);
            }
        } else {
            int id2 = root.getResources().getIdentifier(parameter, null, null);
            return root.getRootView().findViewById(id2);
        }
        return null;
    }

    public static void invalidate(View root, String parameter) {
        View view = ViewDebug.findView(root, parameter);
        if (view != null) {
            view.postInvalidate();
        }
    }

    public static void requestLayout(View root, String parameter) {
        final View view = ViewDebug.findView(root, parameter);
        if (view != null) {
            root.post(new Runnable(){

                public void run() {
                    view.requestLayout();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void profile(View root, OutputStream clientStream, String parameter) throws IOException {
        final View view = ViewDebug.findView(root, parameter);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 32768);
            if (view != null) {
                long durationMeasure = ViewDebug.profileViewOperation(view, new ViewOperation<Void>(){

                    public Void[] pre() {
                        this.forceLayout(view);
                        return null;
                    }

                    public void forceLayout(View view2) {
                        view2.forceLayout();
                        if (view2 instanceof ViewGroup) {
                            ViewGroup group = (ViewGroup)view2;
                            int count = group.getChildCount();
                            for (int i = 0; i < count; ++i) {
                                this.forceLayout(group.getChildAt(i));
                            }
                        }
                    }

                    public void run(Void ... data) {
                        view.measure(view.mOldWidthMeasureSpec, view.mOldHeightMeasureSpec);
                    }

                    public void post(Void ... data) {
                    }
                });
                long durationLayout = ViewDebug.profileViewOperation(view, new ViewOperation<Void>(){

                    public Void[] pre() {
                        return null;
                    }

                    public void run(Void ... data) {
                        view.layout(view.mLeft, view.mTop, view.mRight, view.mBottom);
                    }

                    public void post(Void ... data) {
                    }
                });
                long durationDraw = ViewDebug.profileViewOperation(view, new ViewOperation<Object>(){

                    @Override
                    public Object[] pre() {
                        DisplayMetrics metrics = view.getResources().getDisplayMetrics();
                        Bitmap bitmap = Bitmap.createBitmap(metrics.widthPixels, metrics.heightPixels, Bitmap.Config.RGB_565);
                        Canvas canvas = new Canvas(bitmap);
                        return new Object[]{bitmap, canvas};
                    }

                    @Override
                    public void run(Object ... data) {
                        view.draw((Canvas)data[1]);
                    }

                    @Override
                    public void post(Object ... data) {
                        ((Bitmap)data[0]).recycle();
                    }
                });
                out.write(String.valueOf(durationMeasure));
                out.write(32);
                out.write(String.valueOf(durationLayout));
                out.write(32);
                out.write(String.valueOf(durationDraw));
                out.newLine();
            } else {
                out.write("-1 -1 -1");
                out.newLine();
            }
        }
        catch (Exception e) {
            Log.w("View", "Problem profiling the view:", e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static <T> long profileViewOperation(View view, final ViewOperation<T> operation) {
        final CountDownLatch latch = new CountDownLatch(1);
        final long[] duration = new long[1];
        view.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    T[] data = operation.pre();
                    long start = Debug.threadCpuTimeNanos();
                    operation.run(data);
                    duration[0] = Debug.threadCpuTimeNanos() - start;
                    operation.post(data);
                }
                finally {
                    latch.countDown();
                }
            }
        });
        try {
            latch.await(4000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Log.w("View", "Could not complete the profiling of the view " + view);
            Thread.currentThread().interrupt();
            return -1L;
        }
        return duration[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void capture(View root, OutputStream clientStream, String parameter) throws IOException {
        block8: {
            final View captureView = ViewDebug.findView(root, parameter);
            if (captureView != null) {
                final CountDownLatch latch = new CountDownLatch(1);
                final Bitmap[] cache = new Bitmap[1];
                root.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            cache[0] = captureView.createSnapshot(Bitmap.Config.ARGB_8888, 0);
                        }
                        catch (OutOfMemoryError e) {
                            try {
                                cache[0] = captureView.createSnapshot(Bitmap.Config.ARGB_4444, 0);
                            }
                            catch (OutOfMemoryError e2) {
                                Log.w("View", "Out of memory for bitmap");
                            }
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
                try {
                    latch.await(4000L, TimeUnit.MILLISECONDS);
                    if (cache[0] != null) {
                        BufferedOutputStream out = null;
                        try {
                            out = new BufferedOutputStream(clientStream, 32768);
                            cache[0].compress(Bitmap.CompressFormat.PNG, 100, out);
                            out.flush();
                            break block8;
                        }
                        finally {
                            if (out != null) {
                                out.close();
                            }
                            cache[0].recycle();
                        }
                    }
                    Log.w("View", "Failed to create capture bitmap!");
                    clientStream.close();
                }
                catch (InterruptedException e) {
                    Log.w("View", "Could not complete the capture of the view " + captureView);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(View root, OutputStream clientStream) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 32768);
            View view = root.getRootView();
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                ViewDebug.dumpViewHierarchyWithProperties(group.getContext(), group, out, 0);
            }
            out.write("DONE.");
            out.newLine();
        }
        catch (Exception e) {
            Log.w("View", "Problem dumping the view:", e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static View findView(ViewGroup group, String className, int hashCode) {
        if (ViewDebug.isRequestedView(group, className, hashCode)) {
            return group;
        }
        int count = group.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = group.getChildAt(i);
            if (view instanceof ViewGroup) {
                View found = ViewDebug.findView((ViewGroup)view, className, hashCode);
                if (found == null) continue;
                return found;
            }
            if (!ViewDebug.isRequestedView(view, className, hashCode)) continue;
            return view;
        }
        return null;
    }

    public static boolean isRequestedView(View view, String className, int hashCode) {
        return view.getClass().getName().equals(className) && view.hashCode() == hashCode;
    }

    public static void dumpViewHierarchyWithProperties(Context context, ViewGroup group, BufferedWriter out, int level) {
        if (!ViewDebug.dumpViewWithProperties(context, group, out, level)) {
            return;
        }
        int count = group.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = group.getChildAt(i);
            if (view instanceof ViewGroup) {
                ViewDebug.dumpViewHierarchyWithProperties(context, (ViewGroup)view, out, level + 1);
                continue;
            }
            ViewDebug.dumpViewWithProperties(context, view, out, level + 1);
        }
    }

    public static boolean dumpViewWithProperties(Context context, View view, BufferedWriter out, int level) {
        try {
            for (int i = 0; i < level; ++i) {
                out.write(32);
            }
            out.write(view.getClass().getName());
            out.write(64);
            out.write(Integer.toHexString(view.hashCode()));
            out.write(32);
            ViewDebug.dumpViewProperties(context, view, out);
            out.newLine();
        }
        catch (IOException e) {
            Log.w("View", "Error while dumping hierarchy tree");
            return false;
        }
        return true;
    }

    public static Field[] getExportedPropertyFields(Class<?> klass) {
        if (sFieldsForClasses == null) {
            sFieldsForClasses = new HashMap();
        }
        if (sAnnotations == null) {
            sAnnotations = new HashMap(512);
        }
        HashMap<Class<?>, Field[]> map = sFieldsForClasses;
        HashMap<AccessibleObject, ExportedProperty> annotations = sAnnotations;
        Field[] fields = map.get(klass);
        if (fields != null) {
            return fields;
        }
        ArrayList<Field> foundFields = new ArrayList<Field>();
        for (Field field : klass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ExportedProperty.class)) continue;
            field.setAccessible(true);
            foundFields.add(field);
            annotations.put(field, field.getAnnotation(ExportedProperty.class));
        }
        fields = foundFields.toArray(new Field[foundFields.size()]);
        map.put(klass, fields);
        return fields;
    }

    public static Method[] getExportedPropertyMethods(Class<?> klass) {
        if (sMethodsForClasses == null) {
            sMethodsForClasses = new HashMap(100);
        }
        if (sAnnotations == null) {
            sAnnotations = new HashMap(512);
        }
        HashMap<Class<?>, Method[]> map = sMethodsForClasses;
        HashMap<AccessibleObject, ExportedProperty> annotations = sAnnotations;
        Method[] methods = map.get(klass);
        if (methods != null) {
            return methods;
        }
        ArrayList<Method> foundMethods = new ArrayList<Method>();
        for (Method method : klass.getDeclaredMethods()) {
            if (method.getParameterTypes().length != 0 || !method.isAnnotationPresent(ExportedProperty.class) || method.getReturnType() == Void.class) continue;
            method.setAccessible(true);
            foundMethods.add(method);
            annotations.put(method, method.getAnnotation(ExportedProperty.class));
        }
        methods = foundMethods.toArray(new Method[foundMethods.size()]);
        map.put(klass, methods);
        return methods;
    }

    public static void dumpViewProperties(Context context, Object view, BufferedWriter out) throws IOException {
        ViewDebug.dumpViewProperties(context, view, out, "");
    }

    public static void dumpViewProperties(Context context, Object view, BufferedWriter out, String prefix) throws IOException {
        Class<?> klass = view.getClass();
        do {
            ViewDebug.exportFields(context, view, out, klass, prefix);
            ViewDebug.exportMethods(context, view, out, klass, prefix);
        } while ((klass = klass.getSuperclass()) != Object.class);
    }

    public static void exportMethods(Context context, Object view, BufferedWriter out, Class<?> klass, String prefix) throws IOException {
        for (Method method : ViewDebug.getExportedPropertyMethods(klass)) {
            try {
                Object methodValue;
                block10: {
                    ExportedProperty property;
                    Class<?> returnType;
                    block8: {
                        block9: {
                            methodValue = method.invoke(view, (Object[])null);
                            returnType = method.getReturnType();
                            if (returnType != Integer.TYPE) break block8;
                            property = sAnnotations.get(method);
                            if (!property.resolveId() || context == null) break block9;
                            int id2 = (Integer)methodValue;
                            methodValue = ViewDebug.resolveId(context, id2);
                            break block10;
                        }
                        IntToString[] mapping = property.mapping();
                        if (mapping.length <= 0) break block10;
                        int intValue = (Integer)methodValue;
                        boolean mapped = false;
                        for (IntToString mapper : mapping) {
                            if (mapper.from() != intValue) continue;
                            methodValue = mapper.to();
                            mapped = true;
                            break;
                        }
                        if (mapped) break block10;
                        methodValue = intValue;
                        break block10;
                    }
                    if (returnType == int[].class) {
                        property = sAnnotations.get(method);
                        int[] array2 = (int[])methodValue;
                        String valuePrefix = prefix + method.getName() + '_';
                        String suffix = "()";
                        ViewDebug.exportUnrolledArray(context, out, property, array2, valuePrefix, "()");
                    } else if (!returnType.isPrimitive() && (property = sAnnotations.get(method)).deepExport()) {
                        ViewDebug.dumpViewProperties(context, methodValue, out, prefix + property.prefix());
                        continue;
                    }
                }
                ViewDebug.writeEntry(out, prefix, method.getName(), "()", methodValue);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    public static void exportFields(Context context, Object view, BufferedWriter out, Class<?> klass, String prefix) throws IOException {
        for (Field field : ViewDebug.getExportedPropertyFields(klass)) {
            try {
                Object fieldValue;
                block9: {
                    ExportedProperty property;
                    Class<?> type;
                    block7: {
                        block8: {
                            fieldValue = null;
                            type = field.getType();
                            if (type != Integer.TYPE) break block7;
                            property = sAnnotations.get(field);
                            if (!property.resolveId() || context == null) break block8;
                            int id2 = field.getInt(view);
                            fieldValue = ViewDebug.resolveId(context, id2);
                            break block9;
                        }
                        IntToString[] mapping = property.mapping();
                        if (mapping.length <= 0) break block9;
                        int intValue = field.getInt(view);
                        for (IntToString mapped : mapping) {
                            if (mapped.from() != intValue) continue;
                            fieldValue = mapped.to();
                            break;
                        }
                        if (fieldValue != null) break block9;
                        fieldValue = intValue;
                        break block9;
                    }
                    if (type == int[].class) {
                        property = sAnnotations.get(field);
                        int[] array2 = (int[])field.get(view);
                        String valuePrefix = prefix + field.getName() + '_';
                        String suffix = "";
                        ViewDebug.exportUnrolledArray(context, out, property, array2, valuePrefix, "");
                        return;
                    }
                    if (!type.isPrimitive() && (property = sAnnotations.get(field)).deepExport()) {
                        ViewDebug.dumpViewProperties(context, field.get(view), out, prefix + property.prefix());
                        continue;
                    }
                }
                if (fieldValue == null) {
                    fieldValue = field.get(view);
                }
                ViewDebug.writeEntry(out, prefix, field.getName(), "", fieldValue);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    public static void writeEntry(BufferedWriter out, String prefix, String name, String suffix, Object value) throws IOException {
        out.write(prefix);
        out.write(name);
        out.write(suffix);
        out.write("=");
        ViewDebug.writeValue(out, value);
        out.write(32);
    }

    public static void exportUnrolledArray(Context context, BufferedWriter out, ExportedProperty property, int[] array2, String prefix, String suffix) throws IOException {
        IntToString[] indexMapping = property.indexMapping();
        boolean hasIndexMapping = indexMapping.length > 0;
        IntToString[] mapping = property.mapping();
        boolean hasMapping = mapping.length > 0;
        boolean resolveId = property.resolveId() && context != null;
        int valuesCount = array2.length;
        for (int j = 0; j < valuesCount; ++j) {
            int intValue = array2[j];
            String name = String.valueOf(j);
            if (hasIndexMapping) {
                for (IntToString mapped : indexMapping) {
                    if (mapped.from() != j) continue;
                    name = mapped.to();
                    break;
                }
            }
            String value = String.valueOf(intValue);
            if (hasMapping) {
                for (IntToString mapped : mapping) {
                    if (mapped.from() != intValue) continue;
                    value = mapped.to();
                    break;
                }
            }
            if (resolveId) {
                value = (String)ViewDebug.resolveId(context, intValue);
            }
            ViewDebug.writeEntry(out, prefix, name, suffix, value);
        }
    }

    public static Object resolveId(Context context, int id2) {
        String fieldValue;
        Resources resources = context.getResources();
        if (id2 >= 0) {
            try {
                fieldValue = resources.getResourceTypeName(id2) + '/' + resources.getResourceEntryName(id2);
            }
            catch (Resources.NotFoundException e) {
                fieldValue = "id/0x" + Integer.toHexString(id2);
            }
        } else {
            fieldValue = "NO_ID";
        }
        return fieldValue;
    }

    public static void writeValue(BufferedWriter out, Object value) throws IOException {
        if (value != null) {
            String output = value.toString().replace("\n", "\\n");
            out.write(String.valueOf(output.length()));
            out.write(",");
            out.write(output);
        } else {
            out.write("4,null");
        }
    }

    public static void dumpViewHierarchy(ViewGroup group, BufferedWriter out, int level) {
        if (!ViewDebug.dumpView(group, out, level)) {
            return;
        }
        int count = group.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = group.getChildAt(i);
            if (view instanceof ViewGroup) {
                ViewDebug.dumpViewHierarchy((ViewGroup)view, out, level + 1);
                continue;
            }
            ViewDebug.dumpView(view, out, level + 1);
        }
    }

    public static boolean dumpView(Object view, BufferedWriter out, int level) {
        try {
            for (int i = 0; i < level; ++i) {
                out.write(32);
            }
            out.write(view.getClass().getName());
            out.write(64);
            out.write(Integer.toHexString(view.hashCode()));
            out.newLine();
        }
        catch (IOException e) {
            Log.w("View", "Error while dumping hierarchy tree");
            return false;
        }
        return true;
    }

    public static Field[] capturedViewGetPropertyFields(Class<?> klass) {
        HashMap<Class<?>, Field[]> map;
        Field[] fields;
        if (mCapturedViewFieldsForClasses == null) {
            mCapturedViewFieldsForClasses = new HashMap();
        }
        if ((fields = (map = mCapturedViewFieldsForClasses).get(klass)) != null) {
            return fields;
        }
        ArrayList<Field> foundFields = new ArrayList<Field>();
        for (Field field : klass.getFields()) {
            if (!field.isAnnotationPresent(CapturedViewProperty.class)) continue;
            field.setAccessible(true);
            foundFields.add(field);
        }
        fields = foundFields.toArray(new Field[foundFields.size()]);
        map.put(klass, fields);
        return fields;
    }

    public static Method[] capturedViewGetPropertyMethods(Class<?> klass) {
        HashMap<Class<?>, Method[]> map;
        Method[] methods;
        if (mCapturedViewMethodsForClasses == null) {
            mCapturedViewMethodsForClasses = new HashMap();
        }
        if ((methods = (map = mCapturedViewMethodsForClasses).get(klass)) != null) {
            return methods;
        }
        ArrayList<Method> foundMethods = new ArrayList<Method>();
        for (Method method : klass.getMethods()) {
            if (method.getParameterTypes().length != 0 || !method.isAnnotationPresent(CapturedViewProperty.class) || method.getReturnType() == Void.class) continue;
            method.setAccessible(true);
            foundMethods.add(method);
        }
        methods = foundMethods.toArray(new Method[foundMethods.size()]);
        map.put(klass, methods);
        return methods;
    }

    public static String capturedViewExportMethods(Object obj, Class<?> klass, String prefix) {
        if (obj == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (Method method : ViewDebug.capturedViewGetPropertyMethods(klass)) {
            try {
                Object methodValue = method.invoke(obj, (Object[])null);
                Class<?> returnType = method.getReturnType();
                CapturedViewProperty property = method.getAnnotation(CapturedViewProperty.class);
                if (property.retrieveReturn()) {
                    sb.append(ViewDebug.capturedViewExportMethods(methodValue, returnType, method.getName() + "#"));
                    continue;
                }
                sb.append(prefix);
                sb.append(method.getName());
                sb.append("()=");
                if (methodValue != null) {
                    String value = methodValue.toString().replace("\n", "\\n");
                    sb.append(value);
                } else {
                    sb.append("null");
                }
                sb.append("; ");
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static String capturedViewExportFields(Object obj, Class<?> klass, String prefix) {
        if (obj == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (Field field : ViewDebug.capturedViewGetPropertyFields(klass)) {
            try {
                Object fieldValue = field.get(obj);
                sb.append(prefix);
                sb.append(field.getName());
                sb.append("=");
                if (fieldValue != null) {
                    String value = fieldValue.toString().replace("\n", "\\n");
                    sb.append(value);
                } else {
                    sb.append("null");
                }
                sb.append(' ');
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static void dumpCapturedView(String tag, Object view) {
        Class<?> klass = view.getClass();
        StringBuilder sb = new StringBuilder(klass.getName() + ": ");
        sb.append(ViewDebug.capturedViewExportFields(view, klass, ""));
        sb.append(ViewDebug.capturedViewExportMethods(view, klass, ""));
        Log.d(tag, sb.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ViewOperation<T> {
        public T[] pre();

        public void run(T ... var1);

        public void post(T ... var1);
    }

    public static class RecyclerTrace {
        public int view;
        public RecyclerTraceType type;
        public int position;
        public int indexOnScreen;

        public RecyclerTrace() {
        }

        public /* synthetic */ RecyclerTrace(1 x0) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecyclerTraceType {
        NEW_VIEW,
        BIND_VIEW,
        RECYCLE_FROM_ACTIVE_HEAP,
        RECYCLE_FROM_SCRAP_HEAP,
        MOVE_TO_ACTIVE_HEAP,
        MOVE_TO_SCRAP_HEAP,
        MOVE_FROM_ACTIVE_TO_SCRAP_HEAP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HierarchyTraceType {
        INVALIDATE,
        INVALIDATE_CHILD,
        INVALIDATE_CHILD_IN_PARENT,
        REQUEST_LAYOUT,
        ON_LAYOUT,
        ON_MEASURE,
        DRAW,
        BUILD_CACHE;

    }

    @Target(value={ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CapturedViewProperty {
        public boolean retrieveReturn() default false;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IntToString {
        public int from();

        public String to();
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExportedProperty {
        public boolean resolveId() default false;

        public IntToString[] mapping() default {};

        public IntToString[] indexMapping() default {};

        public boolean deepExport() default false;

        public String prefix() default "";
    }
}

