/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.TextView;

public class ArrowKeyMovementMethod
implements MovementMethod {
    public static ArrowKeyMovementMethod sInstance;

    public boolean up(TextView widget, Spannable buffer) {
        boolean cap = MetaKeyKeyListener.getMetaState(buffer, 1) == 1 || MetaKeyKeyListener.getMetaState(buffer, 65536) != 0;
        boolean alt = MetaKeyKeyListener.getMetaState(buffer, 2) == 1;
        Layout layout2 = widget.getLayout();
        if (cap) {
            if (alt) {
                Selection.extendSelection(buffer, 0);
                return true;
            }
            return Selection.extendUp(buffer, layout2);
        }
        if (alt) {
            Selection.setSelection(buffer, 0);
            return true;
        }
        return Selection.moveUp(buffer, layout2);
    }

    public boolean down(TextView widget, Spannable buffer) {
        boolean cap = MetaKeyKeyListener.getMetaState(buffer, 1) == 1 || MetaKeyKeyListener.getMetaState(buffer, 65536) != 0;
        boolean alt = MetaKeyKeyListener.getMetaState(buffer, 2) == 1;
        Layout layout2 = widget.getLayout();
        if (cap) {
            if (alt) {
                Selection.extendSelection(buffer, buffer.length());
                return true;
            }
            return Selection.extendDown(buffer, layout2);
        }
        if (alt) {
            Selection.setSelection(buffer, buffer.length());
            return true;
        }
        return Selection.moveDown(buffer, layout2);
    }

    public boolean left(TextView widget, Spannable buffer) {
        boolean cap = MetaKeyKeyListener.getMetaState(buffer, 1) == 1 || MetaKeyKeyListener.getMetaState(buffer, 65536) != 0;
        boolean alt = MetaKeyKeyListener.getMetaState(buffer, 2) == 1;
        Layout layout2 = widget.getLayout();
        if (cap) {
            if (alt) {
                return Selection.extendToLeftEdge(buffer, layout2);
            }
            return Selection.extendLeft(buffer, layout2);
        }
        if (alt) {
            return Selection.moveToLeftEdge(buffer, layout2);
        }
        return Selection.moveLeft(buffer, layout2);
    }

    public boolean right(TextView widget, Spannable buffer) {
        boolean cap = MetaKeyKeyListener.getMetaState(buffer, 1) == 1 || MetaKeyKeyListener.getMetaState(buffer, 65536) != 0;
        boolean alt = MetaKeyKeyListener.getMetaState(buffer, 2) == 1;
        Layout layout2 = widget.getLayout();
        if (cap) {
            if (alt) {
                return Selection.extendToRightEdge(buffer, layout2);
            }
            return Selection.extendRight(buffer, layout2);
        }
        if (alt) {
            return Selection.moveToRightEdge(buffer, layout2);
        }
        return Selection.moveRight(buffer, layout2);
    }

    public boolean onKeyDown(TextView widget, Spannable buffer, int keyCode, KeyEvent event) {
        if (this.executeDown(widget, buffer, keyCode)) {
            MetaKeyKeyListener.adjustMetaAfterKeypress(buffer);
            MetaKeyKeyListener.resetLockedMeta(buffer);
            return true;
        }
        return false;
    }

    public boolean executeDown(TextView widget, Spannable buffer, int keyCode) {
        boolean handled = false;
        switch (keyCode) {
            case 19: {
                handled |= this.up(widget, buffer);
                break;
            }
            case 20: {
                handled |= this.down(widget, buffer);
                break;
            }
            case 21: {
                handled |= this.left(widget, buffer);
                break;
            }
            case 22: {
                handled |= this.right(widget, buffer);
                break;
            }
            case 23: {
                if (MetaKeyKeyListener.getMetaState(buffer, 65536) == 0 || !widget.showContextMenu()) break;
                handled = true;
            }
        }
        if (handled) {
            MetaKeyKeyListener.adjustMetaAfterKeypress(buffer);
            MetaKeyKeyListener.resetLockedMeta(buffer);
        }
        return handled;
    }

    public boolean onKeyUp(TextView widget, Spannable buffer, int keyCode, KeyEvent event) {
        return false;
    }

    public boolean onKeyOther(TextView view, Spannable text, KeyEvent event) {
        int code = event.getKeyCode();
        if (code != 0 && event.getAction() == 2) {
            int repeat = event.getRepeatCount();
            boolean handled = false;
            while (--repeat > 0) {
                handled |= this.executeDown(view, text, code);
            }
            return handled;
        }
        return false;
    }

    public boolean onTrackballEvent(TextView widget, Spannable text, MotionEvent event) {
        return false;
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        int initialScrollX = -1;
        int initialScrollY = -1;
        if (event.getAction() == 1) {
            initialScrollX = Touch.getInitialScrollX(widget, buffer);
            initialScrollY = Touch.getInitialScrollY(widget, buffer);
        }
        boolean handled = Touch.onTouchEvent(widget, buffer, event);
        if (widget.isFocused() && !widget.didTouchFocusSelect() && event.getAction() == 1) {
            boolean cap;
            if (initialScrollY >= 0 && initialScrollY != widget.getScrollY() || initialScrollX >= 0 && initialScrollX != widget.getScrollX()) {
                widget.moveCursorToVisibleOffset();
                return true;
            }
            int x = (int)event.getX();
            int y = (int)event.getY();
            y -= widget.getTotalPaddingTop();
            if ((x -= widget.getTotalPaddingLeft()) < 0) {
                x = 0;
            } else if (x >= widget.getWidth() - widget.getTotalPaddingRight()) {
                x = widget.getWidth() - widget.getTotalPaddingRight() - 1;
            }
            if (y < 0) {
                y = 0;
            } else if (y >= widget.getHeight() - widget.getTotalPaddingBottom()) {
                y = widget.getHeight() - widget.getTotalPaddingBottom() - 1;
            }
            Layout layout2 = widget.getLayout();
            int line = layout2.getLineForVertical(y += widget.getScrollY());
            int off = layout2.getOffsetForHorizontal(line, x += widget.getScrollX());
            boolean bl = cap = MetaKeyKeyListener.getMetaState(buffer, 1) == 1 || MetaKeyKeyListener.getMetaState(buffer, 65536) != 0;
            if (cap) {
                Selection.extendSelection(buffer, off);
            } else {
                Selection.setSelection(buffer, off);
            }
            MetaKeyKeyListener.adjustMetaAfterKeypress(buffer);
            MetaKeyKeyListener.resetLockedMeta(buffer);
            return true;
        }
        return handled;
    }

    public boolean canSelectArbitrarily() {
        return true;
    }

    public void initialize(TextView widget, Spannable text) {
        Selection.setSelection(text, 0);
    }

    public void onTakeFocus(TextView view, Spannable text, int dir) {
        if ((dir & 0x82) != 0) {
            Layout layout2 = view.getLayout();
            if (layout2 == null) {
                Selection.setSelection(text, text.length());
            } else if (layout2.getLineCount() == 1) {
                Selection.setSelection(text, text.length());
            } else {
                Selection.setSelection(text, layout2.getLineStart(1) - 1);
            }
        } else {
            Selection.setSelection(text, text.length());
        }
    }

    public static MovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new ArrowKeyMovementMethod();
        }
        return sInstance;
    }
}

