/*
 * Decompiled with CFR 0.152.
 */
package android.server.search;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchableInfo
implements Parcelable {
    public static final String LOG_TAG = "SearchableInfo";
    public static final int DBG_INHIBIT_SUGGESTIONS = 0;
    public static final String MD_LABEL_DEFAULT_SEARCHABLE = "android.app.default_searchable";
    public static final String MD_LABEL_SEARCHABLE = "android.app.searchable";
    public static final String MD_SEARCHABLE_SYSTEM_SEARCH = "*";
    public static final String MD_XML_ELEMENT_SEARCHABLE = "searchable";
    public static final String MD_XML_ELEMENT_SEARCHABLE_ACTION_KEY = "actionkey";
    public static HashMap<ComponentName, SearchableInfo> sSearchablesMap = null;
    public static ArrayList<SearchableInfo> sSearchablesList = null;
    public static SearchableInfo sDefaultSearchable = null;
    public boolean mSearchable = false;
    public int mLabelId = 0;
    public ComponentName mSearchActivity = null;
    public int mHintId = 0;
    public int mSearchMode = 0;
    public boolean mBadgeLabel = false;
    public boolean mBadgeIcon = false;
    public boolean mQueryRewriteFromData = false;
    public boolean mQueryRewriteFromText = false;
    public int mIconId = 0;
    public int mSearchButtonText = 0;
    public int mSearchInputType = 0;
    public int mSearchImeOptions = 0;
    public String mSuggestAuthority = null;
    public String mSuggestPath = null;
    public String mSuggestSelection = null;
    public String mSuggestIntentAction = null;
    public String mSuggestIntentData = null;
    public ActionKeyInfo mActionKeyList = null;
    public String mSuggestProviderPackage = null;
    public Context mCacheActivityContext = null;
    public static int VOICE_SEARCH_SHOW_BUTTON = 1;
    public static int VOICE_SEARCH_LAUNCH_WEB_SEARCH = 2;
    public static int VOICE_SEARCH_LAUNCH_RECOGNIZER = 4;
    public int mVoiceSearchMode = 0;
    public int mVoiceLanguageModeId;
    public int mVoicePromptTextId;
    public int mVoiceLanguageId;
    public int mVoiceMaxResults;
    public static final Parcelable.Creator<SearchableInfo> CREATOR = new Parcelable.Creator<SearchableInfo>(){

        @Override
        public SearchableInfo createFromParcel(Parcel in) {
            return new SearchableInfo(in);
        }

        public SearchableInfo[] newArray(int size) {
            return new SearchableInfo[size];
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultSearchable(Context context, ComponentName activity) {
        Class<SearchableInfo> clazz = SearchableInfo.class;
        synchronized (SearchableInfo.class) {
            SearchableInfo si = null;
            if (activity != null && (si = SearchableInfo.getSearchableInfo(context, activity)) != null) {
                sSearchablesList.remove(si);
                sSearchablesList.add(0, si);
            }
            sDefaultSearchable = si;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchableInfo getDefaultSearchable() {
        Class<SearchableInfo> clazz = SearchableInfo.class;
        synchronized (SearchableInfo.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultSearchable;
        }
    }

    public String getSuggestAuthority() {
        return this.mSuggestAuthority;
    }

    public String getSuggestPath() {
        return this.mSuggestPath;
    }

    public String getSuggestSelection() {
        return this.mSuggestSelection;
    }

    public String getSuggestIntentAction() {
        return this.mSuggestIntentAction;
    }

    public String getSuggestIntentData() {
        return this.mSuggestIntentData;
    }

    public Context getActivityContext(Context context) {
        Context theirContext = null;
        try {
            theirContext = context.createPackageContext(this.mSearchActivity.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return theirContext;
    }

    public Context getProviderContext(Context context, Context activityContext) {
        Context theirContext = null;
        if (this.mSearchActivity.getPackageName().equals(this.mSuggestProviderPackage)) {
            return activityContext;
        }
        if (this.mSuggestProviderPackage != null) {
            try {
                theirContext = context.createPackageContext(this.mSuggestProviderPackage, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        return theirContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchableInfo getSearchableInfo(Context context, ComponentName activity) {
        Class<SearchableInfo> clazz = SearchableInfo.class;
        synchronized (SearchableInfo.class) {
            SearchableInfo result = sSearchablesMap.get(activity);
            if (result != null) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return result;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            ActivityInfo ai = null;
            Object xml2 = null;
            try {
                ai = context.getPackageManager().getActivityInfo(activity, 128);
                String refActivityName = null;
                Bundle md = ai.metaData;
                if (md != null) {
                    refActivityName = md.getString(MD_LABEL_DEFAULT_SEARCHABLE);
                }
                if (refActivityName == null && (md = ai.applicationInfo.metaData) != null) {
                    refActivityName = md.getString(MD_LABEL_DEFAULT_SEARCHABLE);
                }
                if (refActivityName == null) return null;
                if (refActivityName.equals(MD_SEARCHABLE_SYSTEM_SEARCH)) {
                    return SearchableInfo.getDefaultSearchable();
                }
                String pkg = activity.getPackageName();
                ComponentName referredActivity = refActivityName.charAt(0) == '.' ? new ComponentName(pkg, pkg + refActivityName) : new ComponentName(pkg, refActivityName);
                Class<SearchableInfo> clazz2 = SearchableInfo.class;
                synchronized (SearchableInfo.class) {
                    result = sSearchablesMap.get(referredActivity);
                    if (result == null) return null;
                    sSearchablesMap.put(activity, result);
                    // ** MonitorExit[var9_11] (shouldn't be in output)
                    return result;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                // empty catch block
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildSearchableList(Context context) {
        Intent intent;
        HashMap<ComponentName, SearchableInfo> newSearchablesMap = new HashMap<ComponentName, SearchableInfo>();
        ArrayList<SearchableInfo> newSearchablesList = new ArrayList<SearchableInfo>();
        PackageManager pm = context.getPackageManager();
        List<ResolveInfo> infoList = pm.queryIntentActivities(intent = new Intent("android.intent.action.SEARCH"), 128);
        if (infoList != null) {
            int count = infoList.size();
            for (int ii = 0; ii < count; ++ii) {
                ResolveInfo info = infoList.get(ii);
                ActivityInfo ai = info.activityInfo;
                XmlResourceParser xml2 = ai.loadXmlMetaData(context.getPackageManager(), MD_LABEL_SEARCHABLE);
                if (xml2 == null) continue;
                ComponentName cName = new ComponentName(info.activityInfo.packageName, info.activityInfo.name);
                SearchableInfo searchable = SearchableInfo.getActivityMetaData(context, xml2, cName);
                xml2.close();
                if (searchable == null) continue;
                searchable.mCacheActivityContext = null;
                newSearchablesList.add(searchable);
                newSearchablesMap.put(cName, searchable);
            }
        }
        Class<SearchableInfo> clazz = SearchableInfo.class;
        synchronized (SearchableInfo.class) {
            sSearchablesList = newSearchablesList;
            sSearchablesMap = newSearchablesMap;
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return;
        }
    }

    public SearchableInfo(Context context, AttributeSet attr2, ComponentName cName) {
        this.mSearchable = false;
        this.mSearchActivity = cName;
        this.mCacheActivityContext = this.getActivityContext(context);
        if (this.mCacheActivityContext != null) {
            ProviderInfo pi;
            TypedArray a = this.mCacheActivityContext.obtainStyledAttributes(attr2, R.styleable.Searchable);
            this.mSearchMode = a.getInt(3, 0);
            this.mLabelId = a.getResourceId(0, 0);
            this.mHintId = a.getResourceId(2, 0);
            this.mIconId = a.getResourceId(1, 0);
            this.mSearchButtonText = a.getResourceId(9, 0);
            this.mSearchInputType = a.getInt(10, 1);
            this.mSearchImeOptions = a.getInt(16, 3);
            this.setSearchModeFlags();
            this.mSuggestAuthority = a.getString(4);
            this.mSuggestPath = a.getString(5);
            this.mSuggestSelection = a.getString(6);
            this.mSuggestIntentAction = a.getString(7);
            this.mSuggestIntentData = a.getString(8);
            this.mVoiceSearchMode = a.getInt(11, 0);
            this.mVoiceLanguageModeId = a.getResourceId(12, 0);
            this.mVoicePromptTextId = a.getResourceId(13, 0);
            this.mVoiceLanguageId = a.getResourceId(14, 0);
            this.mVoiceMaxResults = a.getInt(15, 0);
            a.recycle();
            if (this.mSuggestAuthority != null && (pi = context.getPackageManager().resolveContentProvider(this.mSuggestAuthority, 0)) != null) {
                this.mSuggestProviderPackage = pi.packageName;
            }
        }
        if (this.mLabelId != 0) {
            this.mSearchable = true;
        } else {
            Log.w(LOG_TAG, "Insufficient metadata to configure searchability for " + cName.flattenToShortString());
        }
    }

    public void setSearchModeFlags() {
        this.mBadgeLabel = 0 != (this.mSearchMode & 4);
        this.mBadgeIcon = 0 != (this.mSearchMode & 8) && this.mIconId != 0;
        this.mQueryRewriteFromData = 0 != (this.mSearchMode & 0x10);
        this.mQueryRewriteFromText = 0 != (this.mSearchMode & 0x20);
    }

    public ActionKeyInfo findActionKey(int keyCode) {
        ActionKeyInfo info = this.mActionKeyList;
        while (info != null) {
            if (info.mKeyCode == keyCode) {
                return info;
            }
            info = info.mNext;
        }
        return null;
    }

    public static SearchableInfo getActivityMetaData(Context context, XmlPullParser xml2, ComponentName cName) {
        SearchableInfo result = null;
        try {
            int tagType = xml2.next();
            while (tagType != 1) {
                if (tagType == 2) {
                    AttributeSet attr2;
                    if (xml2.getName().equals(MD_XML_ELEMENT_SEARCHABLE)) {
                        attr2 = Xml.asAttributeSet(xml2);
                        if (attr2 != null) {
                            result = new SearchableInfo(context, attr2, cName);
                            if (!result.mSearchable) {
                                return null;
                            }
                        }
                    } else if (xml2.getName().equals(MD_XML_ELEMENT_SEARCHABLE_ACTION_KEY)) {
                        if (result == null) {
                            return null;
                        }
                        attr2 = Xml.asAttributeSet(xml2);
                        if (attr2 != null) {
                            SearchableInfo searchableInfo = result;
                            searchableInfo.getClass();
                            ActionKeyInfo keyInfo = searchableInfo.new ActionKeyInfo(context, attr2, result.mActionKeyList);
                            if (keyInfo.mKeyCode != 0) {
                                result.mActionKeyList = keyInfo;
                            }
                        }
                    }
                }
                tagType = xml2.next();
            }
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public int getLabelId() {
        return this.mLabelId;
    }

    public int getHintId() {
        return this.mHintId;
    }

    public int getIconId() {
        return this.mIconId;
    }

    public boolean getVoiceSearchEnabled() {
        return 0 != (this.mVoiceSearchMode & VOICE_SEARCH_SHOW_BUTTON);
    }

    public boolean getVoiceSearchLaunchWebSearch() {
        return 0 != (this.mVoiceSearchMode & VOICE_SEARCH_LAUNCH_WEB_SEARCH);
    }

    public boolean getVoiceSearchLaunchRecognizer() {
        return 0 != (this.mVoiceSearchMode & VOICE_SEARCH_LAUNCH_RECOGNIZER);
    }

    public int getVoiceLanguageModeId() {
        return this.mVoiceLanguageModeId;
    }

    public int getVoicePromptTextId() {
        return this.mVoicePromptTextId;
    }

    public int getVoiceLanguageId() {
        return this.mVoiceLanguageId;
    }

    public int getVoiceMaxResults() {
        return this.mVoiceMaxResults;
    }

    public int getSearchButtonText() {
        return this.mSearchButtonText;
    }

    public int getInputType() {
        return this.mSearchInputType;
    }

    public int getImeOptions() {
        return this.mSearchImeOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<SearchableInfo> getSearchablesList() {
        Class<SearchableInfo> clazz = SearchableInfo.class;
        synchronized (SearchableInfo.class) {
            ArrayList<SearchableInfo> result = new ArrayList<SearchableInfo>(sSearchablesList);
            // ** MonitorExit[var0] (shouldn't be in output)
            return result;
        }
    }

    public SearchableInfo(Parcel in) {
        this.mSearchable = in.readInt() != 0;
        this.mLabelId = in.readInt();
        this.mSearchActivity = ComponentName.readFromParcel(in);
        this.mHintId = in.readInt();
        this.mSearchMode = in.readInt();
        this.mIconId = in.readInt();
        this.mSearchButtonText = in.readInt();
        this.mSearchInputType = in.readInt();
        this.mSearchImeOptions = in.readInt();
        this.setSearchModeFlags();
        this.mSuggestAuthority = in.readString();
        this.mSuggestPath = in.readString();
        this.mSuggestSelection = in.readString();
        this.mSuggestIntentAction = in.readString();
        this.mSuggestIntentData = in.readString();
        this.mActionKeyList = null;
        int count = in.readInt();
        while (count-- > 0) {
            this.mActionKeyList = new ActionKeyInfo(in, this.mActionKeyList);
        }
        this.mSuggestProviderPackage = in.readString();
        this.mVoiceSearchMode = in.readInt();
        this.mVoiceLanguageModeId = in.readInt();
        this.mVoicePromptTextId = in.readInt();
        this.mVoiceLanguageId = in.readInt();
        this.mVoiceMaxResults = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSearchable ? 1 : 0);
        dest.writeInt(this.mLabelId);
        this.mSearchActivity.writeToParcel(dest, flags);
        dest.writeInt(this.mHintId);
        dest.writeInt(this.mSearchMode);
        dest.writeInt(this.mIconId);
        dest.writeInt(this.mSearchButtonText);
        dest.writeInt(this.mSearchInputType);
        dest.writeInt(this.mSearchImeOptions);
        dest.writeString(this.mSuggestAuthority);
        dest.writeString(this.mSuggestPath);
        dest.writeString(this.mSuggestSelection);
        dest.writeString(this.mSuggestIntentAction);
        dest.writeString(this.mSuggestIntentData);
        ActionKeyInfo nextKeyInfo = this.mActionKeyList;
        int count = 0;
        while (nextKeyInfo != null) {
            ++count;
            nextKeyInfo = nextKeyInfo.mNext;
        }
        dest.writeInt(count);
        nextKeyInfo = this.mActionKeyList;
        while (count-- > 0) {
            nextKeyInfo.writeToParcel(dest, flags);
        }
        dest.writeString(this.mSuggestProviderPackage);
        dest.writeInt(this.mVoiceSearchMode);
        dest.writeInt(this.mVoiceLanguageModeId);
        dest.writeInt(this.mVoicePromptTextId);
        dest.writeInt(this.mVoiceLanguageId);
        dest.writeInt(this.mVoiceMaxResults);
    }

    public class ActionKeyInfo
    implements Parcelable {
        public int mKeyCode = 0;
        public String mQueryActionMsg;
        public String mSuggestActionMsg;
        public String mSuggestActionMsgColumn;
        public ActionKeyInfo mNext;

        public ActionKeyInfo(Context context, AttributeSet attr2, ActionKeyInfo next) {
            TypedArray a = SearchableInfo.this.mCacheActivityContext.obtainStyledAttributes(attr2, R.styleable.SearchableActionKey);
            this.mKeyCode = a.getInt(0, 0);
            this.mQueryActionMsg = a.getString(1);
            this.mSuggestActionMsg = a.getString(2);
            this.mSuggestActionMsgColumn = a.getString(3);
            a.recycle();
            this.mNext = next;
            if (this.mQueryActionMsg == null && this.mSuggestActionMsg == null && this.mSuggestActionMsgColumn == null) {
                this.mKeyCode = 0;
            }
        }

        public ActionKeyInfo(Parcel in, ActionKeyInfo next) {
            this.mKeyCode = in.readInt();
            this.mQueryActionMsg = in.readString();
            this.mSuggestActionMsg = in.readString();
            this.mSuggestActionMsgColumn = in.readString();
            this.mNext = next;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mKeyCode);
            dest.writeString(this.mQueryActionMsg);
            dest.writeString(this.mSuggestActionMsg);
            dest.writeString(this.mSuggestActionMsgColumn);
        }
    }
}

