/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.hardware.ISensorService;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorListener;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.SparseArray;
import android.view.IRotationWatcher;
import android.view.IWindowManager;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SensorManager
extends IRotationWatcher.Stub {
    public static final String TAG = "SensorManager";
    public static final float[] mTempMatrix = new float[16];
    @Deprecated
    public static final int SENSOR_ORIENTATION = 1;
    @Deprecated
    public static final int SENSOR_ACCELEROMETER = 2;
    @Deprecated
    public static final int SENSOR_TEMPERATURE = 4;
    @Deprecated
    public static final int SENSOR_MAGNETIC_FIELD = 8;
    @Deprecated
    public static final int SENSOR_LIGHT = 16;
    @Deprecated
    public static final int SENSOR_PROXIMITY = 32;
    @Deprecated
    public static final int SENSOR_TRICORDER = 64;
    @Deprecated
    public static final int SENSOR_ORIENTATION_RAW = 128;
    @Deprecated
    public static final int SENSOR_ALL = 127;
    @Deprecated
    public static final int SENSOR_MIN = 1;
    @Deprecated
    public static final int SENSOR_MAX = 64;
    @Deprecated
    public static final int DATA_X = 0;
    @Deprecated
    public static final int DATA_Y = 1;
    @Deprecated
    public static final int DATA_Z = 2;
    @Deprecated
    public static final int RAW_DATA_INDEX = 3;
    @Deprecated
    public static final int RAW_DATA_X = 3;
    @Deprecated
    public static final int RAW_DATA_Y = 4;
    @Deprecated
    public static final int RAW_DATA_Z = 5;
    public static final float STANDARD_GRAVITY = 9.80665f;
    public static final float GRAVITY_SUN = 275.0f;
    public static final float GRAVITY_MERCURY = 3.7f;
    public static final float GRAVITY_VENUS = 8.87f;
    public static final float GRAVITY_EARTH = 9.80665f;
    public static final float GRAVITY_MOON = 1.6f;
    public static final float GRAVITY_MARS = 3.71f;
    public static final float GRAVITY_JUPITER = 23.12f;
    public static final float GRAVITY_SATURN = 8.96f;
    public static final float GRAVITY_URANUS = 8.69f;
    public static final float GRAVITY_NEPTUNE = 11.0f;
    public static final float GRAVITY_PLUTO = 0.6f;
    public static final float GRAVITY_DEATH_STAR_I = 3.5303614E-7f;
    public static final float GRAVITY_THE_ISLAND = 4.815162f;
    public static final float MAGNETIC_FIELD_EARTH_MAX = 60.0f;
    public static final float MAGNETIC_FIELD_EARTH_MIN = 30.0f;
    public static final float LIGHT_SUNLIGHT_MAX = 120000.0f;
    public static final float LIGHT_SUNLIGHT = 110000.0f;
    public static final float LIGHT_SHADE = 20000.0f;
    public static final float LIGHT_OVERCAST = 10000.0f;
    public static final float LIGHT_SUNRISE = 400.0f;
    public static final float LIGHT_CLOUDY = 100.0f;
    public static final float LIGHT_FULLMOON = 0.25f;
    public static final float LIGHT_NO_MOON = 0.001f;
    public static final int SENSOR_DELAY_FASTEST = 0;
    public static final int SENSOR_DELAY_GAME = 1;
    public static final int SENSOR_DELAY_UI = 2;
    public static final int SENSOR_DELAY_NORMAL = 3;
    public static final int SENSOR_STATUS_UNRELIABLE = 0;
    public static final int SENSOR_STATUS_ACCURACY_LOW = 1;
    public static final int SENSOR_STATUS_ACCURACY_MEDIUM = 2;
    public static final int SENSOR_STATUS_ACCURACY_HIGH = 3;
    public static final int AXIS_X = 1;
    public static final int AXIS_Y = 2;
    public static final int AXIS_Z = 3;
    public static final int AXIS_MINUS_X = 129;
    public static final int AXIS_MINUS_Y = 130;
    public static final int AXIS_MINUS_Z = 131;
    public ISensorService mSensorService;
    public Looper mMainLooper;
    public HashMap<SensorListener, LegacyListener> mLegacyListenersMap = new HashMap();
    public static final int SENSOR_DISABLE = -1;
    public static boolean sSensorModuleInitialized = false;
    public static ArrayList<Sensor> sFullSensorsList = new ArrayList();
    public static SparseArray<List<Sensor>> sSensorListByType = new SparseArray();
    public static IWindowManager sWindowManager;
    public static int sRotation;
    public static SensorThread sSensorThread;
    public static SparseArray<Sensor> sHandleToSensor;
    public static final ArrayList<ListenerDelegate> sListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SensorManager(Looper mainLooper) {
        this.mSensorService = ISensorService.Stub.asInterface(ServiceManager.getService("sensor"));
        this.mMainLooper = mainLooper;
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            if (!sSensorModuleInitialized) {
                sSensorModuleInitialized = true;
                SensorManager.nativeClassInit();
                sWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
                if (sWindowManager != null) {
                    try {
                        sRotation = sWindowManager.watchRotation(this);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                SensorManager.sensors_module_init();
                ArrayList<Sensor> fullList = sFullSensorsList;
                int i = 0;
                do {
                    Sensor sensor;
                    if ((i = SensorManager.sensors_module_get_next_sensor(sensor = new Sensor(), i)) < 0) continue;
                    Log.d(TAG, "found sensor: " + sensor.getName() + ", handle=" + sensor.getHandle());
                    sensor.setLegacyType(this.getLegacySensorType(sensor.getType()));
                    fullList.add(sensor);
                    sHandleToSensor.append(sensor.getHandle(), sensor);
                } while (i > 0);
                sSensorThread = new SensorThread();
            }
        }
    }

    public int getLegacySensorType(int type) {
        switch (type) {
            case 1: {
                return 2;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 128;
            }
            case 7: {
                return 4;
            }
        }
        return 0;
    }

    @Deprecated
    public int getSensors() {
        int result = 0;
        ArrayList<Sensor> fullList = sFullSensorsList;
        for (Sensor i : fullList) {
            switch (i.getType()) {
                case 1: {
                    result |= 2;
                    break;
                }
                case 2: {
                    result |= 8;
                    break;
                }
                case 3: {
                    result |= 0x81;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Sensor> getSensorList(int type) {
        List<Sensor> list;
        ArrayList<Sensor> fullList;
        ArrayList<Sensor> arrayList = fullList = sFullSensorsList;
        synchronized (arrayList) {
            list = sSensorListByType.get(type);
            if (list == null) {
                if (type == -1) {
                    list = fullList;
                } else {
                    list = new ArrayList<Sensor>();
                    for (Sensor i : fullList) {
                        if (i.getType() != type) continue;
                        list.add(i);
                    }
                }
                list = Collections.unmodifiableList(list);
                sSensorListByType.append(type, list);
            }
        }
        return list;
    }

    public Sensor getDefaultSensor(int type) {
        List<Sensor> l = this.getSensorList(type);
        return l.isEmpty() ? null : l.get(0);
    }

    @Deprecated
    public boolean registerListener(SensorListener listener, int sensors) {
        return this.registerListener(listener, sensors, 3);
    }

    @Deprecated
    public boolean registerListener(SensorListener listener, int sensors, int rate) {
        if (listener == null) {
            return false;
        }
        boolean result = false;
        result = this.registerLegacyListener(2, 1, listener, sensors, rate) || result;
        result = this.registerLegacyListener(8, 2, listener, sensors, rate) || result;
        result = this.registerLegacyListener(128, 3, listener, sensors, rate) || result;
        result = this.registerLegacyListener(1, 3, listener, sensors, rate) || result;
        result = this.registerLegacyListener(4, 7, listener, sensors, rate) || result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerLegacyListener(int legacyType, int type, SensorListener listener, int sensors, int rate) {
        Sensor sensor;
        if (listener == null) {
            return false;
        }
        boolean result = false;
        if ((sensors & legacyType) != 0 && (sensor = this.getDefaultSensor(type)) != null) {
            LegacyListener legacyListener = null;
            HashMap<SensorListener, LegacyListener> hashMap = this.mLegacyListenersMap;
            synchronized (hashMap) {
                legacyListener = this.mLegacyListenersMap.get(listener);
                if (legacyListener == null) {
                    legacyListener = new LegacyListener(listener);
                    this.mLegacyListenersMap.put(listener, legacyListener);
                }
            }
            legacyListener.registerSensor(legacyType);
            result = this.registerListener(legacyListener, sensor, rate);
        }
        return result;
    }

    @Deprecated
    public void unregisterListener(SensorListener listener, int sensors) {
        this.unregisterLegacyListener(2, 1, listener, sensors);
        this.unregisterLegacyListener(8, 2, listener, sensors);
        this.unregisterLegacyListener(128, 3, listener, sensors);
        this.unregisterLegacyListener(1, 3, listener, sensors);
        this.unregisterLegacyListener(4, 7, listener, sensors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterLegacyListener(int legacyType, int type, SensorListener listener, int sensors) {
        Sensor sensor;
        if (listener == null) {
            return;
        }
        LegacyListener legacyListener = null;
        HashMap<SensorListener, LegacyListener> hashMap = this.mLegacyListenersMap;
        synchronized (hashMap) {
            legacyListener = this.mLegacyListenersMap.get(listener);
        }
        if (legacyListener != null && (sensors & legacyType) != 0 && (sensor = this.getDefaultSensor(type)) != null && legacyListener.unregisterSensor(legacyType)) {
            this.unregisterListener(legacyListener, sensor);
            ArrayList<ListenerDelegate> arrayList = sListeners;
            synchronized (arrayList) {
                boolean found = false;
                for (ListenerDelegate i : sListeners) {
                    if (i.getListener() != legacyListener) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    HashMap<SensorListener, LegacyListener> hashMap2 = this.mLegacyListenersMap;
                    synchronized (hashMap2) {
                        this.mLegacyListenersMap.remove(listener);
                    }
                }
            }
        }
    }

    @Deprecated
    public void unregisterListener(SensorListener listener) {
        this.unregisterListener(listener, 255);
    }

    public void unregisterListener(SensorEventListener listener, Sensor sensor) {
        this.unregisterListener((Object)listener, sensor);
    }

    public void unregisterListener(SensorEventListener listener) {
        this.unregisterListener((Object)listener);
    }

    public boolean registerListener(SensorEventListener listener, Sensor sensor, int rate) {
        return this.registerListener(listener, sensor, rate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerListener(SensorEventListener listener, Sensor sensor, int rate, Handler handler) {
        boolean result;
        if (listener == null || sensor == null) {
            return false;
        }
        int delay = -1;
        switch (rate) {
            case 0: {
                delay = 0;
                break;
            }
            case 1: {
                delay = 20;
                break;
            }
            case 2: {
                delay = 60;
                break;
            }
            case 3: {
                delay = 200;
                break;
            }
            default: {
                return false;
            }
        }
        try {
            ArrayList<ListenerDelegate> arrayList = sListeners;
            synchronized (arrayList) {
                ListenerDelegate l = null;
                for (ListenerDelegate i : sListeners) {
                    if (i.getListener() != listener) continue;
                    l = i;
                    break;
                }
                String name = sensor.getName();
                int handle = sensor.getHandle();
                if (l == null) {
                    l = new ListenerDelegate(listener, sensor, handler);
                    result = this.mSensorService.enableSensor(l, name, handle, delay);
                    if (result) {
                        sListeners.add(l);
                        sListeners.notify();
                    }
                    if (!sListeners.isEmpty()) {
                        sSensorThread.startLocked(this.mSensorService);
                    }
                } else {
                    result = this.mSensorService.enableSensor(l, name, handle, delay);
                    if (result) {
                        l.addSensor(sensor);
                    }
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in registerListener: ", e);
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(Object listener, Sensor sensor) {
        if (listener == null || sensor == null) {
            return;
        }
        try {
            ArrayList<ListenerDelegate> arrayList = sListeners;
            synchronized (arrayList) {
                int size = sListeners.size();
                for (int i = 0; i < size; ++i) {
                    ListenerDelegate l = sListeners.get(i);
                    if (l.getListener() != listener) continue;
                    String name = sensor.getName();
                    int handle = sensor.getHandle();
                    this.mSensorService.enableSensor(l, name, handle, -1);
                    if (l.removeSensor(sensor) != 0) break;
                    sListeners.remove(i);
                    break;
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in unregisterListener: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(Object listener) {
        if (listener == null) {
            return;
        }
        try {
            ArrayList<ListenerDelegate> arrayList = sListeners;
            synchronized (arrayList) {
                int size = sListeners.size();
                for (int i = 0; i < size; ++i) {
                    ListenerDelegate l = sListeners.get(i);
                    if (l.getListener() != listener) continue;
                    for (Sensor sensor : l.getSensors()) {
                        String name = sensor.getName();
                        int handle = sensor.getHandle();
                        this.mSensorService.enableSensor(l, name, handle, -1);
                    }
                    sListeners.remove(i);
                    break;
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in unregisterListener: ", e);
        }
    }

    public static boolean getRotationMatrix(float[] R2, float[] I, float[] gravity, float[] geomagnetic) {
        float Ey = geomagnetic[1];
        float Az = gravity[2];
        float Ez = geomagnetic[2];
        float Ay = gravity[1];
        float Hx = Ey * Az - Ez * Ay;
        float Ax = gravity[0];
        float Ex = geomagnetic[0];
        float Hy = Ez * Ax - Ex * Az;
        float Hz = Ex * Ay - Ey * Ax;
        float normH = (float)Math.sqrt(Hx * Hx + Hy * Hy + Hz * Hz);
        if (normH < 0.1f) {
            return false;
        }
        float invH = 1.0f / normH;
        float invA = 1.0f / (float)Math.sqrt(Ax * Ax + Ay * Ay + Az * Az);
        float Mx = (Ay *= invA) * (Hz *= invH) - (Az *= invA) * (Hy *= invH);
        float My = Az * (Hx *= invH) - (Ax *= invA) * Hz;
        float Mz = Ax * Hy - Ay * Hx;
        if (R2 != null) {
            if (R2.length == 9) {
                R2[0] = Hx;
                R2[1] = Hy;
                R2[2] = Hz;
                R2[3] = Mx;
                R2[4] = My;
                R2[5] = Mz;
                R2[6] = Ax;
                R2[7] = Ay;
                R2[8] = Az;
            } else if (R2.length == 16) {
                R2[0] = Hx;
                R2[1] = Hy;
                R2[2] = Hz;
                R2[3] = 0.0f;
                R2[4] = Mx;
                R2[5] = My;
                R2[6] = Mz;
                R2[7] = 0.0f;
                R2[8] = Ax;
                R2[9] = Ay;
                R2[10] = Az;
                R2[11] = 0.0f;
                R2[12] = 0.0f;
                R2[13] = 0.0f;
                R2[14] = 0.0f;
                R2[15] = 1.0f;
            }
        }
        if (I != null) {
            float invE = 1.0f / (float)Math.sqrt(Ex * Ex + Ey * Ey + Ez * Ez);
            float c = (Ex * Mx + Ey * My + Ez * Mz) * invE;
            float s = (Ex * Ax + Ey * Ay + Ez * Az) * invE;
            if (I.length == 9) {
                I[0] = 1.0f;
                I[1] = 0.0f;
                I[2] = 0.0f;
                I[3] = 0.0f;
                I[4] = c;
                I[5] = s;
                I[6] = 0.0f;
                I[7] = -s;
                I[8] = c;
            } else if (I.length == 16) {
                I[0] = 1.0f;
                I[1] = 0.0f;
                I[2] = 0.0f;
                I[4] = 0.0f;
                I[5] = c;
                I[6] = s;
                I[8] = 0.0f;
                I[9] = -s;
                I[10] = c;
                I[14] = 0.0f;
                I[13] = 0.0f;
                I[12] = 0.0f;
                I[11] = 0.0f;
                I[7] = 0.0f;
                I[3] = 0.0f;
                I[15] = 1.0f;
            }
        }
        return true;
    }

    public static float getInclination(float[] I) {
        if (I.length == 9) {
            return (float)Math.atan2(I[5], I[4]);
        }
        return (float)Math.atan2(I[6], I[5]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean remapCoordinateSystem(float[] inR, int X, int Y, float[] outR) {
        float[] temp;
        if (inR != outR) return SensorManager.remapCoordinateSystemImpl(inR, X, Y, outR);
        float[] fArray = temp = mTempMatrix;
        synchronized (temp) {
            if (!SensorManager.remapCoordinateSystemImpl(inR, X, Y, temp)) return SensorManager.remapCoordinateSystemImpl(inR, X, Y, outR);
            int size = outR.length;
            for (int i = 0; i < size; ++i) {
                outR[i] = temp[i];
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    public static boolean remapCoordinateSystemImpl(float[] inR, int X, int Y, float[] outR) {
        int length = outR.length;
        if (inR.length != length) {
            return false;
        }
        if ((X & 0x7C) != 0 || (Y & 0x7C) != 0) {
            return false;
        }
        if ((X & 3) == 0 || (Y & 3) == 0) {
            return false;
        }
        if ((X & 3) == (Y & 3)) {
            return false;
        }
        int x = (X & 3) - 1;
        int Z = X ^ Y;
        int z = (Z & 3) - 1;
        int axis_y = (z + 1) % 3;
        int y = (Y & 3) - 1;
        int axis_z = (z + 2) % 3;
        if ((x ^ axis_y | y ^ axis_z) != 0) {
            Z ^= 0x80;
        }
        boolean sx = X >= 128;
        boolean sy = Y >= 128;
        boolean sz = Z >= 128;
        int rowLength = length == 16 ? 4 : 3;
        for (int j = 0; j < 3; ++j) {
            int offset = j * rowLength;
            for (int i = 0; i < 3; ++i) {
                if (x == i) {
                    float f = outR[offset + i] = sx ? -inR[offset + 0] : inR[offset + 0];
                }
                if (y == i) {
                    float f = outR[offset + i] = sy ? -inR[offset + 1] : inR[offset + 1];
                }
                if (z != i) continue;
                outR[offset + i] = sz ? -inR[offset + 2] : inR[offset + 2];
            }
        }
        if (length == 16) {
            outR[14] = 0.0f;
            outR[13] = 0.0f;
            outR[12] = 0.0f;
            outR[11] = 0.0f;
            outR[7] = 0.0f;
            outR[3] = 0.0f;
            outR[15] = 1.0f;
        }
        return true;
    }

    public static float[] getOrientation(float[] R2, float[] values) {
        if (R2.length == 9) {
            values[0] = (float)Math.atan2(R2[1], R2[4]);
            values[1] = (float)Math.asin(-R2[7]);
            values[2] = (float)Math.atan2(-R2[6], R2[8]);
        } else {
            values[0] = (float)Math.atan2(R2[1], R2[5]);
            values[1] = (float)Math.asin(-R2[9]);
            values[2] = (float)Math.atan2(-R2[8], R2[10]);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRotationChanged(int rotation) {
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            sRotation = rotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRotation() {
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            return sRotation;
        }
    }

    public static void nativeClassInit() {
        OverrideMethod.invokeV("android.hardware.SensorManager#nativeClassInit()V", true, null);
    }

    public static int sensors_module_init() {
        return OverrideMethod.invokeI("android.hardware.SensorManager#sensors_module_init()I", true, null);
    }

    public static int sensors_module_get_next_sensor(Sensor sensor, int n) {
        return OverrideMethod.invokeI("android.hardware.SensorManager#sensors_module_get_next_sensor(Landroid/hardware/Sensor;I)I", true, null);
    }

    public static int sensors_data_init() {
        return OverrideMethod.invokeI("android.hardware.SensorManager#sensors_data_init()I", true, null);
    }

    public static int sensors_data_uninit() {
        return OverrideMethod.invokeI("android.hardware.SensorManager#sensors_data_uninit()I", true, null);
    }

    public static int sensors_data_open(FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeI("android.hardware.SensorManager#sensors_data_open(Ljava/io/FileDescriptor;)I", true, null);
    }

    public static int sensors_data_close() {
        return OverrideMethod.invokeI("android.hardware.SensorManager#sensors_data_close()I", true, null);
    }

    public static int sensors_data_poll(float[] fArray, int[] nArray, long[] lArray) {
        return OverrideMethod.invokeI("android.hardware.SensorManager#sensors_data_poll([F[I[J)I", true, null);
    }

    static {
        sRotation = 0;
        sHandleToSensor = new SparseArray();
        sListeners = new ArrayList();
    }

    public class LmsFilter {
        public static final int SENSORS_RATE_MS = 20;
        public static final int COUNT = 12;
        public static final float PREDICTION_RATIO = 0.33333334f;
        public static final float PREDICTION_TIME = 0.08f;
        public float[] mV = new float[24];
        public float[] mT = new float[24];
        public int mIndex = 12;

        public float filter(long time, float in) {
            float v = in;
            float ns = 1.0E-9f;
            float t = (float)time * 1.0E-9f;
            float v1 = this.mV[this.mIndex];
            if (v - v1 > 180.0f) {
                v -= 360.0f;
            } else if (v1 - v > 180.0f) {
                v += 360.0f;
            }
            ++this.mIndex;
            if (this.mIndex >= 24) {
                this.mIndex = 12;
            }
            this.mV[this.mIndex] = v;
            this.mT[this.mIndex] = t;
            this.mV[this.mIndex - 12] = v;
            this.mT[this.mIndex - 12] = t;
            float E = 0.0f;
            float D = 0.0f;
            float C = 0.0f;
            float B = 0.0f;
            float A = 0.0f;
            for (int i = 0; i < 11; ++i) {
                int j = this.mIndex - 1 - i;
                float Z = this.mV[j];
                float T = 0.5f * (this.mT[j] + this.mT[j + 1]) - t;
                float dT = this.mT[j] - this.mT[j + 1];
                dT *= dT;
                A += Z * dT;
                B += T * (T * dT);
                C += T * dT;
                D += Z * (T * dT);
                E += dT;
            }
            float b = (A * B + C * D) / (E * B + C * C);
            float a = (E * b - A) / C;
            float f = b + 0.08f * a;
            float f2 = (f *= 0.0027777778f) >= 0.0f ? f : -f;
            if (f2 >= 0.5f) {
                f = f - (float)Math.ceil(f + 0.5f) + 1.0f;
            }
            if (f < 0.0f) {
                f += 1.0f;
            }
            return f *= 360.0f;
        }
    }

    public class LegacyListener
    implements SensorEventListener {
        public float[] mValues = new float[6];
        public SensorListener mTarget;
        public int mSensors;
        public final LmsFilter mYawfilter = new LmsFilter();

        public LegacyListener(SensorListener target) {
            this.mTarget = target;
            this.mSensors = 0;
        }

        public void registerSensor(int legacyType) {
            this.mSensors |= legacyType;
        }

        public boolean unregisterSensor(int legacyType) {
            this.mSensors &= ~legacyType;
            int mask = 129;
            return (legacyType & mask) == 0 || (this.mSensors & mask) == 0;
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
            try {
                this.mTarget.onAccuracyChanged(sensor.getLegacyType(), accuracy);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }

        public void onSensorChanged(SensorEvent event) {
            float[] v = this.mValues;
            v[0] = event.values[0];
            v[1] = event.values[1];
            v[2] = event.values[2];
            int legacyType = event.sensor.getLegacyType();
            this.mapSensorDataToWindow(legacyType, v, SensorManager.getRotation());
            if (event.sensor.getType() == 3) {
                if ((this.mSensors & 0x80) != 0) {
                    this.mTarget.onSensorChanged(128, v);
                }
                if ((this.mSensors & 1) != 0) {
                    v[0] = this.mYawfilter.filter(event.timestamp, v[0]);
                    this.mTarget.onSensorChanged(1, v);
                }
            } else {
                this.mTarget.onSensorChanged(legacyType, v);
            }
        }

        public void mapSensorDataToWindow(int sensor, float[] values, int orientation) {
            float x = values[0];
            float y = values[1];
            float z = values[2];
            switch (sensor) {
                case 1: 
                case 128: {
                    z = -z;
                    break;
                }
                case 2: {
                    x = -x;
                    y = -y;
                    z = -z;
                    break;
                }
                case 8: {
                    x = -x;
                    y = -y;
                }
            }
            values[0] = x;
            values[1] = y;
            values[2] = z;
            values[3] = x;
            values[4] = y;
            values[5] = z;
            if (orientation == 1) {
                switch (sensor) {
                    case 2: 
                    case 8: {
                        values[0] = -y;
                        values[1] = x;
                        values[2] = z;
                        break;
                    }
                    case 1: 
                    case 128: {
                        values[0] = x + (float)(x < 270.0f ? 90 : -270);
                        values[1] = z;
                        values[2] = y;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListenerDelegate
    extends Binder {
        public final SensorEventListener mSensorEventListener;
        public final ArrayList<Sensor> mSensorList = new ArrayList();
        public final Handler mHandler;
        public SensorEvent mValuesPool;
        public int mSensors;

        public ListenerDelegate(SensorEventListener listener, Sensor sensor, Handler handler) {
            this.mSensorEventListener = listener;
            Looper looper = handler != null ? handler.getLooper() : SensorManager.this.mMainLooper;
            this.mHandler = new Handler(looper){

                public void handleMessage(Message msg) {
                    SensorEvent t = (SensorEvent)msg.obj;
                    if (t.accuracy >= 0) {
                        ListenerDelegate.this.mSensorEventListener.onAccuracyChanged(t.sensor, t.accuracy);
                    }
                    ListenerDelegate.this.mSensorEventListener.onSensorChanged(t);
                    ListenerDelegate.this.returnToPool(t);
                }
            };
            this.addSensor(sensor);
        }

        public SensorEvent createSensorEvent() {
            return new SensorEvent(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SensorEvent getFromPool() {
            SensorEvent t = null;
            ListenerDelegate listenerDelegate = this;
            synchronized (listenerDelegate) {
                t = this.mValuesPool;
                this.mValuesPool = null;
            }
            if (t == null) {
                t = this.createSensorEvent();
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void returnToPool(SensorEvent t) {
            ListenerDelegate listenerDelegate = this;
            synchronized (listenerDelegate) {
                if (this.mValuesPool == null) {
                    this.mValuesPool = t;
                }
            }
        }

        public Object getListener() {
            return this.mSensorEventListener;
        }

        public int addSensor(Sensor sensor) {
            this.mSensors |= 1 << sensor.getHandle();
            this.mSensorList.add(sensor);
            return this.mSensors;
        }

        public int removeSensor(Sensor sensor) {
            this.mSensors &= ~(1 << sensor.getHandle());
            this.mSensorList.remove(sensor);
            return this.mSensors;
        }

        public boolean hasSensor(Sensor sensor) {
            return (this.mSensors & 1 << sensor.getHandle()) != 0;
        }

        public List<Sensor> getSensors() {
            return this.mSensorList;
        }

        public void onSensorChangedLocked(Sensor sensor, float[] values, long[] timestamp, int accuracy) {
            SensorEvent t = this.getFromPool();
            float[] v = t.values;
            v[0] = values[0];
            v[1] = values[1];
            v[2] = values[2];
            t.timestamp = timestamp[0];
            t.accuracy = accuracy;
            t.sensor = sensor;
            Message msg = Message.obtain();
            msg.what = 0;
            msg.obj = t;
            this.mHandler.sendMessage(msg);
        }
    }

    public static class SensorThread {
        public Thread mThread;

        public SensorThread() {
            SensorManager.sensors_data_init();
        }

        public void finalize() {
            SensorManager.sensors_data_uninit();
        }

        public void startLocked(ISensorService service) {
            try {
                if (this.mThread == null) {
                    ParcelFileDescriptor fd = service.getDataChanel();
                    this.mThread = new Thread((Runnable)new SensorThreadRunnable(fd), SensorThread.class.getName());
                    this.mThread.start();
                }
            }
            catch (RemoteException e) {
                Log.e(SensorManager.TAG, "RemoteException in startLocked: ", e);
            }
        }

        public class SensorThreadRunnable
        implements Runnable {
            public ParcelFileDescriptor mSensorDataFd;

            public SensorThreadRunnable(ParcelFileDescriptor fd) {
                this.mSensorDataFd = fd;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                float[] values = new float[3];
                int[] status = new int[1];
                long[] timestamp = new long[1];
                Process.setThreadPriority(-4);
                if (this.mSensorDataFd == null) {
                    Log.e(SensorManager.TAG, "mSensorDataFd == NULL, exiting");
                    ArrayList<ListenerDelegate> arrayList = sListeners;
                    synchronized (arrayList) {
                        SensorThread.this.mThread = null;
                    }
                    return;
                }
                SensorManager.sensors_data_open(this.mSensorDataFd.getFileDescriptor());
                try {
                    this.mSensorDataFd.close();
                }
                catch (IOException e) {
                    Log.e(SensorManager.TAG, "IOException: ", e);
                }
                this.mSensorDataFd = null;
                while (true) {
                    int sensor = SensorManager.sensors_data_poll(values, status, timestamp);
                    int accuracy = status[0];
                    ArrayList<ListenerDelegate> arrayList = sListeners;
                    synchronized (arrayList) {
                        if (sensor == -1 || sListeners.isEmpty()) {
                            if (sensor == -1) {
                                Log.d(SensorManager.TAG, "_sensors_data_poll() failed, we bail out.");
                            }
                            SensorManager.sensors_data_close();
                            SensorThread.this.mThread = null;
                            break;
                        }
                        Sensor sensorObject = sHandleToSensor.get(sensor);
                        if (sensorObject != null) {
                            int size = sListeners.size();
                            for (int i = 0; i < size; ++i) {
                                ListenerDelegate listener = sListeners.get(i);
                                if (!listener.hasSensor(sensorObject)) continue;
                                listener.onSensorChangedLocked(sensorObject, values, timestamp, accuracy);
                            }
                        }
                    }
                }
            }
        }
    }
}

