/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.SystemClock;

public class TransitionDrawable
extends LayerDrawable
implements Drawable.Callback {
    public static final int TRANSITION_STARTING = 0;
    public static final int TRANSITION_RUNNING = 1;
    public static final int TRANSITION_NONE = 2;
    public int mTransitionState = 2;
    public boolean mReverse;
    public long mStartTimeMillis;
    public int mFrom;
    public int mTo;
    public int mDuration;
    public int mOriginalDuration;
    public int mAlpha = 0;
    public boolean mCrossFade;

    public TransitionDrawable(Drawable[] layers) {
        this(new TransitionState(null, null), layers);
    }

    public TransitionDrawable() {
        this(new TransitionState(null, null));
    }

    public TransitionDrawable(TransitionState state) {
        super(state);
    }

    public TransitionDrawable(TransitionState state, Drawable[] layers) {
        super(layers, state);
    }

    public LayerDrawable.LayerState createConstantState(LayerDrawable.LayerState state) {
        return new TransitionState((TransitionState)state, this);
    }

    public void startTransition(int durationMillis) {
        this.mFrom = 0;
        this.mTo = 255;
        this.mAlpha = 0;
        this.mDuration = this.mOriginalDuration = durationMillis;
        this.mReverse = false;
        this.mTransitionState = 0;
        this.invalidateSelf();
    }

    public void resetTransition() {
        this.mAlpha = 0;
        this.mTransitionState = 2;
        this.invalidateSelf();
    }

    public void reverseTransition(int duration) {
        long time = SystemClock.uptimeMillis();
        if (time - this.mStartTimeMillis > (long)this.mDuration) {
            if (this.mAlpha == 0) {
                this.mFrom = 0;
                this.mTo = 255;
                this.mAlpha = 0;
                this.mReverse = false;
            } else {
                this.mFrom = 255;
                this.mTo = 0;
                this.mAlpha = 255;
                this.mReverse = true;
            }
            this.mDuration = this.mOriginalDuration = duration;
            this.mTransitionState = 0;
            this.invalidateSelf();
            return;
        }
        this.mReverse = !this.mReverse;
        this.mFrom = this.mAlpha;
        this.mTo = this.mReverse ? 0 : 255;
        this.mDuration = (int)(this.mReverse ? time - this.mStartTimeMillis : (long)this.mOriginalDuration - (time - this.mStartTimeMillis));
        this.mTransitionState = 0;
    }

    public void draw(Canvas canvas) {
        boolean done = true;
        switch (this.mTransitionState) {
            case 0: {
                this.mStartTimeMillis = SystemClock.uptimeMillis();
                done = false;
                this.mTransitionState = 1;
                break;
            }
            case 1: {
                if (this.mStartTimeMillis < 0L) break;
                float normalized = (float)(SystemClock.uptimeMillis() - this.mStartTimeMillis) / (float)this.mDuration;
                done = normalized >= 1.0f;
                normalized = Math.min(normalized, 1.0f);
                this.mAlpha = (int)((float)this.mFrom + (float)(this.mTo - this.mFrom) * normalized);
            }
        }
        int alpha = this.mAlpha;
        boolean crossFade = this.mCrossFade;
        LayerDrawable.ChildDrawable[] array2 = this.mLayerState.mChildren;
        Drawable d = array2[0].mDrawable;
        if (crossFade) {
            d.setAlpha(255 - alpha);
        }
        d.draw(canvas);
        if (crossFade) {
            d.setAlpha(255);
        }
        if (alpha > 0) {
            d = array2[1].mDrawable;
            d.setAlpha(alpha);
            d.draw(canvas);
            d.setAlpha(255);
        }
        if (!done) {
            this.invalidateSelf();
        }
    }

    public void setCrossFadeEnabled(boolean enabled) {
        this.mCrossFade = enabled;
    }

    public boolean isCrossFadeEnabled() {
        return this.mCrossFade;
    }

    public /* synthetic */ TransitionDrawable(TransitionState x0, 1 x1) {
        this(x0);
    }

    public static class 1 {
    }

    public static class TransitionState
    extends LayerDrawable.LayerState {
        public TransitionState(TransitionState orig, TransitionDrawable owner) {
            super(orig, owner);
        }

        public Drawable newDrawable() {
            return new TransitionDrawable(this, null);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

