/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rasterizer;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.TemporaryBuffer;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import com.android.tools.layoutlib.create.OverrideMethod;

public class _Original_Paint {
    public int mNativePaint;
    public ColorFilter mColorFilter;
    public MaskFilter mMaskFilter;
    public PathEffect mPathEffect;
    public Rasterizer mRasterizer;
    public Shader mShader;
    public Typeface mTypeface;
    public Xfermode mXfermode;
    public static final Style[] sStyleArray = new Style[]{Style.FILL, Style.STROKE, Style.FILL_AND_STROKE};
    public static final Cap[] sCapArray = new Cap[]{Cap.BUTT, Cap.ROUND, Cap.SQUARE};
    public static final Join[] sJoinArray = new Join[]{Join.MITER, Join.ROUND, Join.BEVEL};
    public static final Align[] sAlignArray = new Align[]{Align.LEFT, Align.CENTER, Align.RIGHT};
    public static final int ANTI_ALIAS_FLAG = 1;
    public static final int FILTER_BITMAP_FLAG = 2;
    public static final int DITHER_FLAG = 4;
    public static final int UNDERLINE_TEXT_FLAG = 8;
    public static final int STRIKE_THRU_TEXT_FLAG = 16;
    public static final int FAKE_BOLD_TEXT_FLAG = 32;
    public static final int LINEAR_TEXT_FLAG = 64;
    public static final int SUBPIXEL_TEXT_FLAG = 128;
    public static final int DEV_KERN_TEXT_FLAG = 256;
    public static final int DEFAULT_PAINT_FLAGS = 256;

    public _Original_Paint() {
        this(0);
    }

    public _Original_Paint(int flags) {
        this.mNativePaint = _Original_Paint.native_init();
        this.setFlags(flags | 0x100);
    }

    public _Original_Paint(_Original_Paint paint) {
        this.mNativePaint = _Original_Paint.native_initWithPaint(paint.mNativePaint);
    }

    public void reset() {
        _Original_Paint.native_reset(this.mNativePaint);
        this.setFlags(256);
    }

    public void set(_Original_Paint src) {
        if (this != src) {
            _Original_Paint.native_set(this.mNativePaint, src.mNativePaint);
            this.mColorFilter = src.mColorFilter;
            this.mMaskFilter = src.mMaskFilter;
            this.mPathEffect = src.mPathEffect;
            this.mRasterizer = src.mRasterizer;
            this.mShader = src.mShader;
            this.mTypeface = src.mTypeface;
            this.mXfermode = src.mXfermode;
        }
    }

    public int getFlags() {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#getFlags()I", true, this);
    }

    public void setFlags(int n) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setFlags(I)V", true, this);
    }

    public boolean isAntiAlias() {
        return (this.getFlags() & 1) != 0;
    }

    public void setAntiAlias(boolean bl) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setAntiAlias(Z)V", true, this);
    }

    public boolean isDither() {
        return (this.getFlags() & 4) != 0;
    }

    public void setDither(boolean bl) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setDither(Z)V", true, this);
    }

    public boolean isLinearText() {
        return (this.getFlags() & 0x40) != 0;
    }

    public void setLinearText(boolean bl) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setLinearText(Z)V", true, this);
    }

    public boolean isSubpixelText() {
        return (this.getFlags() & 0x80) != 0;
    }

    public void setSubpixelText(boolean bl) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setSubpixelText(Z)V", true, this);
    }

    public boolean isUnderlineText() {
        return (this.getFlags() & 8) != 0;
    }

    public void setUnderlineText(boolean bl) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setUnderlineText(Z)V", true, this);
    }

    public boolean isStrikeThruText() {
        return (this.getFlags() & 0x10) != 0;
    }

    public void setStrikeThruText(boolean bl) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setStrikeThruText(Z)V", true, this);
    }

    public boolean isFakeBoldText() {
        return (this.getFlags() & 0x20) != 0;
    }

    public void setFakeBoldText(boolean bl) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setFakeBoldText(Z)V", true, this);
    }

    public boolean isFilterBitmap() {
        return (this.getFlags() & 2) != 0;
    }

    public void setFilterBitmap(boolean bl) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setFilterBitmap(Z)V", true, this);
    }

    public void setStyle(Style style2) {
        _Original_Paint.native_setStyle(this.mNativePaint, style2.nativeInt);
    }

    public int getColor() {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#getColor()I", true, this);
    }

    public void setColor(int n) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setColor(I)V", true, this);
    }

    public int getAlpha() {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#getAlpha()I", true, this);
    }

    public void setAlpha(int n) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setAlpha(I)V", true, this);
    }

    public void setARGB(int a, int r, int g, int b) {
        this.setColor(a << 24 | r << 16 | g << 8 | b);
    }

    public float getStrokeWidth() {
        return OverrideMethod.invokeF("android.graphics._Original_Paint#getStrokeWidth()F", true, this);
    }

    public void setStrokeWidth(float f) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setStrokeWidth(F)V", true, this);
    }

    public float getStrokeMiter() {
        return OverrideMethod.invokeF("android.graphics._Original_Paint#getStrokeMiter()F", true, this);
    }

    public void setStrokeMiter(float f) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setStrokeMiter(F)V", true, this);
    }

    public void setStrokeCap(Cap cap) {
        _Original_Paint.native_setStrokeCap(this.mNativePaint, cap.nativeInt);
    }

    public void setStrokeJoin(Join join) {
        _Original_Paint.native_setStrokeJoin(this.mNativePaint, join.nativeInt);
    }

    public boolean getFillPath(Path src, Path dst) {
        return _Original_Paint.native_getFillPath(this.mNativePaint, src.ni(), dst.ni());
    }

    public Shader getShader() {
        return this.mShader;
    }

    public Shader setShader(Shader shader) {
        int shaderNative = 0;
        if (shader != null) {
            shaderNative = shader.native_instance;
        }
        _Original_Paint.native_setShader(this.mNativePaint, shaderNative);
        this.mShader = shader;
        return shader;
    }

    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public ColorFilter setColorFilter(ColorFilter filter) {
        int filterNative = 0;
        if (filter != null) {
            filterNative = filter.native_instance;
        }
        _Original_Paint.native_setColorFilter(this.mNativePaint, filterNative);
        this.mColorFilter = filter;
        return filter;
    }

    public Xfermode getXfermode() {
        return this.mXfermode;
    }

    public Xfermode setXfermode(Xfermode xfermode) {
        int xfermodeNative = 0;
        if (xfermode != null) {
            xfermodeNative = xfermode.native_instance;
        }
        _Original_Paint.native_setXfermode(this.mNativePaint, xfermodeNative);
        this.mXfermode = xfermode;
        return xfermode;
    }

    public PathEffect getPathEffect() {
        return this.mPathEffect;
    }

    public PathEffect setPathEffect(PathEffect effect) {
        int effectNative = 0;
        if (effect != null) {
            effectNative = effect.native_instance;
        }
        _Original_Paint.native_setPathEffect(this.mNativePaint, effectNative);
        this.mPathEffect = effect;
        return effect;
    }

    public MaskFilter getMaskFilter() {
        return this.mMaskFilter;
    }

    public MaskFilter setMaskFilter(MaskFilter maskfilter) {
        int maskfilterNative = 0;
        if (maskfilter != null) {
            maskfilterNative = maskfilter.native_instance;
        }
        _Original_Paint.native_setMaskFilter(this.mNativePaint, maskfilterNative);
        this.mMaskFilter = maskfilter;
        return maskfilter;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public Typeface setTypeface(Typeface typeface) {
        int typefaceNative = 0;
        if (typeface != null) {
            typefaceNative = typeface.native_instance;
        }
        _Original_Paint.native_setTypeface(this.mNativePaint, typefaceNative);
        this.mTypeface = typeface;
        return typeface;
    }

    public Rasterizer getRasterizer() {
        return this.mRasterizer;
    }

    public Rasterizer setRasterizer(Rasterizer rasterizer) {
        int rasterizerNative = 0;
        if (rasterizer != null) {
            rasterizerNative = rasterizer.native_instance;
        }
        _Original_Paint.native_setRasterizer(this.mNativePaint, rasterizerNative);
        this.mRasterizer = rasterizer;
        return rasterizer;
    }

    public void setShadowLayer(float f, float f2, float f3, int n) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setShadowLayer(FFFI)V", true, this);
    }

    public void clearShadowLayer() {
        this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
    }

    public void setTextAlign(Align align) {
        _Original_Paint.native_setTextAlign(this.mNativePaint, align.nativeInt);
    }

    public float getTextSize() {
        return OverrideMethod.invokeF("android.graphics._Original_Paint#getTextSize()F", true, this);
    }

    public void setTextSize(float f) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setTextSize(F)V", true, this);
    }

    public float getTextScaleX() {
        return OverrideMethod.invokeF("android.graphics._Original_Paint#getTextScaleX()F", true, this);
    }

    public void setTextScaleX(float f) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setTextScaleX(F)V", true, this);
    }

    public float getTextSkewX() {
        return OverrideMethod.invokeF("android.graphics._Original_Paint#getTextSkewX()F", true, this);
    }

    public void setTextSkewX(float f) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#setTextSkewX(F)V", true, this);
    }

    public float ascent() {
        return OverrideMethod.invokeF("android.graphics._Original_Paint#ascent()F", true, this);
    }

    public float descent() {
        return OverrideMethod.invokeF("android.graphics._Original_Paint#descent()F", true, this);
    }

    public float getFontMetrics(FontMetrics fontMetrics) {
        return OverrideMethod.invokeF("android.graphics._Original_Paint#getFontMetrics(Landroid/graphics/Paint$FontMetrics;)F", true, this);
    }

    public int getFontMetricsInt(FontMetricsInt fontMetricsInt) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#getFontMetricsInt(Landroid/graphics/Paint$FontMetricsInt;)I", true, this);
    }

    public float getFontSpacing() {
        return this.getFontMetrics(null);
    }

    public float measureText(char[] cArray, int n, int n2) {
        return OverrideMethod.invokeF("android.graphics._Original_Paint#measureText([CII)F", true, this);
    }

    public float measureText(String string2, int n, int n2) {
        return OverrideMethod.invokeF("android.graphics._Original_Paint#measureText(Ljava/lang/String;II)F", true, this);
    }

    public float measureText(String string2) {
        return OverrideMethod.invokeF("android.graphics._Original_Paint#measureText(Ljava/lang/String;)F", true, this);
    }

    public float measureText(CharSequence text, int start, int end) {
        if (text instanceof String) {
            return this.measureText((String)text, start, end);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.measureText(((Object)text).toString(), start, end);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).measureText(start, end, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        float result = this.measureText(buf, 0, end - start);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int breakText(char[] cArray, int n, int n2, float f, float[] fArray) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#breakText([CIIF[F)I", true, this);
    }

    public int breakText(CharSequence text, int start, int end, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (start == 0 && text instanceof String && end == text.length()) {
            return this.breakText((String)text, measureForwards, maxWidth, measuredWidth);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = measureForwards ? this.breakText(buf, 0, end - start, maxWidth, measuredWidth) : this.breakText(buf, 0, -(end - start), maxWidth, measuredWidth);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int breakText(String string2, boolean bl, float f, float[] fArray) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#breakText(Ljava/lang/String;ZF[F)I", true, this);
    }

    public int getTextWidths(char[] text, int index, int count, float[] widths) {
        if ((index | count) < 0 || index + count > text.length || count > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return _Original_Paint.native_getTextWidths(this.mNativePaint, text, index, count, widths);
    }

    public int getTextWidths(CharSequence text, int start, int end, float[] widths) {
        if (text instanceof String) {
            return this.getTextWidths((String)text, start, end, widths);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextWidths(((Object)text).toString(), start, end, widths);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextWidths(start, end, widths, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = this.getTextWidths(buf, 0, end - start, widths);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int getTextWidths(String text, int start, int end, float[] widths) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return _Original_Paint.native_getTextWidths(this.mNativePaint, text, start, end, widths);
    }

    public int getTextWidths(String text, float[] widths) {
        return this.getTextWidths(text, 0, text.length(), widths);
    }

    public void getTextPath(char[] text, int index, int count, float x, float y, Path path) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        _Original_Paint.native_getTextPath(this.mNativePaint, text, index, count, x, y, path.ni());
    }

    public void getTextPath(String text, int start, int end, float x, float y, Path path) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        _Original_Paint.native_getTextPath(this.mNativePaint, text, start, end, x, y, path.ni());
    }

    public void getTextBounds(String text, int start, int end, Rect bounds) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        _Original_Paint.nativeGetStringBounds(this.mNativePaint, text, start, end, bounds);
    }

    public void getTextBounds(char[] text, int index, int count, Rect bounds) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        _Original_Paint.nativeGetCharArrayBounds(this.mNativePaint, text, index, count, bounds);
    }

    public void finalize() throws Throwable {
        _Original_Paint.finalizer(this.mNativePaint);
    }

    public static int native_init() {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_init()I", true, null);
    }

    public static int native_initWithPaint(int n) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_initWithPaint(I)I", true, null);
    }

    public static void native_reset(int n) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#native_reset(I)V", true, null);
    }

    public static void native_set(int n, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#native_set(II)V", true, null);
    }

    public static int native_getStyle(int n) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_getStyle(I)I", true, null);
    }

    public static void native_setStyle(int n, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#native_setStyle(II)V", true, null);
    }

    public static int native_getStrokeCap(int n) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_getStrokeCap(I)I", true, null);
    }

    public static void native_setStrokeCap(int n, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#native_setStrokeCap(II)V", true, null);
    }

    public static int native_getStrokeJoin(int n) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_getStrokeJoin(I)I", true, null);
    }

    public static void native_setStrokeJoin(int n, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#native_setStrokeJoin(II)V", true, null);
    }

    public static boolean native_getFillPath(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_getFillPath(III)Z", true, null) != 0;
    }

    public static int native_setShader(int n, int n2) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_setShader(II)I", true, null);
    }

    public static int native_setColorFilter(int n, int n2) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_setColorFilter(II)I", true, null);
    }

    public static int native_setXfermode(int n, int n2) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_setXfermode(II)I", true, null);
    }

    public static int native_setPathEffect(int n, int n2) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_setPathEffect(II)I", true, null);
    }

    public static int native_setMaskFilter(int n, int n2) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_setMaskFilter(II)I", true, null);
    }

    public static int native_setTypeface(int n, int n2) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_setTypeface(II)I", true, null);
    }

    public static int native_setRasterizer(int n, int n2) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_setRasterizer(II)I", true, null);
    }

    public static int native_getTextAlign(int n) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_getTextAlign(I)I", true, null);
    }

    public static void native_setTextAlign(int n, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#native_setTextAlign(II)V", true, null);
    }

    public static float native_getFontMetrics(int n, FontMetrics fontMetrics) {
        return OverrideMethod.invokeF("android.graphics._Original_Paint#native_getFontMetrics(ILandroid/graphics/Paint$FontMetrics;)F", true, null);
    }

    public static int native_getTextWidths(int n, char[] cArray, int n2, int n3, float[] fArray) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_getTextWidths(I[CII[F)I", true, null);
    }

    public static int native_getTextWidths(int n, String string2, int n2, int n3, float[] fArray) {
        return OverrideMethod.invokeI("android.graphics._Original_Paint#native_getTextWidths(ILjava/lang/String;II[F)I", true, null);
    }

    public static void native_getTextPath(int n, char[] cArray, int n2, int n3, float f, float f2, int n4) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#native_getTextPath(I[CIIFFI)V", true, null);
    }

    public static void native_getTextPath(int n, String string2, int n2, int n3, float f, float f2, int n4) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#native_getTextPath(ILjava/lang/String;IIFFI)V", true, null);
    }

    public static void nativeGetStringBounds(int n, String string2, int n2, int n3, Rect rect) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#nativeGetStringBounds(ILjava/lang/String;IILandroid/graphics/Rect;)V", true, null);
    }

    public static void nativeGetCharArrayBounds(int n, char[] cArray, int n2, int n3, Rect rect) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#nativeGetCharArrayBounds(I[CIILandroid/graphics/Rect;)V", true, null);
    }

    public static void finalizer(int n) {
        OverrideMethod.invokeV("android.graphics._Original_Paint#finalizer(I)V", true, null);
    }

    public static class FontMetricsInt {
        public int top;
        public int ascent;
        public int descent;
        public int bottom;
        public int leading;

        public String toString() {
            return "FontMetricsInt: top=" + this.top + " ascent=" + this.ascent + " descent=" + this.descent + " bottom=" + this.bottom + " leading=" + this.leading;
        }
    }

    public static class FontMetrics {
        public float top;
        public float ascent;
        public float descent;
        public float bottom;
        public float leading;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Align {
        LEFT(0),
        CENTER(1),
        RIGHT(2);

        public final int nativeInt;

        public Align(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Join {
        MITER(0),
        ROUND(1),
        BEVEL(2);

        public final int nativeInt;

        public Join(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cap {
        BUTT(0),
        ROUND(1),
        SQUARE(2);

        public final int nativeInt;

        public Cap(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        FILL(0),
        STROKE(1),
        FILL_AND_STROKE(2);

        public final int nativeInt;

        public Style(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

