/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Path;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.tools.layoutlib.create.OverrideMethod;

public class Region
implements Parcelable {
    public static final Parcelable.Creator<Region> CREATOR = new Parcelable.Creator<Region>(){

        @Override
        public Region createFromParcel(Parcel p) {
            int ni = Region.nativeCreateFromParcel(p);
            if (ni == 0) {
                throw new RuntimeException();
            }
            return new Region(ni);
        }

        public Region[] newArray(int size) {
            return new Region[size];
        }
    };
    public final int mNativeRegion;

    public Region() {
        this(Region.nativeConstructor());
    }

    public Region(Region region) {
        this(Region.nativeConstructor());
        Region.nativeSetRegion(this.mNativeRegion, region.mNativeRegion);
    }

    public Region(Rect r) {
        this.mNativeRegion = Region.nativeConstructor();
        Region.nativeSetRect(this.mNativeRegion, r.left, r.top, r.right, r.bottom);
    }

    public Region(int left, int top, int right, int bottom) {
        this.mNativeRegion = Region.nativeConstructor();
        Region.nativeSetRect(this.mNativeRegion, left, top, right, bottom);
    }

    public void setEmpty() {
        Region.nativeSetRect(this.mNativeRegion, 0, 0, 0, 0);
    }

    public boolean set(Region region) {
        return Region.nativeSetRegion(this.mNativeRegion, region.mNativeRegion);
    }

    public boolean set(Rect r) {
        return Region.nativeSetRect(this.mNativeRegion, r.left, r.top, r.right, r.bottom);
    }

    public boolean set(int left, int top, int right, int bottom) {
        return Region.nativeSetRect(this.mNativeRegion, left, top, right, bottom);
    }

    public boolean setPath(Path path, Region clip) {
        return Region.nativeSetPath(this.mNativeRegion, path.ni(), clip.mNativeRegion);
    }

    public boolean isEmpty() {
        return OverrideMethod.invokeI("android.graphics.Region#isEmpty()Z", true, this) != 0;
    }

    public boolean isRect() {
        return OverrideMethod.invokeI("android.graphics.Region#isRect()Z", true, this) != 0;
    }

    public boolean isComplex() {
        return OverrideMethod.invokeI("android.graphics.Region#isComplex()Z", true, this) != 0;
    }

    public Rect getBounds() {
        Rect r = new Rect();
        Region.nativeGetBounds(this.mNativeRegion, r);
        return r;
    }

    public boolean getBounds(Rect r) {
        if (r == null) {
            throw new NullPointerException();
        }
        return Region.nativeGetBounds(this.mNativeRegion, r);
    }

    public Path getBoundaryPath() {
        Path path = new Path();
        Region.nativeGetBoundaryPath(this.mNativeRegion, path.ni());
        return path;
    }

    public boolean getBoundaryPath(Path path) {
        return Region.nativeGetBoundaryPath(this.mNativeRegion, path.ni());
    }

    public boolean contains(int n, int n2) {
        return OverrideMethod.invokeI("android.graphics.Region#contains(II)Z", true, this) != 0;
    }

    public boolean quickContains(Rect r) {
        return this.quickContains(r.left, r.top, r.right, r.bottom);
    }

    public boolean quickContains(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.graphics.Region#quickContains(IIII)Z", true, this) != 0;
    }

    public boolean quickReject(Rect r) {
        return this.quickReject(r.left, r.top, r.right, r.bottom);
    }

    public boolean quickReject(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.graphics.Region#quickReject(IIII)Z", true, this) != 0;
    }

    public boolean quickReject(Region region) {
        return OverrideMethod.invokeI("android.graphics.Region#quickReject(Landroid/graphics/Region;)Z", true, this) != 0;
    }

    public void translate(int dx, int dy) {
        this.translate(dx, dy, null);
    }

    public void translate(int n, int n2, Region region) {
        OverrideMethod.invokeV("android.graphics.Region#translate(IILandroid/graphics/Region;)V", true, this);
    }

    public boolean union(Rect r) {
        return this.op(r, Op.UNION);
    }

    public boolean op(Rect r, Op op) {
        return Region.nativeOp(this.mNativeRegion, r.left, r.top, r.right, r.bottom, op.nativeInt);
    }

    public boolean op(int left, int top, int right, int bottom, Op op) {
        return Region.nativeOp(this.mNativeRegion, left, top, right, bottom, op.nativeInt);
    }

    public boolean op(Region region, Op op) {
        return this.op(this, region, op);
    }

    public boolean op(Rect rect, Region region, Op op) {
        return Region.nativeOp(this.mNativeRegion, rect, region.mNativeRegion, op.nativeInt);
    }

    public boolean op(Region region1, Region region2, Op op) {
        return Region.nativeOp(this.mNativeRegion, region1.mNativeRegion, region2.mNativeRegion, op.nativeInt);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel p, int flags) {
        if (!Region.nativeWriteToParcel(this.mNativeRegion, p)) {
            throw new RuntimeException();
        }
    }

    public void finalize() throws Throwable {
        Region.nativeDestructor(this.mNativeRegion);
    }

    public Region(int ni) {
        if (ni == 0) {
            throw new RuntimeException();
        }
        this.mNativeRegion = ni;
    }

    public Region(int ni, int dummy) {
        this(ni);
    }

    public int ni() {
        return this.mNativeRegion;
    }

    public static int nativeConstructor() {
        return OverrideMethod.invokeI("android.graphics.Region#nativeConstructor()I", true, null);
    }

    public static void nativeDestructor(int n) {
        OverrideMethod.invokeV("android.graphics.Region#nativeDestructor(I)V", true, null);
    }

    public static boolean nativeSetRegion(int n, int n2) {
        return OverrideMethod.invokeI("android.graphics.Region#nativeSetRegion(II)Z", true, null) != 0;
    }

    public static boolean nativeSetRect(int n, int n2, int n3, int n4, int n5) {
        return OverrideMethod.invokeI("android.graphics.Region#nativeSetRect(IIIII)Z", true, null) != 0;
    }

    public static boolean nativeSetPath(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.graphics.Region#nativeSetPath(III)Z", true, null) != 0;
    }

    public static boolean nativeGetBounds(int n, Rect rect) {
        return OverrideMethod.invokeI("android.graphics.Region#nativeGetBounds(ILandroid/graphics/Rect;)Z", true, null) != 0;
    }

    public static boolean nativeGetBoundaryPath(int n, int n2) {
        return OverrideMethod.invokeI("android.graphics.Region#nativeGetBoundaryPath(II)Z", true, null) != 0;
    }

    public static boolean nativeOp(int n, int n2, int n3, int n4, int n5, int n6) {
        return OverrideMethod.invokeI("android.graphics.Region#nativeOp(IIIIII)Z", true, null) != 0;
    }

    public static boolean nativeOp(int n, Rect rect, int n2, int n3) {
        return OverrideMethod.invokeI("android.graphics.Region#nativeOp(ILandroid/graphics/Rect;II)Z", true, null) != 0;
    }

    public static boolean nativeOp(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.graphics.Region#nativeOp(IIII)Z", true, null) != 0;
    }

    public static int nativeCreateFromParcel(Parcel parcel) {
        return OverrideMethod.invokeI("android.graphics.Region#nativeCreateFromParcel(Landroid/os/Parcel;)I", true, null);
    }

    public static boolean nativeWriteToParcel(int n, Parcel parcel) {
        return OverrideMethod.invokeI("android.graphics.Region#nativeWriteToParcel(ILandroid/os/Parcel;)Z", true, null) != 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Op {
        DIFFERENCE(0),
        INTERSECT(1),
        UNION(2),
        XOR(3),
        REVERSE_DIFFERENCE(4),
        REPLACE(5);

        public final int nativeInt;

        public Op(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

