/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.util.FloatMath;

public class ColorMatrix {
    public final float[] mArray = new float[20];

    public ColorMatrix() {
        this.reset();
    }

    public ColorMatrix(float[] src) {
        System.arraycopy(src, 0, this.mArray, 0, 20);
    }

    public ColorMatrix(ColorMatrix src) {
        System.arraycopy(src.mArray, 0, this.mArray, 0, 20);
    }

    public float[] getArray() {
        return this.mArray;
    }

    public void reset() {
        float[] a = this.mArray;
        for (int i = 19; i > 0; --i) {
            a[i] = 0.0f;
        }
        a[18] = 1.0f;
        a[12] = 1.0f;
        a[6] = 1.0f;
        a[0] = 1.0f;
    }

    public void set(ColorMatrix src) {
        System.arraycopy(src.mArray, 0, this.mArray, 0, 20);
    }

    public void set(float[] src) {
        System.arraycopy(src, 0, this.mArray, 0, 20);
    }

    public void setScale(float rScale, float gScale, float bScale, float aScale) {
        float[] a = this.mArray;
        for (int i = 19; i > 0; --i) {
            a[i] = 0.0f;
        }
        a[0] = rScale;
        a[6] = gScale;
        a[12] = bScale;
        a[18] = aScale;
    }

    public void setRotate(int axis, float degrees) {
        this.reset();
        float radians = degrees * (float)Math.PI / 180.0f;
        float cosine = FloatMath.cos(radians);
        float sine = FloatMath.sin(radians);
        switch (axis) {
            case 0: {
                this.mArray[6] = this.mArray[12] = cosine;
                this.mArray[7] = sine;
                this.mArray[11] = -sine;
                break;
            }
            case 1: {
                this.mArray[0] = this.mArray[17] = cosine;
                this.mArray[2] = sine;
                this.mArray[15] = -sine;
                break;
            }
            case 2: {
                this.mArray[0] = this.mArray[6] = cosine;
                this.mArray[1] = sine;
                this.mArray[5] = -sine;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void setConcat(ColorMatrix matA, ColorMatrix matB) {
        float[] tmp = null;
        tmp = matA == this || matB == this ? new float[20] : this.mArray;
        float[] a = matA.mArray;
        float[] b = matB.mArray;
        int index = 0;
        for (int j = 0; j < 20; j += 5) {
            for (int i = 0; i < 4; ++i) {
                tmp[index++] = a[j + 0] * b[i + 0] + a[j + 1] * b[i + 5] + a[j + 2] * b[i + 10] + a[j + 3] * b[i + 15];
            }
            tmp[index++] = a[j + 0] * b[4] + a[j + 1] * b[9] + a[j + 2] * b[14] + a[j + 3] * b[19] + a[j + 4];
        }
        if (tmp != this.mArray) {
            System.arraycopy(tmp, 0, this.mArray, 0, 20);
        }
    }

    public void preConcat(ColorMatrix prematrix) {
        this.setConcat(this, prematrix);
    }

    public void postConcat(ColorMatrix postmatrix) {
        this.setConcat(postmatrix, this);
    }

    public void setSaturation(float sat) {
        this.reset();
        float[] m = this.mArray;
        float invSat = 1.0f - sat;
        float R2 = 0.213f * invSat;
        float G = 0.715f * invSat;
        float B = 0.072f * invSat;
        m[0] = R2 + sat;
        m[1] = G;
        m[2] = B;
        m[5] = R2;
        m[6] = G + sat;
        m[7] = B;
        m[10] = R2;
        m[11] = G;
        m[12] = B + sat;
    }

    public void setRGB2YUV() {
        this.reset();
        float[] m = this.mArray;
        m[0] = 0.299f;
        m[1] = 0.587f;
        m[2] = 0.114f;
        m[5] = -0.16874f;
        m[6] = -0.33126f;
        m[7] = 0.5f;
        m[10] = 0.5f;
        m[11] = -0.41869f;
        m[12] = -0.08131f;
    }

    public void setYUV2RGB() {
        this.reset();
        float[] m = this.mArray;
        m[2] = 1.402f;
        m[5] = 1.0f;
        m[6] = -0.34414f;
        m[7] = -0.71414f;
        m[10] = 1.0f;
        m[11] = 1.772f;
        m[12] = 0.0f;
    }
}

