/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.util.Log;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;
import org.apache.harmony.dalvik.ddmc.DdmVmInternal;

public class DdmHandleHeap
extends ChunkHandler {
    public static final int CHUNK_HPIF = DdmHandleHeap.type("HPIF");
    public static final int CHUNK_HPSG = DdmHandleHeap.type("HPSG");
    public static final int CHUNK_NHSG = DdmHandleHeap.type("NHSG");
    public static final int CHUNK_HPGC = DdmHandleHeap.type("HPGC");
    public static final int CHUNK_REAE = DdmHandleHeap.type("REAE");
    public static final int CHUNK_REAQ = DdmHandleHeap.type("REAQ");
    public static final int CHUNK_REAL = DdmHandleHeap.type("REAL");
    public static DdmHandleHeap mInstance = new DdmHandleHeap();

    public static void register() {
        DdmServer.registerHandler(CHUNK_HPIF, mInstance);
        DdmServer.registerHandler(CHUNK_HPSG, mInstance);
        DdmServer.registerHandler(CHUNK_NHSG, mInstance);
        DdmServer.registerHandler(CHUNK_HPGC, mInstance);
        DdmServer.registerHandler(CHUNK_REAE, mInstance);
        DdmServer.registerHandler(CHUNK_REAQ, mInstance);
        DdmServer.registerHandler(CHUNK_REAL, mInstance);
    }

    public void connected() {
    }

    public void disconnected() {
    }

    public Chunk handleChunk(Chunk request) {
        int type = request.type;
        if (type == CHUNK_HPIF) {
            return this.handleHPIF(request);
        }
        if (type == CHUNK_HPSG) {
            return this.handleHPSGNHSG(request, false);
        }
        if (type == CHUNK_NHSG) {
            return this.handleHPSGNHSG(request, true);
        }
        if (type == CHUNK_HPGC) {
            return this.handleHPGC(request);
        }
        if (type == CHUNK_REAE) {
            return this.handleREAE(request);
        }
        if (type == CHUNK_REAQ) {
            return this.handleREAQ(request);
        }
        if (type == CHUNK_REAL) {
            return this.handleREAL(request);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name(type));
    }

    public Chunk handleHPIF(Chunk request) {
        ByteBuffer in = DdmHandleHeap.wrapChunk(request);
        byte when = in.get();
        boolean ok = DdmVmInternal.heapInfoNotify(when);
        if (!ok) {
            return DdmHandleHeap.createFailChunk(1, "Unsupported HPIF what");
        }
        return null;
    }

    public Chunk handleHPSGNHSG(Chunk request, boolean isNative) {
        byte what;
        ByteBuffer in = DdmHandleHeap.wrapChunk(request);
        byte when = in.get();
        boolean ok = DdmVmInternal.heapSegmentNotify(when, what = in.get(), isNative);
        if (!ok) {
            return DdmHandleHeap.createFailChunk(1, "Unsupported HPSG what/when");
        }
        return null;
    }

    public Chunk handleHPGC(Chunk request) {
        Log.d("ddm-heap", "Heap GC request");
        System.gc();
        return null;
    }

    public Chunk handleREAE(Chunk request) {
        ByteBuffer in = DdmHandleHeap.wrapChunk(request);
        boolean enable = in.get() != 0;
        Log.d("ddm-heap", "Recent allocation enable request: " + enable);
        DdmVmInternal.enableRecentAllocations(enable);
        return null;
    }

    public Chunk handleREAQ(Chunk request) {
        byte[] reply = new byte[]{DdmVmInternal.getRecentAllocationStatus() ? (byte)1 : 0};
        return new Chunk(CHUNK_REAQ, reply, 0, reply.length);
    }

    public Chunk handleREAL(Chunk request) {
        Log.d("ddm-heap", "Recent allocations request");
        byte[] reply = DdmVmInternal.getRecentAllocations();
        return new Chunk(CHUNK_REAL, reply, 0, reply.length);
    }
}

