/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class AssetFileDescriptor
implements Parcelable {
    public static final long UNKNOWN_LENGTH = -1L;
    public final ParcelFileDescriptor mFd;
    public final long mStartOffset;
    public final long mLength;
    public static final Parcelable.Creator<AssetFileDescriptor> CREATOR = new Parcelable.Creator<AssetFileDescriptor>(){

        @Override
        public AssetFileDescriptor createFromParcel(Parcel in) {
            return new AssetFileDescriptor(in);
        }

        public AssetFileDescriptor[] newArray(int size) {
            return new AssetFileDescriptor[size];
        }
    };

    public AssetFileDescriptor(ParcelFileDescriptor fd, long startOffset, long length) {
        if (length < 0L && startOffset != 0L) {
            throw new IllegalArgumentException("startOffset must be 0 when using UNKNOWN_LENGTH");
        }
        this.mFd = fd;
        this.mStartOffset = startOffset;
        this.mLength = length;
    }

    public ParcelFileDescriptor getParcelFileDescriptor() {
        return this.mFd;
    }

    public FileDescriptor getFileDescriptor() {
        return this.mFd.getFileDescriptor();
    }

    public long getStartOffset() {
        return this.mStartOffset;
    }

    public long getLength() {
        if (this.mLength >= 0L) {
            return this.mLength;
        }
        long len = this.mFd.getStatSize();
        return len >= 0L ? len : -1L;
    }

    public long getDeclaredLength() {
        return this.mLength;
    }

    public void close() throws IOException {
        this.mFd.close();
    }

    public FileInputStream createInputStream() throws IOException {
        if (this.mLength < 0L) {
            return new ParcelFileDescriptor.AutoCloseInputStream(this.mFd);
        }
        return new AutoCloseInputStream(this);
    }

    public FileOutputStream createOutputStream() throws IOException {
        if (this.mLength < 0L) {
            return new ParcelFileDescriptor.AutoCloseOutputStream(this.mFd);
        }
        return new AutoCloseOutputStream(this);
    }

    public String toString() {
        return "{AssetFileDescriptor: " + this.mFd + " start=" + this.mStartOffset + " len=" + this.mLength + "}";
    }

    public int describeContents() {
        return this.mFd.describeContents();
    }

    public void writeToParcel(Parcel out, int flags) {
        this.mFd.writeToParcel(out, flags);
        out.writeLong(this.mStartOffset);
        out.writeLong(this.mLength);
    }

    public AssetFileDescriptor(Parcel src) {
        this.mFd = ParcelFileDescriptor.CREATOR.createFromParcel(src);
        this.mStartOffset = src.readLong();
        this.mLength = src.readLong();
    }

    public static class AutoCloseOutputStream
    extends ParcelFileDescriptor.AutoCloseOutputStream {
        public long mRemaining;

        public AutoCloseOutputStream(AssetFileDescriptor fd) throws IOException {
            super(fd.getParcelFileDescriptor());
            if (fd.getParcelFileDescriptor().seekTo(fd.getStartOffset()) < 0L) {
                throw new IOException("Unable to seek");
            }
            this.mRemaining = (int)fd.getLength();
        }

        public void write(byte[] buffer, int offset, int count) throws IOException {
            if (this.mRemaining >= 0L) {
                if (this.mRemaining == 0L) {
                    return;
                }
                if ((long)count > this.mRemaining) {
                    count = (int)this.mRemaining;
                }
                super.write(buffer, offset, count);
                this.mRemaining -= (long)count;
                return;
            }
            super.write(buffer, offset, count);
        }

        public void write(byte[] buffer) throws IOException {
            if (this.mRemaining >= 0L) {
                if (this.mRemaining == 0L) {
                    return;
                }
                int count = buffer.length;
                if ((long)count > this.mRemaining) {
                    count = (int)this.mRemaining;
                }
                super.write(buffer);
                this.mRemaining -= (long)count;
                return;
            }
            super.write(buffer);
        }

        public void write(int oneByte) throws IOException {
            if (this.mRemaining >= 0L) {
                if (this.mRemaining == 0L) {
                    return;
                }
                super.write(oneByte);
                --this.mRemaining;
                return;
            }
            super.write(oneByte);
        }
    }

    public static class AutoCloseInputStream
    extends ParcelFileDescriptor.AutoCloseInputStream {
        public long mRemaining;

        public AutoCloseInputStream(AssetFileDescriptor fd) throws IOException {
            super(fd.getParcelFileDescriptor());
            super.skip(fd.getStartOffset());
            this.mRemaining = (int)fd.getLength();
        }

        public int available() throws IOException {
            return this.mRemaining >= 0L ? (this.mRemaining < Integer.MAX_VALUE ? (int)this.mRemaining : Integer.MAX_VALUE) : super.available();
        }

        public int read() throws IOException {
            if (this.mRemaining >= 0L) {
                if (this.mRemaining == 0L) {
                    return -1;
                }
                int res = super.read();
                if (res >= 0) {
                    --this.mRemaining;
                }
                return res;
            }
            return super.read();
        }

        public int read(byte[] buffer, int offset, int count) throws IOException {
            if (this.mRemaining >= 0L) {
                int res;
                if (this.mRemaining == 0L) {
                    return -1;
                }
                if ((long)count > this.mRemaining) {
                    count = (int)this.mRemaining;
                }
                if ((res = super.read(buffer, offset, count)) >= 0) {
                    this.mRemaining -= (long)res;
                }
                return res;
            }
            return super.read(buffer, offset, count);
        }

        public int read(byte[] buffer) throws IOException {
            if (this.mRemaining >= 0L) {
                int res;
                if (this.mRemaining == 0L) {
                    return -1;
                }
                int count = buffer.length;
                if ((long)count > this.mRemaining) {
                    count = (int)this.mRemaining;
                }
                if ((res = super.read(buffer, 0, count)) >= 0) {
                    this.mRemaining -= (long)res;
                }
                return res;
            }
            return super.read(buffer);
        }

        public long skip(long count) throws IOException {
            if (this.mRemaining >= 0L) {
                long res;
                if (this.mRemaining == 0L) {
                    return -1L;
                }
                if (count > this.mRemaining) {
                    count = this.mRemaining;
                }
                if ((res = super.skip(count)) >= 0L) {
                    this.mRemaining -= res;
                }
                return res;
            }
            return super.skip(count);
        }

        public void mark(int readlimit) {
            if (this.mRemaining >= 0L) {
                return;
            }
            super.mark(readlimit);
        }

        public boolean markSupported() {
            if (this.mRemaining >= 0L) {
                return false;
            }
            return super.markSupported();
        }

        public synchronized void reset() throws IOException {
            if (this.mRemaining >= 0L) {
                return;
            }
            super.reset();
        }
    }
}

