/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Printer;
import java.text.Collator;
import java.util.Comparator;

public class ApplicationInfo
extends PackageItemInfo
implements Parcelable {
    public String taskAffinity;
    public String permission;
    public String processName;
    public String className;
    public int descriptionRes;
    public int theme;
    public String manageSpaceActivityName;
    public static final int FLAG_SYSTEM = 1;
    public static final int FLAG_DEBUGGABLE = 2;
    public static final int FLAG_HAS_CODE = 4;
    public static final int FLAG_PERSISTENT = 8;
    public static final int FLAG_FACTORY_TEST = 16;
    public static final int FLAG_ALLOW_TASK_REPARENTING = 32;
    public static final int FLAG_ALLOW_CLEAR_USER_DATA = 64;
    public static final int FLAG_UPDATED_SYSTEM_APP = 128;
    public int flags = 0;
    public String sourceDir;
    public String publicSourceDir;
    public String[] sharedLibraryFiles;
    public String dataDir;
    public int uid;
    public boolean enabled = true;
    public static final Parcelable.Creator<ApplicationInfo> CREATOR = new Parcelable.Creator<ApplicationInfo>(){

        @Override
        public ApplicationInfo createFromParcel(Parcel source) {
            return new ApplicationInfo(source, null);
        }

        public ApplicationInfo[] newArray(int size) {
            return new ApplicationInfo[size];
        }
    };

    public void dump(Printer pw, String prefix) {
        super.dumpFront(pw, prefix);
        pw.println(prefix + "className=" + this.className);
        pw.println(prefix + "permission=" + this.permission + " uid=" + this.uid);
        pw.println(prefix + "taskAffinity=" + this.taskAffinity);
        pw.println(prefix + "theme=0x" + Integer.toHexString(this.theme));
        pw.println(prefix + "flags=0x" + Integer.toHexString(this.flags) + " processName=" + this.processName);
        pw.println(prefix + "sourceDir=" + this.sourceDir);
        pw.println(prefix + "publicSourceDir=" + this.publicSourceDir);
        pw.println(prefix + "sharedLibraryFiles=" + this.sharedLibraryFiles);
        pw.println(prefix + "dataDir=" + this.dataDir);
        pw.println(prefix + "enabled=" + this.enabled);
        pw.println(prefix + "manageSpaceActivityName=" + this.manageSpaceActivityName);
        pw.println(prefix + "description=0x" + Integer.toHexString(this.descriptionRes));
        super.dumpBack(pw, prefix);
    }

    public ApplicationInfo() {
    }

    public ApplicationInfo(ApplicationInfo orig) {
        super(orig);
        this.taskAffinity = orig.taskAffinity;
        this.permission = orig.permission;
        this.processName = orig.processName;
        this.className = orig.className;
        this.theme = orig.theme;
        this.flags = orig.flags;
        this.sourceDir = orig.sourceDir;
        this.publicSourceDir = orig.publicSourceDir;
        this.sharedLibraryFiles = orig.sharedLibraryFiles;
        this.dataDir = orig.dataDir;
        this.uid = orig.uid;
        this.enabled = orig.enabled;
        this.manageSpaceActivityName = orig.manageSpaceActivityName;
        this.descriptionRes = orig.descriptionRes;
    }

    public String toString() {
        return "ApplicationInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int parcelableFlags) {
        super.writeToParcel(dest, parcelableFlags);
        dest.writeString(this.taskAffinity);
        dest.writeString(this.permission);
        dest.writeString(this.processName);
        dest.writeString(this.className);
        dest.writeInt(this.theme);
        dest.writeInt(this.flags);
        dest.writeString(this.sourceDir);
        dest.writeString(this.publicSourceDir);
        dest.writeStringArray(this.sharedLibraryFiles);
        dest.writeString(this.dataDir);
        dest.writeInt(this.uid);
        dest.writeInt(this.enabled ? 1 : 0);
        dest.writeString(this.manageSpaceActivityName);
        dest.writeInt(this.descriptionRes);
    }

    public ApplicationInfo(Parcel source) {
        super(source);
        this.taskAffinity = source.readString();
        this.permission = source.readString();
        this.processName = source.readString();
        this.className = source.readString();
        this.theme = source.readInt();
        this.flags = source.readInt();
        this.sourceDir = source.readString();
        this.publicSourceDir = source.readString();
        this.sharedLibraryFiles = source.readStringArray();
        this.dataDir = source.readString();
        this.uid = source.readInt();
        this.enabled = source.readInt() != 0;
        this.manageSpaceActivityName = source.readString();
        this.descriptionRes = source.readInt();
    }

    public CharSequence loadDescription(PackageManager pm) {
        CharSequence label;
        if (this.descriptionRes != 0 && (label = pm.getText(this.packageName, this.descriptionRes, null)) != null) {
            return label;
        }
        return null;
    }

    public /* synthetic */ ApplicationInfo(Parcel x0, 1 x1) {
        this(x0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisplayNameComparator
    implements Comparator<ApplicationInfo> {
        public final Collator sCollator = Collator.getInstance();
        public PackageManager mPM;

        public DisplayNameComparator(PackageManager pm) {
            this.mPM = pm;
        }

        @Override
        public int compare(ApplicationInfo aa, ApplicationInfo ab) {
            CharSequence sb;
            CharSequence sa = this.mPM.getApplicationLabel(aa);
            if (sa == null) {
                sa = aa.packageName;
            }
            if ((sb = this.mPM.getApplicationLabel(ab)) == null) {
                sb = ab.packageName;
            }
            return this.sCollator.compare(((Object)sa).toString(), ((Object)sb).toString());
        }
    }
}

