/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.net.Uri;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class UriMatcher {
    public static final int NO_MATCH = -1;
    public static final Pattern PATH_SPLIT_PATTERN = Pattern.compile("/");
    public static final int EXACT = 0;
    public static final int NUMBER = 1;
    public static final int TEXT = 2;
    public int mCode;
    public int mWhich;
    public String mText;
    public ArrayList<UriMatcher> mChildren;

    public UriMatcher(int code) {
        this.mCode = code;
        this.mWhich = -1;
        this.mChildren = new ArrayList();
        this.mText = null;
    }

    public UriMatcher() {
        this.mCode = -1;
        this.mWhich = -1;
        this.mChildren = new ArrayList();
        this.mText = null;
    }

    public void addURI(String authority, String path, int code) {
        if (code < 0) {
            throw new IllegalArgumentException("code " + code + " is invalid: it must be positive");
        }
        String[] tokens = path != null ? PATH_SPLIT_PATTERN.split(path) : null;
        int numTokens = tokens != null ? tokens.length : 0;
        UriMatcher node = this;
        for (int i = -1; i < numTokens; ++i) {
            UriMatcher child;
            int j;
            String token = i < 0 ? authority : tokens[i];
            ArrayList<UriMatcher> children = node.mChildren;
            int numChildren = children.size();
            for (j = 0; j < numChildren; ++j) {
                child = children.get(j);
                if (!token.equals(child.mText)) continue;
                node = child;
                break;
            }
            if (j != numChildren) continue;
            child = new UriMatcher();
            child.mWhich = token.equals("#") ? 1 : (token.equals("*") ? 2 : 0);
            child.mText = token;
            node.mChildren.add(child);
            node = child;
        }
        node.mCode = code;
    }

    public int match(Uri uri) {
        int li = uri.getPathSegments().size();
        UriMatcher node = this;
        if (li == 0 && uri.getAuthority() == null) {
            return this.mCode;
        }
        for (int i = -1; i < li; ++i) {
            String u = i < 0 ? uri.getAuthority() : uri.getPathSegments().get(i);
            ArrayList<UriMatcher> list = node.mChildren;
            if (list == null) break;
            node = null;
            int lj = list.size();
            for (int j = 0; j < lj; ++j) {
                UriMatcher n = list.get(j);
                block0 : switch (n.mWhich) {
                    case 0: {
                        if (!n.mText.equals(u)) break;
                        node = n;
                        break;
                    }
                    case 1: {
                        int lk = u.length();
                        for (int k = 0; k < lk; ++k) {
                            char c = u.charAt(k);
                            if (c < '0' || c > '9') break block0;
                        }
                        node = n;
                        break;
                    }
                    case 2: {
                        node = n;
                    }
                }
                if (node != null) break;
            }
            if (node != null) continue;
            return -1;
        }
        return node.mCode;
    }
}

