/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.AccountMonitor;
import android.accounts.AccountMonitorListener;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.ISyncAdapter;
import android.content.ISyncContext;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SyncResult;
import android.content.SyncStorageEngine;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.provider.Sync;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.util.ArrayUtils;
import com.google.android.collect.Maps;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.PriorityQueue;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncManager {
    public static final String TAG = "SyncManager";
    public static final long MILLIS_IN_HOUR = 3600000L;
    public static final long MILLIS_IN_DAY = 86400000L;
    public static final long MILLIS_IN_WEEK = 604800000L;
    public static final long MILLIS_IN_4WEEKS = 2419200000L;
    public static final long LOCAL_SYNC_DELAY = 30000L;
    public static final long MAX_TIME_PER_SYNC = 300000L;
    public static final long SYNC_NOTIFICATION_DELAY = 30000L;
    public static final long INITIAL_SYNC_RETRY_TIME_IN_MS = 30000L;
    public static final long DEFAULT_MAX_SYNC_RETRY_TIME_IN_SECONDS = 3600L;
    public static final long ERROR_NOTIFICATION_DELAY_MS = 600000L;
    public static final String SYNC_WAKE_LOCK = "SyncManagerSyncWakeLock";
    public static final String HANDLE_SYNC_ALARM_WAKE_LOCK = "SyncManagerHandleSyncAlarmWakeLock";
    public Context mContext;
    public ContentResolver mContentResolver;
    public String mStatusText = "";
    public long mHeartbeatTime = 0L;
    public AccountMonitor mAccountMonitor;
    public volatile String[] mAccounts = null;
    public volatile PowerManager.WakeLock mSyncWakeLock;
    public volatile PowerManager.WakeLock mHandleAlarmWakeLock;
    public volatile boolean mDataConnectionIsConnected = false;
    public volatile boolean mStorageIsLow = false;
    public Sync.Settings.QueryMap mSyncSettings;
    public final NotificationManager mNotificationMgr;
    public AlarmManager mAlarmService = null;
    public HandlerThread mSyncThread;
    public volatile IPackageManager mPackageManager;
    public final SyncStorageEngine mSyncStorageEngine;
    public final SyncQueue mSyncQueue;
    public ActiveSyncContext mActiveSyncContext = null;
    public boolean mNeedSyncErrorNotification = false;
    public boolean mNeedSyncActiveNotification = false;
    public volatile boolean mSyncPollInitialized;
    public final PendingIntent mSyncAlarmIntent;
    public final PendingIntent mSyncPollAlarmIntent;
    public BroadcastReceiver mStorageIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            SyncManager.this.ensureContentResolver();
            String action = intent.getAction();
            if ("android.intent.action.DEVICE_STORAGE_LOW".equals(action)) {
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Log.v(SyncManager.TAG, "Internal storage is low.");
                }
                SyncManager.this.mStorageIsLow = true;
                SyncManager.this.cancelActiveSync(null);
            } else if ("android.intent.action.DEVICE_STORAGE_OK".equals(action)) {
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Log.v(SyncManager.TAG, "Internal storage is ok.");
                }
                SyncManager.this.mStorageIsLow = false;
                SyncManager.this.sendCheckAlarmsMessage();
            }
        }
    };
    public BroadcastReceiver mConnectivityIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            NetworkInfo.State state;
            NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            NetworkInfo.State state2 = state = networkInfo == null ? NetworkInfo.State.UNKNOWN : networkInfo.getState();
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.v(SyncManager.TAG, "received connectivity action.  network info: " + networkInfo);
            }
            switch (state) {
                case CONNECTED: {
                    SyncManager.this.mDataConnectionIsConnected = true;
                    break;
                }
                case DISCONNECTED: {
                    if (intent.getBooleanExtra("noConnectivity", false)) {
                        SyncManager.this.mDataConnectionIsConnected = false;
                        break;
                    }
                    SyncManager.this.mDataConnectionIsConnected = true;
                    break;
                }
            }
            if (SyncManager.this.mDataConnectionIsConnected) {
                SyncManager.this.initializeSyncPoll();
                SyncManager.this.sendCheckAlarmsMessage();
            }
        }
    };
    public static final String ACTION_SYNC_ALARM = "android.content.syncmanager.SYNC_ALARM";
    public static final String SYNC_POLL_ALARM = "android.content.syncmanager.SYNC_POLL_ALARM";
    public final SyncHandler mSyncHandler;
    public static final String[] SYNC_ACTIVE_PROJECTION = new String[]{"account", "authority", "startTime"};
    public static final String[] SYNC_PENDING_PROJECTION = new String[]{"account", "authority"};
    public static final int MAX_SYNC_POLL_DELAY_SECONDS = 129600;
    public static final int MIN_SYNC_POLL_DELAY_SECONDS = 86400;
    public static final String SYNCMANAGER_PREFS_FILENAME = "/data/system/syncmanager.prefs";
    public static String[] STATUS_PROJECTION = new String[]{"account", "authority", "numSyncs", "totalElapsedTime", "numSourceLocal", "numSourcePoll", "numSourceServer", "numSourceUser", "lastSuccessSource", "lastSuccessTime", "lastFailureSource", "lastFailureTime", "lastFailureMesg"};

    public SyncManager(Context context, boolean factoryTest) {
        SyncStorageEngine.init(context);
        this.mSyncStorageEngine = SyncStorageEngine.getSingleton();
        this.mSyncQueue = new SyncQueue(this.mSyncStorageEngine);
        this.mContext = context;
        this.mSyncThread = new HandlerThread("SyncHandlerThread", 10);
        this.mSyncThread.start();
        this.mSyncHandler = new SyncHandler(this.mSyncThread.getLooper());
        this.mPackageManager = null;
        this.mSyncAlarmIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(ACTION_SYNC_ALARM), 0);
        this.mSyncPollAlarmIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(SYNC_POLL_ALARM), 0);
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver(this.mConnectivityIntentReceiver, intentFilter);
        intentFilter = new IntentFilter("android.intent.action.DEVICE_STORAGE_LOW");
        intentFilter.addAction("android.intent.action.DEVICE_STORAGE_OK");
        context.registerReceiver(this.mStorageIntentReceiver, intentFilter);
        if (!factoryTest) {
            this.mNotificationMgr = (NotificationManager)context.getSystemService("notification");
            context.registerReceiver(new SyncAlarmIntentReceiver(), new IntentFilter(ACTION_SYNC_ALARM));
        } else {
            this.mNotificationMgr = null;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mSyncWakeLock = pm.newWakeLock(1, SYNC_WAKE_LOCK);
        this.mSyncWakeLock.setReferenceCounted(false);
        this.mHandleAlarmWakeLock = pm.newWakeLock(1, HANDLE_SYNC_ALARM_WAKE_LOCK);
        this.mHandleAlarmWakeLock.setReferenceCounted(false);
        if (!factoryTest) {
            AccountMonitorListener listener = new AccountMonitorListener(){

                public void onAccountsUpdated(String[] accounts) {
                    boolean hadAccountsAlready = SyncManager.this.mAccounts != null;
                    String[] newAccounts = new String[accounts.length];
                    System.arraycopy(accounts, 0, newAccounts, 0, accounts.length);
                    SyncManager.access$502(SyncManager.this, newAccounts);
                    ActiveSyncContext activeSyncContext = SyncManager.this.mActiveSyncContext;
                    if (activeSyncContext != null && !ArrayUtils.contains(newAccounts, activeSyncContext.mSyncOperation.account)) {
                        Log.d(SyncManager.TAG, "canceling sync since the account has been removed");
                        SyncManager.this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
                    }
                    SyncManager.this.sendCheckAlarmsMessage();
                    SyncManager.this.mSyncStorageEngine.doDatabaseCleanup(accounts);
                    if (hadAccountsAlready && SyncManager.this.mAccounts.length > 0) {
                        SyncManager.this.startSync(null, null);
                    }
                }
            };
            this.mAccountMonitor = new AccountMonitor(context, listener);
        }
    }

    public synchronized void initializeSyncPoll() {
        long relativeNow;
        if (this.mSyncPollInitialized) {
            return;
        }
        this.mSyncPollInitialized = true;
        this.mContext.registerReceiver(new SyncPollAlarmReceiver(), new IntentFilter(SYNC_POLL_ALARM));
        long absoluteAlarmTime = this.readSyncPollTime();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "initializeSyncPoll: absoluteAlarmTime is " + absoluteAlarmTime);
        }
        long absoluteNow = System.currentTimeMillis();
        long relativeAlarmTime = relativeNow = SystemClock.elapsedRealtime();
        if (absoluteAlarmTime > absoluteNow) {
            long delayInMs = absoluteAlarmTime - absoluteNow;
            int maxDelayInMs = 129600000;
            if (delayInMs > 129600000L) {
                delayInMs = 129600000L;
            }
            relativeAlarmTime += delayInMs;
        }
        this.scheduleSyncPollAlarm(relativeAlarmTime);
    }

    public void scheduleSyncPollAlarm(long relativeAlarmTime) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "scheduleSyncPollAlarm: relativeAlarmTime is " + relativeAlarmTime + ", now is " + SystemClock.elapsedRealtime() + ", delay is " + (relativeAlarmTime - SystemClock.elapsedRealtime()));
        }
        this.ensureAlarmService();
        this.mAlarmService.set(2, relativeAlarmTime, this.mSyncPollAlarmIntent);
    }

    public long jitterize(long minValue, long maxValue) {
        Random random = new Random(SystemClock.elapsedRealtime());
        long spread = maxValue - minValue;
        if (spread > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("the difference between the maxValue and the minValue must be less than 2147483647");
        }
        return minValue + (long)random.nextInt((int)spread);
    }

    public void handleSyncPollAlarm() {
        long delayMs = this.jitterize(86400L, 129600L) * 1000L;
        long nextRelativePollTimeMs = SystemClock.elapsedRealtime() + delayMs;
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "handleSyncPollAlarm: delay " + delayMs);
        }
        this.writeSyncPollTime(System.currentTimeMillis() + delayMs);
        this.scheduleSyncPollAlarm(nextRelativePollTimeMs);
        this.scheduleSync(null, new Bundle(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSyncPollTime(long when) {
        File f = new File(SYNCMANAGER_PREFS_FILENAME);
        FilterOutputStream str = null;
        try {
            str = new DataOutputStream(new FileOutputStream(f));
            ((DataOutputStream)str).writeLong(when);
        }
        catch (FileNotFoundException e) {
            Log.w(TAG, "error writing to file " + f, e);
        }
        catch (IOException e) {
            Log.w(TAG, "error writing to file " + f, e);
        }
        finally {
            if (str != null) {
                try {
                    str.close();
                }
                catch (IOException e) {
                    Log.w(TAG, "error closing file " + f, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readSyncPollTime() {
        File f = new File(SYNCMANAGER_PREFS_FILENAME);
        FilterInputStream str = null;
        try {
            str = new DataInputStream(new FileInputStream(f));
            long l = ((DataInputStream)str).readLong();
            return l;
        }
        catch (FileNotFoundException e) {
            this.writeSyncPollTime(0L);
        }
        catch (IOException e) {
            Log.w(TAG, "error reading file " + f, e);
        }
        finally {
            if (str != null) {
                try {
                    str.close();
                }
                catch (IOException e) {
                    Log.w(TAG, "error closing file " + f, e);
                }
            }
        }
        return 0L;
    }

    public ActiveSyncContext getActiveSyncContext() {
        return this.mActiveSyncContext;
    }

    public Sync.Settings.QueryMap getSyncSettings() {
        if (this.mSyncSettings == null) {
            this.mSyncSettings = new Sync.Settings.QueryMap(this.mContext.getContentResolver(), true, new Handler());
            this.mSyncSettings.addObserver(new Observer(){

                public void update(Observable o, Object arg) {
                    SyncManager.this.sendCheckAlarmsMessage();
                }
            });
        }
        return this.mSyncSettings;
    }

    public void ensureContentResolver() {
        if (this.mContentResolver == null) {
            this.mContentResolver = this.mContext.getContentResolver();
        }
    }

    public void ensureAlarmService() {
        if (this.mAlarmService == null) {
            this.mAlarmService = (AlarmManager)this.mContext.getSystemService("alarm");
        }
    }

    public String getSyncingAccount() {
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        return activeSyncContext != null ? activeSyncContext.mSyncOperation.account : null;
    }

    public boolean isSyncEnabled() {
        return "yes".equals(SystemProperties.get("ro.config.sync"));
    }

    public void scheduleSync(Uri url, Bundle extras, long delay) {
        String[] accounts;
        String accountFromExtras;
        Boolean expedited;
        boolean isLoggable = Log.isLoggable(TAG, 2);
        if (isLoggable) {
            Log.v(TAG, "scheduleSync: delay " + delay + ", url " + (url == null ? "(null)" : url) + ", extras " + (extras == null ? "(null)" : extras));
        }
        if (!this.isSyncEnabled()) {
            if (isLoggable) {
                Log.v(TAG, "not syncing because sync is disabled");
            }
            this.setStatusText("Sync is disabled.");
            return;
        }
        if (this.mAccounts == null) {
            this.setStatusText("The accounts aren't known yet.");
        }
        if (!this.mDataConnectionIsConnected) {
            this.setStatusText("No data connection");
        }
        if (this.mStorageIsLow) {
            this.setStatusText("Memory low");
        }
        if (extras == null) {
            extras = new Bundle();
        }
        if ((expedited = Boolean.valueOf(extras.getBoolean("expedited", false))).booleanValue()) {
            delay = -1L;
        }
        if (!TextUtils.isEmpty(accountFromExtras = extras.getString("account"))) {
            accounts = new String[]{accountFromExtras};
        } else {
            accounts = this.mAccounts;
            if (accounts == null) {
                if (isLoggable) {
                    Log.v(TAG, "scheduleSync: no accounts yet, dropping");
                }
                return;
            }
            if (accounts.length == 0) {
                if (isLoggable) {
                    Log.v(TAG, "scheduleSync: no accounts configured, dropping");
                }
                this.setStatusText("No accounts are configured.");
                return;
            }
        }
        boolean uploadOnly = extras.getBoolean("upload", false);
        boolean force = extras.getBoolean("force", false);
        int source = uploadOnly ? 1 : (force ? 3 : (url == null ? 2 : 0));
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ProviderInfo> providers = new ArrayList<ProviderInfo>();
        this.populateProvidersList(url, names, providers);
        int numProviders = providers.size();
        block0: for (int i = 0; i < numProviders; ++i) {
            if (!((ProviderInfo)providers.get((int)i)).isSyncable) continue;
            String name = (String)names.get(i);
            for (String account : accounts) {
                this.scheduleSyncOperation(new SyncOperation(account, source, name, extras, delay));
                if ("calendar".equals(name)) continue block0;
            }
        }
    }

    public void setStatusText(String message) {
        this.mStatusText = message;
    }

    public void populateProvidersList(Uri url, List<String> names, List<ProviderInfo> providers) {
        try {
            IPackageManager packageManager = this.getPackageManager();
            if (url == null) {
                packageManager.querySyncProviders(names, providers);
            } else {
                String authority = url.getAuthority();
                ProviderInfo info = packageManager.resolveContentProvider(url.getAuthority(), 0);
                if (info != null) {
                    String[] providerNames = info.authority.split(";");
                    if (url.getAuthority().equals(providerNames[0])) {
                        names.add(authority);
                        providers.add(info);
                    }
                }
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "error trying to get the ProviderInfo for " + url, ex);
            names.clear();
            providers.clear();
        }
    }

    public void scheduleLocalSync(Uri url) {
        Bundle extras = new Bundle();
        extras.putBoolean("upload", true);
        this.scheduleSync(url, extras, 30000L);
    }

    public IPackageManager getPackageManager() {
        if (this.mPackageManager == null) {
            IBinder b = ServiceManager.getService("package");
            this.mPackageManager = IPackageManager.Stub.asInterface(b);
        }
        return this.mPackageManager;
    }

    public void startSync(Uri url, Bundle extras) {
        this.scheduleSync(url, extras, 0L);
    }

    public void updateHeartbeatTime() {
        this.mHeartbeatTime = SystemClock.elapsedRealtime();
        this.ensureContentResolver();
        this.mContentResolver.notifyChange(Sync.Active.CONTENT_URI, null);
    }

    public void sendSyncAlarmMessage() {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "sending MESSAGE_SYNC_ALARM");
        }
        this.mSyncHandler.sendEmptyMessage(2);
    }

    public void sendCheckAlarmsMessage() {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "sending MESSAGE_CHECK_ALARMS");
        }
        this.mSyncHandler.sendEmptyMessage(3);
    }

    public void sendSyncFinishedOrCanceledMessage(ActiveSyncContext syncContext, SyncResult syncResult) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "sending MESSAGE_SYNC_FINISHED");
        }
        Message msg = this.mSyncHandler.obtainMessage();
        msg.what = 1;
        msg.obj = new SyncHandlerMessagePayload(syncContext, syncResult);
        this.mSyncHandler.sendMessage(msg);
    }

    public void rescheduleImmediately(SyncOperation syncOperation) {
        SyncOperation rescheduledSyncOperation = new SyncOperation(syncOperation);
        rescheduledSyncOperation.setDelay(0L);
        this.scheduleSyncOperation(rescheduledSyncOperation);
    }

    public long rescheduleWithDelay(SyncOperation syncOperation) {
        long newDelayInMs = syncOperation.delay == 0L ? this.jitterize(30000L, 33000L) : syncOperation.delay * 2L;
        this.ensureContentResolver();
        long maxSyncRetryTimeInSeconds = Settings.Gservices.getLong(this.mContentResolver, "sync_max_retry_delay_in_seconds", 3600L);
        if (newDelayInMs > maxSyncRetryTimeInSeconds * 1000L) {
            newDelayInMs = maxSyncRetryTimeInSeconds * 1000L;
        }
        SyncOperation rescheduledSyncOperation = new SyncOperation(syncOperation);
        rescheduledSyncOperation.setDelay(newDelayInMs);
        this.scheduleSyncOperation(rescheduledSyncOperation);
        return newDelayInMs;
    }

    public void cancelActiveSync(Uri uri) {
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        if (activeSyncContext != null) {
            if (uri != null && !uri.getAuthority().equals(activeSyncContext.mSyncOperation.authority)) {
                return;
            }
            this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSyncOperation(SyncOperation syncOperation) {
        boolean operationEnqueued;
        boolean expedited = syncOperation.delay < 0L;
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        if (expedited && activeSyncContext != null) {
            boolean activeIsExpedited = activeSyncContext.mSyncOperation.delay < 0L;
            boolean hasSameKey = activeSyncContext.mSyncOperation.key.equals(syncOperation.key);
            if (!activeIsExpedited && !hasSameKey) {
                this.rescheduleImmediately(activeSyncContext.mSyncOperation);
                this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
            }
        }
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            operationEnqueued = this.mSyncQueue.add(syncOperation);
        }
        if (operationEnqueued) {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "scheduleSyncOperation: enqueued " + syncOperation);
            }
            this.sendCheckAlarmsMessage();
        } else if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "scheduleSyncOperation: dropping duplicate sync operation " + syncOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearScheduledSyncOperations(Uri uri) {
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            this.mSyncQueue.clear(null, uri != null ? uri.getAuthority() : null);
        }
    }

    public void maybeRescheduleSync(SyncResult syncResult, SyncOperation previousSyncOperation) {
        boolean isLoggable = Log.isLoggable(TAG, 3);
        if (isLoggable) {
            Log.d(TAG, "encountered error(s) during the sync: " + syncResult + ", " + previousSyncOperation);
        }
        if (syncResult.madeSomeProgress()) {
            if (isLoggable) {
                Log.d(TAG, "retrying sync operation immediately because even though it had an error it achieved some success");
            }
            this.rescheduleImmediately(previousSyncOperation);
        } else if (previousSyncOperation.extras.getBoolean("upload", false)) {
            SyncOperation newSyncOperation = new SyncOperation(previousSyncOperation);
            newSyncOperation.extras.putBoolean("upload", false);
            newSyncOperation.setDelay(0L);
            Log.d(TAG, "retrying sync operation as a two-way sync because an upload-only sync encountered an error: " + previousSyncOperation);
            this.scheduleSyncOperation(newSyncOperation);
        } else if (syncResult.hasSoftError()) {
            long delay = this.rescheduleWithDelay(previousSyncOperation);
            if (delay >= 0L && isLoggable) {
                Log.d(TAG, "retrying sync operation in " + delay + " ms because " + "it encountered a soft error: " + previousSyncOperation);
            }
        } else {
            Log.d(TAG, "not retrying sync operation because the error is a hard error: " + previousSyncOperation);
        }
    }

    public void dump(FileDescriptor fd, PrintWriter pw) {
        StringBuilder sb = new StringBuilder();
        this.dumpSyncState(sb);
        sb.append("\n");
        if (this.isSyncEnabled()) {
            this.dumpSyncHistory(sb);
        }
        pw.println(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpSyncState(StringBuilder sb) {
        sb.append("sync enabled: ").append(this.isSyncEnabled()).append("\n");
        sb.append("data connected: ").append(this.mDataConnectionIsConnected).append("\n");
        sb.append("memory low: ").append(this.mStorageIsLow).append("\n");
        String[] accounts = this.mAccounts;
        sb.append("accounts: ");
        if (accounts != null) {
            sb.append(accounts.length);
        } else {
            sb.append("none");
        }
        sb.append("\n");
        long now = SystemClock.elapsedRealtime();
        sb.append("now: ").append(now).append("\n");
        sb.append("uptime: ").append(DateUtils.formatElapsedTime(now / 1000L)).append(" (HH:MM:SS)\n");
        sb.append("time spent syncing : ").append(DateUtils.formatElapsedTime(this.mSyncHandler.mSyncTimeTracker.timeSpentSyncing() / 1000L)).append(" (HH:MM:SS), sync ").append(this.mSyncHandler.mSyncTimeTracker.mLastWasSyncing ? "" : "not ").append("in progress").append("\n");
        if (this.mSyncHandler.mAlarmScheduleTime != null) {
            sb.append("next alarm time: ").append(this.mSyncHandler.mAlarmScheduleTime).append(" (").append(DateUtils.formatElapsedTime((this.mSyncHandler.mAlarmScheduleTime - now) / 1000L)).append(" (HH:MM:SS) from now)\n");
        } else {
            sb.append("no alarm is scheduled (there had better not be any pending syncs)\n");
        }
        sb.append("active sync: ").append(this.mActiveSyncContext).append("\n");
        sb.append("notification info: ");
        this.mSyncHandler.mSyncNotificationInfo.toString(sb);
        sb.append("\n");
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            sb.append("sync queue: ");
            this.mSyncQueue.dump(sb);
        }
        Cursor c = this.mSyncStorageEngine.query(Sync.Active.CONTENT_URI, SYNC_ACTIVE_PROJECTION, null, null, null);
        sb.append("\n");
        try {
            if (c.moveToNext()) {
                long durationInSeconds = (now - c.getLong(2)) / 1000L;
                sb.append("Active sync: ").append(c.getString(0)).append(" ").append(c.getString(1)).append(", duration is ").append(DateUtils.formatElapsedTime(durationInSeconds)).append(".\n");
            } else {
                sb.append("No sync is in progress.\n");
            }
        }
        finally {
            c.close();
        }
        c = this.mSyncStorageEngine.query(Sync.Pending.CONTENT_URI, SYNC_PENDING_PROJECTION, null, null, "account, authority");
        sb.append("\nPending Syncs\n");
        try {
            if (c.getCount() != 0) {
                this.dumpSyncPendingHeader(sb);
                while (c.moveToNext()) {
                    this.dumpSyncPendingRow(sb, c);
                }
                this.dumpSyncPendingFooter(sb);
            } else {
                sb.append("none\n");
            }
        }
        finally {
            c.close();
        }
        String currentAccount = null;
        c = this.mSyncStorageEngine.query(Sync.Status.CONTENT_URI, STATUS_PROJECTION, null, null, "account, authority");
        sb.append("\nSync history by account and authority\n");
        try {
            while (c.moveToNext()) {
                if (!TextUtils.equals(currentAccount, c.getString(0))) {
                    if (currentAccount != null) {
                        this.dumpSyncHistoryFooter(sb);
                    }
                    currentAccount = c.getString(0);
                    this.dumpSyncHistoryHeader(sb, currentAccount);
                }
                this.dumpSyncHistoryRow(sb, c);
            }
            if (c.getCount() > 0) {
                this.dumpSyncHistoryFooter(sb);
            }
        }
        finally {
            c.close();
        }
    }

    public void dumpSyncHistoryHeader(StringBuilder sb, String account) {
        sb.append(" Account: ").append(account).append("\n");
        sb.append("  ___________________________________________________________________________________________________________________________\n");
        sb.append(" |                 |             num times synced           |   total  |         last success          |                     |\n");
        sb.append(" | authority       | local |  poll | server |  user | total | duration |  source |               time  |   result if failing |\n");
    }

    public void dumpSyncHistoryRow(StringBuilder sb, Cursor c) {
        boolean hasSuccess = !c.isNull(9);
        boolean hasFailure = !c.isNull(11);
        Time timeSuccess = new Time();
        if (hasSuccess) {
            timeSuccess.set(c.getLong(9));
        }
        Time timeFailure = new Time();
        if (hasFailure) {
            timeFailure.set(c.getLong(11));
        }
        sb.append(String.format(" | %-15s | %5d | %5d | %6d | %5d | %5d | %8s | %7s | %19s | %19s |\n", c.getString(1), c.getLong(4), c.getLong(5), c.getLong(6), c.getLong(7), c.getLong(2), DateUtils.formatElapsedTime(c.getLong(3) / 1000L), hasSuccess ? Sync.History.SOURCES[c.getInt(8)] : "", hasSuccess ? timeSuccess.format("%Y-%m-%d %H:%M:%S") : "", hasFailure ? Sync.History.mesgToString(c.getString(12)) : ""));
    }

    public void dumpSyncHistoryFooter(StringBuilder sb) {
        sb.append(" |___________________________________________________________________________________________________________________________|\n");
    }

    public void dumpSyncPendingHeader(StringBuilder sb) {
        sb.append(" ____________________________________________________\n");
        sb.append(" | account                        | authority       |\n");
    }

    public void dumpSyncPendingRow(StringBuilder sb, Cursor c) {
        sb.append(String.format(" | %-30s | %-15s |\n", c.getString(0), c.getString(1)));
    }

    public void dumpSyncPendingFooter(StringBuilder sb) {
        sb.append(" |__________________________________________________|\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpSyncHistory(StringBuilder sb) {
        Cursor c = this.mSyncStorageEngine.query(Sync.History.CONTENT_URI, null, "event=?", new String[]{String.valueOf(1)}, "eventTime desc");
        try {
            long numSyncsLastHour = 0L;
            long durationLastHour = 0L;
            long numSyncsLastDay = 0L;
            long durationLastDay = 0L;
            long numSyncsLastWeek = 0L;
            long durationLastWeek = 0L;
            long numSyncsLast4Weeks = 0L;
            long durationLast4Weeks = 0L;
            long numSyncsTotal = 0L;
            long durationTotal = 0L;
            long now = System.currentTimeMillis();
            int indexEventTime = c.getColumnIndexOrThrow("eventTime");
            int indexElapsedTime = c.getColumnIndexOrThrow("elapsedTime");
            while (c.moveToNext()) {
                long duration = c.getLong(indexElapsedTime);
                long endTime = c.getLong(indexEventTime) + duration;
                long millisSinceStart = now - endTime;
                ++numSyncsTotal;
                durationTotal += duration;
                if (millisSinceStart < 3600000L) {
                    ++numSyncsLastHour;
                    durationLastHour += duration;
                }
                if (millisSinceStart < 86400000L) {
                    ++numSyncsLastDay;
                    durationLastDay += duration;
                }
                if (millisSinceStart < 604800000L) {
                    ++numSyncsLastWeek;
                    durationLastWeek += duration;
                }
                if (millisSinceStart >= 2419200000L) continue;
                ++numSyncsLast4Weeks;
                durationLast4Weeks += duration;
            }
            this.dumpSyncIntervalHeader(sb);
            this.dumpSyncInterval(sb, "hour", 3600000L, numSyncsLastHour, durationLastHour);
            this.dumpSyncInterval(sb, "day", 86400000L, numSyncsLastDay, durationLastDay);
            this.dumpSyncInterval(sb, "week", 604800000L, numSyncsLastWeek, durationLastWeek);
            this.dumpSyncInterval(sb, "4 weeks", 2419200000L, numSyncsLast4Weeks, durationLast4Weeks);
            this.dumpSyncInterval(sb, "total", 0L, numSyncsTotal, durationTotal);
            this.dumpSyncIntervalFooter(sb);
        }
        finally {
            c.close();
        }
    }

    public void dumpSyncIntervalHeader(StringBuilder sb) {
        sb.append("Sync Stats\n");
        sb.append(" ___________________________________________________________\n");
        sb.append(" |          |        |   duration in sec   |               |\n");
        sb.append(" | interval |  count |  average |    total | % of interval |\n");
    }

    public void dumpSyncInterval(StringBuilder sb, String label, long interval, long numSyncs, long duration) {
        sb.append(String.format(" | %-8s | %6d | %8.1f | %8.1f", label, numSyncs, Float.valueOf((float)duration / (float)numSyncs / 1000.0f), Float.valueOf((float)duration / 1000.0f)));
        if (interval > 0L) {
            sb.append(String.format(" | %13.2f |\n", (double)((float)duration / (float)interval) * 100.0));
        } else {
            sb.append(String.format(" | %13s |\n", "na"));
        }
    }

    public void dumpSyncIntervalFooter(StringBuilder sb) {
        sb.append(" |_________________________________________________________|\n");
    }

    public static /* synthetic */ String[] access$502(SyncManager x0, String[] x1) {
        x0.mAccounts = x1;
        return x1;
    }

    public static class SyncQueue {
        public SyncStorageEngine mSyncStorageEngine;
        public final String[] COLUMNS = new String[]{"_id", "authority", "account", "extras", "source"};
        public static final int COLUMN_ID = 0;
        public static final int COLUMN_AUTHORITY = 1;
        public static final int COLUMN_ACCOUNT = 2;
        public static final int COLUMN_EXTRAS = 3;
        public static final int COLUMN_SOURCE = 4;
        public static final boolean DEBUG_CHECK_DATA_CONSISTENCY = false;
        public final PriorityQueue<SyncOperation> mOpsByWhen = new PriorityQueue();
        public final HashMap<String, SyncOperation> mOpsByKey = Maps.newHashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SyncQueue(SyncStorageEngine syncStorageEngine) {
            this.mSyncStorageEngine = syncStorageEngine;
            Cursor cursor = this.mSyncStorageEngine.getPendingSyncsCursor(this.COLUMNS);
            try {
                while (cursor.moveToNext()) {
                    this.add(this.cursorToOperation(cursor), true);
                }
            }
            finally {
                cursor.close();
            }
        }

        public boolean add(SyncOperation operation) {
            return this.add(new SyncOperation(operation), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(SyncOperation operation, boolean fromDatabase) {
            String operationKey;
            SyncOperation existingOperation;
            if (operation.delay < 0L) {
                SyncOperation headOperation = this.head();
                operation.earliestRunTime = headOperation != null ? Math.min(SystemClock.elapsedRealtime(), headOperation.earliestRunTime - 1L) : SystemClock.elapsedRealtime();
            }
            if ((existingOperation = this.mOpsByKey.get(operationKey = operation.key)) != null && existingOperation.delay > 0L && !operation.extras.getBoolean("force", false)) {
                return false;
            }
            if (existingOperation != null && operation.earliestRunTime >= existingOperation.earliestRunTime) {
                return false;
            }
            if (existingOperation != null) {
                this.removeByKey(operationKey);
            }
            if (operation.rowId == null) {
                byte[] extrasData = null;
                Parcel parcel = Parcel.obtain();
                try {
                    operation.extras.writeToParcel(parcel, 0);
                    extrasData = parcel.marshall();
                }
                finally {
                    parcel.recycle();
                }
                ContentValues values = new ContentValues();
                values.put("account", operation.account);
                values.put("authority", operation.authority);
                values.put("source", operation.syncSource);
                values.put("extras", extrasData);
                Uri pendingUri = this.mSyncStorageEngine.insertIntoPending(values);
                Long l = operation.rowId = pendingUri == null ? null : Long.valueOf(ContentUris.parseId(pendingUri));
                if (operation.rowId == null) {
                    throw new IllegalStateException("error adding pending sync operation " + operation);
                }
            }
            this.mOpsByKey.put(operationKey, operation);
            this.mOpsByWhen.add(operation);
            return true;
        }

        public void removeByKey(String operationKey) {
            SyncOperation operationToRemove = this.mOpsByKey.remove(operationKey);
            if (!this.mOpsByWhen.remove(operationToRemove)) {
                throw new IllegalStateException("unable to find " + operationToRemove + " in mOpsByWhen");
            }
            if (this.mSyncStorageEngine.deleteFromPending(operationToRemove.rowId) != 1) {
                throw new IllegalStateException("unable to find pending row for " + operationToRemove);
            }
        }

        public SyncOperation head() {
            return this.mOpsByWhen.peek();
        }

        public void popHead() {
            SyncOperation operation = (SyncOperation)this.mOpsByWhen.remove();
            if (this.mOpsByKey.remove(operation.key) == null) {
                throw new IllegalStateException("unable to find " + operation + " in mOpsByKey");
            }
            if (this.mSyncStorageEngine.deleteFromPending(operation.rowId) != 1) {
                throw new IllegalStateException("unable to find pending row for " + operation);
            }
        }

        public void clear(String account, String authority) {
            Iterator<Map.Entry<String, SyncOperation>> entries = this.mOpsByKey.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, SyncOperation> entry = entries.next();
                SyncOperation syncOperation = entry.getValue();
                if (account != null && !syncOperation.account.equals(account) || authority != null && !syncOperation.authority.equals(authority)) continue;
                entries.remove();
                if (!this.mOpsByWhen.remove(syncOperation)) {
                    throw new IllegalStateException("unable to find " + syncOperation + " in mOpsByWhen");
                }
                if (this.mSyncStorageEngine.deleteFromPending(syncOperation.rowId) == 1) continue;
                throw new IllegalStateException("unable to find pending row for " + syncOperation);
            }
        }

        public void dump(StringBuilder sb) {
            sb.append("SyncQueue: ").append(this.mOpsByWhen.size()).append(" operation(s)\n");
            for (SyncOperation operation : this.mOpsByWhen) {
                sb.append(operation).append("\n");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void debugCheckDataStructures(boolean checkDatabase) {
            if (this.mOpsByKey.size() != this.mOpsByWhen.size()) {
                throw new IllegalStateException("size mismatch: " + this.mOpsByKey.size() + " != " + this.mOpsByWhen.size());
            }
            for (SyncOperation syncOperation : this.mOpsByWhen) {
                if (this.mOpsByKey.containsKey(syncOperation.key)) continue;
                throw new IllegalStateException("operation " + syncOperation + " is in mOpsByWhen but not mOpsByKey");
            }
            for (Map.Entry entry : this.mOpsByKey.entrySet()) {
                SyncOperation operation = (SyncOperation)entry.getValue();
                String key = (String)entry.getKey();
                if (!key.equals(operation.key)) {
                    throw new IllegalStateException("operation " + operation + " in mOpsByKey doesn't match key " + key);
                }
                if (this.mOpsByWhen.contains(operation)) continue;
                throw new IllegalStateException("operation " + operation + " is in mOpsByKey but not mOpsByWhen");
            }
            if (checkDatabase) {
                Cursor cursor = this.mSyncStorageEngine.getPendingSyncsCursor(this.COLUMNS);
                try {
                    if (this.mOpsByKey.size() != cursor.getCount()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        DatabaseUtils.dumpCursor(cursor, stringBuilder);
                        stringBuilder.append("\n");
                        this.dump(stringBuilder);
                        throw new IllegalStateException("DB size mismatch: " + this.mOpsByKey.size() + " != " + cursor.getCount() + "\n" + stringBuilder.toString());
                    }
                }
                finally {
                    cursor.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SyncOperation cursorToOperation(Cursor cursor) {
            Bundle extras;
            byte[] extrasData = cursor.getBlob(3);
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(extrasData, 0, extrasData.length);
                parcel.setDataPosition(0);
                extras = parcel.readBundle();
            }
            catch (RuntimeException e) {
                extras = new Bundle();
            }
            finally {
                parcel.recycle();
            }
            SyncOperation syncOperation = new SyncOperation(cursor.getString(2), cursor.getInt(4), cursor.getString(1), extras, 0L);
            syncOperation.rowId = cursor.getLong(0);
            return syncOperation;
        }
    }

    public class SyncHandler
    extends Handler {
        public static final int MESSAGE_SYNC_FINISHED = 1;
        public static final int MESSAGE_SYNC_ALARM = 2;
        public static final int MESSAGE_CHECK_ALARMS = 3;
        public final SyncNotificationInfo mSyncNotificationInfo;
        public Long mAlarmScheduleTime;
        public final SyncTimeTracker mSyncTimeTracker;
        public boolean mErrorNotificationInstalled;

        public SyncHandler(Looper looper) {
            super(looper);
            this.mSyncNotificationInfo = new SyncNotificationInfo();
            this.mAlarmScheduleTime = null;
            this.mSyncTimeTracker = new SyncTimeTracker(null);
            this.mErrorNotificationInstalled = false;
        }

        public void handleMessage(Message msg) {
            this.handleSyncHandlerMessage(msg);
        }

        /*
         * Exception decompiling
         */
        public void handleSyncHandlerMessage(Message msg) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runStateSyncing() {
            ActiveSyncContext activeSyncContext = SyncManager.this.mActiveSyncContext;
            long now = SystemClock.elapsedRealtime();
            if (now > activeSyncContext.mTimeoutStartTime + 300000L) {
                SyncOperation nextSyncOperation;
                SyncQueue syncQueue = SyncManager.this.mSyncQueue;
                synchronized (syncQueue) {
                    nextSyncOperation = SyncManager.this.mSyncQueue.head();
                }
                if (nextSyncOperation != null && nextSyncOperation.earliestRunTime <= now) {
                    Log.d(SyncManager.TAG, "canceling and rescheduling sync because it ran too long: " + activeSyncContext.mSyncOperation);
                    SyncManager.this.rescheduleImmediately(activeSyncContext.mSyncOperation);
                    SyncManager.this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
                } else {
                    activeSyncContext.mTimeoutStartTime = now + 300000L;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runStateIdle() {
            IContentProvider contentProvider;
            SyncOperation syncOperation;
            boolean isLoggable = Log.isLoggable(SyncManager.TAG, 2);
            if (isLoggable) {
                Log.v(SyncManager.TAG, "runStateIdle");
            }
            if (!SyncManager.this.mDataConnectionIsConnected) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runStateIdle: no data connection, skipping");
                }
                SyncManager.this.setStatusText("No data connection");
                return;
            }
            if (SyncManager.this.mStorageIsLow) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runStateIdle: memory low, skipping");
                }
                SyncManager.this.setStatusText("Memory low");
                return;
            }
            String[] accounts = SyncManager.this.mAccounts;
            if (accounts == null) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runStateIdle: accounts not known, skipping");
                }
                SyncManager.this.setStatusText("Accounts not known yet");
                return;
            }
            Sync.Settings.QueryMap syncSettings = SyncManager.this.getSyncSettings();
            ConnectivityManager connManager = (ConnectivityManager)SyncManager.this.mContext.getSystemService("connectivity");
            boolean backgroundDataSetting = connManager.getBackgroundDataSetting();
            SyncQueue syncQueue = SyncManager.this.mSyncQueue;
            synchronized (syncQueue) {
                long now;
                while (true) {
                    if ((syncOperation = SyncManager.this.mSyncQueue.head()) == null) {
                        if (isLoggable) {
                            Log.v(SyncManager.TAG, "runStateIdle: no more sync operations, returning");
                        }
                        return;
                    }
                    if (!SyncManager.this.isSyncEnabled()) {
                        if (isLoggable) {
                            Log.v(SyncManager.TAG, "runStateIdle: sync disabled, dropping " + syncOperation);
                        }
                        SyncManager.this.mSyncQueue.popHead();
                        continue;
                    }
                    boolean force = syncOperation.extras.getBoolean("force", false);
                    if (!(force || backgroundDataSetting && syncSettings.getListenForNetworkTickles() && syncSettings.getSyncProviderAutomatically(syncOperation.authority))) {
                        if (isLoggable) {
                            Log.v(SyncManager.TAG, "runStateIdle: sync off, dropping " + syncOperation);
                        }
                        SyncManager.this.mSyncQueue.popHead();
                        continue;
                    }
                    if (ArrayUtils.contains(accounts, syncOperation.account)) break;
                    SyncManager.this.mSyncQueue.popHead();
                    if (!isLoggable) continue;
                    Log.v(SyncManager.TAG, "runStateIdle: account not present, dropping " + syncOperation);
                }
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runStateIdle: found sync candidate: " + syncOperation);
                }
                if (syncOperation.earliestRunTime > (now = SystemClock.elapsedRealtime())) {
                    if (Log.isLoggable(SyncManager.TAG, 3)) {
                        Log.d(SyncManager.TAG, "runStateIdle: the time is " + now + " yet the next " + "sync operation is for " + syncOperation.earliestRunTime + ": " + syncOperation);
                    }
                    return;
                }
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runStateIdle: we are going to sync " + syncOperation);
                }
                SyncManager.this.mSyncQueue.popHead();
            }
            String providerName = syncOperation.authority;
            SyncManager.this.ensureContentResolver();
            try {
                contentProvider = SyncManager.this.mContentResolver.acquireProvider(providerName);
                if (contentProvider == null) {
                    Log.e(SyncManager.TAG, "Provider " + providerName + " doesn't exist");
                    return;
                }
                if (contentProvider.getSyncAdapter() == null) {
                    Log.e(SyncManager.TAG, "Provider " + providerName + " isn't syncable, " + contentProvider);
                    return;
                }
            }
            catch (RemoteException remoteExc) {
                Log.e(SyncManager.TAG, "Caught a RemoteException while preparing for sync, rescheduling " + syncOperation, remoteExc);
                SyncManager.this.rescheduleWithDelay(syncOperation);
                return;
            }
            catch (RuntimeException exc) {
                Log.e(SyncManager.TAG, "Caught a RuntimeException while validating sync of " + providerName, exc);
                return;
            }
            long historyRowId = this.insertStartSyncEvent(syncOperation);
            try {
                ISyncAdapter syncAdapter = contentProvider.getSyncAdapter();
                ActiveSyncContext activeSyncContext = new ActiveSyncContext(syncOperation, contentProvider, syncAdapter, historyRowId);
                SyncManager.this.mSyncWakeLock.acquire();
                if (Log.isLoggable(SyncManager.TAG, 3)) {
                    Log.d(SyncManager.TAG, "starting sync of " + syncOperation);
                }
                syncAdapter.startSync(activeSyncContext, syncOperation.account, syncOperation.extras);
                SyncManager.this.mActiveSyncContext = activeSyncContext;
                SyncManager.this.mSyncStorageEngine.setActiveSync(SyncManager.this.mActiveSyncContext);
            }
            catch (RemoteException remoteExc) {
                Log.d(SyncManager.TAG, "runStateIdle: caught a RemoteException, rescheduling", remoteExc);
                SyncManager.this.mActiveSyncContext = null;
                SyncManager.this.mSyncStorageEngine.setActiveSync(SyncManager.this.mActiveSyncContext);
                SyncManager.this.rescheduleWithDelay(syncOperation);
            }
            catch (RuntimeException exc) {
                SyncManager.this.mActiveSyncContext = null;
                SyncManager.this.mSyncStorageEngine.setActiveSync(SyncManager.this.mActiveSyncContext);
                Log.e(SyncManager.TAG, "Caught a RuntimeException while starting the sync " + syncOperation, exc);
            }
        }

        public void runSyncFinishedOrCanceled(SyncResult syncResult) {
            int upstreamActivity;
            int downstreamActivity;
            String historyMessage;
            boolean isLoggable = Log.isLoggable(SyncManager.TAG, 2);
            if (isLoggable) {
                Log.v(SyncManager.TAG, "runSyncFinishedOrCanceled");
            }
            ActiveSyncContext activeSyncContext = SyncManager.this.mActiveSyncContext;
            SyncManager.this.mActiveSyncContext = null;
            SyncManager.this.mSyncStorageEngine.setActiveSync(SyncManager.this.mActiveSyncContext);
            SyncOperation syncOperation = activeSyncContext.mSyncOperation;
            long elapsedTime = SystemClock.elapsedRealtime() - activeSyncContext.mStartTime;
            if (syncResult != null) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runSyncFinishedOrCanceled: is a finished: operation " + syncOperation + ", result " + syncResult);
                }
                if (!syncResult.hasError()) {
                    if (isLoggable) {
                        Log.v(SyncManager.TAG, "finished sync operation " + syncOperation);
                    }
                    historyMessage = "success";
                    downstreamActivity = 0;
                    upstreamActivity = 0;
                } else {
                    SyncManager.this.maybeRescheduleSync(syncResult, syncOperation);
                    Log.d(SyncManager.TAG, "failed sync operation " + syncOperation);
                    historyMessage = Integer.toString(this.syncResultToErrorNumber(syncResult));
                    downstreamActivity = 0;
                    upstreamActivity = 0;
                }
            } else {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runSyncFinishedOrCanceled: is a cancel: operation " + syncOperation);
                }
                try {
                    activeSyncContext.mSyncAdapter.cancelSync();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                historyMessage = "canceled";
                downstreamActivity = 0;
                upstreamActivity = 0;
            }
            this.stopSyncEvent(activeSyncContext.mHistoryRowId, syncOperation, historyMessage, upstreamActivity, downstreamActivity, elapsedTime);
            SyncManager.this.mContentResolver.releaseProvider(activeSyncContext.mContentProvider);
            if (syncResult != null && syncResult.tooManyDeletions) {
                this.installHandleTooManyDeletesNotification(syncOperation.account, syncOperation.authority, syncResult.stats.numDeletes);
            } else {
                SyncManager.this.mNotificationMgr.cancel(syncOperation.account.hashCode() ^ syncOperation.authority.hashCode());
            }
            if (syncResult != null && syncResult.fullSyncRequested) {
                SyncManager.this.scheduleSyncOperation(new SyncOperation(syncOperation.account, syncOperation.syncSource, syncOperation.authority, new Bundle(), 0L));
            }
        }

        public int syncResultToErrorNumber(SyncResult syncResult) {
            if (syncResult.syncAlreadyInProgress) {
                return 1;
            }
            if (syncResult.stats.numAuthExceptions > 0L) {
                return 2;
            }
            if (syncResult.stats.numIoExceptions > 0L) {
                return 3;
            }
            if (syncResult.stats.numParseExceptions > 0L) {
                return 4;
            }
            if (syncResult.stats.numConflictDetectedExceptions > 0L) {
                return 5;
            }
            if (syncResult.tooManyDeletions) {
                return 6;
            }
            if (syncResult.tooManyRetries) {
                return 7;
            }
            if (syncResult.databaseError) {
                return 8;
            }
            throw new IllegalStateException("we are not in an error state, " + syncResult);
        }

        public void manageSyncNotification() {
            SyncOperation syncOperation;
            boolean shouldInstall;
            boolean shouldCancel;
            if (SyncManager.this.mActiveSyncContext == null) {
                this.mSyncNotificationInfo.startTime = null;
                shouldCancel = this.mSyncNotificationInfo.isActive;
                shouldInstall = false;
            } else {
                syncOperation = ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncOperation;
                long now = SystemClock.elapsedRealtime();
                if (this.mSyncNotificationInfo.startTime == null) {
                    this.mSyncNotificationInfo.startTime = now;
                }
                boolean bl = shouldCancel = this.mSyncNotificationInfo.isActive && (!syncOperation.authority.equals(this.mSyncNotificationInfo.authority) || !syncOperation.account.equals(this.mSyncNotificationInfo.account));
                if (this.mSyncNotificationInfo.isActive) {
                    shouldInstall = shouldCancel;
                } else {
                    boolean timeToShowNotification = now > this.mSyncNotificationInfo.startTime + 30000L;
                    boolean syncIsForced = syncOperation.extras.getBoolean("force", false);
                    boolean bl2 = shouldInstall = timeToShowNotification || syncIsForced;
                }
            }
            if (shouldCancel && !shouldInstall) {
                SyncManager.this.mNeedSyncActiveNotification = false;
                this.sendSyncStateIntent();
                this.mSyncNotificationInfo.isActive = false;
            }
            if (shouldInstall) {
                syncOperation = ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncOperation;
                SyncManager.this.mNeedSyncActiveNotification = true;
                this.sendSyncStateIntent();
                this.mSyncNotificationInfo.isActive = true;
                this.mSyncNotificationInfo.account = syncOperation.account;
                this.mSyncNotificationInfo.authority = syncOperation.authority;
            }
        }

        public void manageErrorNotification() {
            long when = SyncManager.this.mSyncStorageEngine.getInitialSyncFailureTime();
            if (when > 0L && when + 600000L < System.currentTimeMillis()) {
                if (!this.mErrorNotificationInstalled) {
                    SyncManager.this.mNeedSyncErrorNotification = true;
                    this.sendSyncStateIntent();
                }
                this.mErrorNotificationInstalled = true;
            } else {
                if (this.mErrorNotificationInstalled) {
                    SyncManager.this.mNeedSyncErrorNotification = false;
                    this.sendSyncStateIntent();
                }
                this.mErrorNotificationInstalled = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void manageSyncAlarm() {
            boolean needAlarm;
            long when;
            if (!SyncManager.this.mDataConnectionIsConnected) {
                return;
            }
            if (SyncManager.this.mAccounts == null) {
                return;
            }
            if (SyncManager.this.mStorageIsLow) {
                return;
            }
            Long alarmTime = null;
            ActiveSyncContext activeSyncContext = SyncManager.this.mActiveSyncContext;
            if (activeSyncContext == null) {
                SyncOperation syncOperation;
                SyncQueue syncQueue = SyncManager.this.mSyncQueue;
                synchronized (syncQueue) {
                    syncOperation = SyncManager.this.mSyncQueue.head();
                }
                if (syncOperation != null) {
                    alarmTime = syncOperation.earliestRunTime;
                }
            } else {
                long notificationTime = ((SyncManager)SyncManager.this).mSyncHandler.mSyncNotificationInfo.startTime + 30000L;
                long timeoutTime = ((SyncManager)SyncManager.this).mActiveSyncContext.mTimeoutStartTime + 300000L;
                alarmTime = ((SyncManager)SyncManager.this).mSyncHandler.mSyncNotificationInfo.isActive ? Long.valueOf(timeoutTime) : Long.valueOf(Math.min(notificationTime, timeoutTime));
            }
            if (!this.mErrorNotificationInstalled && (when = SyncManager.this.mSyncStorageEngine.getInitialSyncFailureTime()) > 0L) {
                long delay = (when += 600000L) - System.currentTimeMillis();
                when = SystemClock.elapsedRealtime() + delay;
                alarmTime = alarmTime != null ? Math.min(alarmTime, when) : when;
            }
            boolean shouldSet = false;
            boolean shouldCancel = false;
            boolean alarmIsActive = this.mAlarmScheduleTime != null;
            boolean bl = needAlarm = alarmTime != null;
            if (needAlarm) {
                if (!alarmIsActive || alarmTime < this.mAlarmScheduleTime) {
                    shouldSet = true;
                }
            } else {
                shouldCancel = alarmIsActive;
            }
            SyncManager.this.ensureAlarmService();
            if (shouldSet) {
                this.mAlarmScheduleTime = alarmTime;
                SyncManager.this.mAlarmService.set(2, alarmTime, SyncManager.this.mSyncAlarmIntent);
            } else if (shouldCancel) {
                this.mAlarmScheduleTime = null;
                SyncManager.this.mAlarmService.cancel(SyncManager.this.mSyncAlarmIntent);
            }
        }

        public void sendSyncStateIntent() {
            Intent syncStateIntent = new Intent("android.intent.action.SYNC_STATE_CHANGED");
            syncStateIntent.putExtra("active", SyncManager.this.mNeedSyncActiveNotification);
            syncStateIntent.putExtra("failing", SyncManager.this.mNeedSyncErrorNotification);
            SyncManager.this.mContext.sendBroadcast(syncStateIntent);
        }

        public void installHandleTooManyDeletesNotification(String account, String authority, long numDeletes) {
            if (SyncManager.this.mNotificationMgr == null) {
                return;
            }
            Intent clickIntent = new Intent();
            clickIntent.setClassName("com.android.providers.subscribedfeeds", "com.android.settings.SyncActivityTooManyDeletes");
            clickIntent.putExtra("account", account);
            clickIntent.putExtra("provider", authority);
            clickIntent.putExtra("numDeletes", numDeletes);
            if (!this.isActivityAvailable(clickIntent)) {
                Log.w(SyncManager.TAG, "No activity found to handle too many deletes.");
                return;
            }
            PendingIntent pendingIntent = PendingIntent.getActivity(SyncManager.this.mContext, 0, clickIntent, 0x10000000);
            CharSequence tooManyDeletesDescFormat = SyncManager.this.mContext.getResources().getText(17039450);
            String[] authorities = authority.split(";");
            Notification notification = new Notification(17302026, SyncManager.this.mContext.getString(17039448), System.currentTimeMillis());
            notification.setLatestEventInfo(SyncManager.this.mContext, SyncManager.this.mContext.getString(17039449), String.format(((Object)tooManyDeletesDescFormat).toString(), authorities[0]), pendingIntent);
            notification.flags |= 2;
            SyncManager.this.mNotificationMgr.notify(account.hashCode() ^ authority.hashCode(), notification);
        }

        public boolean isActivityAvailable(Intent intent) {
            PackageManager pm = SyncManager.this.mContext.getPackageManager();
            List<ResolveInfo> list = pm.queryIntentActivities(intent, 0);
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                ResolveInfo resolveInfo = list.get(i);
                if ((resolveInfo.activityInfo.applicationInfo.flags & 1) == 0) continue;
                return true;
            }
            return false;
        }

        public long insertStartSyncEvent(SyncOperation syncOperation) {
            int source = syncOperation.syncSource;
            long now = System.currentTimeMillis();
            EventLog.writeEvent(2720, syncOperation.authority, 0, source);
            return SyncManager.this.mSyncStorageEngine.insertStartSyncEvent(syncOperation.account, syncOperation.authority, now, source);
        }

        public void stopSyncEvent(long rowId, SyncOperation syncOperation, String resultMessage, int upstreamActivity, int downstreamActivity, long elapsedTime) {
            EventLog.writeEvent(2720, syncOperation.authority, 1, syncOperation.syncSource);
            SyncManager.this.mSyncStorageEngine.stopSyncEvent(rowId, elapsedTime, resultMessage, downstreamActivity, upstreamActivity);
        }

        public class SyncNotificationInfo {
            public String account;
            public String authority;
            public boolean isActive = false;
            public Long startTime = null;

            public void toString(StringBuilder sb) {
                sb.append("account ").append(this.account).append(", authority ").append(this.authority).append(", isActive ").append(this.isActive).append(", startTime ").append(this.startTime);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                this.toString(sb);
                return sb.toString();
            }
        }
    }

    public class SyncTimeTracker {
        public boolean mLastWasSyncing = false;
        public long mWhenSyncStarted = 0L;
        public long mTimeSpentSyncing;

        public SyncTimeTracker() {
        }

        public synchronized void update() {
            boolean isSyncInProgress;
            boolean bl = isSyncInProgress = SyncManager.this.mActiveSyncContext != null;
            if (isSyncInProgress == this.mLastWasSyncing) {
                return;
            }
            long now = SystemClock.elapsedRealtime();
            if (isSyncInProgress) {
                this.mWhenSyncStarted = now;
            } else {
                this.mTimeSpentSyncing += now - this.mWhenSyncStarted;
            }
            this.mLastWasSyncing = isSyncInProgress;
        }

        public synchronized long timeSpentSyncing() {
            if (!this.mLastWasSyncing) {
                return this.mTimeSpentSyncing;
            }
            long now = SystemClock.elapsedRealtime();
            return this.mTimeSpentSyncing + (now - this.mWhenSyncStarted);
        }

        public /* synthetic */ SyncTimeTracker(1 x1) {
            this();
        }
    }

    public class ActiveSyncContext
    extends ISyncContext.Stub {
        public final SyncOperation mSyncOperation;
        public final long mHistoryRowId;
        public final IContentProvider mContentProvider;
        public final ISyncAdapter mSyncAdapter;
        public final long mStartTime;
        public long mTimeoutStartTime;

        public ActiveSyncContext(SyncOperation syncOperation, IContentProvider contentProvider, ISyncAdapter syncAdapter, long historyRowId) {
            this.mSyncOperation = syncOperation;
            this.mHistoryRowId = historyRowId;
            this.mContentProvider = contentProvider;
            this.mSyncAdapter = syncAdapter;
            this.mTimeoutStartTime = this.mStartTime = SystemClock.elapsedRealtime();
        }

        public void sendHeartbeat() {
            if (SyncManager.this.mActiveSyncContext == this) {
                SyncManager.this.updateHeartbeatTime();
            }
        }

        public void onFinished(SyncResult result) {
            SyncManager.this.sendSyncFinishedOrCanceledMessage(this, result);
        }

        public void toString(StringBuilder sb) {
            sb.append("startTime ").append(this.mStartTime).append(", mTimeoutStartTime ").append(this.mTimeoutStartTime).append(", mHistoryRowId ").append(this.mHistoryRowId).append(", syncOperation ").append(this.mSyncOperation);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }
    }

    public static class SyncOperation
    implements Comparable {
        public final String account;
        public int syncSource;
        public String authority;
        public Bundle extras;
        public final String key;
        public long earliestRunTime;
        public long delay;
        public Long rowId = null;

        public SyncOperation(String account, int source, String authority, Bundle extras, long delay) {
            this.account = account;
            this.syncSource = source;
            this.authority = authority;
            this.extras = new Bundle(extras);
            this.setDelay(delay);
            this.key = this.toKey();
        }

        public SyncOperation(SyncOperation other) {
            this.account = other.account;
            this.syncSource = other.syncSource;
            this.authority = other.authority;
            this.extras = new Bundle(other.extras);
            this.delay = other.delay;
            this.earliestRunTime = other.earliestRunTime;
            this.key = this.toKey();
        }

        public void setDelay(long delay) {
            this.delay = delay;
            this.earliestRunTime = delay >= 0L ? SystemClock.elapsedRealtime() + delay : 0L;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("authority: ").append(this.authority);
            sb.append(" account: ").append(this.account);
            sb.append(" extras: ");
            SyncOperation.extrasToStringBuilder(this.extras, sb);
            sb.append(" syncSource: ").append(this.syncSource);
            sb.append(" when: ").append(this.earliestRunTime);
            sb.append(" delay: ").append(this.delay);
            sb.append(" key: {").append(this.key).append("}");
            if (this.rowId != null) {
                sb.append(" rowId: ").append(this.rowId);
            }
            return sb.toString();
        }

        public String toKey() {
            StringBuilder sb = new StringBuilder();
            sb.append("authority: ").append(this.authority);
            sb.append(" account: ").append(this.account);
            sb.append(" extras: ");
            SyncOperation.extrasToStringBuilder(this.extras, sb);
            return sb.toString();
        }

        public static void extrasToStringBuilder(Bundle bundle, StringBuilder sb) {
            sb.append("[");
            for (String key : bundle.keySet()) {
                sb.append(key).append("=").append(bundle.get(key)).append(" ");
            }
            sb.append("]");
        }

        public int compareTo(Object o) {
            SyncOperation other = (SyncOperation)o;
            if (this.earliestRunTime == other.earliestRunTime) {
                return 0;
            }
            return this.earliestRunTime < other.earliestRunTime ? -1 : 1;
        }
    }

    public class SyncPollAlarmReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            SyncManager.this.handleSyncPollAlarm();
        }
    }

    public class SyncAlarmIntentReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            SyncManager.this.mHandleAlarmWakeLock.acquire();
            SyncManager.this.sendSyncAlarmMessage();
        }
    }

    public class SyncHandlerMessagePayload {
        public final ActiveSyncContext activeSyncContext;
        public final SyncResult syncResult;

        public SyncHandlerMessagePayload(ActiveSyncContext syncContext, SyncResult syncResult) {
            this.activeSyncContext = syncContext;
            this.syncResult = syncResult;
        }
    }
}

