/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.app.Application;
import android.app.IActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.IBinder;
import android.os.RemoteException;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public abstract class Service
extends ContextWrapper
implements ComponentCallbacks {
    public static final String TAG = "Service";
    public ActivityThread mThread = null;
    public String mClassName = null;
    public IBinder mToken = null;
    public Application mApplication = null;
    public IActivityManager mActivityManager = null;

    public Service() {
        super(null);
    }

    public Application getApplication() {
        return this.mApplication;
    }

    public void onCreate() {
    }

    public void onStart(Intent intent, int startId) {
    }

    public void onDestroy() {
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onLowMemory() {
    }

    public abstract IBinder onBind(Intent var1);

    public boolean onUnbind(Intent intent) {
        return false;
    }

    public void onRebind(Intent intent) {
    }

    public void stopSelf() {
        this.stopSelf(-1);
    }

    public void stopSelf(int startId) {
        if (this.mActivityManager == null) {
            return;
        }
        try {
            this.mActivityManager.stopServiceToken(new ComponentName((Context)this, this.mClassName), this.mToken, startId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean stopSelfResult(int startId) {
        if (this.mActivityManager == null) {
            return false;
        }
        try {
            return this.mActivityManager.stopServiceToken(new ComponentName((Context)this, this.mClassName), this.mToken, startId);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void setForeground(boolean isForeground) {
        if (this.mActivityManager == null) {
            return;
        }
        try {
            this.mActivityManager.setServiceForeground(new ComponentName((Context)this, this.mClassName), this.mToken, isForeground);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.println("nothing to dump");
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public void attach(Context context, ActivityThread thread, String className, IBinder token, Application application, Object activityManager) {
        this.attachBaseContext(context);
        this.mThread = thread;
        this.mClassName = className;
        this.mToken = token;
        this.mApplication = application;
        this.mActivityManager = (IActivityManager)activityManager;
    }

    public String getClassName() {
        return this.mClassName;
    }
}

