/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class ApkConfigEditDialog
extends Dialog
implements ModifyListener,
VerifyListener {
    private String mName;
    private String mFilter;
    private Text mNameField;
    private Text mFilterField;
    private Button mOkButton;

    protected ApkConfigEditDialog(String name, String filter, Shell parentShell) {
        super(parentShell);
        this.mName = name;
        this.mFilter = filter;
    }

    public String getName() {
        return this.mName;
    }

    public String getFilter() {
        return this.mFilter;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.mOkButton = this.getButton(0);
        this.validateButtons();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayoutData((Object)new GridData(1808));
        Label l = new Label(composite, 0);
        l.setText("Name");
        this.mNameField = new Text(composite, 2048);
        this.mNameField.setLayoutData((Object)new GridData(768));
        this.mNameField.addVerifyListener((VerifyListener)this);
        if (this.mName != null) {
            this.mNameField.setText(this.mName);
        }
        this.mNameField.addModifyListener((ModifyListener)this);
        l = new Label(composite, 0);
        l.setText("Filter");
        this.mFilterField = new Text(composite, 2048);
        this.mFilterField.setLayoutData((Object)new GridData(768));
        if (this.mFilter != null) {
            this.mFilterField.setText(this.mFilter);
        }
        this.mFilterField.addVerifyListener((VerifyListener)this);
        this.mFilterField.addModifyListener((ModifyListener)this);
        ApkConfigEditDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void validateButtons() {
        this.mOkButton.setEnabled(this.mNameField.getText().trim().length() > 0 && this.mFilterField.getText().trim().length() > 0);
    }

    protected void okPressed() {
        this.mName = this.mNameField.getText();
        this.mFilter = this.mFilterField.getText().trim();
        super.okPressed();
    }

    public void modifyText(ModifyEvent e) {
        this.validateButtons();
    }

    public void verifyText(VerifyEvent e) {
        block3: {
            Text source;
            block2: {
                source = (Text)e.getSource();
                if (source != this.mNameField) break block2;
                String text = e.text;
                int len = text.length();
                for (int i = 0; i < len; ++i) {
                    char letter = text.charAt(i);
                    if (letter <= '\u00ff' && Character.isLetterOrDigit(letter)) continue;
                    e.doit = false;
                    return;
                }
                break block3;
            }
            if (source != this.mFilterField) break block3;
            String text = e.text;
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                char letter = text.charAt(i);
                if (letter <= '\u00ff' && (Character.isLetterOrDigit(letter) || letter == ',')) continue;
                e.doit = false;
                return;
            }
        }
    }
}

