/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.newxmlfile;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.wizards.newxmlfile.NewXmlFileCreationPage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewXmlFileWizard
extends Wizard
implements INewWizard {
    private static final String PROJECT_LOGO_LARGE = "android_large";
    protected static final String MAIN_PAGE_NAME = "newAndroidXmlFilePage";
    private NewXmlFileCreationPage mMainPage;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.setHelpAvailable(false);
        this.setWindowTitle("New Android XML File");
        this.setImageDescriptor();
        this.mMainPage = this.createMainPage();
        this.mMainPage.setTitle("New Android XML File");
        this.mMainPage.setDescription("Creates a new Android XML file.");
        this.mMainPage.setInitialSelection(iStructuredSelection);
    }

    protected NewXmlFileCreationPage createMainPage() {
        return new NewXmlFileCreationPage(MAIN_PAGE_NAME);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mMainPage);
    }

    public boolean performFinish() {
        IWorkbenchPage iWorkbenchPage;
        IFile iFile = this.createXmlFile();
        if (iFile == null) {
            return false;
        }
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            try {
                IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile);
            }
            catch (PartInitException partInitException) {
                AdtPlugin.log(partInitException, "Failed to create %1$s: missing type", iFile.getFullPath().toString());
            }
        }
        return true;
    }

    private IFile createXmlFile() {
        String string;
        IFile iFile = this.mMainPage.getDestinationFile();
        String string2 = iFile.getFullPath().toString();
        boolean bl = false;
        if (iFile.exists()) {
            if (!AdtPlugin.displayPrompt("New Android XML File", String.format("Do you want to overwrite the file %1$s ?", string2))) {
                return null;
            }
            bl = true;
        } else {
            this.createWsParentDirectory(iFile.getParent());
        }
        NewXmlFileCreationPage.TypeInfo typeInfo = this.mMainPage.getSelectedType();
        if (typeInfo == null) {
            AdtPlugin.log(4, "Failed to create %1$s: missing type", string2);
            return null;
        }
        String string3 = typeInfo.getXmlns();
        String string4 = this.mMainPage.getRootElement();
        if (string4 == null) {
            AdtPlugin.log(4, "Failed to create %1$s: missing root element", iFile.toString());
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        stringBuilder.append('<').append(string4);
        if (string3 != null) {
            stringBuilder.append('\n').append("  xmlns:android=\"").append(string3).append("\"");
        }
        if ((string = typeInfo.getDefaultAttrs()) != null) {
            stringBuilder.append("\n  ");
            stringBuilder.append(string.replace("\n", "\n  "));
        }
        stringBuilder.append(">\n");
        stringBuilder.append("</").append(string4).append(">\n");
        String string5 = stringBuilder.toString();
        String string6 = null;
        try {
            byte[] byArray = string5.getBytes("UTF8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            if (bl) {
                iFile.delete(3, null);
            }
            iFile.create((InputStream)byteArrayInputStream, true, null);
            return iFile;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string6 = unsupportedEncodingException.getMessage();
        }
        catch (CoreException coreException) {
            string6 = coreException.getMessage();
        }
        string6 = String.format("Failed to generate %1$s: %2$s", string2, string6);
        AdtPlugin.displayError("New Android XML File", string6);
        return null;
    }

    private boolean createWsParentDirectory(IContainer iContainer) {
        if (iContainer.getType() == 2) {
            if (iContainer == null || iContainer.exists()) {
                return true;
            }
            IFolder iFolder = (IFolder)iContainer;
            try {
                if (this.createWsParentDirectory(iContainer.getParent())) {
                    iFolder.create(true, true, null);
                    return true;
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        return false;
    }

    private void setImageDescriptor() {
        ImageDescriptor imageDescriptor = IconFactory.getInstance().getImageDescriptor(PROJECT_LOGO_LARGE);
        this.setDefaultPageImageDescriptor(imageDescriptor);
    }
}

