/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.ui;

import com.android.ide.eclipse.adt.internal.resources.configurations.CountryCodeQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.KeyboardStateQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.LanguageQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.NavigationMethodQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.NetworkCodeQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.PixelDensityQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.RegionQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.ScreenDimensionQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.ScreenOrientationQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.ScreenRatioQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.ScreenSizeQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.TextInputMethodQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.TouchScreenQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.VersionQualifier;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import java.util.HashMap;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ConfigurationSelector
extends Composite {
    public static final int WIDTH_HINT = 600;
    public static final int HEIGHT_HINT = 250;
    private Runnable mOnChangeListener;
    private TableViewer mFullTableViewer;
    private TableViewer mSelectionTableViewer;
    private Button mAddButton;
    private Button mRemoveButton;
    private StackLayout mStackLayout;
    private boolean mOnRefresh = false;
    private final FolderConfiguration mBaseConfiguration = new FolderConfiguration();
    private final FolderConfiguration mSelectedConfiguration = new FolderConfiguration();
    private final HashMap<Class<? extends ResourceQualifier>, QualifierEditBase> mUiMap = new HashMap();
    private Composite mQualifierEditParent;

    public ConfigurationSelector(Composite composite) {
        super(composite, 0);
        this.mBaseConfiguration.createDefault();
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        final Table table = new Table((Composite)this, 67588);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        final TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText("Available Qualifiers");
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = table.getClientArea();
                tableColumn.setWidth(rectangle.width);
            }
        });
        this.mFullTableViewer = new TableViewer(table);
        this.mFullTableViewer.setContentProvider((IContentProvider)new QualifierContentProvider());
        this.mFullTableViewer.setLabelProvider((IBaseLabelProvider)new QualifierLabelProvider(false));
        this.mFullTableViewer.setInput((Object)this.mBaseConfiguration);
        this.mFullTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection;
                Object object;
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof ResourceQualifier) {
                    ConfigurationSelector.this.mAddButton.setEnabled(true);
                    return;
                }
                ConfigurationSelector.this.mAddButton.setEnabled(false);
            }
        });
        Composite composite2 = new Composite((Composite)this, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1040));
        new Composite(composite2, 0);
        this.mAddButton = new Button(composite2, 2056);
        this.mAddButton.setText("->");
        this.mAddButton.setEnabled(false);
        this.mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ConfigurationSelector.this.mFullTableViewer.getSelection();
                Object object = iStructuredSelection.getFirstElement();
                if (object instanceof ResourceQualifier) {
                    ResourceQualifier resourceQualifier = (ResourceQualifier)object;
                    ConfigurationSelector.this.mBaseConfiguration.removeQualifier(resourceQualifier);
                    ConfigurationSelector.this.mSelectedConfiguration.addQualifier(resourceQualifier);
                    ConfigurationSelector.this.mFullTableViewer.refresh();
                    ConfigurationSelector.this.mSelectionTableViewer.refresh();
                    ConfigurationSelector.this.mSelectionTableViewer.setSelection((ISelection)new StructuredSelection((Object)resourceQualifier), true);
                    ConfigurationSelector.this.onChange(false);
                }
            }
        });
        this.mRemoveButton = new Button(composite2, 2056);
        this.mRemoveButton.setText("<-");
        this.mRemoveButton.setEnabled(false);
        this.mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ConfigurationSelector.this.mSelectionTableViewer.getSelection();
                Object object = iStructuredSelection.getFirstElement();
                if (object instanceof ResourceQualifier) {
                    ResourceQualifier resourceQualifier = (ResourceQualifier)object;
                    ConfigurationSelector.this.mSelectedConfiguration.removeQualifier(resourceQualifier);
                    ConfigurationSelector.this.mBaseConfiguration.addQualifier(resourceQualifier);
                    ConfigurationSelector.this.mFullTableViewer.refresh();
                    ConfigurationSelector.this.mSelectionTableViewer.refresh();
                    ConfigurationSelector.this.onChange(false);
                }
            }
        });
        final Table table2 = new Table((Composite)this, 67588);
        table2.setLayoutData((Object)new GridData(1808));
        table2.setHeaderVisible(true);
        table2.setLinesVisible(true);
        final TableColumn tableColumn2 = new TableColumn(table2, 16384);
        tableColumn2.setText("Chosen Qualifiers");
        table2.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = table2.getClientArea();
                tableColumn2.setWidth(rectangle.width);
            }
        });
        this.mSelectionTableViewer = new TableViewer(table2);
        this.mSelectionTableViewer.setContentProvider((IContentProvider)new QualifierContentProvider());
        this.mSelectionTableViewer.setLabelProvider((IBaseLabelProvider)new QualifierLabelProvider(true));
        this.mSelectionTableViewer.setInput((Object)this.mSelectedConfiguration);
        this.mSelectionTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (ConfigurationSelector.this.mOnRefresh) {
                    return;
                }
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                    if (!iStructuredSelection.isEmpty()) {
                        Object object = iStructuredSelection.getFirstElement();
                        if (object instanceof ResourceQualifier) {
                            ConfigurationSelector.this.mRemoveButton.setEnabled(true);
                            QualifierEditBase qualifierEditBase = (QualifierEditBase)((Object)ConfigurationSelector.this.mUiMap.get(object.getClass()));
                            if (qualifierEditBase != null) {
                                qualifierEditBase.setQualifier((ResourceQualifier)object);
                            }
                            ((ConfigurationSelector)ConfigurationSelector.this).mStackLayout.topControl = qualifierEditBase;
                            ConfigurationSelector.this.mQualifierEditParent.layout();
                            return;
                        }
                    } else {
                        ((ConfigurationSelector)ConfigurationSelector.this).mStackLayout.topControl = null;
                        ConfigurationSelector.this.mQualifierEditParent.layout();
                    }
                }
                ConfigurationSelector.this.mRemoveButton.setEnabled(false);
            }
        });
        this.mQualifierEditParent = new Composite((Composite)this, 0);
        this.mStackLayout = new StackLayout();
        this.mQualifierEditParent.setLayout((Layout)this.mStackLayout);
        this.mQualifierEditParent.setLayoutData((Object)new GridData(1040));
        this.mUiMap.put(CountryCodeQualifier.class, new MCCEdit(this.mQualifierEditParent));
        this.mUiMap.put(NetworkCodeQualifier.class, new MNCEdit(this.mQualifierEditParent));
        this.mUiMap.put(LanguageQualifier.class, new LanguageEdit(this.mQualifierEditParent));
        this.mUiMap.put(RegionQualifier.class, new RegionEdit(this.mQualifierEditParent));
        this.mUiMap.put(ScreenSizeQualifier.class, new ScreenSizeEdit(this.mQualifierEditParent));
        this.mUiMap.put(ScreenRatioQualifier.class, new ScreenRatioEdit(this.mQualifierEditParent));
        this.mUiMap.put(ScreenOrientationQualifier.class, new OrientationEdit(this.mQualifierEditParent));
        this.mUiMap.put(PixelDensityQualifier.class, new PixelDensityEdit(this.mQualifierEditParent));
        this.mUiMap.put(TouchScreenQualifier.class, new TouchEdit(this.mQualifierEditParent));
        this.mUiMap.put(KeyboardStateQualifier.class, new KeyboardEdit(this.mQualifierEditParent));
        this.mUiMap.put(TextInputMethodQualifier.class, new TextInputEdit(this.mQualifierEditParent));
        this.mUiMap.put(NavigationMethodQualifier.class, new NavigationEdit(this.mQualifierEditParent));
        this.mUiMap.put(ScreenDimensionQualifier.class, new ScreenDimensionEdit(this.mQualifierEditParent));
        this.mUiMap.put(VersionQualifier.class, new VersionEdit(this.mQualifierEditParent));
    }

    public void setOnChangeListener(Runnable runnable) {
        this.mOnChangeListener = runnable;
    }

    public void setConfiguration(FolderConfiguration folderConfiguration) {
        this.mSelectedConfiguration.set(folderConfiguration);
        this.mSelectionTableViewer.refresh();
        this.mBaseConfiguration.substract(this.mSelectedConfiguration);
        this.mFullTableViewer.refresh();
    }

    public boolean setConfiguration(String[] stringArray) {
        FolderConfiguration folderConfiguration = ResourceManager.getInstance().getConfig(stringArray);
        if (folderConfiguration == null) {
            return false;
        }
        this.setConfiguration(folderConfiguration);
        return true;
    }

    public boolean setConfiguration(String string) {
        String[] stringArray = string.split("-");
        return this.setConfiguration(stringArray);
    }

    public void getConfiguration(FolderConfiguration folderConfiguration) {
        folderConfiguration.set(this.mSelectedConfiguration);
    }

    public ConfigurationState getState() {
        if (this.mSelectedConfiguration.getInvalidQualifier() != null) {
            return ConfigurationState.INVALID_CONFIG;
        }
        if (!this.mSelectedConfiguration.checkRegion()) {
            return ConfigurationState.REGION_WITHOUT_LANGUAGE;
        }
        return ConfigurationState.OK;
    }

    public ResourceQualifier getInvalidQualifier() {
        return this.mSelectedConfiguration.getInvalidQualifier();
    }

    private void onChange(boolean bl) {
        ISelection iSelection = null;
        if (bl) {
            this.mOnRefresh = true;
            iSelection = this.mSelectionTableViewer.getSelection();
        }
        this.mSelectionTableViewer.refresh(true);
        if (bl) {
            this.mSelectionTableViewer.setSelection(iSelection);
            this.mOnRefresh = false;
        }
        if (this.mOnChangeListener != null) {
            this.mOnChangeListener.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfigurationState {
        OK,
        INVALID_CONFIG,
        REGION_WITHOUT_LANGUAGE;

    }

    public static class DensityVerifier
    extends DigitVerifier {
    }

    private static class DigitVerifier
    implements VerifyListener {
        private DigitVerifier() {
        }

        public void verifyText(VerifyEvent verifyEvent) {
            int n = 0;
            while (n < verifyEvent.text.length()) {
                char c = verifyEvent.text.charAt(n);
                if (c < '0' || c > '9') {
                    verifyEvent.doit = false;
                    return;
                }
                ++n;
            }
        }
    }

    public static class DimensionVerifier
    extends DigitVerifier {
    }

    private class KeyboardEdit
    extends QualifierEditBase {
        private Combo mKeyboard;

        public KeyboardEdit(Composite composite) {
            KeyboardStateQualifier.KeyboardState[] keyboardStateArray;
            super(composite, "Keyboard State");
            this.mKeyboard = new Combo((Composite)this, 12);
            KeyboardStateQualifier.KeyboardState[] keyboardStateArray2 = keyboardStateArray = KeyboardStateQualifier.KeyboardState.values();
            int n = keyboardStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                KeyboardStateQualifier.KeyboardState keyboardState = keyboardStateArray2[n2];
                this.mKeyboard.add(keyboardState.getDisplayValue());
                ++n2;
            }
            this.mKeyboard.setLayoutData((Object)new GridData(768));
            this.mKeyboard.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    KeyboardEdit.this.onKeyboardChange();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    KeyboardEdit.this.onKeyboardChange();
                }
            });
        }

        protected void onKeyboardChange() {
            int n = this.mKeyboard.getSelectionIndex();
            if (n != -1) {
                ConfigurationSelector.this.mSelectedConfiguration.setKeyboardStateQualifier(new KeyboardStateQualifier(KeyboardStateQualifier.KeyboardState.getByIndex(n)));
            } else {
                ConfigurationSelector.this.mSelectedConfiguration.setKeyboardStateQualifier(new KeyboardStateQualifier());
            }
            ConfigurationSelector.this.onChange(true);
        }

        public void setQualifier(ResourceQualifier resourceQualifier) {
            KeyboardStateQualifier keyboardStateQualifier = (KeyboardStateQualifier)resourceQualifier;
            KeyboardStateQualifier.KeyboardState keyboardState = keyboardStateQualifier.getValue();
            if (keyboardState == null) {
                this.mKeyboard.clearSelection();
            } else {
                this.mKeyboard.select(KeyboardStateQualifier.KeyboardState.getIndex(keyboardState));
            }
        }
    }

    private class LanguageEdit
    extends QualifierEditBase {
        private Combo mLanguage;

        public LanguageEdit(Composite composite) {
            super(composite, "Language");
            this.mLanguage = new Combo((Composite)this, 4);
            this.mLanguage.setLayoutData((Object)new GridData(768));
            this.mLanguage.addVerifyListener((VerifyListener)new LanguageRegionVerifier());
            this.mLanguage.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    LanguageEdit.this.onLanguageChange();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    LanguageEdit.this.onLanguageChange();
                }
            });
            this.mLanguage.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    LanguageEdit.this.onLanguageChange();
                }
            });
            new Label((Composite)this, 0).setText("(2 letter code)");
        }

        private void onLanguageChange() {
            String string = this.mLanguage.getText();
            if (string.length() == 0) {
                ConfigurationSelector.this.mSelectedConfiguration.setLanguageQualifier(new LanguageQualifier());
            } else {
                LanguageQualifier languageQualifier = null;
                String string2 = LanguageQualifier.getFolderSegment(string);
                if (string2 != null) {
                    languageQualifier = LanguageQualifier.getQualifier(string2);
                }
                if (languageQualifier != null) {
                    ConfigurationSelector.this.mSelectedConfiguration.setLanguageQualifier(languageQualifier);
                } else {
                    ConfigurationSelector.this.mSelectedConfiguration.setLanguageQualifier(new LanguageQualifier());
                }
            }
            ConfigurationSelector.this.onChange(true);
        }

        public void setQualifier(ResourceQualifier resourceQualifier) {
            LanguageQualifier languageQualifier = (LanguageQualifier)resourceQualifier;
            String string = languageQualifier.getValue();
            if (string != null) {
                this.mLanguage.setText(string);
            }
        }
    }

    public static class LanguageRegionVerifier
    implements VerifyListener {
        public void verifyText(VerifyEvent verifyEvent) {
            if (verifyEvent.text.length() - verifyEvent.end + verifyEvent.start + ((Combo)verifyEvent.getSource()).getText().length() > 2) {
                verifyEvent.doit = false;
                return;
            }
            int n = 0;
            while (n < verifyEvent.text.length()) {
                char c = verifyEvent.text.charAt(n);
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    verifyEvent.doit = false;
                    return;
                }
                ++n;
            }
        }
    }

    private class MCCEdit
    extends QualifierEditBase {
        private Text mText;

        public MCCEdit(Composite composite) {
            super(composite, "Mobile Country Code");
            this.mText = new Text((Composite)this, 2048);
            this.mText.addVerifyListener((VerifyListener)new MobileCodeVerifier());
            this.mText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    MCCEdit.this.onTextChange();
                }
            });
            this.mText.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    MCCEdit.this.onTextChange();
                }
            });
            new Label((Composite)this, 0).setText("(3 digit code)");
        }

        private void onTextChange() {
            String string = this.mText.getText();
            if (string.length() == 0) {
                ConfigurationSelector.this.mSelectedConfiguration.setCountryCodeQualifier(new CountryCodeQualifier());
            } else {
                try {
                    CountryCodeQualifier countryCodeQualifier = CountryCodeQualifier.getQualifier(CountryCodeQualifier.getFolderSegment(Integer.parseInt(string)));
                    if (countryCodeQualifier != null) {
                        ConfigurationSelector.this.mSelectedConfiguration.setCountryCodeQualifier(countryCodeQualifier);
                    } else {
                        ConfigurationSelector.this.mSelectedConfiguration.setCountryCodeQualifier(new CountryCodeQualifier());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    ConfigurationSelector.this.mSelectedConfiguration.setCountryCodeQualifier(new CountryCodeQualifier());
                }
            }
            ConfigurationSelector.this.onChange(true);
        }

        public void setQualifier(ResourceQualifier resourceQualifier) {
            CountryCodeQualifier countryCodeQualifier = (CountryCodeQualifier)resourceQualifier;
            this.mText.setText(Integer.toString(countryCodeQualifier.getCode()));
        }
    }

    private class MNCEdit
    extends QualifierEditBase {
        private Text mText;

        public MNCEdit(Composite composite) {
            super(composite, "Mobile Network Code");
            this.mText = new Text((Composite)this, 2048);
            this.mText.addVerifyListener((VerifyListener)new MobileCodeVerifier());
            this.mText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    MNCEdit.this.onTextChange();
                }
            });
            this.mText.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    MNCEdit.this.onTextChange();
                }
            });
            new Label((Composite)this, 0).setText("(1-3 digit code)");
        }

        private void onTextChange() {
            String string = this.mText.getText();
            if (string.length() == 0) {
                ConfigurationSelector.this.mSelectedConfiguration.setNetworkCodeQualifier(new NetworkCodeQualifier());
            } else {
                try {
                    NetworkCodeQualifier networkCodeQualifier = NetworkCodeQualifier.getQualifier(NetworkCodeQualifier.getFolderSegment(Integer.parseInt(string)));
                    if (networkCodeQualifier != null) {
                        ConfigurationSelector.this.mSelectedConfiguration.setNetworkCodeQualifier(networkCodeQualifier);
                    } else {
                        ConfigurationSelector.this.mSelectedConfiguration.setNetworkCodeQualifier(new NetworkCodeQualifier());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    ConfigurationSelector.this.mSelectedConfiguration.setNetworkCodeQualifier(new NetworkCodeQualifier());
                }
            }
            ConfigurationSelector.this.onChange(true);
        }

        public void setQualifier(ResourceQualifier resourceQualifier) {
            NetworkCodeQualifier networkCodeQualifier = (NetworkCodeQualifier)resourceQualifier;
            this.mText.setText(Integer.toString(networkCodeQualifier.getCode()));
        }
    }

    public static class MobileCodeVerifier
    extends DigitVerifier {
        public void verifyText(VerifyEvent verifyEvent) {
            super.verifyText(verifyEvent);
            if (verifyEvent.doit && verifyEvent.text.length() - verifyEvent.end + verifyEvent.start + ((Text)verifyEvent.getSource()).getText().length() > 3) {
                verifyEvent.doit = false;
            }
        }
    }

    private class NavigationEdit
    extends QualifierEditBase {
        private Combo mNavigation;

        public NavigationEdit(Composite composite) {
            NavigationMethodQualifier.NavigationMethod[] navigationMethodArray;
            super(composite, "Navigation Method");
            this.mNavigation = new Combo((Composite)this, 12);
            NavigationMethodQualifier.NavigationMethod[] navigationMethodArray2 = navigationMethodArray = NavigationMethodQualifier.NavigationMethod.values();
            int n = navigationMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                NavigationMethodQualifier.NavigationMethod navigationMethod = navigationMethodArray2[n2];
                this.mNavigation.add(navigationMethod.getDisplayValue());
                ++n2;
            }
            this.mNavigation.setLayoutData((Object)new GridData(768));
            this.mNavigation.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    NavigationEdit.this.onNavigationChange();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NavigationEdit.this.onNavigationChange();
                }
            });
        }

        protected void onNavigationChange() {
            int n = this.mNavigation.getSelectionIndex();
            if (n != -1) {
                ConfigurationSelector.this.mSelectedConfiguration.setNavigationMethodQualifier(new NavigationMethodQualifier(NavigationMethodQualifier.NavigationMethod.getByIndex(n)));
            } else {
                ConfigurationSelector.this.mSelectedConfiguration.setNavigationMethodQualifier(new NavigationMethodQualifier());
            }
            ConfigurationSelector.this.onChange(true);
        }

        public void setQualifier(ResourceQualifier resourceQualifier) {
            NavigationMethodQualifier navigationMethodQualifier = (NavigationMethodQualifier)resourceQualifier;
            NavigationMethodQualifier.NavigationMethod navigationMethod = navigationMethodQualifier.getValue();
            if (navigationMethod == null) {
                this.mNavigation.clearSelection();
            } else {
                this.mNavigation.select(NavigationMethodQualifier.NavigationMethod.getIndex(navigationMethod));
            }
        }
    }

    private class OrientationEdit
    extends QualifierEditBase {
        private Combo mOrientation;

        public OrientationEdit(Composite composite) {
            ScreenOrientationQualifier.ScreenOrientation[] screenOrientationArray;
            super(composite, "Screen Orientation");
            this.mOrientation = new Combo((Composite)this, 12);
            ScreenOrientationQualifier.ScreenOrientation[] screenOrientationArray2 = screenOrientationArray = ScreenOrientationQualifier.ScreenOrientation.values();
            int n = screenOrientationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScreenOrientationQualifier.ScreenOrientation screenOrientation = screenOrientationArray2[n2];
                this.mOrientation.add(screenOrientation.getDisplayValue());
                ++n2;
            }
            this.mOrientation.setLayoutData((Object)new GridData(768));
            this.mOrientation.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    OrientationEdit.this.onOrientationChange();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    OrientationEdit.this.onOrientationChange();
                }
            });
        }

        protected void onOrientationChange() {
            int n = this.mOrientation.getSelectionIndex();
            if (n != -1) {
                ConfigurationSelector.this.mSelectedConfiguration.setScreenOrientationQualifier(new ScreenOrientationQualifier(ScreenOrientationQualifier.ScreenOrientation.getByIndex(n)));
            } else {
                ConfigurationSelector.this.mSelectedConfiguration.setScreenOrientationQualifier(new ScreenOrientationQualifier());
            }
            ConfigurationSelector.this.onChange(true);
        }

        public void setQualifier(ResourceQualifier resourceQualifier) {
            ScreenOrientationQualifier screenOrientationQualifier = (ScreenOrientationQualifier)resourceQualifier;
            ScreenOrientationQualifier.ScreenOrientation screenOrientation = screenOrientationQualifier.getValue();
            if (screenOrientation == null) {
                this.mOrientation.clearSelection();
            } else {
                this.mOrientation.select(ScreenOrientationQualifier.ScreenOrientation.getIndex(screenOrientation));
            }
        }
    }

    private class PixelDensityEdit
    extends QualifierEditBase {
        private Combo mDensity;

        public PixelDensityEdit(Composite composite) {
            PixelDensityQualifier.Density[] densityArray;
            super(composite, "Pixel Density");
            this.mDensity = new Combo((Composite)this, 12);
            PixelDensityQualifier.Density[] densityArray2 = densityArray = PixelDensityQualifier.Density.values();
            int n = densityArray.length;
            int n2 = 0;
            while (n2 < n) {
                PixelDensityQualifier.Density density = densityArray2[n2];
                this.mDensity.add(density.getDisplayValue());
                ++n2;
            }
            this.mDensity.setLayoutData((Object)new GridData(768));
            this.mDensity.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    PixelDensityEdit.this.onDensityChange();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PixelDensityEdit.this.onDensityChange();
                }
            });
        }

        private void onDensityChange() {
            int n = this.mDensity.getSelectionIndex();
            if (n != -1) {
                ConfigurationSelector.this.mSelectedConfiguration.setPixelDensityQualifier(new PixelDensityQualifier(PixelDensityQualifier.Density.getByIndex(n)));
            } else {
                ConfigurationSelector.this.mSelectedConfiguration.setPixelDensityQualifier(new PixelDensityQualifier());
            }
            ConfigurationSelector.this.onChange(true);
        }

        public void setQualifier(ResourceQualifier resourceQualifier) {
            PixelDensityQualifier pixelDensityQualifier = (PixelDensityQualifier)resourceQualifier;
            PixelDensityQualifier.Density density = pixelDensityQualifier.getValue();
            if (density == null) {
                this.mDensity.clearSelection();
            } else {
                this.mDensity.select(PixelDensityQualifier.Density.getIndex(density));
            }
        }
    }

    private static class QualifierContentProvider
    implements IStructuredContentProvider {
        private FolderConfiguration mInput;

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return this.mInput.getQualifiers();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.mInput = null;
            if (object2 instanceof FolderConfiguration) {
                this.mInput = (FolderConfiguration)object2;
            }
        }
    }

    private static abstract class QualifierEditBase
    extends Composite {
        public QualifierEditBase(Composite composite, String string) {
            super(composite, 0);
            this.setLayout((Layout)new GridLayout(1, false));
            new Label((Composite)this, 0).setText(string);
        }

        public abstract void setQualifier(ResourceQualifier var1);
    }

    private static class QualifierLabelProvider
    implements ITableLabelProvider {
        private final boolean mShowQualifierValue;

        public QualifierLabelProvider(boolean bl) {
            this.mShowQualifierValue = bl;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof ResourceQualifier) {
                if (this.mShowQualifierValue) {
                    String string = ((ResourceQualifier)object).getStringValue();
                    if (string.length() == 0) {
                        return String.format("%1$s (?)", ((ResourceQualifier)object).getShortName());
                    }
                    return string;
                }
                return ((ResourceQualifier)object).getShortName();
            }
            return null;
        }

        public Image getColumnImage(Object object, int n) {
            if (object instanceof ResourceQualifier) {
                return ((ResourceQualifier)object).getIcon();
            }
            return null;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }

    private class RegionEdit
    extends QualifierEditBase {
        private Combo mRegion;

        public RegionEdit(Composite composite) {
            super(composite, "Region");
            this.mRegion = new Combo((Composite)this, 4);
            this.mRegion.setLayoutData((Object)new GridData(768));
            this.mRegion.addVerifyListener((VerifyListener)new LanguageRegionVerifier());
            this.mRegion.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    RegionEdit.this.onRegionChange();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RegionEdit.this.onRegionChange();
                }
            });
            this.mRegion.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    RegionEdit.this.onRegionChange();
                }
            });
            new Label((Composite)this, 0).setText("(2 letter code)");
        }

        private void onRegionChange() {
            String string = this.mRegion.getText();
            if (string.length() == 0) {
                ConfigurationSelector.this.mSelectedConfiguration.setRegionQualifier(new RegionQualifier());
            } else {
                RegionQualifier regionQualifier = null;
                String string2 = RegionQualifier.getFolderSegment(string);
                if (string2 != null) {
                    regionQualifier = RegionQualifier.getQualifier(string2);
                }
                if (regionQualifier != null) {
                    ConfigurationSelector.this.mSelectedConfiguration.setRegionQualifier(regionQualifier);
                } else {
                    ConfigurationSelector.this.mSelectedConfiguration.setRegionQualifier(new RegionQualifier());
                }
            }
            ConfigurationSelector.this.onChange(true);
        }

        public void setQualifier(ResourceQualifier resourceQualifier) {
            RegionQualifier regionQualifier = (RegionQualifier)resourceQualifier;
            String string = regionQualifier.getValue();
            if (string != null) {
                this.mRegion.setText(regionQualifier.getValue());
            }
        }
    }

    private class ScreenDimensionEdit
    extends QualifierEditBase {
        private Text mSize1;
        private Text mSize2;

        public ScreenDimensionEdit(Composite composite) {
            super(composite, "Screen Dimension");
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    ScreenDimensionEdit.this.onSizeChange();
                }
            };
            FocusAdapter focusAdapter = new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    ScreenDimensionEdit.this.onSizeChange();
                }
            };
            this.mSize1 = new Text((Composite)this, 2048);
            this.mSize1.addVerifyListener((VerifyListener)new DimensionVerifier());
            this.mSize1.addModifyListener(modifyListener);
            this.mSize1.addFocusListener((FocusListener)focusAdapter);
            this.mSize2 = new Text((Composite)this, 2048);
            this.mSize2.addVerifyListener((VerifyListener)new DimensionVerifier());
            this.mSize2.addModifyListener(modifyListener);
            this.mSize2.addFocusListener((FocusListener)focusAdapter);
        }

        private void onSizeChange() {
            String string = this.mSize1.getText();
            String string2 = this.mSize2.getText();
            if (string.length() == 0 || string2.length() == 0) {
                ConfigurationSelector.this.mSelectedConfiguration.setScreenDimensionQualifier(new ScreenDimensionQualifier());
            } else {
                ScreenDimensionQualifier screenDimensionQualifier = ScreenDimensionQualifier.getQualifier(string, string2);
                if (screenDimensionQualifier != null) {
                    ConfigurationSelector.this.mSelectedConfiguration.setScreenDimensionQualifier(screenDimensionQualifier);
                } else {
                    ConfigurationSelector.this.mSelectedConfiguration.setScreenDimensionQualifier(new ScreenDimensionQualifier());
                }
            }
            ConfigurationSelector.this.onChange(true);
        }

        public void setQualifier(ResourceQualifier resourceQualifier) {
            ScreenDimensionQualifier screenDimensionQualifier = (ScreenDimensionQualifier)resourceQualifier;
            this.mSize1.setText(Integer.toString(screenDimensionQualifier.getValue1()));
            this.mSize2.setText(Integer.toString(screenDimensionQualifier.getValue2()));
        }
    }

    private class ScreenRatioEdit
    extends QualifierEditBase {
        private Combo mSize;

        public ScreenRatioEdit(Composite composite) {
            ScreenRatioQualifier.ScreenRatio[] screenRatioArray;
            super(composite, "Screen Ratio");
            this.mSize = new Combo((Composite)this, 12);
            ScreenRatioQualifier.ScreenRatio[] screenRatioArray2 = screenRatioArray = ScreenRatioQualifier.ScreenRatio.values();
            int n = screenRatioArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScreenRatioQualifier.ScreenRatio screenRatio = screenRatioArray2[n2];
                this.mSize.add(screenRatio.getDisplayValue());
                ++n2;
            }
            this.mSize.setLayoutData((Object)new GridData(768));
            this.mSize.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    ScreenRatioEdit.this.onScreenRatioChange();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ScreenRatioEdit.this.onScreenRatioChange();
                }
            });
        }

        protected void onScreenRatioChange() {
            int n = this.mSize.getSelectionIndex();
            if (n != -1) {
                ConfigurationSelector.this.mSelectedConfiguration.setScreenRatioQualifier(new ScreenRatioQualifier(ScreenRatioQualifier.ScreenRatio.getByIndex(n)));
            } else {
                ConfigurationSelector.this.mSelectedConfiguration.setScreenRatioQualifier(new ScreenRatioQualifier());
            }
            ConfigurationSelector.this.onChange(true);
        }

        public void setQualifier(ResourceQualifier resourceQualifier) {
            ScreenRatioQualifier screenRatioQualifier = (ScreenRatioQualifier)resourceQualifier;
            ScreenRatioQualifier.ScreenRatio screenRatio = screenRatioQualifier.getValue();
            if (screenRatio == null) {
                this.mSize.clearSelection();
            } else {
                this.mSize.select(ScreenRatioQualifier.ScreenRatio.getIndex(screenRatio));
            }
        }
    }

    private class ScreenSizeEdit
    extends QualifierEditBase {
        private Combo mSize;

        public ScreenSizeEdit(Composite composite) {
            ScreenSizeQualifier.ScreenSize[] screenSizeArray;
            super(composite, "Screen Size");
            this.mSize = new Combo((Composite)this, 12);
            ScreenSizeQualifier.ScreenSize[] screenSizeArray2 = screenSizeArray = ScreenSizeQualifier.ScreenSize.values();
            int n = screenSizeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScreenSizeQualifier.ScreenSize screenSize = screenSizeArray2[n2];
                this.mSize.add(screenSize.getDisplayValue());
                ++n2;
            }
            this.mSize.setLayoutData((Object)new GridData(768));
            this.mSize.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    ScreenSizeEdit.this.onScreenSizeChange();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ScreenSizeEdit.this.onScreenSizeChange();
                }
            });
        }

        protected void onScreenSizeChange() {
            int n = this.mSize.getSelectionIndex();
            if (n != -1) {
                ConfigurationSelector.this.mSelectedConfiguration.setScreenSizeQualifier(new ScreenSizeQualifier(ScreenSizeQualifier.ScreenSize.getByIndex(n)));
            } else {
                ConfigurationSelector.this.mSelectedConfiguration.setScreenSizeQualifier(new ScreenSizeQualifier());
            }
            ConfigurationSelector.this.onChange(true);
        }

        public void setQualifier(ResourceQualifier resourceQualifier) {
            ScreenSizeQualifier screenSizeQualifier = (ScreenSizeQualifier)resourceQualifier;
            ScreenSizeQualifier.ScreenSize screenSize = screenSizeQualifier.getValue();
            if (screenSize == null) {
                this.mSize.clearSelection();
            } else {
                this.mSize.select(ScreenSizeQualifier.ScreenSize.getIndex(screenSize));
            }
        }
    }

    private class TextInputEdit
    extends QualifierEditBase {
        private Combo mTextInput;

        public TextInputEdit(Composite composite) {
            TextInputMethodQualifier.TextInputMethod[] textInputMethodArray;
            super(composite, "Text Input Method");
            this.mTextInput = new Combo((Composite)this, 12);
            TextInputMethodQualifier.TextInputMethod[] textInputMethodArray2 = textInputMethodArray = TextInputMethodQualifier.TextInputMethod.values();
            int n = textInputMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextInputMethodQualifier.TextInputMethod textInputMethod = textInputMethodArray2[n2];
                this.mTextInput.add(textInputMethod.getDisplayValue());
                ++n2;
            }
            this.mTextInput.setLayoutData((Object)new GridData(768));
            this.mTextInput.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    TextInputEdit.this.onTextInputChange();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TextInputEdit.this.onTextInputChange();
                }
            });
        }

        protected void onTextInputChange() {
            int n = this.mTextInput.getSelectionIndex();
            if (n != -1) {
                ConfigurationSelector.this.mSelectedConfiguration.setTextInputMethodQualifier(new TextInputMethodQualifier(TextInputMethodQualifier.TextInputMethod.getByIndex(n)));
            } else {
                ConfigurationSelector.this.mSelectedConfiguration.setTextInputMethodQualifier(new TextInputMethodQualifier());
            }
            ConfigurationSelector.this.onChange(true);
        }

        public void setQualifier(ResourceQualifier resourceQualifier) {
            TextInputMethodQualifier textInputMethodQualifier = (TextInputMethodQualifier)resourceQualifier;
            TextInputMethodQualifier.TextInputMethod textInputMethod = textInputMethodQualifier.getValue();
            if (textInputMethod == null) {
                this.mTextInput.clearSelection();
            } else {
                this.mTextInput.select(TextInputMethodQualifier.TextInputMethod.getIndex(textInputMethod));
            }
        }
    }

    private class TouchEdit
    extends QualifierEditBase {
        private Combo mTouchScreen;

        public TouchEdit(Composite composite) {
            TouchScreenQualifier.TouchScreenType[] touchScreenTypeArray;
            super(composite, "Touch Screen");
            this.mTouchScreen = new Combo((Composite)this, 12);
            TouchScreenQualifier.TouchScreenType[] touchScreenTypeArray2 = touchScreenTypeArray = TouchScreenQualifier.TouchScreenType.values();
            int n = touchScreenTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TouchScreenQualifier.TouchScreenType touchScreenType = touchScreenTypeArray2[n2];
                this.mTouchScreen.add(touchScreenType.getDisplayValue());
                ++n2;
            }
            this.mTouchScreen.setLayoutData((Object)new GridData(768));
            this.mTouchScreen.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    TouchEdit.this.onTouchChange();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TouchEdit.this.onTouchChange();
                }
            });
        }

        protected void onTouchChange() {
            int n = this.mTouchScreen.getSelectionIndex();
            if (n != -1) {
                ConfigurationSelector.this.mSelectedConfiguration.setTouchTypeQualifier(new TouchScreenQualifier(TouchScreenQualifier.TouchScreenType.getByIndex(n)));
            } else {
                ConfigurationSelector.this.mSelectedConfiguration.setTouchTypeQualifier(new TouchScreenQualifier());
            }
            ConfigurationSelector.this.onChange(true);
        }

        public void setQualifier(ResourceQualifier resourceQualifier) {
            TouchScreenQualifier touchScreenQualifier = (TouchScreenQualifier)resourceQualifier;
            TouchScreenQualifier.TouchScreenType touchScreenType = touchScreenQualifier.getValue();
            if (touchScreenType == null) {
                this.mTouchScreen.clearSelection();
            } else {
                this.mTouchScreen.select(TouchScreenQualifier.TouchScreenType.getIndex(touchScreenType));
            }
        }
    }

    private class VersionEdit
    extends QualifierEditBase {
        private Text mText;

        public VersionEdit(Composite composite) {
            super(composite, "Platform Version");
            this.mText = new Text((Composite)this, 2048);
            this.mText.addVerifyListener((VerifyListener)new MobileCodeVerifier());
            this.mText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    VersionEdit.this.onVersionChange();
                }
            });
            this.mText.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    VersionEdit.this.onVersionChange();
                }
            });
            new Label((Composite)this, 0).setText("(Platform API level)");
        }

        private void onVersionChange() {
            String string = this.mText.getText();
            if (string.length() == 0) {
                ConfigurationSelector.this.mSelectedConfiguration.setVersionQualifier(new VersionQualifier());
            } else {
                try {
                    VersionQualifier versionQualifier = VersionQualifier.getQualifier(VersionQualifier.getFolderSegment(Integer.parseInt(string)));
                    if (versionQualifier != null) {
                        ConfigurationSelector.this.mSelectedConfiguration.setVersionQualifier(versionQualifier);
                    } else {
                        ConfigurationSelector.this.mSelectedConfiguration.setVersionQualifier(new VersionQualifier());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    ConfigurationSelector.this.mSelectedConfiguration.setVersionQualifier(new VersionQualifier());
                }
            }
            ConfigurationSelector.this.onChange(true);
        }

        public void setQualifier(ResourceQualifier resourceQualifier) {
            VersionQualifier versionQualifier = (VersionQualifier)resourceQualifier;
            this.mText.setText(Integer.toString(versionQualifier.getVersion()));
        }
    }
}

