/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.sdk;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.resources.AttrsXmlParser;
import com.android.ide.eclipse.adt.internal.resources.ViewClassInfo;
import com.android.ide.eclipse.adt.internal.sdk.IAndroidClassLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.InvalidAttributeValueException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutParamsParser {
    protected IAndroidClassLoader.IClassDescriptor mTopViewClass;
    protected IAndroidClassLoader.IClassDescriptor mTopGroupClass;
    protected IAndroidClassLoader.IClassDescriptor mTopLayoutParamsClass;
    protected ArrayList<IAndroidClassLoader.IClassDescriptor> mViewList;
    protected ArrayList<IAndroidClassLoader.IClassDescriptor> mGroupList;
    protected TreeMap<String, ExtViewClassInfo> mViewMap;
    protected TreeMap<String, ExtViewClassInfo> mGroupMap;
    protected HashMap<String, ViewClassInfo.LayoutParamsInfo> mLayoutParamsMap;
    protected AttrsXmlParser mAttrsXmlParser;
    protected IAndroidClassLoader mClassLoader;

    public LayoutParamsParser(IAndroidClassLoader iAndroidClassLoader, AttrsXmlParser attrsXmlParser) {
        this.mClassLoader = iAndroidClassLoader;
        this.mAttrsXmlParser = attrsXmlParser;
    }

    public List<ViewClassInfo> getViews() {
        return this.getInstantiables(this.mViewMap);
    }

    public List<ViewClassInfo> getGroups() {
        return this.getInstantiables(this.mGroupMap);
    }

    public void parseLayoutClasses(IProgressMonitor iProgressMonitor) {
        this.parseClasses(iProgressMonitor, "android.view.View", "android.view.ViewGroup", "android.view.ViewGroup$LayoutParams");
    }

    public void parsePreferencesClasses(IProgressMonitor iProgressMonitor) {
        this.parseClasses(iProgressMonitor, "android.preference.Preference", "android.preference.PreferenceGroup", null);
    }

    private void parseClasses(IProgressMonitor iProgressMonitor, String string, String string2, String string3) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            String[] stringArray = new String[2 + (string3 == null ? 0 : 1)];
            stringArray[0] = string2;
            stringArray[1] = string;
            if (string3 != null) {
                stringArray[2] = string3;
            }
            HashMap<String, ArrayList<IAndroidClassLoader.IClassDescriptor>> hashMap = this.mClassLoader.findClassesDerivingFrom("android.", stringArray);
            this.mTopViewClass = this.mClassLoader.getClass(string);
            this.mTopGroupClass = this.mClassLoader.getClass(string2);
            if (string3 != null) {
                this.mTopLayoutParamsClass = this.mClassLoader.getClass(string3);
            }
            this.mViewList = hashMap.get(string);
            this.mGroupList = hashMap.get(string2);
            this.mViewMap = new TreeMap();
            this.mGroupMap = new TreeMap();
            if (this.mTopLayoutParamsClass != null) {
                this.mLayoutParamsMap = new HashMap();
            }
            this.addGroup(this.mTopGroupClass);
            this.addView(this.mTopViewClass);
            this.mGroupMap.get(string2).setSuperClass(this.mViewMap.get(string));
            subMonitor.setWorkRemaining(this.mGroupList.size() + this.mViewList.size());
            for (IAndroidClassLoader.IClassDescriptor iClassDescriptor : this.mGroupList) {
                this.addGroup(iClassDescriptor);
                subMonitor.worked(1);
            }
            for (IAndroidClassLoader.IClassDescriptor iClassDescriptor : this.mViewList) {
                if (iClassDescriptor != this.mTopGroupClass) {
                    this.addView(iClassDescriptor);
                }
                subMonitor.worked(1);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AdtPlugin.log(classNotFoundException, "Problem loading class %1$s or %2$s", string, string2);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            AdtPlugin.log(invalidAttributeValueException, "Problem loading classes", new Object[0]);
        }
        catch (ClassFormatError classFormatError) {
            AdtPlugin.log(classFormatError, "Problem loading classes", new Object[0]);
        }
        catch (IOException iOException) {
            AdtPlugin.log(iOException, "Problem loading classes", new Object[0]);
        }
    }

    private ExtViewClassInfo addView(IAndroidClassLoader.IClassDescriptor iClassDescriptor) {
        String string = iClassDescriptor.getCanonicalName();
        if (this.mViewMap.containsKey(string)) {
            return this.mViewMap.get(string);
        }
        if (this.mGroupMap.containsKey(string)) {
            return this.mGroupMap.get(string);
        }
        ExtViewClassInfo extViewClassInfo = new ExtViewClassInfo(iClassDescriptor.isInstantiable(), false, string, iClassDescriptor.getSimpleName());
        this.mViewMap.put(string, extViewClassInfo);
        if (!iClassDescriptor.equals(this.mTopViewClass)) {
            IAndroidClassLoader.IClassDescriptor iClassDescriptor2 = iClassDescriptor.getSuperclass();
            ExtViewClassInfo extViewClassInfo2 = this.addView(iClassDescriptor2);
            extViewClassInfo.setSuperClass(extViewClassInfo2);
        }
        this.mAttrsXmlParser.loadViewAttributes(extViewClassInfo);
        return extViewClassInfo;
    }

    private ExtViewClassInfo addGroup(IAndroidClassLoader.IClassDescriptor iClassDescriptor) {
        ExtViewClassInfo extViewClassInfo;
        String string = iClassDescriptor.getCanonicalName();
        if (this.mGroupMap.containsKey(string)) {
            return this.mGroupMap.get(string);
        }
        ExtViewClassInfo extViewClassInfo2 = new ExtViewClassInfo(iClassDescriptor.isInstantiable(), true, string, iClassDescriptor.getSimpleName());
        this.mGroupMap.put(string, extViewClassInfo2);
        IAndroidClassLoader.IClassDescriptor iClassDescriptor2 = iClassDescriptor.getSuperclass();
        if (iClassDescriptor2 != null && !iClassDescriptor2.equals(this.mTopViewClass) && (extViewClassInfo = this.addGroup(iClassDescriptor2)) != null && extViewClassInfo != extViewClassInfo2) {
            extViewClassInfo2.setSuperClass(extViewClassInfo);
        }
        this.mAttrsXmlParser.loadViewAttributes(extViewClassInfo2);
        if (this.mTopLayoutParamsClass != null) {
            extViewClassInfo2.setLayoutParams(this.addLayoutParams(iClassDescriptor));
        }
        return extViewClassInfo2;
    }

    private ViewClassInfo.LayoutParamsInfo addLayoutParams(IAndroidClassLoader.IClassDescriptor iClassDescriptor) {
        IAndroidClassLoader.IClassDescriptor iClassDescriptor2 = this.findLayoutParams(iClassDescriptor);
        if (iClassDescriptor2 == null) {
            IAndroidClassLoader.IClassDescriptor iClassDescriptor3 = iClassDescriptor.getSuperclass();
            while (iClassDescriptor2 == null && iClassDescriptor3 != null && !iClassDescriptor3.equals(this.mTopViewClass)) {
                iClassDescriptor2 = this.findLayoutParams(iClassDescriptor3);
                iClassDescriptor3 = iClassDescriptor3.getSuperclass();
            }
        }
        if (iClassDescriptor2 != null) {
            return this.getLayoutParamsInfo(iClassDescriptor2);
        }
        return null;
    }

    private ViewClassInfo.LayoutParamsInfo getLayoutParamsInfo(IAndroidClassLoader.IClassDescriptor iClassDescriptor) {
        Object object;
        String string = iClassDescriptor.getCanonicalName();
        ViewClassInfo.LayoutParamsInfo layoutParamsInfo = this.mLayoutParamsMap.get(string);
        if (layoutParamsInfo != null) {
            return layoutParamsInfo;
        }
        ViewClassInfo.LayoutParamsInfo layoutParamsInfo2 = null;
        if (!iClassDescriptor.equals(this.mTopLayoutParamsClass)) {
            object = iClassDescriptor.getSuperclass();
            layoutParamsInfo2 = this.getLayoutParamsInfo((IAndroidClassLoader.IClassDescriptor)object);
        }
        object = this.addGroup(iClassDescriptor.getEnclosingClass());
        layoutParamsInfo = new ViewClassInfo.LayoutParamsInfo((ViewClassInfo)object, iClassDescriptor.getSimpleName(), layoutParamsInfo2);
        this.mLayoutParamsMap.put(string, layoutParamsInfo);
        this.mAttrsXmlParser.loadLayoutParamsAttributes(layoutParamsInfo);
        return layoutParamsInfo;
    }

    private IAndroidClassLoader.IClassDescriptor findLayoutParams(IAndroidClassLoader.IClassDescriptor iClassDescriptor) {
        IAndroidClassLoader.IClassDescriptor[] iClassDescriptorArray;
        IAndroidClassLoader.IClassDescriptor[] iClassDescriptorArray2 = iClassDescriptorArray = iClassDescriptor.getDeclaredClasses();
        int n = iClassDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAndroidClassLoader.IClassDescriptor iClassDescriptor2 = iClassDescriptorArray2[n2];
            if (iClassDescriptor2.getSimpleName().equals("LayoutParams")) {
                return iClassDescriptor2;
            }
            ++n2;
        }
        return null;
    }

    private List<ViewClassInfo> getInstantiables(SortedMap<String, ExtViewClassInfo> sortedMap) {
        Collection<ExtViewClassInfo> collection = sortedMap.values();
        ArrayList<ViewClassInfo> arrayList = new ArrayList<ViewClassInfo>();
        for (ExtViewClassInfo extViewClassInfo : collection) {
            if (!extViewClassInfo.isInstantiable()) continue;
            arrayList.add(extViewClassInfo);
        }
        return arrayList;
    }

    static final class ExtViewClassInfo
    extends ViewClassInfo {
        private boolean mIsInstantiable;

        ExtViewClassInfo(boolean bl, boolean bl2, String string, String string2) {
            super(bl2, string, string2);
            this.mIsInstantiable = bl;
        }

        boolean isInstantiable() {
            return this.mIsInstantiable;
        }
    }
}

