/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import com.android.ide.eclipse.adt.internal.resources.ResourceType;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.ide.eclipse.adt.internal.resources.manager.CompiledResourcesMonitor;
import com.android.ide.eclipse.adt.internal.resources.manager.FolderTypeRelationship;
import com.android.ide.eclipse.adt.internal.resources.manager.MultiResourceFile;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFile;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolder;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolderType;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceMonitor;
import com.android.ide.eclipse.adt.internal.resources.manager.SingleResourceFile;
import com.android.ide.eclipse.adt.internal.resources.manager.files.FileWrapper;
import com.android.ide.eclipse.adt.internal.resources.manager.files.FolderWrapper;
import com.android.ide.eclipse.adt.internal.resources.manager.files.IAbstractFile;
import com.android.ide.eclipse.adt.internal.resources.manager.files.IAbstractFolder;
import com.android.ide.eclipse.adt.internal.resources.manager.files.IFileWrapper;
import com.android.ide.eclipse.adt.internal.resources.manager.files.IFolderWrapper;
import com.android.sdklib.IAndroidTarget;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public final class ResourceManager
implements ResourceMonitor.IProjectListener,
ResourceMonitor.IFolderListener,
ResourceMonitor.IFileListener {
    private static final ResourceManager sThis = new ResourceManager();
    private final ResourceQualifier[] mQualifiers;
    private final HashMap<IProject, ProjectResources> mMap = new HashMap();

    public static void setup(ResourceMonitor resourceMonitor) {
        resourceMonitor.addProjectListener(sThis);
        int n = 7;
        resourceMonitor.addFolderListener(sThis, n);
        resourceMonitor.addFileListener(sThis, n);
        CompiledResourcesMonitor.setupMonitor(resourceMonitor);
    }

    public static ResourceManager getInstance() {
        return sThis;
    }

    public ProjectResources getProjectResources(IProject iProject) {
        return this.mMap.get(iProject);
    }

    public void folderChanged(IFolder iFolder, int n) {
        IProject iProject = iFolder.getProject();
        try {
            if (!iProject.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                return;
            }
        }
        catch (CoreException coreException) {
            return;
        }
        switch (n) {
            case 1: {
                IPath iPath = iFolder.getFullPath();
                if (iPath.segmentCount() != 3 || !this.isInResFolder(iPath)) break;
                ProjectResources projectResources = this.mMap.get(iProject);
                if (projectResources == null) {
                    projectResources = new ProjectResources(false);
                    this.mMap.put(iProject, projectResources);
                }
                this.processFolder(new IFolderWrapper(iFolder), projectResources);
                break;
            }
            case 4: {
                ResourceFolder resourceFolder;
                ProjectResources projectResources = this.mMap.get(iFolder.getProject());
                if (projectResources == null || (resourceFolder = projectResources.getResourceFolder(iFolder)) == null) break;
                resourceFolder.touch();
                break;
            }
            case 2: {
                ProjectResources projectResources = this.mMap.get(iFolder.getProject());
                if (projectResources == null) break;
                ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType(iFolder.getName());
                projectResources.removeFolder(resourceFolderType, iFolder);
            }
        }
    }

    public void fileChanged(IFile iFile, IMarkerDelta[] iMarkerDeltaArray, int n) {
        IProject iProject = iFile.getProject();
        try {
            if (!iProject.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                return;
            }
        }
        catch (CoreException coreException) {
            return;
        }
        switch (n) {
            case 1: {
                ResourceFolder resourceFolder;
                IPath iPath = iFile.getFullPath();
                if (iPath.segmentCount() != 4 || !this.isInResFolder(iPath)) break;
                ProjectResources projectResources = this.mMap.get(iProject);
                IContainer iContainer = iFile.getParent();
                if (!(iContainer instanceof IFolder) || projectResources == null || (resourceFolder = projectResources.getResourceFolder((IFolder)iContainer)) == null) break;
                this.processFile(new IFileWrapper(iFile), resourceFolder);
                break;
            }
            case 4: {
                ResourceFile resourceFile;
                ResourceFolder resourceFolder;
                IContainer iContainer;
                ProjectResources projectResources = this.mMap.get(iProject);
                if (projectResources == null || !((iContainer = iFile.getParent()) instanceof IFolder) || (resourceFolder = projectResources.getResourceFolder((IFolder)iContainer)) == null || (resourceFile = resourceFolder.getFile(iFile)) == null) break;
                resourceFile.touch();
                break;
            }
            case 2: {
                ResourceFolder resourceFolder;
                IContainer iContainer;
                ProjectResources projectResources = this.mMap.get(iProject);
                if (projectResources == null || !((iContainer = iFile.getParent()) instanceof IFolder) || (resourceFolder = projectResources.getResourceFolder((IFolder)iContainer)) == null) break;
                resourceFolder.removeFile(iFile);
            }
        }
    }

    public void projectClosed(IProject iProject) {
        this.mMap.remove(iProject);
    }

    public void projectDeleted(IProject iProject) {
        this.mMap.remove(iProject);
    }

    public void projectOpened(IProject iProject) {
        this.createProject(iProject);
    }

    public void projectOpenedWithWorkspace(IProject iProject) {
        this.createProject(iProject);
    }

    public ResourceFolder getResourceFolder(IFile iFile) {
        IContainer iContainer = iFile.getParent();
        if (iContainer.getType() == 2) {
            IFolder iFolder = (IFolder)iContainer;
            IProject iProject = iFile.getProject();
            ProjectResources projectResources = this.getProjectResources(iProject);
            if (projectResources != null) {
                return projectResources.getResourceFolder(iFolder);
            }
        }
        return null;
    }

    public ProjectResources loadFrameworkResources(IAndroidTarget iAndroidTarget) {
        String string = iAndroidTarget.getPath(11);
        File file = new File(string);
        if (file.isDirectory()) {
            ProjectResources projectResources = new ProjectResources(true);
            try {
                this.loadResources(projectResources, file);
                return projectResources;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public void loadResources(ProjectResources projectResources, File file) throws IOException {
        File[] fileArray;
        File[] fileArray2 = fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceFolder resourceFolder;
            File file2 = fileArray2[n2];
            if (file2.isDirectory() && (resourceFolder = this.processFolder(new FolderWrapper(file2), projectResources)) != null) {
                File[] fileArray3;
                File[] fileArray4 = fileArray3 = file2.listFiles();
                int n3 = fileArray3.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file3 = fileArray4[n4];
                    if (file3.isFile()) {
                        this.processFile(new FileWrapper(file3), resourceFolder);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        projectResources.loadAll();
    }

    private void createProject(IProject iProject) {
        if (iProject.isOpen()) {
            try {
                if (!iProject.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                    return;
                }
            }
            catch (CoreException coreException) {
                return;
            }
            IFolder iFolder = iProject.getFolder("res");
            ProjectResources projectResources = this.mMap.get(iProject);
            if (projectResources == null) {
                projectResources = new ProjectResources(false);
                this.mMap.put(iProject, projectResources);
            }
            if (iFolder != null && iFolder.exists()) {
                try {
                    IResource[] iResourceArray;
                    IResource[] iResourceArray2 = iResourceArray = iFolder.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFolder iFolder2;
                        ResourceFolder resourceFolder;
                        IResource iResource = iResourceArray2[n2];
                        if (iResource.getType() == 2 && (resourceFolder = this.processFolder(new IFolderWrapper(iFolder2 = (IFolder)iResource), projectResources)) != null) {
                            IResource[] iResourceArray3;
                            IResource[] iResourceArray4 = iResourceArray3 = iFolder2.members();
                            int n3 = iResourceArray3.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResource iResource2 = iResourceArray4[n4];
                                if (iResource2.getType() == 1) {
                                    IFile iFile = (IFile)iResource2;
                                    this.processFile(new IFileWrapper(iFile), resourceFolder);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
    }

    public FolderConfiguration getConfig(String[] stringArray) {
        FolderConfiguration folderConfiguration = new FolderConfiguration();
        int n = 0;
        int n2 = this.mQualifiers.length;
        int n3 = 1;
        while (n3 < stringArray.length) {
            String string = stringArray[n3];
            if (string.length() > 0) {
                while (n < n2 && !this.mQualifiers[n].checkAndSet(string, folderConfiguration)) {
                    ++n;
                }
                if (n == n2) {
                    return null;
                }
            } else {
                return null;
            }
            ++n3;
        }
        return folderConfiguration;
    }

    private ResourceFolder processFolder(IAbstractFolder iAbstractFolder, ProjectResources projectResources) {
        FolderConfiguration folderConfiguration;
        String[] stringArray = iAbstractFolder.getName().split("-");
        ResourceFolderType resourceFolderType = ResourceFolderType.getTypeByName(stringArray[0]);
        if (resourceFolderType != null && (folderConfiguration = this.getConfig(stringArray)) != null) {
            ResourceFolder resourceFolder = projectResources.add(resourceFolderType, folderConfiguration, iAbstractFolder);
            return resourceFolder;
        }
        return null;
    }

    private void processFile(IAbstractFile iAbstractFile, ResourceFolder resourceFolder) {
        ResourceFolderType resourceFolderType = resourceFolder.getType();
        ResourceFile resourceFile = resourceFolder.getFile(iAbstractFile);
        if (resourceFile != null) {
            resourceFile.touch();
        } else {
            ResourceType[] resourceTypeArray = FolderTypeRelationship.getRelatedResourceTypes(resourceFolderType);
            resourceFile = resourceTypeArray.length == 1 ? new SingleResourceFile(iAbstractFile, resourceFolder) : new MultiResourceFile(iAbstractFile, resourceFolder);
            resourceFolder.addFile(resourceFile);
        }
    }

    private boolean isInResFolder(IPath iPath) {
        return "res".equalsIgnoreCase(iPath.segment(1));
    }

    ResourceManager() {
        FolderConfiguration folderConfiguration = new FolderConfiguration();
        folderConfiguration.createDefault();
        this.mQualifiers = folderConfiguration.getQualifiers();
    }
}

