/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.resources.manager.IntArrayWrapper;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectClassLoader;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceMonitor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompiledResourcesMonitor
implements ResourceMonitor.IFileListener,
ResourceMonitor.IProjectListener {
    private static final CompiledResourcesMonitor sThis = new CompiledResourcesMonitor();

    public static void setupMonitor(ResourceMonitor resourceMonitor) {
        resourceMonitor.addFileListener(sThis, 5);
        resourceMonitor.addProjectListener(sThis);
    }

    private CompiledResourcesMonitor() {
    }

    @Override
    public void fileChanged(IFile iFile, IMarkerDelta[] iMarkerDeltaArray, int n) {
        if (iFile.getName().equals("R.class")) {
            this.loadAndParseRClass(iFile.getProject());
        }
    }

    @Override
    public void projectClosed(IProject iProject) {
    }

    @Override
    public void projectDeleted(IProject iProject) {
    }

    @Override
    public void projectOpened(IProject iProject) {
    }

    @Override
    public void projectOpenedWithWorkspace(IProject iProject) {
        try {
            if (iProject.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                this.loadAndParseRClass(iProject);
            }
        }
        catch (CoreException coreException) {}
    }

    private void loadAndParseRClass(IProject iProject) {
        block6: {
            try {
                ProjectResources projectResources = ResourceManager.getInstance().getProjectResources(iProject);
                if (projectResources == null) break block6;
                String string = this.getRClassName(iProject);
                if (string == null) {
                    AdtPlugin.log(4, "loadAndParseRClass: failed to find manifest package for project %1$s", iProject.getName());
                    return;
                }
                ProjectClassLoader projectClassLoader = new ProjectClassLoader(null, iProject);
                try {
                    HashMap<String, Map<String, Integer>> hashMap;
                    HashMap<IntArrayWrapper, String> hashMap2;
                    HashMap<Integer, String[]> hashMap3;
                    Class<?> clazz = projectClassLoader.loadClass(string);
                    if (clazz != null && this.parseClass(clazz, hashMap3 = new HashMap<Integer, String[]>(), hashMap2 = new HashMap<IntArrayWrapper, String>(), hashMap = new HashMap<String, Map<String, Integer>>())) {
                        projectResources.setCompiledResources(hashMap3, hashMap2, hashMap);
                    }
                }
                catch (Error error) {
                    AdtPlugin.log(error, "loadAndParseRClass failed to find class %1$s", string);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    private boolean parseClass(Class<?> clazz, Map<Integer, String[]> map, Map<IntArrayWrapper, String> map2, Map<String, Map<String, Integer>> map3) {
        try {
            Class<?>[] classArray = clazz.getDeclaredClasses();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz2 = classArray[n2];
                String string = clazz2.getSimpleName();
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                map3.put(string, hashMap);
                Field[] fieldArray = clazz2.getDeclaredFields();
                int n3 = fieldArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Field field = fieldArray[n4];
                    int n5 = field.getModifiers();
                    if (Modifier.isStatic(n5) && Modifier.isFinal(n5)) {
                        Class<?> clazz3 = field.getType();
                        if (clazz3.isArray() && clazz3.getComponentType() == Integer.TYPE) {
                            map2.put(new IntArrayWrapper((int[])field.get(null)), field.getName());
                        } else if (clazz3 == Integer.TYPE) {
                            Integer n6 = (Integer)field.get(null);
                            map.put(n6, new String[]{field.getName(), string});
                            hashMap.put(field.getName(), n6);
                        } else assert (false);
                    }
                    ++n4;
                }
                ++n2;
            }
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return false;
    }

    private String getRClassName(IProject iProject) {
        try {
            AndroidManifestParser androidManifestParser;
            IFile iFile = AndroidManifestParser.getManifest(iProject);
            if (iFile != null && iFile.isSynchronized(0) && (androidManifestParser = AndroidManifestParser.parseForData(iFile)) != null) {
                String string = androidManifestParser.getPackage();
                return String.valueOf(string) + ".R";
            }
        }
        catch (CoreException coreException) {
            AdtPlugin.logAndPrintError(coreException, "Android Resources", "Failed to find the package of the AndroidManifest of project %1$s. Reason: %2$s", iProject.getName(), coreException.getMessage());
        }
        return null;
    }
}

