/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.sdklib.IAndroidTarget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Image;

public final class ScreenDimensionQualifier
extends ResourceQualifier {
    static final int DEFAULT_SIZE = -1;
    private static final Pattern sDimensionPattern = Pattern.compile("^(\\d+)x(\\d+)$");
    public static final String NAME = "Screen Dimension";
    private int mValue1 = -1;
    private int mValue2 = -1;

    public int getValue1() {
        return this.mValue1;
    }

    public int getValue2() {
        return this.mValue2;
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return "Dimension";
    }

    public Image getIcon() {
        return IconFactory.getInstance().getIcon("dimension");
    }

    public boolean isValid() {
        return this.mValue1 != -1 && this.mValue2 != -1;
    }

    public boolean checkAndSet(String string, FolderConfiguration folderConfiguration) {
        String string2;
        String string3;
        ScreenDimensionQualifier screenDimensionQualifier;
        Matcher matcher = sDimensionPattern.matcher(string);
        if (matcher.matches() && (screenDimensionQualifier = ScreenDimensionQualifier.getQualifier(string3 = matcher.group(1), string2 = matcher.group(2))) != null) {
            folderConfiguration.setScreenDimensionQualifier(screenDimensionQualifier);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof ScreenDimensionQualifier) {
            ScreenDimensionQualifier screenDimensionQualifier = (ScreenDimensionQualifier)object;
            return this.mValue1 == screenDimensionQualifier.mValue1 && this.mValue2 == screenDimensionQualifier.mValue2;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static ScreenDimensionQualifier getQualifier(String string, String string2) {
        try {
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            ScreenDimensionQualifier screenDimensionQualifier = new ScreenDimensionQualifier();
            if (n > n2) {
                screenDimensionQualifier.mValue1 = n;
                screenDimensionQualifier.mValue2 = n2;
            } else {
                screenDimensionQualifier.mValue1 = n2;
                screenDimensionQualifier.mValue2 = n;
            }
            return screenDimensionQualifier;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getFolderSegment(IAndroidTarget iAndroidTarget) {
        return String.format("%1$dx%2$d", this.mValue1, this.mValue2);
    }

    public String getStringValue() {
        if (this.mValue1 != -1 && this.mValue2 != -1) {
            return String.format("%1$dx%2$d", this.mValue1, this.mValue2);
        }
        return "";
    }
}

