/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.sdklib.IAndroidTarget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Image;

public final class RegionQualifier
extends ResourceQualifier {
    private static final Pattern sRegionPattern = Pattern.compile("^r([A-Z]{2})$");
    public static final String NAME = "Region";
    private String mValue;

    public static RegionQualifier getQualifier(String string) {
        Matcher matcher = sRegionPattern.matcher(string);
        if (matcher.matches()) {
            RegionQualifier regionQualifier = new RegionQualifier();
            regionQualifier.mValue = matcher.group(1);
            return regionQualifier;
        }
        return null;
    }

    public static String getFolderSegment(String string) {
        String string2;
        if (string != null && sRegionPattern.matcher(string2 = "r" + string.toUpperCase()).matches()) {
            return string2;
        }
        return "";
    }

    public String getValue() {
        if (this.mValue != null) {
            return this.mValue;
        }
        return "";
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return NAME;
    }

    public Image getIcon() {
        return IconFactory.getInstance().getIcon("region");
    }

    public boolean isValid() {
        return this.mValue != null;
    }

    public boolean checkAndSet(String string, FolderConfiguration folderConfiguration) {
        RegionQualifier regionQualifier = RegionQualifier.getQualifier(string);
        if (regionQualifier != null) {
            folderConfiguration.setRegionQualifier(regionQualifier);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof RegionQualifier) {
            if (this.mValue == null) {
                return ((RegionQualifier)object).mValue == null;
            }
            return this.mValue.equals(((RegionQualifier)object).mValue);
        }
        return false;
    }

    public int hashCode() {
        if (this.mValue != null) {
            return this.mValue.hashCode();
        }
        return 0;
    }

    public String getFolderSegment(IAndroidTarget iAndroidTarget) {
        return RegionQualifier.getFolderSegment(this.mValue);
    }

    public String getStringValue() {
        if (this.mValue != null) {
            return this.mValue;
        }
        return "";
    }
}

