/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.sdklib.IAndroidTarget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Image;

public final class CountryCodeQualifier
extends ResourceQualifier {
    private static final int DEFAULT_CODE = -1;
    private static final Pattern sCountryCodePattern = Pattern.compile("^mcc(\\d{3})$");
    private int mCode = -1;
    public static final String NAME = "Mobile Country Code";

    public static CountryCodeQualifier getQualifier(String string) {
        Matcher matcher = sCountryCodePattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            int n = -1;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            CountryCodeQualifier countryCodeQualifier = new CountryCodeQualifier();
            countryCodeQualifier.mCode = n;
            return countryCodeQualifier;
        }
        return null;
    }

    public static String getFolderSegment(int n) {
        if (n != -1 && n >= 100 && n <= 999) {
            return String.format("mcc%1$d", n);
        }
        return "";
    }

    public int getCode() {
        return this.mCode;
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return "Country Code";
    }

    public Image getIcon() {
        return IconFactory.getInstance().getIcon("mcc");
    }

    public boolean isValid() {
        return this.mCode != -1;
    }

    public boolean checkAndSet(String string, FolderConfiguration folderConfiguration) {
        CountryCodeQualifier countryCodeQualifier = CountryCodeQualifier.getQualifier(string);
        if (countryCodeQualifier != null) {
            folderConfiguration.setCountryCodeQualifier(countryCodeQualifier);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof CountryCodeQualifier) {
            return this.mCode == ((CountryCodeQualifier)object).mCode;
        }
        return false;
    }

    public int hashCode() {
        return this.mCode;
    }

    public String getFolderSegment(IAndroidTarget iAndroidTarget) {
        return CountryCodeQualifier.getFolderSegment(this.mCode);
    }

    public String getStringValue() {
        if (this.mCode != -1) {
            return String.format("MCC %1$d", this.mCode);
        }
        return "";
    }
}

