/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources;

import com.android.ide.eclipse.adt.internal.resources.IIdResourceItem;
import com.android.ide.eclipse.adt.internal.resources.ResourceItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResourceType {
    ANIM("anim", "Animation", new String[0]),
    ARRAY("array", "Array", "string-array", "integer-array"),
    ATTR("attr", "Attr", new String[0]),
    COLOR("color", "Color", new String[0]),
    DIMEN("dimen", "Dimension", new String[0]),
    DRAWABLE("drawable", "Drawable", new String[0]),
    ID("id", "ID", new String[0]),
    LAYOUT("layout", "Layout", new String[0]),
    MENU("menu", "Menu", new String[0]),
    RAW("raw", "Raw", new String[0]),
    STRING("string", "String", new String[0]),
    STYLE("style", "Style", new String[0]),
    STYLEABLE("styleable", "Styleable", new String[0]),
    XML("xml", "XML", new String[0]);

    private final String mName;
    private final String mDisplayName;
    private final String[] mAlternateXmlNames;

    private ResourceType(String string2, String string3, String ... stringArray) {
        this.mName = string2;
        this.mDisplayName = string3;
        this.mAlternateXmlNames = stringArray;
    }

    public String getName() {
        return this.mName;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public static ResourceType getEnum(String string) {
        ResourceType[] resourceTypeArray = ResourceType.values();
        int n = resourceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceType resourceType = resourceTypeArray[n2];
            if (resourceType.mName.equals(string)) {
                return resourceType;
            }
            if (resourceType.mAlternateXmlNames != null) {
                String[] stringArray = resourceType.mAlternateXmlNames;
                int n3 = resourceType.mAlternateXmlNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string2 = stringArray[n4];
                    if (string2.equals(string)) {
                        return resourceType;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public String getXmlString(ResourceItem resourceItem, boolean bl) {
        IIdResourceItem iIdResourceItem;
        if (this == ID && resourceItem instanceof IIdResourceItem && (iIdResourceItem = (IIdResourceItem)((Object)resourceItem)).isDeclaredInline()) {
            return String.valueOf(bl ? "@android:" : "@+") + this.mName + "/" + resourceItem.getName();
        }
        return String.valueOf(bl ? "@android:" : "@") + this.mName + "/" + resourceItem.getName();
    }

    public static String[] getNames() {
        ResourceType[] resourceTypeArray = ResourceType.values();
        String[] stringArray = new String[resourceTypeArray.length];
        int n = resourceTypeArray.length - 1;
        while (n >= 0) {
            stringArray[n] = resourceTypeArray[n].getName();
            --n;
        }
        return stringArray;
    }
}

