/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.project.XmlErrorHandler;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenJavaPerspectiveAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BaseProjectHelper {
    public static final String TEST_CLASS_OK = null;

    public static ArrayList<IPath> getSourceClasspaths(IJavaProject iJavaProject) {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.readRawClasspath();
        if (iClasspathEntryArray != null) {
            IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray;
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n2];
                if (iClasspathEntry.getEntryKind() == 3) {
                    arrayList.add(iClasspathEntry.getPath());
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public static final IMarker addMarker(IResource iResource, String string, String string2, int n, int n2) {
        try {
            IMarker iMarker = iResource.createMarker(string);
            iMarker.setAttribute("message", (Object)string2);
            iMarker.setAttribute("severity", n2);
            if (n < 1) {
                n = 1;
            }
            iMarker.setAttribute("lineNumber", n);
            iResource.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            return iMarker;
        }
        catch (CoreException coreException) {
            AdtPlugin.log(coreException, "Failed to add marker '%1$s' to '%2$s'", string, iResource.getFullPath());
            return null;
        }
    }

    public static final IMarker addMarker(IResource iResource, String string, String string2, int n) {
        try {
            IMarker iMarker = iResource.createMarker(string);
            iMarker.setAttribute("message", (Object)string2);
            iMarker.setAttribute("severity", n);
            iResource.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            return iMarker;
        }
        catch (CoreException coreException) {
            AdtPlugin.log(coreException, "Failed to add marker '%1$s' to '%2$s'", string, iResource.getFullPath());
            return null;
        }
    }

    public static final IMarker addMarker(IResource iResource, String string, String string2, int n, int n2, int n3) throws CoreException {
        IMarker iMarker = iResource.createMarker(string);
        iMarker.setAttribute("message", (Object)string2);
        iMarker.setAttribute("severity", n2);
        if (n != -1) {
            iMarker.setAttribute("lineNumber", n);
        }
        iMarker.setAttribute("priority", n3);
        iResource.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        return iMarker;
    }

    public static final String testClassForManifest(IJavaProject iJavaProject, String string, String string2, boolean bl) {
        try {
            String string3 = string.replaceAll("\\$", "\\.");
            IType iType = iJavaProject.findType(string3);
            if (iType != null && iType.exists()) {
                IType iType2;
                IType iType3;
                int n = iType.getFlags();
                if (Flags.isAbstract((int)n)) {
                    return String.format("%1$s is abstract", string);
                }
                if (bl && !Flags.isPublic((int)n)) {
                    iType3 = iType.getMethod(iType.getElementName(), new String[0]);
                    if (iType3 != null && iType3.exists()) {
                        int n2 = iType3.getFlags();
                        if (!Flags.isPublic((int)n2)) {
                            return String.format("%1$s or its default constructor must be public for the system to be able to instantiate it", string);
                        }
                    } else {
                        return String.format("%1$s must be public, or the system will not be able to instantiate it.", string);
                    }
                }
                iType3 = iType;
                do {
                    if ((iType2 = iType3.getDeclaringType()) == null) continue;
                    if (iType2.exists()) {
                        n = iType3.getFlags();
                        if (!Flags.isStatic((int)n)) {
                            return String.format("%1$s is enclosed, but not static", iType3.getFullyQualifiedName());
                        }
                        n = iType2.getFlags();
                        if (!bl || Flags.isPublic((int)n)) continue;
                        return String.format("%1$s is not public", iType2.getFullyQualifiedName());
                    }
                    iType2 = null;
                } while ((iType3 = iType2) != null);
                iType2 = iType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                IType iType4 = iType;
                boolean bl2 = false;
                while ((iType4 = iType2.getSuperclass(iType4)) != null && iType4.exists()) {
                    if (!string2.equals(iType4.getFullyQualifiedName())) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    return String.format("%1$s does not extend %2$s", string, string2);
                }
                return TEST_CLASS_OK;
            }
            return String.format("Class %1$s does not exist", string);
        }
        catch (JavaModelException javaModelException) {
            return String.format("%1$s: %2$s", string, javaModelException.getMessage());
        }
    }

    public static AndroidManifestParser parseManifestForError(IFile iFile, XmlErrorHandler.XmlErrorListener xmlErrorListener) throws CoreException {
        if (iFile.exists()) {
            iFile.deleteMarkers("com.android.ide.eclipse.common.xmlProblem", true, 0);
            iFile.deleteMarkers("com.android.ide.eclipse.common.androidProblem", true, 0);
        }
        return AndroidManifestParser.parseForError(BaseProjectHelper.getJavaProject(iFile.getProject()), iFile, xmlErrorListener);
    }

    public static IJavaProject getJavaProject(IProject iProject) throws CoreException {
        if (iProject != null && iProject.hasNature("org.eclipse.jdt.core.javanature")) {
            return JavaCore.create((IProject)iProject);
        }
        return null;
    }

    public static void revealSource(IProject iProject, String string, int n) {
        string = string.replaceAll("\\$", "\\.");
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        try {
            IType iType = iJavaProject.findType(string);
            if (iType != null && iType.exists()) {
                IEditorPart iEditorPart;
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                if (!iWorkbenchPage.isEditorAreaVisible()) {
                    new OpenJavaPerspectiveAction().run();
                }
                if ((iEditorPart = JavaUI.openInEditor((IJavaElement)iType)) instanceof ITextEditor) {
                    ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                    IEditorInput iEditorInput = iTextEditor.getEditorInput();
                    IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
                    IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
                    IRegion iRegion = iDocument.getLineInformation(n - 1);
                    iTextEditor.selectAndReveal(iRegion.getOffset(), iRegion.getLength());
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (PartInitException partInitException) {
        }
        catch (BadLocationException badLocationException) {}
    }

    public static IJavaProject[] getAndroidProjects() {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel iJavaModel = JavaCore.create((IWorkspaceRoot)iWorkspaceRoot);
        return BaseProjectHelper.getAndroidProjects(iJavaModel);
    }

    public static IJavaProject[] getAndroidProjects(IJavaModel iJavaModel) {
        IJavaProject[] iJavaProjectArray = null;
        try {
            iJavaProjectArray = iJavaModel.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            return new IJavaProject[0];
        }
        ArrayList<IJavaProject> arrayList = new ArrayList<IJavaProject>();
        IJavaProject[] iJavaProjectArray2 = iJavaProjectArray;
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject iJavaProject = iJavaProjectArray2[n2];
            IProject iProject = iJavaProject.getProject();
            try {
                if (iProject.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                    arrayList.add(iJavaProject);
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return arrayList.toArray(new IJavaProject[arrayList.size()]);
    }

    public static final IFolder getOutputFolder(IProject iProject) {
        try {
            if (iProject.isOpen() && iProject.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
                IPath iPath = iJavaProject.getOutputLocation();
                IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IResource iResource = iWorkspaceRoot.findMember(iPath);
                if (iResource != null && iResource.getType() == 2) {
                    return (IFolder)iResource;
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
        return null;
    }
}

