/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.preferences;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.preferences.Messages;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.IAndroidTarget;
import com.android.sdkuilib.internal.widgets.SdkTargetSelector;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AndroidPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private SdkDirectoryFieldEditor mDirectoryField;

    public AndroidPreferencePage() {
        super(1);
        this.setPreferenceStore(AdtPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.AndroidPreferencePage_Title);
    }

    public void createFieldEditors() {
        this.mDirectoryField = new SdkDirectoryFieldEditor("com.android.ide.eclipse.adt.sdk", Messages.AndroidPreferencePage_SDK_Location_, this.getFieldEditorParent());
        this.addField((FieldEditor)this.mDirectoryField);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void dispose() {
        super.dispose();
        if (this.mDirectoryField != null) {
            this.mDirectoryField.dispose();
            this.mDirectoryField = null;
        }
    }

    private static class SdkDirectoryFieldEditor
    extends DirectoryFieldEditor {
        private SdkTargetSelector mTargetSelector;
        private TargetChangedListener mTargetChangeListener;

        public SdkDirectoryFieldEditor(String string, String string2, Composite composite) {
            super(string, string2, composite);
            this.setEmptyStringAllowed(false);
        }

        protected boolean doCheckState() {
            String string = this.getTextControl().getText();
            if ((string = string.trim()).indexOf(44) >= 0 || string.indexOf(59) >= 0) {
                this.setErrorMessage(Messages.AndroidPreferencePage_ERROR_Reserved_Char);
                return false;
            }
            File file = new File(string);
            if (!file.isDirectory()) {
                this.setErrorMessage(JFaceResources.getString((String)"DirectoryFieldEditor.errorMessage"));
                return false;
            }
            boolean bl = AdtPlugin.getDefault().checkSdkLocationAndId(string, new AdtPlugin.CheckSdkErrorHandler(){

                public boolean handleError(String string) {
                    SdkDirectoryFieldEditor.this.setErrorMessage(string.replaceAll("\n", " "));
                    return false;
                }

                public boolean handleWarning(String string) {
                    SdkDirectoryFieldEditor.this.showMessage(string.replaceAll("\n", " "));
                    return true;
                }
            });
            if (bl) {
                this.clearMessage();
            }
            return bl;
        }

        public Text getTextControl(Composite composite) {
            this.setValidateStrategy(0);
            return super.getTextControl(composite);
        }

        protected void doFillIntoGrid(Composite composite, int n) {
            super.doFillIntoGrid(composite, n);
            Label label = new Label(composite, 0);
            label.setText("Note: The list of SDK Targets below is only reloaded once you hit 'Apply' or 'OK'.");
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = n;
            label.setLayoutData((Object)gridData);
            try {
                Sdk sdk = Sdk.getCurrent();
                IAndroidTarget[] iAndroidTargetArray = sdk != null ? sdk.getTargets() : null;
                this.mTargetSelector = new SdkTargetSelector(composite, iAndroidTargetArray, false);
                gridData = (GridData)this.mTargetSelector.getLayoutData();
                gridData.horizontalSpan = n;
                if (this.mTargetChangeListener == null) {
                    this.mTargetChangeListener = new TargetChangedListener();
                    AdtPlugin.getDefault().addTargetListener(this.mTargetChangeListener);
                }
            }
            catch (Exception exception) {
                AdtPlugin.log(exception, "SdkTargetSelector failed", new Object[0]);
            }
        }

        public void dispose() {
            super.dispose();
            if (this.mTargetChangeListener != null) {
                AdtPlugin.getDefault().removeTargetListener(this.mTargetChangeListener);
                this.mTargetChangeListener = null;
            }
        }

        private class TargetChangedListener
        implements Sdk.ITargetChangeListener {
            private TargetChangedListener() {
            }

            public void onProjectTargetChange(IProject iProject) {
            }

            public void onTargetsLoaded() {
                if (SdkDirectoryFieldEditor.this.mTargetSelector != null) {
                    Sdk sdk = Sdk.getCurrent();
                    IAndroidTarget[] iAndroidTargetArray = sdk != null ? sdk.getTargets() : null;
                    SdkDirectoryFieldEditor.this.mTargetSelector.setTargets(iAndroidTargetArray);
                }
            }
        }
    }
}

