/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch.junit.runtime;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ide.eclipse.adt.internal.launch.junit.runtime.TestCaseReference;
import com.android.ide.eclipse.adt.internal.launch.junit.runtime.TestSuiteReference;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.junit.runner.ITestReference;
import org.eclipse.jdt.internal.junit.runner.IVisitsTestTrees;

class TestCollector
implements ITestRunListener {
    private int mTotalTestCount = 0;
    private Map<String, TestSuiteReference> mTestTree = new HashMap<String, TestSuiteReference>();
    private String mErrorMessage = null;

    TestCollector() {
    }

    public void testEnded(TestIdentifier testIdentifier) {
    }

    public void testFailed(ITestRunListener.TestFailure testFailure, TestIdentifier testIdentifier, String string) {
    }

    public void testRunEnded(long l) {
    }

    public void testRunFailed(String string) {
        this.mErrorMessage = string;
    }

    public void testRunStarted(int n) {
        this.mTotalTestCount = n;
    }

    public void testRunStopped(long l) {
    }

    public void testStarted(TestIdentifier testIdentifier) {
        TestSuiteReference testSuiteReference = this.mTestTree.get(testIdentifier.getClassName());
        if (testSuiteReference == null) {
            testSuiteReference = new TestSuiteReference(testIdentifier.getClassName());
            this.mTestTree.put(testIdentifier.getClassName(), testSuiteReference);
        }
        testSuiteReference.addTest(new TestCaseReference(testIdentifier));
    }

    public int getTestCaseCount() {
        return this.mTotalTestCount;
    }

    public void sendTrees(IVisitsTestTrees iVisitsTestTrees) {
        for (ITestReference iTestReference : this.mTestTree.values()) {
            iTestReference.sendTree(iVisitsTestTrees);
        }
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }
}

