/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch.junit;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;

class InstrumentationRunnerValidator {
    private final IJavaProject mJavaProject;
    private String[] mInstrumentationNames = null;
    private boolean mHasRunnerLibrary = false;
    static final String INSTRUMENTATION_OK = null;

    InstrumentationRunnerValidator(IJavaProject iJavaProject) {
        this.mJavaProject = iJavaProject;
        try {
            AndroidManifestParser androidManifestParser = AndroidManifestParser.parse(iJavaProject, null, true, false);
            this.init(androidManifestParser);
        }
        catch (CoreException coreException) {
            AdtPlugin.printErrorToConsole(iJavaProject.getProject(), new Object[]{"ERROR: Failed to parse %1$s", "AndroidManifest.xml"});
        }
    }

    InstrumentationRunnerValidator(IProject iProject) throws CoreException {
        this(BaseProjectHelper.getJavaProject(iProject));
    }

    InstrumentationRunnerValidator(IJavaProject iJavaProject, AndroidManifestParser androidManifestParser) {
        this.mJavaProject = iJavaProject;
        this.init(androidManifestParser);
    }

    private void init(AndroidManifestParser androidManifestParser) {
        AndroidManifestParser.Instrumentation[] instrumentationArray = androidManifestParser.getInstrumentations();
        this.mInstrumentationNames = new String[instrumentationArray.length];
        int n = 0;
        while (n < instrumentationArray.length) {
            this.mInstrumentationNames[n] = instrumentationArray[n].getName();
            ++n;
        }
        this.mHasRunnerLibrary = this.hasTestRunnerLibrary(androidManifestParser);
    }

    private boolean hasTestRunnerLibrary(AndroidManifestParser androidManifestParser) {
        String[] stringArray = androidManifestParser.getUsesLibraries();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.equals("android.test.runner")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    String[] getInstrumentationNames() {
        return this.mInstrumentationNames;
    }

    String getValidInstrumentationTestRunner() {
        String[] stringArray = this.getInstrumentationNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (this.validateInstrumentationRunner(string) == INSTRUMENTATION_OK) {
                return string;
            }
            ++n2;
        }
        return null;
    }

    String validateInstrumentationRunner(String string) {
        String string2;
        if (!this.mHasRunnerLibrary) {
            return String.format("The application does not declare uses-library %1$s", "android.test.runner");
        }
        if (!string.equals("android.test.InstrumentationTestRunner") && (string2 = BaseProjectHelper.testClassForManifest(this.mJavaProject, string, "android.test.InstrumentationTestRunner", true)) != BaseProjectHelper.TEST_CLASS_OK) {
            return String.format("The instrumentation runner must be of type %s", "android.test.InstrumentationTestRunner");
        }
        return INSTRUMENTATION_OK;
    }
}

