/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.uimodel;

import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.FlagAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiTextAttributeNode;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class UiFlagAttributeNode
extends UiTextAttributeNode {
    public UiFlagAttributeNode(FlagAttributeDescriptor flagAttributeDescriptor, UiElementNode uiElementNode) {
        super(flagAttributeDescriptor, uiElementNode);
    }

    public void createUiControl(Composite composite, IManagedForm iManagedForm) {
        this.setManagedForm(iManagedForm);
        FormToolkit formToolkit = iManagedForm.getToolkit();
        TextAttributeDescriptor textAttributeDescriptor = (TextAttributeDescriptor)this.getDescriptor();
        Label label = formToolkit.createLabel(composite, textAttributeDescriptor.getUiName());
        label.setLayoutData((Object)new TableWrapData(2, 32));
        SectionHelper.addControlTooltip((Control)label, DescriptorsUtils.formatTooltip(textAttributeDescriptor.getTooltip()));
        Composite composite2 = formToolkit.createComposite(composite);
        composite2.setLayoutData((Object)new TableWrapData(256, 32));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        formToolkit.paintBordersFor(composite2);
        Text text = formToolkit.createText(composite2, this.getCurrentValue());
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 1;
        text.setLayoutData((Object)gridData);
        final Button button = formToolkit.createButton(composite2, "Select...", 8);
        this.setTextWidget(text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                String string = UiFlagAttributeNode.this.getTextWidgetValue();
                String string2 = UiFlagAttributeNode.this.showDialog(button.getShell(), string);
                if (string2 != null) {
                    UiFlagAttributeNode.this.setTextWidgetValue(string2);
                }
            }
        });
    }

    public String[] getPossibleValues(String string) {
        UiElementNode uiElementNode;
        AndroidEditor androidEditor;
        AndroidTargetData androidTargetData;
        String string2 = this.getDescriptor().getXmlLocalName();
        String string3 = this.getUiParent().getDescriptor().getXmlName();
        String[] stringArray = null;
        if (this.getDescriptor() instanceof FlagAttributeDescriptor && ((FlagAttributeDescriptor)this.getDescriptor()).getNames() != null) {
            stringArray = ((FlagAttributeDescriptor)this.getDescriptor()).getNames();
        }
        if (stringArray == null && (androidTargetData = (androidEditor = (uiElementNode = this.getUiParent()).getEditor()).getTargetData()) != null) {
            stringArray = androidTargetData.getAttributeValues(string3, string2);
        }
        return stringArray;
    }

    public String showDialog(Shell shell, String string) {
        FlagSelectionDialog flagSelectionDialog = new FlagSelectionDialog(shell, string.trim().split("\\s*\\|\\s*"));
        flagSelectionDialog.open();
        Object[] objectArray = flagSelectionDialog.getResult();
        if (objectArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                if (object instanceof String) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("|");
                    }
                    stringBuilder.append(object);
                }
                ++n2;
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private class FlagSelectionDialog
    extends SelectionStatusDialog {
        private Set<String> mCurrentSet;
        private Table mTable;

        public FlagSelectionDialog(Shell shell, String[] stringArray) {
            super(shell);
            this.mCurrentSet = new HashSet<String>();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (string.length() > 0) {
                    this.mCurrentSet.add(string);
                }
                ++n2;
            }
            int n3 = this.getShellStyle();
            this.setShellStyle(n3 | 0x400 | 0x10);
        }

        protected void computeResult() {
            if (this.mTable != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                TableItem[] tableItemArray = this.mTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    if (tableItem.getChecked()) {
                        arrayList.add((String)tableItem.getData());
                    }
                    ++n2;
                }
                this.setResult(arrayList);
            }
        }

        protected Control createDialogArea(Composite composite) {
            TableItem tableItem;
            Object object;
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)new GridData(4, 4, true, true));
            composite2.setLayout((Layout)new GridLayout(1, true));
            composite2.setFont(composite.getFont());
            Label label = new Label(composite2, 0);
            label.setLayoutData((Object)new GridData(4, 4, true, false));
            label.setText(String.format("Select the flag values for attribute %1$s:", ((FlagAttributeDescriptor)UiFlagAttributeNode.this.getDescriptor()).getUiName()));
            this.mTable = new Table(composite2, 2080);
            GridData gridData = new GridData();
            gridData.widthHint = this.convertWidthInCharsToPixels(60);
            gridData.heightHint = this.convertHeightInCharsToPixels(18);
            gridData.grabExcessVerticalSpace = true;
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            this.mTable.setLayoutData((Object)gridData);
            this.mTable.setHeaderVisible(false);
            final TableColumn tableColumn = new TableColumn(this.mTable, 0);
            String[] stringArray = UiFlagAttributeNode.this.getPossibleValues(null);
            if (stringArray != null) {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = stringArray2[n2];
                    tableItem = new TableItem(this.mTable, 0);
                    tableItem.setText((String)object);
                    tableItem.setData(object);
                    boolean bl = this.mCurrentSet.contains(object);
                    tableItem.setChecked(bl);
                    if (bl) {
                        this.mCurrentSet.remove(object);
                    }
                    ++n2;
                }
            }
            if (!this.mCurrentSet.isEmpty()) {
                object = JFaceResources.getDialogFontDescriptor();
                object = object.withStyle(2);
                Font font = object.createFont(JFaceResources.getDialogFont().getDevice());
                for (String string : this.mCurrentSet) {
                    tableItem = new TableItem(this.mTable, 0);
                    tableItem.setText(String.format("%1$s (unknown flag)", string));
                    tableItem.setData((Object)string);
                    tableItem.setChecked(true);
                    tableItem.setFont(font);
                }
            }
            object = new ControlAdapter(){

                public void controlResized(ControlEvent controlEvent) {
                    Rectangle rectangle = FlagSelectionDialog.this.mTable.getClientArea();
                    tableColumn.setWidth(rectangle.width);
                }
            };
            this.mTable.addControlListener((ControlListener)object);
            object.controlResized(null);
            this.mTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    if (selectionEvent.item instanceof TableItem) {
                        TableItem tableItem;
                        tableItem.setChecked(!(tableItem = (TableItem)selectionEvent.item).getChecked());
                    }
                    super.widgetDefaultSelected(selectionEvent);
                }
            });
            Dialog.applyDialogFont((Control)composite2);
            this.setHelpAvailable(false);
            return composite2;
        }
    }
}

