/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui.tree;

import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.ViewElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.part.FileEditorInput;

public class NewItemSelectionDialog
extends AbstractElementListSelectionDialog {
    private UiElementNode mSelectedUiNode;
    private UiElementNode mChosenRootNode;
    private UiElementNode mLocalRootNode;
    private ElementDescriptor[] mDescriptorFilters;
    private String mLastUsedKey;
    private static final Map<String, String> sLastUsedXmlName = new HashMap<String, String>();
    private String mInitialXmlName;

    public NewItemSelectionDialog(Shell shell, ILabelProvider iLabelProvider, ElementDescriptor[] elementDescriptorArray, UiElementNode uiElementNode, UiElementNode uiElementNode2) {
        super(shell, iLabelProvider);
        Object object;
        this.mDescriptorFilters = elementDescriptorArray;
        this.mLocalRootNode = uiElementNode2;
        if (uiElementNode != null && uiElementNode != this.mLocalRootNode) {
            if (uiElementNode.getDescriptor().hasChildren()) {
                this.mSelectedUiNode = uiElementNode;
            } else {
                object = uiElementNode.getUiParent();
                if (object != null && object != this.mLocalRootNode) {
                    this.mSelectedUiNode = object;
                }
            }
        }
        this.setHelpAvailable(false);
        this.setMultipleSelection(false);
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] objectArray) {
                if (objectArray.length == 1 && objectArray[0] instanceof ViewElementDescriptor) {
                    return new Status(0, "com.android.ide.eclipse.adt", 0, ((ViewElementDescriptor)objectArray[0]).getCanonicalClassName(), null);
                }
                if (objectArray.length == 1 && objectArray[0] instanceof ElementDescriptor) {
                    return new Status(0, "com.android.ide.eclipse.adt", 0, "", null);
                }
                return new Status(4, "com.android.ide.eclipse.adt", 4, "Invalid selection", null);
            }
        });
        object = this.getLastUsedXmlName(uiElementNode2);
        if (object == null) {
            object = this.getMostUsedXmlName(uiElementNode2);
        }
        if (object == null) {
            object = this.getLeafFileName(uiElementNode2);
        }
        this.mInitialXmlName = object;
    }

    private String getLeafFileName(UiElementNode uiElementNode) {
        IFile iFile;
        IEditorInput iEditorInput;
        AndroidEditor androidEditor;
        if (uiElementNode != null && (androidEditor = uiElementNode.getEditor()) != null && (iEditorInput = androidEditor.getEditorInput()) instanceof FileEditorInput && (iFile = ((FileEditorInput)iEditorInput).getFile()) != null) {
            String string = iFile.getFullPath().removeFileExtension().lastSegment();
            return "*" + string;
        }
        return null;
    }

    private String getLastUsedXmlName(UiElementNode uiElementNode) {
        IFile iFile;
        IEditorInput iEditorInput;
        AndroidEditor androidEditor;
        if (uiElementNode != null && (androidEditor = uiElementNode.getEditor()) != null && (iEditorInput = androidEditor.getEditorInput()) instanceof FileEditorInput && (iFile = ((FileEditorInput)iEditorInput).getFile()) != null) {
            this.mLastUsedKey = iFile.getFullPath().toPortableString();
            return sLastUsedXmlName.get(this.mLastUsedKey);
        }
        return null;
    }

    private void setLastUsedXmlName(Object[] objectArray) {
        if (this.mLastUsedKey != null && objectArray != null && objectArray.length > 0 && objectArray[0] instanceof ElementDescriptor) {
            ElementDescriptor elementDescriptor = (ElementDescriptor)objectArray[0];
            sLastUsedXmlName.put(this.mLastUsedKey, elementDescriptor.getXmlName());
        }
    }

    private String getMostUsedXmlName(UiElementNode uiElementNode) {
        if (uiElementNode != null) {
            TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
            int n = -1;
            for (UiElementNode object : uiElementNode.getUiChildren()) {
                String string = object.getDescriptor().getXmlName();
                Integer n2 = (Integer)treeMap.get(string);
                int n3 = n2 == null ? 1 : n2 + 1;
                treeMap.put(string, n3);
                n = Math.max(n, n3);
            }
            if (n > 0) {
                for (Map.Entry entry : treeMap.entrySet()) {
                    if ((Integer)entry.getValue() != n) continue;
                    return (String)entry.getKey();
                }
            }
        }
        return null;
    }

    public UiElementNode getChosenRootNode() {
        return this.mChosenRootNode;
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.getSelectedElements()));
        this.setLastUsedXmlName(this.getSelectedElements());
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createRadioControl(composite2);
        this.createFilterText(composite2);
        this.createFilteredList(composite2);
        this.chooseNode(this.mChosenRootNode);
        this.setInitialSelection(this.mChosenRootNode);
        return composite2;
    }

    private void setInitialSelection(UiElementNode uiElementNode) {
        ElementDescriptor[] elementDescriptorArray;
        ElementDescriptor elementDescriptor = null;
        if (this.mInitialXmlName != null && this.mInitialXmlName.length() > 0) {
            String string = this.mInitialXmlName;
            boolean bl = string.startsWith("*");
            if (bl) {
                string = string.substring(1).toLowerCase();
            }
            ElementDescriptor[] elementDescriptorArray2 = this.getAllowedDescriptors(uiElementNode);
            int n = elementDescriptorArray2.length;
            int n2 = 0;
            while (n2 < n) {
                String string2;
                ElementDescriptor elementDescriptor2 = elementDescriptorArray2[n2];
                if (!bl && elementDescriptor2.getXmlName().equals(string)) {
                    elementDescriptor = elementDescriptor2;
                    break;
                }
                if (bl && (string.startsWith(string2 = elementDescriptor2.getXmlLocalName().toLowerCase()) || string2.startsWith(string))) {
                    elementDescriptor = elementDescriptor2;
                    break;
                }
                ++n2;
            }
        }
        if (elementDescriptor == null) {
            elementDescriptorArray = null;
        } else {
            ElementDescriptor[] elementDescriptorArray3 = new ElementDescriptor[1];
            elementDescriptorArray = elementDescriptorArray3;
            elementDescriptorArray3[0] = elementDescriptor;
        }
        this.setSelection(elementDescriptorArray);
    }

    private Composite createRadioControl(Composite composite) {
        if (this.mSelectedUiNode != null) {
            Button button = new Button(composite, 16);
            button.setText(String.format("Create a new element at the top level, in %1$s.", this.mLocalRootNode.getShortDescription()));
            Button button2 = new Button(composite, 16);
            button2.setText(String.format("Create a new element in the selected element, %1$s.", this.mSelectedUiNode.getBreadcrumbTrailDescription(false)));
            button.setSelection(false);
            button2.setSelection(true);
            this.mChosenRootNode = this.mSelectedUiNode;
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    super.widgetSelected(selectionEvent);
                    NewItemSelectionDialog.this.chooseNode(NewItemSelectionDialog.this.mLocalRootNode);
                }
            });
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    super.widgetSelected(selectionEvent);
                    NewItemSelectionDialog.this.chooseNode(NewItemSelectionDialog.this.mSelectedUiNode);
                }
            });
        } else {
            this.setMessage(String.format("Create a new element at the top level, in %1$s.", this.mLocalRootNode.getShortDescription()));
            this.createMessageArea(composite);
            this.mChosenRootNode = this.mLocalRootNode;
        }
        return composite;
    }

    private void chooseNode(UiElementNode uiElementNode) {
        this.mChosenRootNode = uiElementNode;
        this.setListElements(this.getAllowedDescriptors(uiElementNode));
    }

    private ElementDescriptor[] getAllowedDescriptors(UiElementNode uiElementNode) {
        if (uiElementNode == this.mLocalRootNode && this.mDescriptorFilters != null && this.mDescriptorFilters.length != 0) {
            return this.mDescriptorFilters;
        }
        return uiElementNode.getDescriptor().getChildren();
    }
}

