/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest.model;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiTextAttributeNode;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.jdt.ui.dialogs.ITypeSelectionComponent;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.w3c.dom.Element;

public class UiClassAttributeNode
extends UiTextAttributeNode {
    private String mReferenceClass;
    private IPostTypeCreationAction mPostCreationAction;
    private boolean mMandatory;
    private final boolean mDefaultToProjectOnly;

    public UiClassAttributeNode(String string, IPostTypeCreationAction iPostTypeCreationAction, boolean bl, AttributeDescriptor attributeDescriptor, UiElementNode uiElementNode, boolean bl2) {
        super(attributeDescriptor, uiElementNode);
        this.mReferenceClass = string;
        this.mPostCreationAction = iPostTypeCreationAction;
        this.mMandatory = bl;
        this.mDefaultToProjectOnly = bl2;
    }

    public void createUiControl(Composite composite, IManagedForm iManagedForm) {
        this.setManagedForm(iManagedForm);
        FormToolkit formToolkit = iManagedForm.getToolkit();
        TextAttributeDescriptor textAttributeDescriptor = (TextAttributeDescriptor)this.getDescriptor();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<form><p><a href='unused'>");
        stringBuilder.append(textAttributeDescriptor.getUiName());
        stringBuilder.append("</a></p></form>");
        FormText formText = SectionHelper.createFormText(composite, formToolkit, true, stringBuilder.toString(), true);
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                super.linkActivated(hyperlinkEvent);
                UiClassAttributeNode.this.handleLabelClick();
            }
        });
        formText.setLayoutData((Object)new TableWrapData(2, 32));
        SectionHelper.addControlTooltip((Control)formText, textAttributeDescriptor.getTooltip());
        Composite composite2 = formToolkit.createComposite(composite);
        composite2.setLayoutData((Object)new TableWrapData(256, 32));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        formToolkit.paintBordersFor(composite2);
        Text text = formToolkit.createText(composite2, this.getCurrentValue());
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 1;
        text.setLayoutData((Object)gridData);
        Button button = formToolkit.createButton(composite2, "Browse...", 8);
        this.setTextWidget(text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                UiClassAttributeNode.this.handleBrowseClick();
            }
        });
    }

    protected void onAddValidators(final Text text) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                try {
                    String string = text.getText().trim();
                    if (string.length() == 0) {
                        if (UiClassAttributeNode.this.mMandatory) {
                            UiClassAttributeNode.this.setErrorMessage("Value is mandatory", text);
                        } else {
                            UiClassAttributeNode.this.setErrorMessage(null, text);
                        }
                        return;
                    }
                    String string2 = UiClassAttributeNode.this.getManifestPackage();
                    String string3 = AndroidManifestParser.combinePackageAndClassName(string2, string);
                    boolean bl = "android.app.Activity".equals(UiClassAttributeNode.this.mReferenceClass);
                    UiClassAttributeNode.this.setErrorMessage(BaseProjectHelper.testClassForManifest(BaseProjectHelper.getJavaProject(UiClassAttributeNode.this.getProject()), string3, UiClassAttributeNode.this.mReferenceClass, bl), text);
                }
                catch (CoreException coreException) {
                    UiClassAttributeNode.this.setErrorMessage(coreException.getMessage(), text);
                }
            }
        };
        text.addModifyListener(modifyListener);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                UiClassAttributeNode.this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
            }
        });
        modifyListener.modifyText(null);
    }

    private void handleBrowseClick() {
        Text text = this.getTextWidget();
        IProject iProject = this.getProject();
        if (iProject != null) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.getPackageFragmentRoots(iProject, true);
            IJavaSearchScope iJavaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])iPackageFragmentRootArray, (boolean)false);
            try {
                Object[] objectArray;
                SelectionDialog selectionDialog = JavaUI.createTypeDialog((Shell)text.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)iJavaSearchScope, (int)2, (boolean)false, (String)"**", (TypeSelectionExtension)new HierarchyTypeSelection(iProject, this.mReferenceClass));
                selectionDialog.setMessage(String.format("Select class name for element %1$s:", this.getUiParent().getBreadcrumbTrailDescription(false)));
                if (selectionDialog instanceof ITypeSelectionComponent) {
                    ((ITypeSelectionComponent)selectionDialog).triggerSearch();
                }
                if (selectionDialog.open() == 0 && (objectArray = selectionDialog.getResult()).length == 1) {
                    this.handleNewType((IType)objectArray[0]);
                }
            }
            catch (JavaModelException javaModelException) {
                AdtPlugin.log(javaModelException, "UiClassAttributeNode HandleBrowser failed", new Object[0]);
            }
        }
    }

    private void handleLabelClick() {
        String string = this.getTextWidget().getText().trim();
        String string2 = this.getManifestPackage();
        if (string.length() == 0) {
            this.createNewClass(string2, null);
        } else {
            IProject iProject;
            String string3 = string;
            if (string.startsWith(".")) {
                string3 = String.valueOf(string2) + string;
            } else {
                iProject = string.split("\\.");
                if (((String[])iProject).length == 1) {
                    string3 = String.valueOf(string2) + "." + string;
                }
            }
            string3 = string3.replaceAll("\\$", "\\.");
            iProject = this.getProject();
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            try {
                IType iType = iJavaProject.findType(string3);
                if (iType != null) {
                    JavaUI.openInEditor((IJavaElement)iType);
                } else {
                    int n = string3.lastIndexOf(46);
                    if (n != -1) {
                        this.createNewClass(string3.substring(0, n), string3.substring(n + 1));
                    } else {
                        this.createNewClass(string2, string);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                AdtPlugin.log(javaModelException, "UiClassAttributeNode HandleLabel failed", new Object[0]);
            }
            catch (PartInitException partInitException) {
                AdtPlugin.log(partInitException, "UiClassAttributeNode HandleLabel failed", new Object[0]);
            }
        }
    }

    private IProject getProject() {
        UiElementNode uiElementNode = this.getUiParent();
        AndroidEditor androidEditor = uiElementNode.getEditor();
        IEditorInput iEditorInput = androidEditor.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            return iFile.getProject();
        }
        return null;
    }

    private String getManifestPackage() {
        UiElementNode uiElementNode = this.getUiParent().getUiRoot();
        Element element = (Element)uiElementNode.getXmlNode();
        if (element != null) {
            return element.getAttribute("package");
        }
        return "";
    }

    private IPackageFragmentRoot[] getPackageFragmentRoots(IProject iProject, boolean bl) {
        ArrayList<IPackageFragmentRoot> arrayList = new ArrayList<IPackageFragmentRoot>();
        try {
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
            int n = 0;
            while (n < iPackageFragmentRootArray.length) {
                IClasspathEntry iClasspathEntry = iPackageFragmentRootArray[n].getRawClasspathEntry();
                if (iClasspathEntry.getEntryKind() == 3 || bl && iClasspathEntry.getEntryKind() == 5) {
                    arrayList.add(iPackageFragmentRootArray[n]);
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {}
        return arrayList.toArray(new IPackageFragmentRoot[arrayList.size()]);
    }

    private void handleNewType(IType iType) {
        Text text = this.getTextWidget();
        String string = iType.getFullyQualifiedName('$');
        String string2 = this.getManifestPackage();
        if (string2.length() > 0 && string.startsWith(string2)) {
            String[] stringArray = (string = string.substring(string2.length() + 1)).split("\\.");
            if (stringArray.length == 1) {
                text.setText(string);
            } else {
                text.setText("." + string);
            }
        } else {
            text.setText(string);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void createNewClass(String var1_1, String var2_2) {
        block25: {
            var3_3 = new NewClassWizardPage();
            var3_3.setSuperClass(this.mReferenceClass, true);
            var4_4 = this.getPackageFragmentRoots(this.getProject(), true);
            var5_5 = null;
            var6_6 = null;
            var7_7 = -1;
            var11_8 = var4_4;
            var10_13 = ((IPackageFragmentRoot[])var11_8).length;
            var9_15 = 0;
            while (var9_15 < var10_13) {
                var8_18 = var11_8[var9_15];
                var12_19 = var8_18.getPackageFragment(var1_1);
                if (var12_19 != null && var12_19.exists()) {
                    var5_5 = var8_18;
                    var6_6 = var12_19;
                    var7_7 = -1;
                    break;
                }
                try {
                    var17_24 = var13_20 = var8_18.getChildren();
                    var16_23 = ((IJavaElement[])var17_24).length;
                    var15_22 = 0;
                    while (var15_22 < var16_23) {
                        var14_21 = var17_24[var15_22];
                        if (var14_21 instanceof IPackageFragment && var1_1.startsWith((var12_19 = (IPackageFragment)var14_21).getElementName()) && (var18_25 = var12_19.getElementName().split("\\.")).length > var7_7) {
                            var7_7 = var18_25.length;
                            var6_6 = var12_19;
                            var5_5 = var8_18;
                        }
                        ++var15_22;
                    }
                }
                catch (JavaModelException v0) {}
                ++var9_15;
            }
            var8_18 = null;
            if (var5_5 == null) ** GOTO lbl74
            if (var7_7 == -1) {
                var3_3.setPackageFragmentRoot(var5_5, true);
                var3_3.setPackageFragment(var6_6, true);
            } else {
                try {
                    var8_18 = new ArrayList<E>();
                    var9_15 = var1_1.split("\\.").length;
                    var10_13 = 0;
                    var11_9 = -1;
                    while (var10_13 < var7_7) {
                        var11_9 = var1_1.indexOf(46, var11_9 + 1);
                        ++var10_13;
                    }
                    while (var10_13 < var9_15 - 1) {
                        var11_9 = var1_1.indexOf(46, var11_9 + 1);
                        ++var10_13;
                        var8_18.add(var5_5.createPackageFragment(var1_1.substring(0, var11_9), true, (IProgressMonitor)new NullProgressMonitor()));
                    }
                    var8_18.add(var5_5.createPackageFragment(var1_1, true, (IProgressMonitor)new NullProgressMonitor()));
                    var3_3.setPackageFragmentRoot((IPackageFragmentRoot)var5_5, true);
                    var3_3.setPackageFragment((IPackageFragment)var8_18.get(var8_18.size() - 1), true);
                    break block25;
                }
                catch (JavaModelException v1) {
                    var12_19 = var4_4;
                    var11_10 = ((IPackageFragmentRoot[])var12_19).length;
                    var10_13 = 0;
                    ** while (var10_13 < var11_10)
                }
lbl-1000:
                // 1 sources

                {
                    var9_16 = var12_19[var10_13];
                    var13_20 = var9_16.getPackageFragment(var1_1);
                    if (var13_20 != null && var13_20.exists()) {
                        var3_3.setPackageFragmentRoot(var9_16, true);
                        var3_3.setPackageFragment(var13_20, true);
                    } else {
                        ++var10_13;
                        continue;
                    }
lbl73:
                    // 1 sources

                    break block25;
                }
lbl74:
                // 1 sources

                if (((IPackageFragmentRoot[])var4_4).length > 0) {
                    var3_3.setPackageFragmentRoot(var4_4[0], true);
                }
            }
        }
        if (var2_2 != null) {
            var3_3.setTypeName(var2_2, true);
        }
        var9_17 = new OpenNewClassWizardAction();
        var9_17.setConfiguredWizardPage(var3_3);
        var9_17.run();
        var10_14 = var9_17.getCreatedElement();
        if (var10_14 != null) {
            if (var10_14.getElementType() == 7) {
                var11_8 = (IType)var10_14;
                if (this.mPostCreationAction != null) {
                    this.mPostCreationAction.processNewType(var11_8);
                }
                this.handleNewType(var11_8);
            }
        } else if (var8_18 != null) {
            try {
                var11_11 = var8_18.size() - 1;
                while (var11_11 >= 0) {
                    ((IPackageFragment)var8_18.get(var11_11)).delete(true, (IProgressMonitor)new NullProgressMonitor());
                    --var11_11;
                }
            }
            catch (JavaModelException var11_12) {
                var11_12.printStackTrace();
            }
        }
    }

    private final void setErrorMessage(String string, Text text) {
        if (string != null) {
            this.setHasError(true);
            this.getManagedForm().getMessageManager().addMessage((Object)text, string, null, 3, (Control)text);
        } else {
            this.setHasError(false);
            this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
        }
    }

    public String[] getPossibleValues(String string) {
        return null;
    }

    private class HierarchyTypeSelection
    extends TypeSelectionExtension {
        private IJavaProject mJavaProject;
        private IType mReferenceType;
        private Button mProjectOnly;
        private boolean mUseProjectOnly;

        public HierarchyTypeSelection(IProject iProject, String string) throws JavaModelException {
            this.mJavaProject = JavaCore.create((IProject)iProject);
            this.mReferenceType = this.mJavaProject.findType(string);
        }

        public ITypeInfoFilterExtension getFilterExtension() {
            return new ITypeInfoFilterExtension(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean select(ITypeInfoRequestor iTypeInfoRequestor) {
                    boolean bl = HierarchyTypeSelection.this.mUseProjectOnly;
                    String string = iTypeInfoRequestor.getPackageName();
                    String string2 = iTypeInfoRequestor.getTypeName();
                    String string3 = iTypeInfoRequestor.getEnclosingName();
                    StringBuilder stringBuilder = new StringBuilder(string);
                    stringBuilder.append('.');
                    if (string3.length() > 0) {
                        stringBuilder.append(string3);
                        stringBuilder.append('.');
                    }
                    stringBuilder.append(string2);
                    String string4 = stringBuilder.toString();
                    try {
                        IPackageFragment iPackageFragment;
                        IType iType = HierarchyTypeSelection.this.mJavaProject.findType(string4);
                        if (iType == null) {
                            return false;
                        }
                        if ((iType.getFlags() & 0x400) != 0) {
                            return false;
                        }
                        if (bl) {
                            iPackageFragment = iType.getPackageFragment();
                            if (iPackageFragment == null) return false;
                            if (iPackageFragment.getKind() != 1) {
                                return false;
                            }
                        }
                        iPackageFragment = iType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                        IType[] iTypeArray = iPackageFragment.getAllSupertypes(iType);
                        int n = iTypeArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) {
                                return false;
                            }
                            IType iType2 = iTypeArray[n2];
                            if (HierarchyTypeSelection.this.mReferenceType.equals(iType2)) {
                                return true;
                            }
                            ++n2;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    return false;
                }
            };
        }

        public Control createContentArea(Composite composite) {
            this.mProjectOnly = new Button(composite, 32);
            this.mProjectOnly.setLayoutData((Object)new GridData(768));
            this.mProjectOnly.setText(String.format("Display classes from sources of project '%s' only", this.mJavaProject.getProject().getName()));
            this.mUseProjectOnly = UiClassAttributeNode.this.mDefaultToProjectOnly;
            this.mProjectOnly.setSelection(this.mUseProjectOnly);
            this.mProjectOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    super.widgetSelected(selectionEvent);
                    HierarchyTypeSelection.this.mUseProjectOnly = HierarchyTypeSelection.this.mProjectOnly.getSelection();
                    HierarchyTypeSelection.this.getTypeSelectionComponent().triggerSearch();
                }
            });
            return super.createContentArea(composite);
        }
    }

    public static interface IPostTypeCreationAction {
        public void processNewType(IType var1);
    }
}

