/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.parts;

import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.parts.ElementCreateCommand;
import com.android.ide.eclipse.adt.internal.editors.layout.parts.UiLayoutEditPart;
import com.android.ide.eclipse.adt.internal.editors.uimodel.IUiUpdateListener;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class UiElementEditPart
extends AbstractGraphicalEditPart
implements IUiUpdateListener {
    public UiElementEditPart(UiElementNode uiElementNode) {
        this.setModel(uiElementNode);
    }

    protected abstract void hideSelection();

    protected abstract void showSelection();

    public DragTracker getDragTracker(Request request) {
        return new SelectEditPartTracker((EditPart)this);
    }

    protected void createEditPolicies() {
    }

    protected List getModelChildren() {
        return this.getUiNode().getUiChildren();
    }

    public void activate() {
        super.activate();
        this.getUiNode().addUpdateListener(this);
    }

    public void deactivate() {
        super.deactivate();
        this.getUiNode().removeUpdateListener(this);
    }

    protected void refreshVisuals() {
        if (this.getFigure().getParent() != null) {
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)this.getBounds());
        }
        this.refreshChildrenVisuals();
    }

    protected void refreshChildrenVisuals() {
        if (this.children != null) {
            for (Object e : this.children) {
                if (!(e instanceof UiElementEditPart)) continue;
                UiElementEditPart uiElementEditPart = (UiElementEditPart)e;
                uiElementEditPart.refreshVisuals();
            }
        }
    }

    public void uiElementNodeUpdated(UiElementNode uiElementNode, IUiUpdateListener.UiUpdateState uiUpdateState) {
        switch (uiUpdateState) {
            case ATTR_UPDATED: {
                this.refreshVisuals();
                break;
            }
            case CHILDREN_CHANGED: {
                this.refreshChildren();
                this.refreshVisuals();
                break;
            }
            case CREATED: {
                this.refreshVisuals();
                break;
            }
        }
    }

    public final UiElementNode getUiNode() {
        return (UiElementNode)this.getModel();
    }

    protected final ElementDescriptor getDescriptor() {
        return this.getUiNode().getDescriptor();
    }

    protected final UiElementEditPart getEditPartParent() {
        EditPart editPart = this.getParent();
        if (editPart instanceof UiElementEditPart) {
            return (UiElementEditPart)editPart;
        }
        return null;
    }

    protected final String getStringAttr(String string) {
        Node node;
        NamedNodeMap namedNodeMap;
        Node node2;
        UiElementNode uiElementNode = this.getUiNode();
        if (uiElementNode.getXmlNode() != null && (node2 = uiElementNode.getXmlNode()) != null && (namedNodeMap = node2.getAttributes()) != null && (node = namedNodeMap.getNamedItemNS("http://schemas.android.com/apk/res/android", string)) != null) {
            return node.getNodeValue();
        }
        return null;
    }

    protected final Rectangle getBounds() {
        UiElementNode uiElementNode = (UiElementNode)this.getModel();
        Object object = uiElementNode.getEditData();
        if (object != null) {
            assert (object instanceof Rectangle);
            return (Rectangle)object;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request != null && request.getType() == "create child" && !this.getUiNode().getDescriptor().hasChildren()) {
            return null;
        }
        return super.getTargetEditPart(request);
    }

    protected void installLayoutEditPolicy(final UiElementEditPart uiElementEditPart) {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart editPart) {
                if (editPart instanceof UiElementEditPart) {
                    return new NonResizableSelectionEditPolicy((UiElementEditPart)editPart);
                }
                return null;
            }

            protected Command getCreateCommand(CreateRequest createRequest) {
                Object object = createRequest.getNewObjectType();
                if (object instanceof ElementDescriptor) {
                    Point point = createRequest.getLocation().getCopy();
                    Point point2 = this.getLayoutContainer().getClientArea().getLocation();
                    point.translate(point2.getNegated());
                    EditPart editPart = this.getHost();
                    if (editPart instanceof UiElementEditPart) {
                        return new ElementCreateCommand((ElementDescriptor)object, (UiElementEditPart)editPart, point);
                    }
                }
                return null;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            public void showLayoutTargetFeedback(Request request) {
                super.showLayoutTargetFeedback(request);
                if (uiElementEditPart instanceof UiLayoutEditPart && request instanceof DropRequest) {
                    Point point = ((DropRequest)request).getLocation().getCopy();
                    Point point2 = this.getLayoutContainer().getClientArea().getLocation();
                    point.translate(point2.getNegated());
                    ((UiLayoutEditPart)uiElementEditPart).showDropTarget(point);
                }
            }

            protected void eraseLayoutTargetFeedback(Request request) {
                super.eraseLayoutTargetFeedback(request);
                if (uiElementEditPart instanceof UiLayoutEditPart) {
                    ((UiLayoutEditPart)uiElementEditPart).hideDropTarget();
                }
            }

            protected IFigure createSizeOnDropFeedback(CreateRequest createRequest) {
                return super.createSizeOnDropFeedback(createRequest);
            }
        });
    }

    protected static class NonResizableSelectionEditPolicy
    extends SelectionEditPolicy {
        private final UiElementEditPart mEditPart;

        public NonResizableSelectionEditPolicy(UiElementEditPart uiElementEditPart) {
            this.mEditPart = uiElementEditPart;
        }

        protected void hideSelection() {
            this.mEditPart.hideSelection();
        }

        protected void showSelection() {
            this.mEditPart.showSelection();
        }
    }
}

