/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;

class ElementFigure
extends Figure {
    private boolean mIsSelected;
    private Rectangle mInnerBounds;

    public ElementFigure() {
        this.setOpaque(false);
    }

    public void setSelected(boolean bl) {
        if (bl != this.mIsSelected) {
            this.mIsSelected = bl;
            this.repaint();
        }
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.mInnerBounds = this.getBounds().getCopy();
        if (this.mInnerBounds.width > 0) {
            --this.mInnerBounds.width;
        }
        if (this.mInnerBounds.height > 0) {
            --this.mInnerBounds.height;
        }
    }

    public Rectangle getInnerBounds() {
        return this.mInnerBounds;
    }

    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        if (this.mIsSelected) {
            graphics.setLineWidth(1);
            graphics.setLineStyle(1);
            graphics.setForegroundColor(ColorConstants.red);
            graphics.drawRectangle(this.getInnerBounds());
        }
    }
}

