/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.IDescriptorProvider;
import com.android.ide.eclipse.adt.internal.editors.descriptors.SeparatorAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextValueDescriptor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiFlagAttributeNode;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Node;

public abstract class AndroidContentAssist
implements IContentAssistProcessor {
    private static Pattern sFirstAttribute = Pattern.compile("^ *[a-zA-Z_:]+ *= *(?:\"[^<\"]*\"|'[^<']*')");
    private static Pattern sFirstElementWord = Pattern.compile("^[a-zA-Z0-9_:]+");
    private static Pattern sWhitespace = Pattern.compile("\\s+");
    protected static final String ROOT_ELEMENT = "";
    private ElementDescriptor mRootDescriptor;
    private final int mDescriptorId;
    private AndroidEditor mEditor;

    public AndroidContentAssist(int n) {
        this.mDescriptorId = n;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        int n2;
        char c;
        UiElementNode uiElementNode;
        if (this.mEditor == null) {
            this.mEditor = this.getAndroidEditor(iTextViewer);
            if (this.mEditor == null) {
                AdtPlugin.log(4, "Editor not found during completion", new Object[0]);
                return null;
            }
        }
        UiElementNode uiElementNode2 = this.mEditor.getUiRootNode();
        Object[] objectArray = null;
        String string = ROOT_ELEMENT;
        String string2 = this.extractElementPrefix(iTextViewer, n);
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        Node node = this.getNode(iTextViewer, n);
        if (node == null) {
            return null;
        }
        UiElementNode uiElementNode3 = uiElementNode = uiElementNode2 == null ? null : uiElementNode2.findXmlNode(node);
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1) {
            string = node.getNodeName();
            if (string2.equals(string)) {
                bl = true;
                objectArray = this.getChoicesForElement(string, node);
            } else {
                bl2 = true;
                AttribInfo attribInfo = this.parseAttributeInfo(iTextViewer, n);
                if (attribInfo != null) {
                    objectArray = this.getChoicesForAttribute(string, node, uiElementNode, attribInfo);
                    if (attribInfo.correctedPrefix != null) {
                        string2 = attribInfo.correctedPrefix;
                    }
                    n3 = attribInfo.needTag;
                }
            }
        } else if (node.getNodeType() == 3) {
            bl = true;
            objectArray = this.getChoicesForTextNode(node);
        }
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        if (bl && (c = this.extractChar(iTextViewer, n2 = n - string2.length() - 1)) != '<' && (c != '/' || this.extractChar(iTextViewer, n2 - 1) != '<')) {
            n3 = 60;
        }
        int n4 = 0;
        ISelection iSelection = iTextViewer.getSelectionProvider().getSelection();
        if (iSelection instanceof TextSelection) {
            TextSelection textSelection = (TextSelection)iSelection;
            n4 = textSelection.getLength();
        }
        return this.computeProposals(n, node, objectArray, string2, (char)n3, bl2, n4);
    }

    private String lookupNamespacePrefix(Node node, String string) {
        int n;
        Object object;
        if ("http://www.w3.org/2000/xmlns/".equals(string)) {
            return "xmlns";
        }
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = null;
        while (string2 == null && node != null && node.getNodeType() == 1) {
            object = node.getAttributes();
            n = object.getLength() - 1;
            while (n >= 0) {
                Node node2 = object.item(n);
                if ("xmlns".equals(node2.getPrefix())) {
                    String string3 = node2.getNodeValue();
                    if ("http://schemas.android.com/apk/res/android".equals(string3)) {
                        return node2.getLocalName();
                    }
                    hashSet.add(string3);
                }
                --n;
            }
            node = node.getParentNode();
        }
        string2 = "http://schemas.android.com/apk/res/android".equals(string) ? "android" : "ns";
        object = string2;
        n = 1;
        while (hashSet.contains(string2)) {
            string2 = String.valueOf(object) + Integer.toString(n);
            ++n;
        }
        return string2;
    }

    private Object[] getChoicesForElement(String string, Node node) {
        ElementDescriptor elementDescriptor = null;
        if (node.getParentNode().getNodeType() == 1) {
            elementDescriptor = this.getDescriptor(node.getParentNode().getNodeName());
        } else if (node.getParentNode().getNodeType() == 9) {
            elementDescriptor = this.getRootDescriptor();
        }
        if (elementDescriptor != null) {
            ElementDescriptor[] elementDescriptorArray = elementDescriptor.getChildren();
            int n = elementDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                ElementDescriptor elementDescriptor2 = elementDescriptorArray[n2];
                if (elementDescriptor2.getXmlName().startsWith(string)) {
                    return elementDescriptor.getChildren();
                }
                ++n2;
            }
        }
        return null;
    }

    private Object[] getChoicesForAttribute(String string, Node node, UiElementNode uiElementNode, AttribInfo attribInfo) {
        Object[] objectArray = null;
        if (attribInfo.isInValue) {
            Object object;
            String string2;
            String string3 = attribInfo.value;
            if (string3.startsWith("'") || string3.startsWith("\"")) {
                attribInfo.correctedPrefix = string3 = string3.substring(1);
            } else {
                attribInfo.needTag = (char)34;
            }
            if (uiElementNode != null) {
                string2 = attribInfo.name;
                int n = string2.indexOf(58);
                if (n >= 0) {
                    string2 = string2.substring(n + 1);
                }
                object = null;
                for (UiAttributeNode uiAttributeNode : uiElementNode.getUiAttributes()) {
                    if (!uiAttributeNode.getDescriptor().getXmlLocalName().equals(string2)) continue;
                    object = uiAttributeNode;
                    break;
                }
                if (object != null) {
                    objectArray = ((UiAttributeNode)object).getPossibleValues(string3);
                    if (object instanceof UiFlagAttributeNode && (n = string3.indexOf(124)) >= 0) {
                        attribInfo.correctedPrefix = string3 = string3.substring(n + 1);
                        attribInfo.needTag = '\u0000';
                    }
                }
            }
            if (objectArray == null) {
                string2 = null;
                Node node2 = node.getParentNode();
                if (node2 != null && (object = node2.getParentNode()) != null) {
                    string2 = object.getLocalName();
                }
                if ((object = this.mEditor.getTargetData()) != null) {
                    objectArray = ((AndroidTargetData)object).getAttributeValues(string, attribInfo.name, string2);
                }
            }
        } else if (uiElementNode != null) {
            objectArray = uiElementNode.getAttributeDescriptors();
        } else {
            ElementDescriptor elementDescriptor = this.getDescriptor(string);
            objectArray = elementDescriptor.getAttributes();
        }
        return objectArray;
    }

    private Object[] getChoicesForTextNode(Node node) {
        Object[] objectArray = null;
        Node node2 = node.getParentNode();
        if (node2.getNodeType() == 1) {
            String string = node2.getNodeName();
            ElementDescriptor elementDescriptor = this.getDescriptor(string);
            if (elementDescriptor != null) {
                objectArray = elementDescriptor.getChildren();
            }
        } else if (node2.getNodeType() == 9) {
            objectArray = this.getRootDescriptor().getChildren();
        }
        return objectArray;
    }

    private ICompletionProposal[] computeProposals(int n, Node node, Object[] objectArray, String string, char c, boolean bl, int n2) {
        ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object[] objectArray2 = objectArray;
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            block18: {
                String string2;
                String string3;
                Image image;
                String string4;
                String string5;
                Object object;
                block17: {
                    block19: {
                        block16: {
                            object = objectArray2[n4];
                            string5 = null;
                            string4 = null;
                            image = null;
                            string3 = null;
                            if (!(object instanceof ElementDescriptor)) break block16;
                            string5 = ((ElementDescriptor)object).getXmlName();
                            image = ((ElementDescriptor)object).getIcon();
                            string3 = DescriptorsUtils.formatTooltip(((ElementDescriptor)object).getTooltip());
                            break block17;
                        }
                        if (object instanceof TextValueDescriptor || object instanceof SeparatorAttributeDescriptor) break block18;
                        if (!(object instanceof AttributeDescriptor)) break block19;
                        string5 = ((AttributeDescriptor)object).getXmlLocalName();
                        image = ((AttributeDescriptor)object).getIcon();
                        if (object instanceof TextAttributeDescriptor) {
                            string3 = ((TextAttributeDescriptor)object).getTooltip();
                        }
                        if ((string2 = ((AttributeDescriptor)object).getNamespaceUri()) != null && (string4 = (String)hashMap.get(string2)) == null) {
                            string4 = this.lookupNamespacePrefix(node, string2);
                            hashMap.put(string2, string4);
                        }
                        if (string4 != null) {
                            string4 = String.valueOf(string4) + ":";
                        }
                        break block17;
                    }
                    if (!(object instanceof String)) break block18;
                    string5 = (String)object;
                }
                String string6 = string2 = string4 == null ? string5 : String.valueOf(string4) + string5;
                if (string5.startsWith(string) || string4 != null && string5.startsWith(string4) || string4 != null && string2.startsWith(string)) {
                    if (string4 != null) {
                        string5 = String.valueOf(string4) + string5;
                    }
                    String string7 = ROOT_ELEMENT;
                    if (c != '\u0000') {
                        if (c == '\"') {
                            string5 = String.valueOf(c) + string5;
                            string7 = String.valueOf(c);
                        } else if (c == '<') {
                            if (this.elementCanHaveChildren(object)) {
                                string7 = String.format("></%1$s>", string5);
                                string5 = String.valueOf(c) + string5;
                            } else {
                                string5 = String.valueOf(c) + string5;
                                string7 = "/>";
                            }
                        }
                    }
                    CompletionProposal completionProposal = new CompletionProposal(String.valueOf(string5) + string7, n - string.length(), string.length() + n2, string5.length(), image, null, null, string3);
                    arrayList.add(completionProposal);
                }
            }
            ++n4;
        }
        return arrayList.toArray(new ICompletionProposal[arrayList.size()]);
    }

    private boolean elementCanHaveChildren(Object object) {
        if (object instanceof ElementDescriptor) {
            ElementDescriptor elementDescriptor = (ElementDescriptor)object;
            if (elementDescriptor.hasChildren()) {
                return true;
            }
            AttributeDescriptor[] attributeDescriptorArray = elementDescriptor.getAttributes();
            int n = attributeDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeDescriptor attributeDescriptor = attributeDescriptorArray[n2];
                if (attributeDescriptor instanceof TextValueDescriptor) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private ElementDescriptor getDescriptor(String string) {
        return this.getRootDescriptor().findChildrenDescriptor(string, true);
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'<', ':', '='};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected String extractElementPrefix(ITextViewer var1_1, int var2_2) {
        var3_3 = var2_2;
        var4_4 = var1_1.getDocument();
        if (var3_3 <= var4_4.getLength()) ** GOTO lbl7
        return "";
        {
            while (!Character.isWhitespace(var5_5 = var4_4.getChar(var3_3 - 1)) && var5_5 != '<' && var5_5 != '>' && var5_5 != '\'' && var5_5 != '\"' && var5_5 != '=') {
                --var3_3;
lbl7:
                // 2 sources

                if (var3_3 > 0) continue;
            }
            return var4_4.get(var3_3, var2_2 - var3_3);
        }
    }

    protected char extractChar(ITextViewer iTextViewer, int n) {
        IDocument iDocument = iTextViewer.getDocument();
        if (n > iDocument.getLength()) {
            return '\u0000';
        }
        try {
            return iDocument.getChar(n);
        }
        catch (BadLocationException badLocationException) {
            return '\u0000';
        }
    }

    private AttribInfo parseAttributeInfo(ITextViewer iTextViewer, int n) {
        AttribInfo attribInfo = new AttribInfo();
        IDocument iDocument = iTextViewer.getDocument();
        int n2 = iDocument.getLength();
        if (n <= n2) {
            String string;
            block8: {
                n2 = n;
                while (n > 0) {
                    char c = iDocument.getChar(n - 1);
                    if (c == '<') break;
                    --n;
                }
                string = iDocument.get(n, n2 - n);
                string = sWhitespace.matcher(string).replaceAll(" ");
                string = sFirstElementWord.matcher(string).replaceFirst(ROOT_ELEMENT);
                if (string.startsWith(" ")) break block8;
                return null;
            }
            try {
                String string2;
                while (!(string2 = string).equals(string = sFirstAttribute.matcher(string2).replaceFirst(ROOT_ELEMENT))) {
                }
                int n3 = string.indexOf(61);
                if (n3 == -1) {
                    attribInfo.isInValue = false;
                    attribInfo.name = string.trim();
                } else {
                    attribInfo.isInValue = true;
                    attribInfo.name = string.substring(0, n3).trim();
                    attribInfo.value = string.substring(n3 + 1).trim();
                }
                return attribInfo;
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    protected Node getNode(ITextViewer iTextViewer, int n) {
        Node node = null;
        try {
            IStructuredModel iStructuredModel;
            IModelManager iModelManager = StructuredModelManager.getModelManager();
            if (iModelManager != null && (iStructuredModel = iModelManager.getExistingModelForRead(iTextViewer.getDocument())) != null) {
                while (n >= 0 && node == null) {
                    node = (Node)iStructuredModel.getIndexedRegion(n);
                    --n;
                }
            }
        }
        catch (Exception exception) {}
        return node;
    }

    private ElementDescriptor getRootDescriptor() {
        IDescriptorProvider iDescriptorProvider;
        AndroidTargetData androidTargetData;
        if (this.mRootDescriptor == null && (androidTargetData = this.mEditor.getTargetData()) != null && (iDescriptorProvider = androidTargetData.getDescriptorProvider(this.mDescriptorId)) != null) {
            this.mRootDescriptor = new ElementDescriptor(ROOT_ELEMENT, iDescriptorProvider.getRootElementDescriptors());
        }
        return this.mRootDescriptor;
    }

    private AndroidEditor getAndroidEditor(ITextViewer iTextViewer) {
        ISourceViewer iSourceViewer;
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) instanceof AndroidEditor && (iSourceViewer = ((AndroidEditor)iEditorPart).getStructuredSourceViewer()) == iTextViewer) {
            return (AndroidEditor)iEditorPart;
        }
        return null;
    }

    private class AttribInfo {
        public boolean isInValue = false;
        public String name = null;
        public String value = null;
        public String correctedPrefix = null;
        public char needTag = '\u0000';

        private AttribInfo() {
        }
    }
}

