/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.build.ApkDeltaVisitor;
import com.android.ide.eclipse.adt.internal.build.BaseBuilder;
import com.android.ide.eclipse.adt.internal.build.Messages;
import com.android.ide.eclipse.adt.internal.project.ApkInstallManager;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.DexWrapper;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.jarutils.DebugKeyProvider;
import com.android.jarutils.JavaResourceFilter;
import com.android.jarutils.SignedJarBuilder;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApkBuilder
extends BaseBuilder {
    public static final String ID = "com.android.ide.eclipse.adt.ApkBuilder";
    private static final String PROPERTY_CONVERT_TO_DEX = "convertToDex";
    private static final String PROPERTY_PACKAGE_RESOURCES = "packageResources";
    private static final String PROPERTY_BUILD_APK = "buildApk";
    private static final String DX_PREFIX = "Dx";
    private boolean mConvertToDex = false;
    private boolean mPackageResources = false;
    private boolean mBuildFinalPackage = false;
    private PrintStream mOutStream = null;
    private PrintStream mErrStream = null;
    private final SignedJarBuilder.IZipEntryFilter mJavaResourcesFilter = new JavaResourceFilter();

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = this.getProject();
        IProject[] iProjectArray = null;
        try {
            IContainer iContainer;
            Object object;
            String string;
            Object object2;
            Set<Map.Entry<String, String>> set;
            IJavaProject iJavaProject;
            Object object5;
            this.abortOnBadSetup(iProject);
            iProjectArray = ProjectHelper.getReferencedProjects(iProject);
            IJavaProject[] iJavaProjectArray = this.getJavaProjects(iProjectArray);
            IJavaProject iJavaProject2 = JavaCore.create((IProject)iProject);
            IFolder iFolder = BaseProjectHelper.getOutputFolder(iProject);
            ArrayList<IPath> arrayList = BaseProjectHelper.getSourceClasspaths(iJavaProject2);
            ApkDeltaVisitor apkDeltaVisitor = null;
            if (n == 6) {
                AdtPlugin.printBuildToConsole(2, iProject, Messages.Start_Full_Apk_Build);
                this.mPackageResources = true;
                this.mConvertToDex = true;
                this.mBuildFinalPackage = true;
            } else {
                AdtPlugin.printBuildToConsole(2, iProject, Messages.Start_Inc_Apk_Build);
                object5 = this.getDelta(iProject);
                if (object5 == null) {
                    this.mPackageResources = true;
                    this.mConvertToDex = true;
                    this.mBuildFinalPackage = true;
                } else {
                    apkDeltaVisitor = new ApkDeltaVisitor(this, arrayList, iFolder);
                    object5.accept((IResourceDeltaVisitor)apkDeltaVisitor);
                    this.mPackageResources |= apkDeltaVisitor.getPackageResources();
                    this.mConvertToDex |= apkDeltaVisitor.getConvertToDex();
                    this.mBuildFinalPackage |= apkDeltaVisitor.getMakeFinalPackage();
                }
                int n2 = 0;
                while (!(n2 >= iJavaProjectArray.length || this.mBuildFinalPackage && this.mConvertToDex)) {
                    iJavaProject = iJavaProjectArray[n2];
                    object5 = this.getDelta(iJavaProject.getProject());
                    if (object5 != null) {
                        set = new ReferencedProjectDeltaVisitor(iJavaProject);
                        object5.accept((IResourceDeltaVisitor)set);
                        this.mConvertToDex |= ((ReferencedProjectDeltaVisitor)((Object)set)).needDexConvertion();
                        this.mBuildFinalPackage |= ((ReferencedProjectDeltaVisitor)((Object)set)).needMakeFinalPackage();
                    }
                    ++n2;
                }
            }
            this.saveProjectBooleanProperty(PROPERTY_CONVERT_TO_DEX, this.mConvertToDex);
            this.saveProjectBooleanProperty(PROPERTY_PACKAGE_RESOURCES, this.mPackageResources);
            this.saveProjectBooleanProperty(PROPERTY_BUILD_APK, this.mBuildFinalPackage);
            if (apkDeltaVisitor != null && apkDeltaVisitor.mXmlError) {
                AdtPlugin.printBuildToConsole(2, iProject, Messages.Xml_Error);
                return iProjectArray;
            }
            if (iFolder == null) {
                this.markProject("com.android.ide.eclipse.adt.adtProblem", Messages.Failed_To_Get_Output, 2);
                return iProjectArray;
            }
            object5 = AdtPlugin.getOsSdkFolder();
            if (((String)object5).length() == 0) {
                return iProjectArray;
            }
            Map<String, String> map2 = Sdk.getCurrent().getProjectApkConfigs(iProject);
            iJavaProject = null;
            if (!this.mPackageResources) {
                iJavaProject = iFolder.findMember("resources.ap_");
                if (iJavaProject == null || !iJavaProject.exists()) {
                    this.mPackageResources = true;
                    this.mBuildFinalPackage = true;
                } else if (map2 != null) {
                    set = map2.entrySet();
                    for (Map.Entry object42 : set) {
                        object2 = String.format("resources-%s.ap_", object42.getKey());
                        iJavaProject = iFolder.findMember((String)object2);
                        if (iJavaProject != null && (!(iJavaProject instanceof IFile) || iJavaProject.exists())) continue;
                        string = String.format(Messages.s_Missing_Repackaging, object2);
                        AdtPlugin.printBuildToConsole(2, iProject, string);
                        this.mPackageResources = true;
                        this.mBuildFinalPackage = true;
                        break;
                    }
                }
            }
            if (!(this.mConvertToDex || (iJavaProject = iFolder.findMember("classes.dex")) != null && iJavaProject.exists())) {
                this.mConvertToDex = true;
                this.mBuildFinalPackage = true;
            }
            set = ProjectHelper.getApkFilename(iProject, null);
            if (!this.mBuildFinalPackage) {
                iJavaProject = iFolder.findMember((String)((Object)set));
                if (iJavaProject == null || iJavaProject instanceof IFile && !iJavaProject.exists()) {
                    String string2 = String.format(Messages.s_Missing_Repackaging, set);
                    AdtPlugin.printBuildToConsole(2, iProject, string2);
                    this.mBuildFinalPackage = true;
                } else if (map2 != null) {
                    Set<Map.Entry<String, String>> set2 = map2.entrySet();
                    for (Object object22 : set2) {
                        string = ProjectHelper.getApkFilename(iProject, (String)object22.getKey());
                        iJavaProject = iFolder.findMember(string);
                        if (iJavaProject != null && (!(iJavaProject instanceof IFile) || iJavaProject.exists())) continue;
                        object = String.format(Messages.s_Missing_Repackaging, string);
                        AdtPlugin.printBuildToConsole(2, iProject, object);
                        this.mBuildFinalPackage = true;
                        break;
                    }
                }
            }
            if ((iContainer = iFolder.getParent()) != null) {
                iContainer.refreshLocal(1, iProgressMonitor);
            }
            if (this.mPackageResources || this.mConvertToDex || this.mBuildFinalPackage) {
                String string3;
                String string4;
                Object object3;
                Object object4;
                Object object6;
                Object object72;
                Object object8;
                Object object22;
                object22 = iFolder.getLocation();
                if (object22 == null) {
                    this.markProject("com.android.ide.eclipse.adt.adtProblem", Messages.Output_Missing, 2);
                    return iProjectArray;
                }
                object2 = object22.toOSString();
                string = String.valueOf(object2) + File.separator + set;
                object = new File(string);
                ((File)object).delete();
                if (map2 != null) {
                    object8 = map2.entrySet();
                    for (Object object72 : object8) {
                        object6 = String.valueOf(object2) + File.separator + ProjectHelper.getApkFilename(iProject, (String)object72.getKey());
                        object = new File((String)object6);
                        ((File)object).delete();
                    }
                }
                if (this.mPackageResources) {
                    this.removeMarkersFromContainer((IContainer)iProject, "com.android.ide.eclipse.common.aapt2Problem");
                    object8 = iProject.findMember("/AndroidManifest.xml");
                    if (object8 == null || !object8.exists()) {
                        object72 = String.format(Messages.s_File_Missing, "AndroidManifest.xml");
                        this.markProject("com.android.ide.eclipse.adt.adtProblem", (String)object72, 2);
                        return iProjectArray;
                    }
                    object72 = iProject.getFolder("/res");
                    object4 = iProject.getFolder("/assets");
                    if (!object4.exists()) {
                        object4 = null;
                    }
                    object6 = object72.getLocation();
                    object3 = object8.getLocation();
                    if (object6 != null && object3 != null) {
                        string4 = object6.toOSString();
                        string3 = object3.toOSString();
                        String string5 = null;
                        if (object4 != null) {
                            string5 = object4.getLocation().toOSString();
                        }
                        if (!this.executeAapt(iProject, string3, string4, string5, String.valueOf(object2) + File.separator + "resources.ap_", null)) {
                            return iProjectArray;
                        }
                        if (map2 != null) {
                            Set<Map.Entry<String, String>> set3 = map2.entrySet();
                            for (Map.Entry<String, String> entry : set3) {
                                String string6 = String.valueOf(object2) + File.separator + "resources-%s.ap_";
                                String string7 = String.format(string6, entry.getKey());
                                if (this.executeAapt(iProject, string3, string4, string5, string7, entry.getValue())) continue;
                                return iProjectArray;
                            }
                        }
                        this.mPackageResources = false;
                        this.saveProjectBooleanProperty(PROPERTY_PACKAGE_RESOURCES, this.mPackageResources);
                    }
                }
                if (this.mConvertToDex) {
                    if (!this.executeDx(iJavaProject2, (String)object2, String.valueOf(object2) + File.separator + "classes.dex", iJavaProjectArray)) {
                        return iProjectArray;
                    }
                    this.mConvertToDex = false;
                    this.saveProjectBooleanProperty(PROPERTY_CONVERT_TO_DEX, this.mConvertToDex);
                }
                object8 = String.valueOf(object2) + File.separator + "classes.dex";
                if (!this.finalPackage(String.valueOf(object2) + File.separator + "resources.ap_", (String)object8, string, iJavaProject2, iJavaProjectArray)) {
                    return iProjectArray;
                }
                if (map2 != null) {
                    object72 = String.valueOf(object2) + File.separator + "resources-%s.ap_";
                    object4 = map2.entrySet();
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object6 = (Map.Entry)object3.next();
                        string4 = String.format((String)object72, object6.getKey());
                        if (this.finalPackage(string4, (String)object8, string3 = String.valueOf(object2) + File.separator + ProjectHelper.getApkFilename(iProject, (String)object6.getKey()), iJavaProject2, iJavaProjectArray)) continue;
                        return iProjectArray;
                    }
                }
                iFolder.refreshLocal(1, iProgressMonitor);
                this.mBuildFinalPackage = false;
                this.saveProjectBooleanProperty(PROPERTY_BUILD_APK, this.mBuildFinalPackage);
                ApkInstallManager.getInstance().resetInstallationFor(iProject);
                AdtPlugin.printBuildToConsole(2, this.getProject(), "Build Success!");
            }
        }
        catch (Exception exception) {
            if (exception instanceof CoreException && ((CoreException)((Object)exception)).getStatus().getSeverity() == 8) {
                return iProjectArray;
            }
            String string = exception.getMessage();
            if (string == null) {
                string = exception.getClass().getCanonicalName();
            }
            string = String.format("Unknown error: %1$s", string);
            AdtPlugin.printErrorToConsole(iProject, new Object[]{string});
            this.markProject("com.android.ide.eclipse.adt.adtProblem", string, 2);
        }
        return iProjectArray;
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
        this.mConvertToDex = this.loadProjectBooleanProperty(PROPERTY_CONVERT_TO_DEX, true);
        this.mPackageResources = this.loadProjectBooleanProperty(PROPERTY_PACKAGE_RESOURCES, true);
        this.mBuildFinalPackage = this.loadProjectBooleanProperty(PROPERTY_BUILD_APK, true);
    }

    private boolean executeAapt(IProject iProject, String string, String string2, String string3, String string4, String string5) {
        Object object;
        int n;
        IAndroidTarget iAndroidTarget = Sdk.getCurrent().getTarget(iProject);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(iAndroidTarget.getPath(20));
        arrayList.add("package");
        arrayList.add("-f");
        if (AdtPlugin.getBuildVerbosity() == 2) {
            arrayList.add("-v");
        }
        if (string5 != null) {
            arrayList.add("-c");
            arrayList.add(string5);
        }
        arrayList.add("-M");
        arrayList.add(string);
        arrayList.add("-S");
        arrayList.add(string2);
        if (string3 != null) {
            arrayList.add("-A");
            arrayList.add(string3);
        }
        arrayList.add("-I");
        arrayList.add(iAndroidTarget.getPath(1));
        arrayList.add("-F");
        arrayList.add(string4);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        if (AdtPlugin.getBuildVerbosity() == 2) {
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray2 = stringArray;
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray2[n2];
                stringBuilder.append((String)object);
                stringBuilder.append(' ');
                ++n2;
            }
            AdtPlugin.printToConsole(iProject, stringBuilder.toString());
        }
        int n3 = 1;
        try {
            object = Runtime.getRuntime().exec(stringArray);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            n3 = this.grabProcessOutput((Process)object, arrayList2);
            n = this.parseAaptOutput(arrayList2, iProject) ? 1 : 0;
            if (n != 0) {
                if (n3 != 0) {
                    AdtPlugin.printErrorToConsole(iProject, arrayList2.toArray());
                } else {
                    AdtPlugin.printBuildToConsole(0, iProject, arrayList2.toArray());
                }
            }
            if (n3 != 0) {
                if (n != 0) {
                    this.markProject("com.android.ide.eclipse.adt.adtProblem", Messages.Unparsed_AAPT_Errors, 2);
                }
                return false;
            }
        }
        catch (IOException iOException) {
            object = String.format(Messages.AAPT_Exec_Error, stringArray[0]);
            this.markProject("com.android.ide.eclipse.adt.adtProblem", (String)object, 2);
            return false;
        }
        catch (InterruptedException interruptedException) {
            object = String.format(Messages.AAPT_Exec_Error, stringArray[0]);
            this.markProject("com.android.ide.eclipse.adt.adtProblem", (String)object, 2);
            return false;
        }
        return true;
    }

    private boolean executeDx(IJavaProject iJavaProject, String string, String string2, IJavaProject[] iJavaProjectArray) throws CoreException {
        String[] stringArray;
        IAndroidTarget iAndroidTarget = Sdk.getCurrent().getTarget(iJavaProject.getProject());
        AndroidTargetData androidTargetData = Sdk.getCurrent().getTargetData(iAndroidTarget);
        if (androidTargetData == null) {
            throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", Messages.ApkBuilder_UnableBuild_Dex_Not_loaded));
        }
        DexWrapper dexWrapper = androidTargetData.getDexWrapper();
        if (dexWrapper == null) {
            throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", Messages.ApkBuilder_UnableBuild_Dex_Not_loaded));
        }
        if (this.mOutStream == null) {
            stringArray = this.getProject();
            this.mOutStream = AdtPlugin.getOutPrintStream((IProject)stringArray, DX_PREFIX);
            this.mErrStream = AdtPlugin.getErrPrintStream((IProject)stringArray, DX_PREFIX);
        }
        try {
            stringArray = this.getExternalJars();
            String[] stringArray2 = this.getProjectOutputs(iJavaProjectArray);
            String[] stringArray3 = new String[1 + stringArray2.length + stringArray.length];
            stringArray3[0] = string;
            System.arraycopy(stringArray2, 0, stringArray3, 1, stringArray2.length);
            System.arraycopy(stringArray, 0, stringArray3, 1 + stringArray2.length, stringArray.length);
            int n = dexWrapper.run(string2, stringArray3, AdtPlugin.getBuildVerbosity() == 2, this.mOutStream, this.mErrStream);
            if (n != 0) {
                String string3 = String.format(Messages.Dalvik_Error_d, n);
                AdtPlugin.printErrorToConsole(this.getProject(), new Object[]{string3});
                this.markProject("com.android.ide.eclipse.adt.adtProblem", string3, 2);
                return false;
            }
        }
        catch (Throwable throwable) {
            String string4 = throwable.getMessage();
            if (string4 == null) {
                string4 = throwable.getClass().getCanonicalName();
            }
            string4 = String.format(Messages.Dalvik_Error_s, string4);
            AdtPlugin.printErrorToConsole(this.getProject(), new Object[]{string4});
            this.markProject("com.android.ide.eclipse.adt.adtProblem", string4, 2);
            if (throwable instanceof NoClassDefFoundError || throwable instanceof NoSuchMethodError) {
                AdtPlugin.printErrorToConsole(this.getProject(), new Object[]{Messages.Incompatible_VM_Warning, Messages.Requires_1_5_Error});
            }
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean finalPackage(String var1_1, String var2_2, String var3_3, final IJavaProject var4_4, IJavaProject[] var5_5) {
        var6_6 = null;
        try {
            block39: {
                block38: {
                    var7_7 = AdtPlugin.getDefault().getPreferenceStore();
                    var8_14 = var7_7.getString("com.android.ide.eclipse.adt.customDebugKeyStore");
                    if (var8_14 == null || !new File(var8_14).exists()) {
                        var8_14 = DebugKeyProvider.getDefaultKeyStoreOsPath();
                        AdtPlugin.printBuildToConsole(2, this.getProject(), new Object[]{Messages.ApkBuilder_Using_Default_Key});
                    } else {
                        AdtPlugin.printBuildToConsole(2, this.getProject(), new Object[]{String.format(Messages.ApkBuilder_Using_s_To_Sign, new Object[]{var8_14})});
                    }
                    var9_15 = new DebugKeyProvider(var8_14, null, new DebugKeyProvider.IKeyGenOutput(){

                        public void err(String string) {
                            AdtPlugin.printErrorToConsole(var4_4.getProject(), new Object[]{String.valueOf(Messages.ApkBuilder_Signing_Key_Creation_s) + string});
                        }

                        public void out(String string) {
                            AdtPlugin.printBuildToConsole(2, var4_4.getProject(), String.valueOf(Messages.ApkBuilder_Signing_Key_Creation_s) + string);
                        }
                    });
                    var10_16 = var9_15.getDebugKey();
                    var11_17 = (X509Certificate)var9_15.getCertificate();
                    if (var10_16 != null) break block38;
                    var12_18 = String.format(Messages.Final_Archive_Error_s, new Object[]{Messages.ApkBuilder_Unable_To_Gey_Key});
                    AdtPlugin.printErrorToConsole(var4_4.getProject(), new Object[]{var12_18});
                    this.markProject("com.android.ide.eclipse.adt.adtProblem", var12_18, 2);
                    ** GOTO lbl116
                }
                if (var11_17 == null || var11_17.getNotAfter().compareTo(new Date()) >= 0) break block39;
                var12_19 = String.format(Messages.Final_Archive_Error_s, new Object[]{String.format(Messages.ApkBuilder_Certificate_Expired_on_s, new Object[]{DateFormat.getInstance().format(var11_17.getNotAfter())})});
                AdtPlugin.printErrorToConsole(var4_4.getProject(), new Object[]{var12_19});
                this.markProject("com.android.ide.eclipse.adt.adtProblem", var12_19, 2);
                ** GOTO lbl116
            }
            var6_6 = new FileOutputStream(var3_3);
            var12_20 = new SignedJarBuilder((OutputStream)var6_6, var10_16, var11_17);
            AdtPlugin.printBuildToConsole(2, this.getProject(), new Object[]{String.format(Messages.ApkBuilder_Packaging_s, new Object[]{var1_1})});
            var13_21 = new FileInputStream(var1_1);
            try {
                var12_20.writeZip((InputStream)var13_21, null);
            }
            finally {
                var13_21.close();
            }
            AdtPlugin.printBuildToConsole(2, this.getProject(), new Object[]{String.format(Messages.ApkBuilder_Packaging_s, new Object[]{"classes.dex"})});
            var14_23 = new File(var2_2);
            var12_20.writeFile(var14_23, "classes.dex");
            this.writeStandardResources(var12_20, var4_4, var5_5);
            var18_24 = this.getExternalJars();
            var17_25 = var18_24.length;
            var16_26 = 0;
            while (true) {
                if (var16_26 >= var17_25) {
                    var15_27 = var4_4.getProject().findMember("libs");
                    if (var15_27 != null && var15_27.exists() && var15_27.getType() == 2) {
                        this.writeNativeLibraries(var15_27.getFullPath().segmentCount(), var12_20, (IResource)var15_27);
                    }
                    var12_20.close();
                    break;
                }
                var15_27 = var18_24[var16_26];
                AdtPlugin.printBuildToConsole(2, this.getProject(), new Object[]{String.format(Messages.ApkBuilder_Packaging_s, new Object[]{var15_27})});
                try {
                    var13_21 = new FileInputStream(var15_27);
                    var12_20.writeZip((InputStream)var13_21, this.mJavaResourcesFilter);
                }
                finally {
                    var13_21.close();
                }
                ++var16_26;
            }
        }
        catch (GeneralSecurityException var7_8) {
            var8_14 = String.format(Messages.Final_Archive_Error_s, new Object[]{var7_8.getMessage()});
            AdtPlugin.printErrorToConsole(var4_4.getProject(), new Object[]{var8_14});
            this.markProject("com.android.ide.eclipse.adt.adtProblem", var8_14, 2);
            ** GOTO lbl116
        }
        catch (IOException var7_9) {
            var8_14 = String.format(Messages.Final_Archive_Error_s, new Object[]{var7_9.getMessage()});
            AdtPlugin.printErrorToConsole(var4_4.getProject(), new Object[]{var8_14});
            this.markProject("com.android.ide.eclipse.adt.adtProblem", var8_14, 2);
            ** GOTO lbl116
        }
        catch (DebugKeyProvider.KeytoolException var7_10) {
            var8_14 = var7_10.getMessage();
            var9_15 = String.format(Messages.Final_Archive_Error_s, new Object[]{var8_14});
            this.markProject("com.android.ide.eclipse.adt.adtProblem", var9_15, 2);
            AdtPlugin.printErrorToConsole(var4_4.getProject(), new Object[]{var9_15, String.format(Messages.ApkBuilder_JAVA_HOME_is_s, new Object[]{var7_10.getJavaHome()}), Messages.ApkBuilder_Update_or_Execute_manually_s, var7_10.getCommandLine()});
            if (var6_6 == null) return true;
            try {
                var6_6.close();
                return true;
            }
            catch (IOException v0) {
                return true;
            }
        }
        catch (AndroidLocation.AndroidLocationException var7_11) {
            var8_14 = var7_11.getMessage();
            var9_15 = String.format(Messages.Final_Archive_Error_s, new Object[]{var8_14});
            this.markProject("com.android.ide.eclipse.adt.adtProblem", var9_15, 2);
            AdtPlugin.printErrorToConsole(var4_4.getProject(), new Object[]{var9_15});
            if (var6_6 == null) return true;
            {
                catch (Throwable var20_29) {
                    if (var6_6 == null) throw var20_29;
                    try {
                        var6_6.close();
                        throw var20_29;
                    }
                    catch (IOException v1) {}
                    throw var20_29;
                }
            }
            try {
                var6_6.close();
                return true;
            }
            catch (IOException v2) {
                return true;
            }
            catch (CoreException var7_12) {
                block37: {
                    var8_14 = String.format(Messages.Final_Archive_Error_s, new Object[]{var7_12.getMessage()});
                    AdtPlugin.printErrorToConsole(var4_4.getProject(), new Object[]{var8_14});
                    this.markProject("com.android.ide.eclipse.adt.adtProblem", var8_14, 2);
                    break block37;
                    catch (Exception var7_13) {
                        var8_14 = var7_13.getMessage();
                        if (var8_14 == null) {
                            var8_14 = var7_13.getClass().getCanonicalName();
                        }
                        var8_14 = String.format("Unknown error: %1$s", new Object[]{var8_14});
                        AdtPlugin.printErrorToConsole(var4_4.getProject(), new Object[]{var8_14});
                        this.markProject("com.android.ide.eclipse.adt.adtProblem", var8_14, 2);
                    }
                }
                if (var6_6 == null) return false;
                try {
                    var6_6.close();
                    return false;
                }
                catch (IOException v3) {}
                return false;
            }
        }
        if (var6_6 == null) return true;
        try {
            var6_6.close();
            return true;
        }
        catch (IOException v4) {}
        return true;
    }

    private void writeNativeLibraries(int n, SignedJarBuilder signedJarBuilder, IResource iResource) throws CoreException, IOException {
        if (iResource.getType() == 1) {
            IPath iPath = iResource.getFullPath();
            String string = iPath.getFileExtension();
            if (string != null && string.equalsIgnoreCase("so")) {
                iPath = iPath.removeFirstSegments(n);
                Path path = new Path("lib");
                path = path.append(iPath);
                signedJarBuilder.writeFile(iResource.getLocation().toFile(), path.toString());
            }
        } else if (iResource.getType() == 2 && ApkBuilder.checkFolderForPackaging((IFolder)iResource)) {
            IResource[] iResourceArray;
            IResource[] iResourceArray2 = iResourceArray = ((IFolder)iResource).members();
            int n2 = iResourceArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IResource iResource2 = iResourceArray2[n3];
                this.writeNativeLibraries(n, signedJarBuilder, iResource2);
                ++n3;
            }
        }
    }

    private void writeStandardResources(SignedJarBuilder signedJarBuilder, IJavaProject iJavaProject, IJavaProject[] iJavaProjectArray) throws IOException, CoreException {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.writeStandardProjectResources(signedJarBuilder, iJavaProject, iWorkspaceRoot, arrayList);
        IJavaProject[] iJavaProjectArray2 = iJavaProjectArray;
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject iJavaProject2 = iJavaProjectArray2[n2];
            if (!iJavaProject2.getProject().hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                this.writeStandardProjectResources(signedJarBuilder, iJavaProject2, iWorkspaceRoot, arrayList);
            }
            ++n2;
        }
    }

    private void writeStandardProjectResources(SignedJarBuilder signedJarBuilder, IJavaProject iJavaProject, IWorkspaceRoot iWorkspaceRoot, ArrayList<String> arrayList) throws IOException {
        ArrayList<IPath> arrayList2 = BaseProjectHelper.getSourceClasspaths(iJavaProject);
        for (IPath iPath : arrayList2) {
            IResource iResource = iWorkspaceRoot.findMember(iPath);
            if (iResource == null || iResource.getType() != 2) continue;
            this.writeStandardSourceFolderResources(signedJarBuilder, iPath, (IFolder)iResource, arrayList);
        }
    }

    private void writeStandardSourceFolderResources(SignedJarBuilder signedJarBuilder, IPath iPath, IFolder iFolder, ArrayList<String> arrayList) throws IOException {
        try {
            IResource[] iResourceArray;
            IResource[] iResourceArray2 = iResourceArray = iFolder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray2[n2];
                int n3 = iResource.getType();
                if (n3 == 1 && iResource.exists()) {
                    if (ApkBuilder.checkFileForPackaging((IFile)iResource)) {
                        IPath iPath2 = iResource.getFullPath();
                        IPath iPath3 = iPath2.removeFirstSegments(iPath.segmentCount());
                        String string = iPath3.toString();
                        if (arrayList.indexOf(string) != -1) {
                            AdtPlugin.printErrorToConsole(this.getProject(), new Object[]{String.format(Messages.ApkBuilder_s_Conflict_with_file_s, iPath2, string)});
                        } else {
                            File file = iResource.getLocation().toFile();
                            AdtPlugin.printBuildToConsole(2, this.getProject(), String.format(Messages.ApkBuilder_Packaging_s_into_s, iPath2, string));
                            signedJarBuilder.writeFile(file, string);
                            arrayList.add(string);
                        }
                    }
                } else if (n3 == 2 && ApkBuilder.checkFolderForPackaging((IFolder)iResource)) {
                    this.writeStandardSourceFolderResources(signedJarBuilder, iPath, (IFolder)iResource, arrayList);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    private String[] getProjectOutputs(IJavaProject[] iJavaProjectArray) throws CoreException {
        ArrayList<String> arrayList = new ArrayList<String>();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        IJavaProject[] iJavaProjectArray2 = iJavaProjectArray;
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IJavaProject iJavaProject = iJavaProjectArray2[n2];
                if (!iJavaProject.getProject().hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                    IPath iPath = null;
                    try {
                        iPath = iJavaProject.getOutputLocation();
                    }
                    catch (JavaModelException javaModelException) {
                        break block5;
                    }
                    IResource iResource = iWorkspaceRoot.findMember(iPath);
                    if (iResource != null && iResource.getType() == 2) {
                        String string = iResource.getLocation().toOSString();
                        arrayList.add(string);
                    }
                }
            }
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private IJavaProject[] getJavaProjects(IProject[] iProjectArray) throws CoreException {
        ArrayList<IJavaProject> arrayList = new ArrayList<IJavaProject>();
        IProject[] iProjectArray2 = iProjectArray;
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray2[n2];
            if (iProject.isOpen() && iProject.hasNature("org.eclipse.jdt.core.javanature")) {
                arrayList.add(JavaCore.create((IProject)iProject));
            }
            ++n2;
        }
        return arrayList.toArray(new IJavaProject[arrayList.size()]);
    }

    static boolean checkFileForPackaging(IFile iFile) {
        String string = iFile.getName();
        String string2 = iFile.getFileExtension();
        return JavaResourceFilter.checkFileForPackaging((String)string, (String)string2);
    }

    static boolean checkFolderForPackaging(IFolder iFolder) {
        String string = iFolder.getName();
        return JavaResourceFilter.checkFolderForPackaging((String)string);
    }

    @Override
    protected void abortOnBadSetup(IProject iProject) throws CoreException {
        super.abortOnBadSetup(iProject);
        IMarker[] iMarkerArray = iProject.findMarkers(null, false, 0);
        if (iMarkerArray.length > 0) {
            this.stopBuild("", new Object[0]);
        }
    }

    private static class ReferencedProjectDeltaVisitor
    implements IResourceDeltaVisitor {
        private boolean mConvertToDex = false;
        private boolean mMakeFinalPackage;
        private IPath mOutputFolder;
        private ArrayList<IPath> mSourceFolders;

        private ReferencedProjectDeltaVisitor(IJavaProject iJavaProject) {
            try {
                this.mOutputFolder = iJavaProject.getOutputLocation();
                this.mSourceFolders = BaseProjectHelper.getSourceClasspaths(iJavaProject);
            }
            catch (JavaModelException javaModelException) {}
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            if (this.mConvertToDex && this.mMakeFinalPackage) {
                return false;
            }
            IResource iResource = iResourceDelta.getResource();
            IPath iPath = iResource.getFullPath();
            if (this.mOutputFolder.isPrefixOf(iPath)) {
                String string;
                int n = iResource.getType();
                if (n == 1 && "class".equals(string = iResource.getFileExtension())) {
                    this.mConvertToDex = true;
                }
                return true;
            }
            for (IPath iPath2 : this.mSourceFolders) {
                if (!iPath2.isPrefixOf(iPath)) continue;
                int n = iResource.getType();
                if (n == 1) {
                    if (ApkBuilder.checkFileForPackaging((IFile)iResource)) {
                        this.mMakeFinalPackage = true;
                    }
                    return false;
                }
                if (n != 2) continue;
                return ApkBuilder.checkFolderForPackaging((IFolder)iResource);
            }
            return true;
        }

        boolean needDexConvertion() {
            return this.mConvertToDex;
        }

        boolean needMakeFinalPackage() {
            return this.mMakeFinalPackage;
        }
    }
}

