/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.ui;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResourceItem;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFile;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceMonitor;
import com.android.ide.eclipse.adt.internal.ui.ResourceContentProvider;
import com.android.ide.eclipse.adt.internal.ui.ResourceLabelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class ResourceExplorerView
extends ViewPart
implements ISelectionListener,
ResourceMonitor.IResourceEventListener {
    private static final String PREFS_COLUMN_RES = "com.android.ide.eclipse.editorsResourceExplorer.Col1";
    private static final String PREFS_COLUMN_2 = "com.android.ide.eclipse.editorsResourceExplorer.Col2";
    private Tree mTree;
    private TreeViewer mTreeViewer;
    private IProject mCurrentProject;

    public void createPartControl(Composite composite) {
        this.mTree = new Tree(composite, 0x10000004);
        this.mTree.setLayoutData((Object)new GridData(1808));
        this.mTree.setHeaderVisible(true);
        this.mTree.setLinesVisible(true);
        IPreferenceStore iPreferenceStore = AdtPlugin.getDefault().getPreferenceStore();
        this.createTreeColumn(this.mTree, "Resources", 16384, "abcdefghijklmnopqrstuvwxz", -1, PREFS_COLUMN_RES, iPreferenceStore);
        this.createTreeColumn(this.mTree, "Info", 16384, "0123456789", -1, PREFS_COLUMN_2, iPreferenceStore);
        this.mTreeViewer = new TreeViewer(this.mTree);
        this.mTreeViewer.setContentProvider((IContentProvider)new ResourceContentProvider(true));
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
        IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
        iWorkbenchPage.addSelectionListener((ISelectionListener)this);
        this.selectionChanged(this.getSite().getPart(), iWorkbenchPage.getSelection());
        this.mTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                IStructuredSelection iStructuredSelection;
                ISelection iSelection = doubleClickEvent.getSelection();
                if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1) {
                    ResourceFile[] resourceFileArray;
                    ProjectResourceItem projectResourceItem;
                    Object object = iStructuredSelection.getFirstElement();
                    if (object instanceof ResourceFile) {
                        try {
                            IDE.openEditor((IWorkbenchPage)ResourceExplorerView.this.getSite().getWorkbenchWindow().getActivePage(), (IFile)((ResourceFile)object).getFile().getIFile());
                        }
                        catch (PartInitException partInitException) {}
                    } else if (object instanceof ProjectResourceItem && (projectResourceItem = (ProjectResourceItem)object).isEditableDirectly() && (resourceFileArray = projectResourceItem.getSourceFileArray())[0] != null) {
                        try {
                            IDE.openEditor((IWorkbenchPage)ResourceExplorerView.this.getSite().getWorkbenchWindow().getActivePage(), (IFile)resourceFileArray[0].getFile().getIFile());
                        }
                        catch (PartInitException partInitException) {}
                    }
                }
            }
        });
        AdtPlugin.getDefault().getResourceMonitor().addResourceEventListener(this);
    }

    public void dispose() {
        AdtPlugin.getDefault().getResourceMonitor().removeResourceEventListener(this);
        super.dispose();
    }

    public void setFocus() {
        this.mTree.setFocus();
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart instanceof IEditorPart) {
            IEditorInput iEditorInput = ((IEditorPart)iWorkbenchPart).getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
                IProject iProject = iFile.getProject();
                this.handleProjectSelection(iProject);
            }
        } else if (iSelection instanceof IStructuredSelection) {
            for (Object e : (IStructuredSelection)iSelection) {
                IProject iProject = null;
                if (e instanceof IResource) {
                    iProject = ((IResource)e).getProject();
                } else if (e instanceof IJavaElement) {
                    IJavaElement iJavaElement = (IJavaElement)e;
                    IJavaProject iJavaProject = iJavaElement.getJavaProject();
                    if (iJavaProject != null) {
                        iProject = iJavaProject.getProject();
                    }
                } else if (e instanceof IAdaptable) {
                    iProject = (IProject)((IAdaptable)e).getAdapter(IProject.class);
                }
                if (iProject == null || !this.handleProjectSelection(iProject)) continue;
                return;
            }
        }
    }

    private boolean handleProjectSelection(IProject iProject) {
        try {
            ProjectResources projectResources;
            if (iProject.hasNature("com.android.ide.eclipse.adt.AndroidNature") && this.mCurrentProject != iProject && (projectResources = ResourceManager.getInstance().getProjectResources(iProject)) != null) {
                this.mTreeViewer.setInput((Object)projectResources);
                this.mCurrentProject = iProject;
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public void createTreeColumn(Tree tree, String string, int n, String string2, int n2, final String string3, final IPreferenceStore iPreferenceStore) {
        TreeColumn treeColumn = new TreeColumn(tree, n);
        if (n2 != -1) {
            treeColumn.setWidth(n2);
            treeColumn.setResizable(false);
        } else {
            if (iPreferenceStore == null || !iPreferenceStore.contains(string3)) {
                treeColumn.setText(string2);
                treeColumn.pack();
                if (iPreferenceStore != null) {
                    iPreferenceStore.setValue(string3, treeColumn.getWidth());
                }
            } else {
                treeColumn.setWidth(iPreferenceStore.getInt(string3));
            }
            if (iPreferenceStore != null && string3 != null) {
                treeColumn.addControlListener(new ControlListener(){

                    public void controlMoved(ControlEvent controlEvent) {
                    }

                    public void controlResized(ControlEvent controlEvent) {
                        int n = ((TreeColumn)controlEvent.widget).getWidth();
                        iPreferenceStore.setValue(string3, n);
                    }
                });
            }
        }
        treeColumn.setText(string);
    }

    public void resourceChangeEventStart() {
    }

    public void resourceChangeEventEnd() {
        try {
            this.mTree.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!ResourceExplorerView.this.mTree.isDisposed()) {
                        ResourceExplorerView.this.mTreeViewer.refresh();
                    }
                }
            });
        }
        catch (SWTException sWTException) {}
    }
}

