/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.sdk;

import com.android.ide.eclipse.adt.internal.editors.descriptors.IDescriptorProvider;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.LayoutDescriptors;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.AndroidManifestDescriptors;
import com.android.ide.eclipse.adt.internal.editors.menu.descriptors.MenuDescriptors;
import com.android.ide.eclipse.adt.internal.editors.resources.descriptors.ResourcesDescriptors;
import com.android.ide.eclipse.adt.internal.editors.xml.descriptors.XmlDescriptors;
import com.android.ide.eclipse.adt.internal.resources.IResourceRepository;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.sdk.DexWrapper;
import com.android.ide.eclipse.adt.internal.sdk.LoadStatus;
import com.android.layoutlib.api.ILayoutBridge;
import com.android.sdklib.IAndroidTarget;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidTargetData {
    public static final int DESCRIPTOR_MANIFEST = 1;
    public static final int DESCRIPTOR_LAYOUT = 2;
    public static final int DESCRIPTOR_MENU = 3;
    public static final int DESCRIPTOR_XML = 4;
    public static final int DESCRIPTOR_RESOURCES = 5;
    public static final int DESCRIPTOR_SEARCHABLE = 6;
    public static final int DESCRIPTOR_PREFERENCES = 7;
    public static final int DESCRIPTOR_APPWIDGET_PROVIDER = 8;
    private final IAndroidTarget mTarget;
    private DexWrapper mDexWrapper;
    private Hashtable<String, String[]> mAttributeValues = new Hashtable();
    private IResourceRepository mSystemResourceRepository;
    private AndroidManifestDescriptors mManifestDescriptors;
    private LayoutDescriptors mLayoutDescriptors;
    private MenuDescriptors mMenuDescriptors;
    private XmlDescriptors mXmlDescriptors;
    private Map<String, Map<String, Integer>> mEnumValueMap;
    private ProjectResources mFrameworkResources;
    private LayoutBridge mLayoutBridge;
    private boolean mLayoutBridgeInit = false;

    AndroidTargetData(IAndroidTarget iAndroidTarget) {
        this.mTarget = iAndroidTarget;
    }

    void setDexWrapper(DexWrapper dexWrapper) {
        this.mDexWrapper = dexWrapper;
    }

    void setExtraData(IResourceRepository iResourceRepository, AndroidManifestDescriptors androidManifestDescriptors, LayoutDescriptors layoutDescriptors, MenuDescriptors menuDescriptors, XmlDescriptors xmlDescriptors, Map<String, Map<String, Integer>> map, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, IAndroidTarget.IOptionalLibrary[] iOptionalLibraryArray, ProjectResources projectResources, LayoutBridge layoutBridge) {
        this.mSystemResourceRepository = iResourceRepository;
        this.mManifestDescriptors = androidManifestDescriptors;
        this.mLayoutDescriptors = layoutDescriptors;
        this.mMenuDescriptors = menuDescriptors;
        this.mXmlDescriptors = xmlDescriptors;
        this.mEnumValueMap = map;
        this.mFrameworkResources = projectResources;
        this.mLayoutBridge = layoutBridge;
        this.setPermissions(stringArray);
        this.setIntentFilterActionsAndCategories(stringArray2, stringArray3, stringArray4, stringArray5);
        this.setOptionalLibraries(stringArray6, iOptionalLibraryArray);
    }

    public DexWrapper getDexWrapper() {
        return this.mDexWrapper;
    }

    public IResourceRepository getSystemResources() {
        return this.mSystemResourceRepository;
    }

    public IDescriptorProvider getDescriptorProvider(int n) {
        switch (n) {
            case 1: {
                return this.mManifestDescriptors;
            }
            case 2: {
                return this.mLayoutDescriptors;
            }
            case 3: {
                return this.mMenuDescriptors;
            }
            case 4: {
                return this.mXmlDescriptors;
            }
            case 5: {
                return ResourcesDescriptors.getInstance();
            }
            case 7: {
                return this.mXmlDescriptors.getPreferencesProvider();
            }
            case 8: {
                return this.mXmlDescriptors.getAppWidgetProvider();
            }
            case 6: {
                return this.mXmlDescriptors.getSearchableProvider();
            }
        }
        throw new IllegalArgumentException();
    }

    public AndroidManifestDescriptors getManifestDescriptors() {
        return this.mManifestDescriptors;
    }

    public LayoutDescriptors getLayoutDescriptors() {
        return this.mLayoutDescriptors;
    }

    public MenuDescriptors getMenuDescriptors() {
        return this.mMenuDescriptors;
    }

    public XmlDescriptors getXmlDescriptors() {
        return this.mXmlDescriptors;
    }

    public String[] getAttributeValues(String string, String string2) {
        String string3 = String.format("(%1$s,%2$s)", string, string2);
        return this.mAttributeValues.get(string3);
    }

    public String[] getAttributeValues(String string, String string2, String string3) {
        String string4;
        String[] stringArray;
        if (string3 != null && (stringArray = this.mAttributeValues.get(string4 = String.format("(%1$s,%2$s,%3$s)", string3, string, string2))) != null) {
            return stringArray;
        }
        return this.getAttributeValues(string, string2);
    }

    public Map<String, Map<String, Integer>> getEnumValueMap() {
        return this.mEnumValueMap;
    }

    public ProjectResources getFrameworkResources() {
        return this.mFrameworkResources;
    }

    public synchronized LayoutBridge getLayoutBridge() {
        if (!this.mLayoutBridgeInit && this.mLayoutBridge.bridge != null) {
            this.mLayoutBridge.bridge.init(this.mTarget.getPath(12), this.getEnumValueMap());
            this.mLayoutBridgeInit = true;
        }
        return this.mLayoutBridge;
    }

    private void setPermissions(String[] stringArray) {
        this.setValues("(uses-permission,android:name)", stringArray);
        this.setValues("(application,android:permission)", stringArray);
        this.setValues("(activity,android:permission)", stringArray);
        this.setValues("(receiver,android:permission)", stringArray);
        this.setValues("(service,android:permission)", stringArray);
        this.setValues("(provider,android:permission)", stringArray);
    }

    private void setIntentFilterActionsAndCategories(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        this.setValues("(activity,action,android:name)", stringArray);
        this.setValues("(receiver,action,android:name)", stringArray2);
        this.setValues("(service,action,android:name)", stringArray3);
        this.setValues("(category,android:name)", stringArray4);
    }

    private void setOptionalLibraries(String[] stringArray, IAndroidTarget.IOptionalLibrary[] iOptionalLibraryArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                arrayList.add(string);
                ++n2;
            }
        }
        if (iOptionalLibraryArray != null) {
            int n = 0;
            while (n < iOptionalLibraryArray.length) {
                arrayList.add(iOptionalLibraryArray[n].getName());
                ++n;
            }
        }
        this.setValues("(uses-library,android:name)", arrayList.toArray(new String[arrayList.size()]));
    }

    private void setValues(String string, String[] stringArray) {
        this.mAttributeValues.remove(string);
        this.mAttributeValues.put(string, stringArray);
    }

    public static final class LayoutBridge {
        public ILayoutBridge bridge;
        public LoadStatus status = LoadStatus.LOADING;
        public ClassLoader classLoader;
        public int apiLevel;
    }
}

