/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectClassLoader
extends ClassLoader {
    private final IJavaProject mJavaProject;
    private URLClassLoader mJarClassLoader;
    private boolean mInsideJarClassLoader = false;

    public ProjectClassLoader(ClassLoader classLoader, IProject iProject) {
        super(classLoader);
        this.mJavaProject = JavaCore.create((IProject)iProject);
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        try {
            Class<?> clazz;
            String[] stringArray;
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IPath iPath = this.mJavaProject.getOutputLocation();
            IResource iResource = iWorkspaceRoot.findMember(iPath);
            if (iResource == null) {
                throw new ClassNotFoundException(string);
            }
            File file = new File(iResource.getLocation().toOSString());
            File file2 = this.getFile(file, stringArray = string.split("\\."), 0);
            if (file2 == null) {
                if (!this.mInsideJarClassLoader) {
                    return this.loadClassFromJar(string);
                }
                throw new ClassNotFoundException(string);
            }
            FileInputStream fileInputStream = new FileInputStream(file2);
            byte[] byArray = new byte[(int)file2.length()];
            int n = 0;
            try {
                n = fileInputStream.read(byArray);
            }
            catch (IOException iOException) {
                byArray = null;
            }
            fileInputStream.close();
            if (byArray != null && (clazz = this.defineClass(null, byArray, 0, n)) != null) {
                return clazz;
            }
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(exception.getMessage());
        }
        throw new ClassNotFoundException(string);
    }

    private File getFile(File file, String[] stringArray, int n) throws FileNotFoundException {
        if (n == stringArray.length) {
            throw new FileNotFoundException();
        }
        String string = stringArray[n];
        File[] fileArray = file.listFiles();
        if (n == stringArray.length - 1) {
            string = String.valueOf(string) + ".class";
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                int n2 = fileArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    File file2 = fileArray2[n3];
                    if (file2.isFile() && file2.getName().equals(string)) {
                        return file2;
                    }
                    ++n3;
                }
            }
            throw new FileNotFoundException();
        }
        String string2 = null;
        if (fileArray != null) {
            File[] fileArray3 = fileArray;
            int n4 = fileArray.length;
            int n5 = 0;
            while (n5 < n4) {
                File file3 = fileArray3[n5];
                if (file3.isDirectory()) {
                    if (string.equals(file3.getName())) {
                        return this.getFile(file3, stringArray, n + 1);
                    }
                } else if (file3.getName().startsWith(string)) {
                    if (string2 == null) {
                        StringBuilder stringBuilder = new StringBuilder(stringArray[n]);
                        int n6 = n + 1;
                        while (n6 < stringArray.length) {
                            stringBuilder.append('$');
                            stringBuilder.append(stringArray[n6]);
                            ++n6;
                        }
                        stringBuilder.append(".class");
                        string2 = stringBuilder.toString();
                    }
                    if (file3.getName().equals(string2)) {
                        return file3;
                    }
                }
                ++n5;
            }
        }
        return null;
    }

    private Class<?> loadClassFromJar(String string) throws ClassNotFoundException {
        if (this.mJarClassLoader == null) {
            URL[] uRLArray = this.getExternalJars();
            this.mJarClassLoader = new URLClassLoader(uRLArray, (ClassLoader)this);
        }
        try {
            this.mInsideJarClassLoader = true;
            Class<?> clazz = this.mJarClassLoader.loadClass(string);
            return clazz;
        }
        finally {
            this.mInsideJarClassLoader = false;
        }
    }

    private final URL[] getExternalJars() {
        IJavaProject iJavaProject = JavaCore.create((IProject)this.mJavaProject.getProject());
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.readRawClasspath();
        if (iClasspathEntryArray != null) {
            IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray;
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n2];
                if (iClasspathEntry.getEntryKind() == 1 || iClasspathEntry.getEntryKind() == 4) {
                    IPath iPath;
                    if (iClasspathEntry.getEntryKind() == 4) {
                        iClasspathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntry);
                    }
                    if ("jar".equalsIgnoreCase((iPath = iClasspathEntry.getPath()).getFileExtension())) {
                        String string;
                        File file;
                        boolean bl = false;
                        IResource iResource = iWorkspaceRoot.findMember(iPath);
                        if (iResource != null && iResource.exists() && iResource.getType() == 1) {
                            bl = true;
                            try {
                                arrayList.add(new File(iResource.getLocation().toOSString()).toURL());
                            }
                            catch (MalformedURLException malformedURLException) {}
                        }
                        if (!bl && (file = new File(string = iPath.toOSString())).exists()) {
                            try {
                                arrayList.add(file.toURL());
                            }
                            catch (MalformedURLException malformedURLException) {}
                        }
                    }
                }
                ++n2;
            }
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }
}

