/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import com.android.ide.eclipse.adt.internal.resources.ResourceType;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolderType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FolderTypeRelationship {
    private static final HashMap<ResourceType, ResourceFolderType[]> mTypeToFolderMap = new HashMap();
    private static final HashMap<ResourceFolderType, ResourceType[]> mFolderToTypeMap = new HashMap();

    static {
        HashMap<ResourceType, List<ResourceFolderType>> hashMap = new HashMap<ResourceType, List<ResourceFolderType>>();
        HashMap<ResourceFolderType, List<ResourceType>> hashMap2 = new HashMap<ResourceFolderType, List<ResourceType>>();
        FolderTypeRelationship.add(ResourceType.ANIM, ResourceFolderType.ANIM, hashMap, hashMap2);
        FolderTypeRelationship.add(ResourceType.ARRAY, ResourceFolderType.VALUES, hashMap, hashMap2);
        FolderTypeRelationship.add(ResourceType.COLOR, ResourceFolderType.VALUES, hashMap, hashMap2);
        FolderTypeRelationship.add(ResourceType.COLOR, ResourceFolderType.COLOR, hashMap, hashMap2);
        FolderTypeRelationship.add(ResourceType.DIMEN, ResourceFolderType.VALUES, hashMap, hashMap2);
        FolderTypeRelationship.add(ResourceType.DRAWABLE, ResourceFolderType.VALUES, hashMap, hashMap2);
        FolderTypeRelationship.add(ResourceType.DRAWABLE, ResourceFolderType.DRAWABLE, hashMap, hashMap2);
        FolderTypeRelationship.add(ResourceType.ID, ResourceFolderType.VALUES, hashMap, hashMap2);
        FolderTypeRelationship.add(ResourceType.LAYOUT, ResourceFolderType.LAYOUT, hashMap, hashMap2);
        FolderTypeRelationship.add(ResourceType.MENU, ResourceFolderType.MENU, hashMap, hashMap2);
        FolderTypeRelationship.add(ResourceType.RAW, ResourceFolderType.RAW, hashMap, hashMap2);
        FolderTypeRelationship.add(ResourceType.STRING, ResourceFolderType.VALUES, hashMap, hashMap2);
        FolderTypeRelationship.add(ResourceType.STYLE, ResourceFolderType.VALUES, hashMap, hashMap2);
        FolderTypeRelationship.add(ResourceType.XML, ResourceFolderType.XML, hashMap, hashMap2);
        FolderTypeRelationship.optimize(hashMap, hashMap2);
    }

    public static ResourceType[] getRelatedResourceTypes(ResourceFolderType resourceFolderType) {
        ResourceType[] resourceTypeArray = mFolderToTypeMap.get((Object)resourceFolderType);
        if (resourceTypeArray != null) {
            return resourceTypeArray;
        }
        return new ResourceType[0];
    }

    public static ResourceFolderType[] getRelatedFolders(ResourceType resourceType) {
        ResourceFolderType[] resourceFolderTypeArray = mTypeToFolderMap.get((Object)resourceType);
        if (resourceFolderTypeArray != null) {
            return resourceFolderTypeArray;
        }
        return new ResourceFolderType[0];
    }

    public static boolean match(ResourceType resourceType, ResourceFolderType resourceFolderType) {
        ResourceFolderType[] resourceFolderTypeArray = mTypeToFolderMap.get((Object)resourceType);
        if (resourceFolderTypeArray != null && resourceFolderTypeArray.length > 0) {
            ResourceFolderType[] resourceFolderTypeArray2 = resourceFolderTypeArray;
            int n = resourceFolderTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceFolderType resourceFolderType2 = resourceFolderTypeArray2[n2];
                if (resourceFolderType2 == resourceFolderType) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static void add(ResourceType resourceType, ResourceFolderType resourceFolderType, HashMap<ResourceType, List<ResourceFolderType>> hashMap, HashMap<ResourceFolderType, List<ResourceType>> hashMap2) {
        List<ResourceType> list;
        List<ResourceFolderType> list2 = hashMap.get((Object)resourceType);
        if (list2 == null) {
            list2 = new ArrayList<ResourceFolderType>();
            hashMap.put(resourceType, list2);
        }
        if (list2.indexOf((Object)resourceFolderType) == -1) {
            list2.add(resourceFolderType);
        }
        if ((list = hashMap2.get((Object)resourceFolderType)) == null) {
            list = new ArrayList<ResourceType>();
            hashMap2.put(resourceFolderType, list);
        }
        if (list.indexOf((Object)resourceType) == -1) {
            list.add(resourceType);
        }
    }

    private static void optimize(HashMap<ResourceType, List<ResourceFolderType>> hashMap, HashMap<ResourceFolderType, List<ResourceType>> hashMap2) {
        Set<ResourceType> set = hashMap.keySet();
        for (ResourceType resourceType : set) {
            List<ResourceFolderType> list = hashMap.get((Object)resourceType);
            mTypeToFolderMap.put(resourceType, list.toArray(new ResourceFolderType[list.size()]));
        }
        Set<ResourceFolderType> set2 = hashMap2.keySet();
        for (ResourceFolderType resourceFolderType : set2) {
            List<ResourceType> list = hashMap2.get((Object)resourceFolderType);
            mFolderToTypeMap.put(resourceFolderType, list.toArray(new ResourceType[list.size()]));
        }
    }
}

