/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Image;

public final class PixelDensityQualifier
extends ResourceQualifier {
    private static final Pattern sDensityLegacyPattern = Pattern.compile("^(\\d+)dpi$");
    public static final String NAME = "Pixel Density";
    private Density mValue = Density.MEDIUM;

    public PixelDensityQualifier() {
    }

    public PixelDensityQualifier(Density density) {
        this.mValue = density;
    }

    public Density getValue() {
        return this.mValue;
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return NAME;
    }

    public Image getIcon() {
        return IconFactory.getInstance().getIcon("dpi");
    }

    public boolean isValid() {
        return this.mValue != null;
    }

    public boolean checkAndSet(String string, FolderConfiguration folderConfiguration) {
        Density density = Density.getEnum(string);
        if (density == null) {
            density = Density.getLegacyEnum(string);
        }
        if (density != null) {
            PixelDensityQualifier pixelDensityQualifier = new PixelDensityQualifier();
            pixelDensityQualifier.mValue = density;
            folderConfiguration.setPixelDensityQualifier(pixelDensityQualifier);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof PixelDensityQualifier) {
            return this.mValue == ((PixelDensityQualifier)object).mValue;
        }
        return false;
    }

    public int hashCode() {
        if (this.mValue != null) {
            return this.mValue.hashCode();
        }
        return 0;
    }

    public String getFolderSegment(IAndroidTarget iAndroidTarget) {
        if (this.mValue != null) {
            AndroidVersion androidVersion;
            if (iAndroidTarget != null && (androidVersion = iAndroidTarget.getVersion()).getApiLevel() <= 3 && androidVersion.getCodename() == null) {
                return this.mValue.getLegacyValue();
            }
            return this.mValue.getValue();
        }
        return "";
    }

    public String getStringValue() {
        if (this.mValue != null) {
            return this.mValue.getDisplayValue();
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Density {
        HIGH("hdpi", 240, "High Density"),
        MEDIUM("mdpi", 160, "Medium Density"),
        LOW("ldpi", 120, "Low Density"),
        NODPI("nodpi", -1, "No Density");

        private final String mValue;
        private final String mDisplayValue;
        private final int mDpiValue;

        private Density(String string2, int n2, String string3) {
            this.mValue = string2;
            this.mDpiValue = n2;
            this.mDisplayValue = string3;
        }

        static Density getEnum(String string) {
            Density[] densityArray = Density.values();
            int n = densityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Density density = densityArray[n2];
                if (density.mValue.equals(string)) {
                    return density;
                }
                ++n2;
            }
            return null;
        }

        static Density getLegacyEnum(String string) {
            Matcher matcher = sDensityLegacyPattern.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                try {
                    int n = Integer.parseInt(string2);
                    Density[] densityArray = Density.values();
                    int n2 = densityArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Density density = densityArray[n3];
                        if (density.mDpiValue == n) {
                            return density;
                        }
                        ++n3;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return null;
        }

        public String getValue() {
            return this.mValue;
        }

        public int getDpiValue() {
            return this.mDpiValue;
        }

        public String getLegacyValue() {
            if (this != NODPI) {
                return String.format("%1$ddpi", this.mDpiValue);
            }
            return "";
        }

        public String getDisplayValue() {
            return this.mDisplayValue;
        }

        public static int getIndex(Density density) {
            int n = 0;
            Density[] densityArray = Density.values();
            int n2 = densityArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Density density2 = densityArray[n3];
                if (density == density2) {
                    return n;
                }
                ++n;
                ++n3;
            }
            return -1;
        }

        public static Density getByIndex(int n) {
            int n2 = 0;
            Density[] densityArray = Density.values();
            int n3 = densityArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Density density = densityArray[n4];
                if (n2 == n) {
                    return density;
                }
                ++n2;
                ++n4;
            }
            return null;
        }
    }
}

