/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ProjectChooserHelper {
    private final Shell mParentShell;
    private IJavaProject[] mAndroidProjects;

    public ProjectChooserHelper(Shell shell) {
        this.mParentShell = shell;
    }

    public IJavaProject chooseJavaProject(String string) {
        JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.mParentShell, (ILabelProvider)javaElementLabelProvider);
        elementListSelectionDialog.setTitle("Project Selection");
        elementListSelectionDialog.setMessage("Select a project to constrain your search.");
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel iJavaModel = JavaCore.create((IWorkspaceRoot)iWorkspaceRoot);
        elementListSelectionDialog.setElements((Object[])this.getAndroidProjects(iJavaModel));
        IJavaProject iJavaProject = null;
        if (string != null && string.length() > 0) {
            iJavaProject = iJavaModel.getJavaProject(string);
        }
        if (iJavaProject != null) {
            elementListSelectionDialog.setInitialSelections(new Object[]{iJavaProject});
        }
        if (elementListSelectionDialog.open() == 0) {
            return (IJavaProject)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    public IJavaProject[] getAndroidProjects(IJavaModel iJavaModel) {
        if (this.mAndroidProjects == null) {
            this.mAndroidProjects = iJavaModel == null ? BaseProjectHelper.getAndroidProjects() : BaseProjectHelper.getAndroidProjects(iJavaModel);
        }
        return this.mAndroidProjects;
    }

    public IProject getAndroidProject(String string) {
        IProject iProject = null;
        IJavaProject[] iJavaProjectArray = this.getAndroidProjects(null);
        if (iJavaProjectArray != null) {
            IJavaProject[] iJavaProjectArray2 = iJavaProjectArray;
            int n = iJavaProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject iJavaProject = iJavaProjectArray2[n2];
                if (iJavaProject.getElementName().equals(string)) {
                    iProject = iJavaProject.getProject();
                    break;
                }
                ++n2;
            }
        }
        return iProject;
    }
}

