/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.eclipse.adt.AdtPlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class FixLaunchConfig
extends Thread {
    private IProject mProject;
    private String mOldPackage;
    private String mNewPackage;
    private boolean mDisplayPrompt = true;

    public FixLaunchConfig(IProject iProject, String string, String string2) {
        this.mProject = iProject;
        this.mOldPackage = string;
        this.mNewPackage = string2;
    }

    public void setDisplayPrompt(boolean bl) {
        this.mDisplayPrompt = bl;
    }

    public void run() {
        ILaunchConfiguration[] iLaunchConfigurationArray;
        boolean bl;
        if (this.mDisplayPrompt && !(bl = AdtPlugin.displayPrompt("Launch Configuration Update", "The package definition in the manifest changed.\nDo you want to update your Launch Configuration(s)?"))) {
            return;
        }
        String string = this.mProject.getName();
        ILaunchConfiguration[] iLaunchConfigurationArray2 = iLaunchConfigurationArray = FixLaunchConfig.findConfigs(this.mProject.getName());
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2;
            ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray2[n2];
            try {
                ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy();
                string2 = iLaunchConfiguration.getAttribute("com.android.ide.eclipse.adt.activity", "");
                if (string2.startsWith(this.mOldPackage)) {
                    string2 = String.valueOf(this.mNewPackage) + string2.substring(this.mOldPackage.length());
                    iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.activity", string2);
                    iLaunchConfigurationWorkingCopy.doSave();
                }
            }
            catch (CoreException coreException) {
                string2 = String.format("Failed to modify %1$s: %2$s", string, coreException.getMessage());
                AdtPlugin.printErrorToConsole(this.mProject, new Object[]{string2});
            }
            ++n2;
        }
    }

    private static ILaunchConfiguration[] findConfigs(String string) {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType("com.android.ide.eclipse.adt.debug.LaunchConfigType");
        ArrayList<ILaunchConfiguration> arrayList = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray;
            ILaunchConfiguration[] iLaunchConfigurationArray2 = iLaunchConfigurationArray = iLaunchManager.getLaunchConfigurations(iLaunchConfigurationType);
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray2[n2];
                if (iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(string)) {
                    arrayList.add(iLaunchConfiguration);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return arrayList.toArray(new ILaunchConfiguration[arrayList.size()]);
    }
}

