/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;

public class ApkInstallManager
implements AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IDebugBridgeChangeListener,
ResourceMonitor.IProjectListener {
    private static final ApkInstallManager sThis = new ApkInstallManager();
    private final ArrayList<ApkInstall> mInstallList = new ArrayList();

    public static ApkInstallManager getInstance() {
        return sThis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstallation(IProject iProject, IDevice iDevice) {
        ArrayList<ApkInstall> arrayList = this.mInstallList;
        synchronized (arrayList) {
            this.mInstallList.add(new ApkInstall(iProject, iDevice));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isApplicationInstalled(IProject iProject, IDevice iDevice) {
        ArrayList<ApkInstall> arrayList = this.mInstallList;
        synchronized (arrayList) {
            ApkInstall apkInstall;
            Iterator<ApkInstall> iterator = this.mInstallList.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                apkInstall = iterator.next();
            } while (iProject != apkInstall.project || iDevice != apkInstall.device);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetInstallationFor(IProject iProject) {
        ArrayList<ApkInstall> arrayList = this.mInstallList;
        synchronized (arrayList) {
            int n = 0;
            while (n < this.mInstallList.size()) {
                ApkInstall apkInstall = this.mInstallList.get(n);
                if (apkInstall.project == iProject) {
                    this.mInstallList.remove(n);
                    continue;
                }
                ++n;
            }
        }
    }

    private ApkInstallManager() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        ResourceMonitor.getMonitor().addProjectListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bridgeChanged(AndroidDebugBridge androidDebugBridge) {
        ArrayList<ApkInstall> arrayList = this.mInstallList;
        synchronized (arrayList) {
            this.mInstallList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceDisconnected(IDevice iDevice) {
        ArrayList<ApkInstall> arrayList = this.mInstallList;
        synchronized (arrayList) {
            int n = 0;
            while (n < this.mInstallList.size()) {
                ApkInstall apkInstall = this.mInstallList.get(n);
                if (apkInstall.device == iDevice) {
                    this.mInstallList.remove(n);
                    continue;
                }
                ++n;
            }
        }
    }

    public void projectClosed(IProject iProject) {
        this.resetInstallationFor(iProject);
    }

    public void projectDeleted(IProject iProject) {
        this.resetInstallationFor(iProject);
    }

    public void deviceChanged(IDevice iDevice, int n) {
    }

    public void deviceConnected(IDevice iDevice) {
    }

    public void projectOpened(IProject iProject) {
    }

    public void projectOpenedWithWorkspace(IProject iProject) {
    }

    private static class ApkInstall {
        IProject project;
        IDevice device;

        public ApkInstall(IProject iProject, IDevice iDevice) {
            this.project = iProject;
            this.device = iDevice;
        }
    }
}

