/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch.junit.runtime;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.launch.junit.runtime.AndroidJUnitLaunchInfo;
import com.android.ide.eclipse.adt.internal.launch.junit.runtime.TestCaseReference;
import com.android.ide.eclipse.adt.internal.launch.junit.runtime.TestCollector;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.IVisitsTestTrees;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.jdt.internal.junit.runner.TestExecution;
import org.eclipse.jdt.internal.junit.runner.TestReferenceFailure;

public class RemoteAdtTestRunner
extends RemoteTestRunner {
    private AndroidJUnitLaunchInfo mLaunchInfo;
    private TestExecution mExecution;

    protected void init(String[] stringArray, AndroidJUnitLaunchInfo androidJUnitLaunchInfo) {
        this.defaultInit(stringArray);
        this.mLaunchInfo = androidJUnitLaunchInfo;
    }

    public void runTests(String[] stringArray, String string, TestExecution testExecution) {
        this.mExecution = testExecution;
        RemoteAndroidTestRunner remoteAndroidTestRunner = new RemoteAndroidTestRunner(this.mLaunchInfo.getAppPackage(), this.mLaunchInfo.getRunner(), this.mLaunchInfo.getDevice());
        if (this.mLaunchInfo.getTestClass() != null) {
            if (this.mLaunchInfo.getTestMethod() != null) {
                remoteAndroidTestRunner.setMethodName(this.mLaunchInfo.getTestClass(), this.mLaunchInfo.getTestMethod());
            } else {
                remoteAndroidTestRunner.setClassName(this.mLaunchInfo.getTestClass());
            }
        }
        if (this.mLaunchInfo.getTestPackage() != null) {
            remoteAndroidTestRunner.setTestPackageName(this.mLaunchInfo.getTestPackage());
        }
        remoteAndroidTestRunner.setLogOnly(true);
        TestCollector testCollector = new TestCollector();
        remoteAndroidTestRunner.run((ITestRunListener)testCollector);
        if (testCollector.getErrorMessage() != null) {
            this.reportError(testCollector.getErrorMessage());
            this.notifyTestRunEnded(0L);
            return;
        }
        this.notifyTestRunStarted(testCollector.getTestCaseCount());
        testCollector.sendTrees((IVisitsTestTrees)this);
        remoteAndroidTestRunner.setLogOnly(false);
        if (this.mLaunchInfo.isDebugMode()) {
            remoteAndroidTestRunner.setDebug(true);
        }
        remoteAndroidTestRunner.run((ITestRunListener)new TestRunListener());
    }

    public void runTests(String[] stringArray, AndroidJUnitLaunchInfo androidJUnitLaunchInfo) {
        this.init(stringArray, androidJUnitLaunchInfo);
        this.run();
    }

    public void terminate() {
        this.stop();
    }

    protected void stop() {
        if (this.mExecution != null) {
            this.mExecution.stop();
        }
    }

    private void notifyTestRunEnded(long l) {
        this.sendMessage("%RUNTIME" + l);
        this.flush();
    }

    private void reportError(String string) {
        AdtPlugin.printErrorToConsole(this.mLaunchInfo.getProject(), new Object[]{String.format("Test run failed: %s", string)});
    }

    private class TestRunListener
    implements ITestRunListener {
        private TestRunListener() {
        }

        public void testEnded(TestIdentifier testIdentifier) {
            RemoteAdtTestRunner.this.mExecution.getListener().notifyTestEnded((ITestIdentifier)new TestCaseReference(testIdentifier));
        }

        public void testFailed(ITestRunListener.TestFailure testFailure, TestIdentifier testIdentifier, String string) {
            String string2 = testFailure == ITestRunListener.TestFailure.ERROR ? "%ERROR  " : "%FAILED ";
            TestReferenceFailure testReferenceFailure = new TestReferenceFailure((ITestIdentifier)new TestCaseReference(testIdentifier), string2, string, null);
            RemoteAdtTestRunner.this.mExecution.getListener().notifyTestFailed(testReferenceFailure);
        }

        public void testRunEnded(long l) {
            RemoteAdtTestRunner.this.notifyTestRunEnded(l);
            AdtPlugin.printToConsole(RemoteAdtTestRunner.this.mLaunchInfo.getProject(), "Test run complete");
        }

        public void testRunFailed(String string) {
            RemoteAdtTestRunner.this.reportError(string);
        }

        public void testRunStarted(int n) {
        }

        public void testRunStopped(long l) {
            RemoteAdtTestRunner.this.notifyTestRunStopped(l);
            AdtPlugin.printToConsole(RemoteAdtTestRunner.this.mLaunchInfo.getProject(), "Test run stopped");
        }

        public void testStarted(TestIdentifier testIdentifier) {
            TestCaseReference testCaseReference = new TestCaseReference(testIdentifier);
            RemoteAdtTestRunner.this.mExecution.getListener().notifyTestStarted((ITestIdentifier)testCaseReference);
        }
    }
}

