/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch.junit;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.launch.junit.AndroidJUnitLaunchConfigDelegate;
import com.android.ide.eclipse.adt.internal.launch.junit.InstrumentationRunnerValidator;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectChooserHelper;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitMigrationDelegate;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.internal.junit.launcher.TestSelectionDialog;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class AndroidJUnitLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private Label mProjLabel;
    private Text mProjText;
    private Button mProjButton;
    private Text mTestText;
    private Button mSearchButton;
    private String mOriginalTestMethodName;
    private Label mTestMethodLabel;
    private Text mContainerText;
    private IJavaElement mContainerElement;
    private final ILabelProvider mJavaElementLabelProvider = new JavaElementLabelProvider();
    private Button mContainerSearchButton;
    private Button mTestContainerRadioButton;
    private Button mTestRadioButton;
    private Label mTestLabel;
    private Image mTabIcon = null;
    private Combo mInstrumentationCombo;
    private static final String EMPTY_STRING = "";
    private static final String TAG = "AndroidJUnitLaunchConfigurationTab";
    private String[] mInstrumentations = null;
    private InstrumentationRunnerValidator mInstrValidator = null;
    private ProjectChooserHelper mProjectChooserHelper;

    public void createControl(Composite composite) {
        this.mProjectChooserHelper = new ProjectChooserHelper(composite.getShell());
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        this.createSingleTestSection(composite2);
        this.createTestContainerSelectionGroup(composite2);
        this.createSpacer(composite2);
        this.createInstrumentationGroup(composite2);
        this.createSpacer(composite2);
        Dialog.applyDialogFont((Control)composite2);
        this.validatePage();
    }

    private void createSpacer(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
    }

    private void createSingleTestSection(Composite composite) {
        this.mTestRadioButton = new Button(composite, 16);
        this.mTestRadioButton.setText(JUnitMessages.JUnitLaunchConfigurationTab_label_oneTest);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.mTestRadioButton.setLayoutData((Object)gridData);
        this.mTestRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (AndroidJUnitLaunchConfigurationTab.this.mTestRadioButton.getSelection()) {
                    AndroidJUnitLaunchConfigurationTab.this.testModeChanged();
                }
            }
        });
        this.mProjLabel = new Label(composite, 0);
        this.mProjLabel.setText(JUnitMessages.JUnitLaunchConfigurationTab_label_project);
        gridData = new GridData();
        gridData.horizontalIndent = 25;
        this.mProjLabel.setLayoutData((Object)gridData);
        this.mProjText = new Text(composite, 2052);
        this.mProjText.setLayoutData((Object)new GridData(768));
        this.mProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                AndroidJUnitLaunchConfigurationTab.this.validatePage();
                AndroidJUnitLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                AndroidJUnitLaunchConfigurationTab.this.mSearchButton.setEnabled(AndroidJUnitLaunchConfigurationTab.this.mTestRadioButton.getSelection() && AndroidJUnitLaunchConfigurationTab.this.mProjText.getText().length() > 0);
            }
        });
        this.mProjButton = new Button(composite, 8);
        this.mProjButton.setText(JUnitMessages.JUnitLaunchConfigurationTab_label_browse);
        this.mProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AndroidJUnitLaunchConfigurationTab.this.handleProjectButtonSelected();
            }
        });
        this.setButtonGridData(this.mProjButton);
        this.mTestLabel = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 25;
        this.mTestLabel.setLayoutData((Object)gridData);
        this.mTestLabel.setText(JUnitMessages.JUnitLaunchConfigurationTab_label_test);
        this.mTestText = new Text(composite, 2052);
        this.mTestText.setLayoutData((Object)new GridData(768));
        this.mTestText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                AndroidJUnitLaunchConfigurationTab.this.validatePage();
                AndroidJUnitLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.mSearchButton = new Button(composite, 8);
        this.mSearchButton.setEnabled(this.mProjText.getText().length() > 0);
        this.mSearchButton.setText(JUnitMessages.JUnitLaunchConfigurationTab_label_search);
        this.mSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AndroidJUnitLaunchConfigurationTab.this.handleSearchButtonSelected();
            }
        });
        this.setButtonGridData(this.mSearchButton);
        new Label(composite, 0);
        this.mTestMethodLabel = new Label(composite, 0);
        this.mTestMethodLabel.setText(EMPTY_STRING);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.mTestMethodLabel.setLayoutData((Object)gridData);
    }

    private void createTestContainerSelectionGroup(Composite composite) {
        this.mTestContainerRadioButton = new Button(composite, 16);
        this.mTestContainerRadioButton.setText("Run all tests in the selected project, or package");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.mTestContainerRadioButton.setLayoutData((Object)gridData);
        this.mTestContainerRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (AndroidJUnitLaunchConfigurationTab.this.mTestContainerRadioButton.getSelection()) {
                    AndroidJUnitLaunchConfigurationTab.this.testModeChanged();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.mContainerText = new Text(composite, 2060);
        gridData = new GridData(768);
        gridData.horizontalIndent = 25;
        gridData.horizontalSpan = 2;
        this.mContainerText.setLayoutData((Object)gridData);
        this.mContainerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                AndroidJUnitLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.mContainerSearchButton = new Button(composite, 8);
        this.mContainerSearchButton.setText(JUnitMessages.JUnitLaunchConfigurationTab_label_search);
        this.mContainerSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AndroidJUnitLaunchConfigurationTab.this.handleContainerSearchButtonSelected();
            }
        });
        this.setButtonGridData(this.mContainerSearchButton);
    }

    private void createInstrumentationGroup(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Instrumentation runner:");
        GridData gridData = new GridData();
        gridData.horizontalIndent = 0;
        label.setLayoutData((Object)gridData);
        this.mInstrumentationCombo = new Combo(composite, 12);
        gridData = new GridData(768);
        this.mInstrumentationCombo.setLayoutData((Object)new GridData(768));
        this.mInstrumentationCombo.clearSelection();
        this.mInstrumentationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AndroidJUnitLaunchConfigurationTab.this.validatePage();
                AndroidJUnitLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void handleContainerSearchButtonSelected() {
        IJavaElement iJavaElement = this.chooseContainer(this.mContainerElement);
        if (iJavaElement != null) {
            this.setContainerElement(iJavaElement);
        }
    }

    private void setContainerElement(IJavaElement iJavaElement) {
        this.mContainerElement = iJavaElement;
        this.mContainerText.setText(this.getPresentationName(iJavaElement));
        this.validatePage();
        this.updateLaunchConfigurationDialog();
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        String string = this.updateProjectFromConfig(iLaunchConfiguration);
        String string2 = EMPTY_STRING;
        try {
            string2 = iLaunchConfiguration.getAttribute("org.eclipse.jdt.junit.CONTAINER", EMPTY_STRING);
        }
        catch (CoreException coreException) {}
        if (string2.length() > 0) {
            this.updateTestContainerFromConfig(iLaunchConfiguration);
        } else {
            this.updateTestTypeFromConfig(iLaunchConfiguration);
        }
        IProject iProject = this.mProjectChooserHelper.getAndroidProject(string);
        this.loadInstrumentations(iProject);
        this.updateInstrumentationFromConfig(iLaunchConfiguration);
        this.validatePage();
    }

    private void updateInstrumentationFromConfig(ILaunchConfiguration iLaunchConfiguration) {
        boolean bl;
        block5: {
            bl = false;
            try {
                String string = iLaunchConfiguration.getAttribute("com.android.ide.eclipse.adt.instrumentation", EMPTY_STRING);
                if (this.mInstrumentations == null) break block5;
                int n = 0;
                while (n < this.mInstrumentations.length) {
                    if (string.equals(this.mInstrumentations[n])) {
                        bl = true;
                        this.mInstrumentationCombo.select(n);
                        break;
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {}
        }
        if (!bl) {
            this.mInstrumentationCombo.clearSelection();
        }
    }

    private String updateProjectFromConfig(ILaunchConfiguration iLaunchConfiguration) {
        String string = EMPTY_STRING;
        try {
            string = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        catch (CoreException coreException) {}
        this.mProjText.setText(string);
        return string;
    }

    private void updateTestTypeFromConfig(ILaunchConfiguration iLaunchConfiguration) {
        String string = EMPTY_STRING;
        this.mOriginalTestMethodName = EMPTY_STRING;
        try {
            string = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, EMPTY_STRING);
            this.mOriginalTestMethodName = iLaunchConfiguration.getAttribute("org.eclipse.jdt.junit.TESTNAME", EMPTY_STRING);
        }
        catch (CoreException coreException) {}
        this.mTestRadioButton.setSelection(true);
        this.setEnableSingleTestGroup(true);
        this.setEnableContainerTestGroup(false);
        this.mTestContainerRadioButton.setSelection(false);
        this.mTestText.setText(string);
        this.mContainerText.setText(EMPTY_STRING);
        this.setTestMethodLabel(this.mOriginalTestMethodName);
    }

    private void setTestMethodLabel(String string) {
        if (!EMPTY_STRING.equals(string)) {
            this.mTestMethodLabel.setText(String.valueOf(JUnitMessages.JUnitLaunchConfigurationTab_label_method) + this.mOriginalTestMethodName);
        } else {
            this.mTestMethodLabel.setText(EMPTY_STRING);
        }
    }

    private void updateTestContainerFromConfig(ILaunchConfiguration iLaunchConfiguration) {
        String string = EMPTY_STRING;
        IJavaElement iJavaElement = null;
        try {
            string = iLaunchConfiguration.getAttribute("org.eclipse.jdt.junit.CONTAINER", EMPTY_STRING);
            if (string.length() > 0) {
                iJavaElement = JavaCore.create((String)string);
            }
        }
        catch (CoreException coreException) {}
        if (iJavaElement != null) {
            this.mContainerElement = iJavaElement;
        }
        this.mTestContainerRadioButton.setSelection(true);
        this.setEnableSingleTestGroup(false);
        this.setEnableContainerTestGroup(true);
        this.mTestRadioButton.setSelection(false);
        if (this.mContainerElement != null) {
            this.mContainerText.setText(this.getPresentationName(this.mContainerElement));
        }
        this.mTestText.setText(EMPTY_STRING);
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        if (this.mTestContainerRadioButton.getSelection() && this.mContainerElement != null) {
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.mContainerElement.getJavaProject().getElementName());
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.jdt.junit.CONTAINER", this.mContainerElement.getHandleIdentifier());
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, EMPTY_STRING);
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.jdt.junit.TESTNAME", EMPTY_STRING);
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.mProjText.getText());
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.mTestText.getText());
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.jdt.junit.CONTAINER", EMPTY_STRING);
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.jdt.junit.TESTNAME", this.mOriginalTestMethodName);
        }
        try {
            this.mapResources(iLaunchConfigurationWorkingCopy);
        }
        catch (CoreException coreException) {
            AdtPlugin.log(coreException, "Error occurred saving configuration", new Object[0]);
        }
        AndroidJUnitLaunchConfigDelegate.setJUnitDefaults(iLaunchConfigurationWorkingCopy);
        iLaunchConfigurationWorkingCopy.setAttribute("com.android.ide.eclipse.adt.instrumentation", this.getSelectedInstrumentation());
    }

    private void mapResources(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) throws CoreException {
        JUnitMigrationDelegate.mapResources((ILaunchConfigurationWorkingCopy)iLaunchConfigurationWorkingCopy);
    }

    public void dispose() {
        super.dispose();
        if (this.mTabIcon != null) {
            this.mTabIcon.dispose();
            this.mTabIcon = null;
        }
        this.mJavaElementLabelProvider.dispose();
    }

    public Image getImage() {
        if (this.mTabIcon == null) {
            this.mTabIcon = AdtPlugin.getImageLoader().loadImage("mainLaunchTab.png", null);
        }
        return this.mTabIcon;
    }

    /*
     * Unable to fully structure code
     */
    private void handleSearchButtonSelected() {
        var1_1 = this.getShell();
        var2_2 = this.getJavaProject();
        var3_3 = new IType[]{};
        var4_4 = new boolean[2];
        try {
            try {
                var4_4[0] = this.mTestRadioButton.getSelection();
                var4_4[1] = this.mTestContainerRadioButton.getSelection();
                var3_3 = TestSearchEngine.findTests((IRunnableContext)this.getLaunchConfigurationDialog(), (IJavaElement)var2_2, (ITestKind)this.getTestKind());
            }
            catch (InterruptedException var5_5) {
                this.setErrorMessage(var5_5.getMessage());
lbl13:
                // 2 sources

                while (true) {
                    this.mTestRadioButton.setSelection(var4_4[0]);
                    this.mTestContainerRadioButton.setSelection(var4_4[1]);
                    return;
                }
            }
            catch (InvocationTargetException var5_6) {
                AdtPlugin.log(var5_6.getTargetException(), "Error finding test types", new Object[0]);
                ** continue;
            }
        }
        finally {
            this.mTestRadioButton.setSelection(var4_4[0]);
            this.mTestContainerRadioButton.setSelection(var4_4[1]);
        }
        var5_7 = new TestSelectionDialog(var1_1, var3_3);
        var5_7.setTitle(JUnitMessages.JUnitLaunchConfigurationTab_testdialog_title);
        var5_7.setMessage(JUnitMessages.JUnitLaunchConfigurationTab_testdialog_message);
        if (var5_7.open() == 1) {
            return;
        }
        var6_9 = var5_7.getResult();
        if (var6_9 == null || var6_9.length < 1) {
            return;
        }
        var7_10 = (IType)var6_9[0];
        if (var7_10 != null) {
            this.mTestText.setText(var7_10.getFullyQualifiedName('.'));
            var2_2 = var7_10.getJavaProject();
            this.mProjText.setText(var2_2.getElementName());
        }
    }

    private ITestKind getTestKind() {
        return TestKindRegistry.getDefault().getKind("org.eclipse.jdt.junit.loader.junit3");
    }

    private void handleProjectButtonSelected() {
        IJavaProject iJavaProject = this.mProjectChooserHelper.chooseJavaProject(this.getProjectName());
        if (iJavaProject == null) {
            return;
        }
        String string = iJavaProject.getElementName();
        this.mProjText.setText(string);
        this.loadInstrumentations(iJavaProject.getProject());
    }

    private IJavaProject getJavaProject() {
        String string = this.getProjectName();
        return this.getJavaModel().getJavaProject(string);
    }

    private String getProjectName() {
        String string = this.mProjText.getText().trim();
        if (string.length() < 1) {
            return null;
        }
        return string;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.validatePage();
        return this.getErrorMessage() == null;
    }

    private void testModeChanged() {
        IJavaProject iJavaProject;
        String string;
        boolean bl = this.mTestRadioButton.getSelection();
        this.setEnableSingleTestGroup(bl);
        this.setEnableContainerTestGroup(!bl);
        if (!bl && this.mContainerText.getText().length() == 0 && Path.EMPTY.isValidSegment(string = this.mProjText.getText()) && (iJavaProject = this.getJavaModel().getJavaProject(string)) != null && iJavaProject.exists()) {
            this.setContainerElement((IJavaElement)iJavaProject);
        }
        this.validatePage();
        this.updateLaunchConfigurationDialog();
    }

    private void validatePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.mTestContainerRadioButton.getSelection()) {
            if (this.mContainerElement == null) {
                this.setErrorMessage(JUnitMessages.JUnitLaunchConfigurationTab_error_noContainer);
                return;
            }
            this.validateJavaProject(this.mContainerElement.getJavaProject());
            return;
        }
        String string = this.mProjText.getText().trim();
        if (string.length() == 0) {
            this.setErrorMessage(JUnitMessages.JUnitLaunchConfigurationTab_error_projectnotdefined);
            return;
        }
        IStatus iStatus = ResourcesPlugin.getWorkspace().validatePath(String.valueOf('/') + string, 4);
        if (!iStatus.isOK() || !Path.ROOT.isValidSegment(string)) {
            this.setErrorMessage(Messages.format((String)JUnitMessages.JUnitLaunchConfigurationTab_error_invalidProjectName, (Object)string));
            return;
        }
        IProject iProject = this.getWorkspaceRoot().getProject(string);
        if (!iProject.exists()) {
            this.setErrorMessage(JUnitMessages.JUnitLaunchConfigurationTab_error_projectnotexists);
            return;
        }
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        this.validateJavaProject(iJavaProject);
        try {
            if (!iProject.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                this.setErrorMessage("Specified project is not an Android project");
                return;
            }
            String string2 = this.mTestText.getText().trim();
            if (string2.length() == 0) {
                this.setErrorMessage(JUnitMessages.JUnitLaunchConfigurationTab_error_testnotdefined);
                return;
            }
            if (iJavaProject.findType(string2) == null) {
                this.setErrorMessage(Messages.format((String)JUnitMessages.JUnitLaunchConfigurationTab_error_test_class_not_found, (Object[])new String[]{string2, string}));
                return;
            }
        }
        catch (CoreException coreException) {
            AdtPlugin.log(coreException, "validatePage failed", new Object[0]);
        }
        this.validateInstrumentation();
    }

    private void validateJavaProject(IJavaProject iJavaProject) {
        if (!TestSearchEngine.hasTestCaseType((IJavaProject)iJavaProject)) {
            this.setErrorMessage(JUnitMessages.JUnitLaunchConfigurationTab_error_testcasenotonpath);
            return;
        }
    }

    private void validateInstrumentation() {
        String string = this.getSelectedInstrumentation();
        if (string == null) {
            this.setErrorMessage("Instrumentation runner not specified");
            return;
        }
        String string2 = this.mInstrValidator.validateInstrumentationRunner(string);
        if (string2 != InstrumentationRunnerValidator.INSTRUMENTATION_OK) {
            this.setErrorMessage(string2);
            return;
        }
    }

    private String getSelectedInstrumentation() {
        int n = this.mInstrumentationCombo.getSelectionIndex();
        if (this.mInstrumentations != null && n >= 0 && n < this.mInstrumentations.length) {
            return this.mInstrumentations[n];
        }
        return null;
    }

    private void setEnableContainerTestGroup(boolean bl) {
        this.mContainerSearchButton.setEnabled(bl);
        this.mContainerText.setEnabled(bl);
    }

    private void setEnableSingleTestGroup(boolean bl) {
        this.mProjLabel.setEnabled(bl);
        this.mProjText.setEnabled(bl);
        this.mProjButton.setEnabled(bl);
        this.mTestLabel.setEnabled(bl);
        this.mTestText.setEnabled(bl);
        this.mSearchButton.setEnabled(bl && this.mProjText.getText().length() > 0);
        this.mTestMethodLabel.setEnabled(bl);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        IJavaElement iJavaElement = this.getContext();
        if (iJavaElement != null) {
            this.initializeJavaProject(iJavaElement, iLaunchConfigurationWorkingCopy);
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.jdt.junit.CONTAINER", EMPTY_STRING);
        }
        this.initializeTestAttributes(iJavaElement, iLaunchConfigurationWorkingCopy);
    }

    private void initializeTestAttributes(IJavaElement iJavaElement, ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        if (iJavaElement != null && iJavaElement.getElementType() < 5) {
            this.initializeTestContainer(iJavaElement, iLaunchConfigurationWorkingCopy);
        } else {
            this.initializeTestType(iJavaElement, iLaunchConfigurationWorkingCopy);
        }
    }

    private void initializeTestContainer(IJavaElement iJavaElement, ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.jdt.junit.CONTAINER", iJavaElement.getHandleIdentifier());
        this.initializeName(iLaunchConfigurationWorkingCopy, iJavaElement.getElementName());
    }

    private void initializeName(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy, String string) {
        if (string == null) {
            string = EMPTY_STRING;
        }
        if (string.length() > 0) {
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string = string.substring(n + 1);
            }
            string = this.getLaunchConfigurationDialog().generateName(string);
            iLaunchConfigurationWorkingCopy.rename(string);
        }
    }

    private void initializeTestType(IJavaElement iJavaElement, ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        String string = EMPTY_STRING;
        String string2 = null;
        try {
            if (iJavaElement instanceof ISourceReference) {
                ITestKind iTestKind = TestKindRegistry.getContainerTestKind((IJavaElement)iJavaElement);
                string2 = iTestKind.getId();
                IType[] iTypeArray = TestSearchEngine.findTests((IRunnableContext)this.getLaunchConfigurationDialog(), (IJavaElement)iJavaElement, (ITestKind)iTestKind);
                if (iTypeArray == null || iTypeArray.length < 1) {
                    return;
                }
                string = iTypeArray[0].getFullyQualifiedName('.');
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, string);
        if (string2 != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.jdt.junit.TEST_KIND", string2);
        }
        this.initializeName(iLaunchConfigurationWorkingCopy, string);
    }

    public String getName() {
        return JUnitMessages.JUnitLaunchConfigurationTab_tab_label;
    }

    private IJavaElement chooseContainer(IJavaElement iJavaElement) {
        Class[] classArray = new Class[]{IJavaProject.class, IPackageFragment.class};
        TypedElementSelectionValidator typedElementSelectionValidator = new TypedElementSelectionValidator(classArray, false){

            public boolean isSelectedValid(Object object) {
                return true;
            }
        };
        classArray = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class, IPackageFragment.class};
        TypedViewerFilter typedViewerFilter = new TypedViewerFilter(classArray){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (object2 instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)object2).isArchive()) {
                    return false;
                }
                try {
                    if (object2 instanceof IPackageFragment && !((IPackageFragment)object2).hasChildren()) {
                        return false;
                    }
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
                return super.select(viewer, object, object2);
            }
        };
        AndroidJavaElementContentProvider androidJavaElementContentProvider = new AndroidJavaElementContentProvider();
        JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)javaElementLabelProvider, (ITreeContentProvider)androidJavaElementContentProvider);
        elementTreeSelectionDialog.setValidator((ISelectionStatusValidator)typedElementSelectionValidator);
        elementTreeSelectionDialog.setComparator((ViewerComparator)new JavaElementComparator());
        elementTreeSelectionDialog.setTitle(JUnitMessages.JUnitLaunchConfigurationTab_folderdialog_title);
        elementTreeSelectionDialog.setMessage(JUnitMessages.JUnitLaunchConfigurationTab_folderdialog_message);
        elementTreeSelectionDialog.addFilter((ViewerFilter)typedViewerFilter);
        elementTreeSelectionDialog.setInput((Object)JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()));
        elementTreeSelectionDialog.setInitialSelection((Object)iJavaElement);
        elementTreeSelectionDialog.setAllowMultiple(false);
        if (elementTreeSelectionDialog.open() == 0) {
            Object object = elementTreeSelectionDialog.getFirstResult();
            return (IJavaElement)object;
        }
        return null;
    }

    private String getPresentationName(IJavaElement iJavaElement) {
        return this.mJavaElementLabelProvider.getText((Object)iJavaElement);
    }

    private IJavaElement getContext() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null) {
            Object object;
            IStructuredSelection iStructuredSelection;
            ISelection iSelection = iWorkbenchPage.getSelection();
            if (iSelection instanceof IStructuredSelection && !(iStructuredSelection = (IStructuredSelection)iSelection).isEmpty()) {
                object = iStructuredSelection.getFirstElement();
                if (object instanceof IJavaElement) {
                    return (IJavaElement)object;
                }
                if (object instanceof IResource) {
                    IJavaElement iJavaElement = JavaCore.create((IResource)((IResource)object));
                    if (iJavaElement == null) {
                        IProject iProject = ((IResource)object).getProject();
                        iJavaElement = JavaCore.create((IProject)iProject);
                    }
                    if (iJavaElement != null) {
                        return iJavaElement;
                    }
                }
            }
            if ((iStructuredSelection = iWorkbenchPage.getActiveEditor()) != null) {
                object = iStructuredSelection.getEditorInput();
                return (IJavaElement)object.getAdapter(IJavaElement.class);
            }
        }
        return null;
    }

    private void initializeJavaProject(IJavaElement iJavaElement, ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        IJavaProject iJavaProject = iJavaElement.getJavaProject();
        String string = null;
        if (iJavaProject != null && iJavaProject.exists()) {
            string = iJavaProject.getElementName();
        }
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, string);
    }

    private void setButtonGridData(Button button) {
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
        LayoutUtil.setButtonDimensionHint((Button)button);
    }

    public String getId() {
        return "com.android.ide.eclipse.adt.launch.AndroidJUnitLaunchConfigurationTab";
    }

    private void loadInstrumentations(IProject iProject) {
        try {
            this.mInstrValidator = new InstrumentationRunnerValidator(iProject);
            String[] stringArray = this.mInstrumentations = this.mInstrValidator == null ? null : this.mInstrValidator.getInstrumentationNames();
            if (this.mInstrumentations != null) {
                this.mInstrumentationCombo.removeAll();
                String[] stringArray2 = this.mInstrumentations;
                int n = this.mInstrumentations.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    this.mInstrumentationCombo.add(string);
                    ++n2;
                }
                return;
            }
        }
        catch (CoreException coreException) {
            AdtPlugin.logAndPrintError(coreException, TAG, "ERROR: Failed to get instrumentations for %1$s", iProject.getName());
        }
        this.mInstrValidator = null;
        this.mInstrumentations = null;
        this.mInstrumentationCombo.removeAll();
    }

    private static class AndroidJavaElementContentProvider
    extends StandardJavaElementContentProvider {
        private AndroidJavaElementContentProvider() {
        }

        public Object[] getChildren(Object object) {
            if (object instanceof IJavaModel) {
                return BaseProjectHelper.getAndroidProjects((IJavaModel)object);
            }
            return super.getChildren(object);
        }
    }
}

