/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.launch.ActivityLaunchAction;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunch;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchConfiguration;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchController;
import com.android.ide.eclipse.adt.internal.launch.EmptyLaunchAction;
import com.android.ide.eclipse.adt.internal.launch.IAndroidLaunchAction;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class LaunchConfigDelegate
extends LaunchConfigurationDelegate {
    static final int INVALID_DEBUG_PORT = -1;
    public static final String ANDROID_LAUNCH_TYPE_ID = "com.android.ide.eclipse.adt.debug.LaunchConfigType";
    public static final String ATTR_TARGET_MODE = "com.android.ide.eclipse.adt.target";
    public static final AndroidLaunchConfiguration.TargetMode DEFAULT_TARGET_MODE = AndroidLaunchConfiguration.TargetMode.AUTO;
    public static final String ATTR_LAUNCH_ACTION = "com.android.ide.eclipse.adt.action";
    public static final int ACTION_DEFAULT = 0;
    public static final int ACTION_ACTIVITY = 1;
    public static final int ACTION_DO_NOTHING = 2;
    public static final int DEFAULT_LAUNCH_ACTION = 0;
    public static final String ATTR_ACTIVITY = "com.android.ide.eclipse.adt.activity";
    public static final String ATTR_AVD_NAME = "com.android.ide.eclipse.adt.avd";
    public static final String ATTR_SPEED = "com.android.ide.eclipse.adt.speed";
    public static final int DEFAULT_SPEED = 0;
    public static final String ATTR_DELAY = "com.android.ide.eclipse.adt.delay";
    public static final int DEFAULT_DELAY = 0;
    public static final String ATTR_COMMANDLINE = "com.android.ide.eclipse.adt.commandline";
    public static final String ATTR_WIPE_DATA = "com.android.ide.eclipse.adt.wipedata";
    public static final boolean DEFAULT_WIPE_DATA = false;
    public static final String ATTR_NO_BOOT_ANIM = "com.android.ide.eclipse.adt.nobootanim";
    public static final boolean DEFAULT_NO_BOOT_ANIM = false;
    public static final String ATTR_DEBUG_PORT = "com.android.ide.eclipse.adt.debugPort";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = AndroidLaunchController.getPortForConfig(iLaunchConfiguration);
        IProject iProject = this.getProject(iLaunchConfiguration);
        AndroidLaunch androidLaunch = null;
        if (!(iLaunch instanceof AndroidLaunch)) {
            AdtPlugin.printErrorToConsole(iProject, new Object[]{"Wrong Launch Type!"});
            return;
        }
        androidLaunch = (AndroidLaunch)iLaunch;
        if (n != -1) {
            AndroidLaunchController.launchRemoteDebugger(n, androidLaunch, iProgressMonitor);
            return;
        }
        if (iProject == null) {
            AdtPlugin.printErrorToConsole("Couldn't get project object!", new Object[0]);
            androidLaunch.stopLaunch();
            return;
        }
        if (ProjectHelper.hasError(iProject, true)) {
            AdtPlugin.displayError("Android Launch", "Your project contains error(s), please fix them before running your application.");
            return;
        }
        AdtPlugin.printToConsole(iProject, "------------------------------");
        AdtPlugin.printToConsole(iProject, "Android Launch!");
        if (!this.checkAndroidProject(iProject)) {
            AdtPlugin.printErrorToConsole(iProject, new Object[]{"Project is not an Android Project. Aborting!"});
            androidLaunch.stopLaunch();
            return;
        }
        AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.getBridge();
        if (androidDebugBridge == null || !androidDebugBridge.isConnected()) {
            try {
                int n2 = -1;
                int n3 = -1;
                if (androidDebugBridge != null) {
                    n2 = androidDebugBridge.getConnectionAttemptCount();
                    n3 = androidDebugBridge.getRestartAttemptCount();
                }
                if (n2 == -1 || n3 == -1) {
                    AdtPlugin.printErrorToConsole(iProject, new Object[]{"The connection to adb is down, and a severe error has occured.", "You must restart adb and Eclipse.", String.format("Please ensure that adb is correctly located at '%1$s' and can be executed.", AdtPlugin.getOsAbsoluteAdb())});
                    return;
                }
                if (n3 == 0) {
                    AdtPlugin.printErrorToConsole(iProject, new Object[]{"Connection with adb was interrupted.", String.format("%1$s attempts have been made to reconnect.", n2), "You may want to manually restart adb from the Devices view."});
                    return;
                }
                AdtPlugin.printErrorToConsole(iProject, new Object[]{"Connection with adb was interrupted, and attempts to reconnect have failed.", String.format("%1$s attempts have been made to restart adb.", n3), "You may want to manually restart adb from the Devices view."});
                return;
            }
            finally {
                androidLaunch.stopLaunch();
            }
        }
        AdtPlugin.printToConsole(iProject, "adb is running normally.");
        AndroidLaunchConfiguration androidLaunchConfiguration = new AndroidLaunchConfiguration();
        androidLaunchConfiguration.set(iLaunchConfiguration);
        AndroidLaunchController androidLaunchController = AndroidLaunchController.getInstance();
        IFile iFile = ProjectHelper.getApplicationPackage(iProject);
        if (iFile == null) {
            androidLaunch.stopLaunch();
            return;
        }
        AndroidManifestParser androidManifestParser = AndroidManifestParser.parse(BaseProjectHelper.getJavaProject(iProject), null, true, false);
        if (androidManifestParser == null) {
            AdtPlugin.printErrorToConsole(iProject, new Object[]{"Failed to parse AndroidManifest: aborting!"});
            androidLaunch.stopLaunch();
            return;
        }
        this.doLaunch(iLaunchConfiguration, string, iProgressMonitor, iProject, androidLaunch, androidLaunchConfiguration, androidLaunchController, iFile, androidManifestParser);
    }

    protected void doLaunch(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor, IProject iProject, AndroidLaunch androidLaunch, AndroidLaunchConfiguration androidLaunchConfiguration, AndroidLaunchController androidLaunchController, IFile iFile, AndroidManifestParser androidManifestParser) {
        Object object;
        String string2 = null;
        if (androidLaunchConfiguration.mLaunchAction == 1) {
            string2 = this.getActivityName(iLaunchConfiguration);
            object = androidManifestParser.getActivities();
            if (((AndroidManifestParser.Activity[])object).length == 0) {
                AdtPlugin.printErrorToConsole(iProject, new Object[]{"The Manifest defines no activity!", "The launch will only sync the application package on the device!"});
                androidLaunchConfiguration.mLaunchAction = 2;
            } else if (string2 == null) {
                AdtPlugin.printErrorToConsole(iProject, new Object[]{"No activity specified! Getting the launcher activity."});
                AndroidManifestParser.Activity activity = androidManifestParser.getLauncherActivity();
                if (activity != null) {
                    string2 = activity.getName();
                }
                if (string2 == null) {
                    this.revertToNoActionLaunch(iProject, androidLaunchConfiguration);
                }
            } else {
                Object object2;
                boolean bl = false;
                Object object3 = object;
                int n = ((Object)object3).length;
                int n2 = 0;
                while (n2 < n) {
                    object2 = object3[n2];
                    if (object2 != null && ((AndroidManifestParser.Activity)object2).getName().equals(string2)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    AdtPlugin.printErrorToConsole(iProject, new Object[]{"The specified activity does not exist! Getting the launcher activity."});
                    object2 = androidManifestParser.getLauncherActivity();
                    if (object2 != null) {
                        string2 = ((AndroidManifestParser.Activity)object2).getName();
                    }
                    if (string2 == null) {
                        this.revertToNoActionLaunch(iProject, androidLaunchConfiguration);
                    }
                }
            }
        } else if (androidLaunchConfiguration.mLaunchAction == 0) {
            object = androidManifestParser.getLauncherActivity();
            if (object != null) {
                string2 = ((AndroidManifestParser.Activity)object).getName();
            }
            if (string2 == null) {
                this.revertToNoActionLaunch(iProject, androidLaunchConfiguration);
            }
        }
        object = new EmptyLaunchAction();
        if (string2 != null) {
            object = new ActivityLaunchAction(string2, androidLaunchController);
        }
        androidLaunchController.launch(iProject, string, iFile, androidManifestParser.getPackage(), androidManifestParser.getPackage(), androidManifestParser.getDebuggable(), androidManifestParser.getApiLevelRequirement(), (IAndroidLaunchAction)object, androidLaunchConfiguration, androidLaunch, iProgressMonitor);
    }

    public boolean buildForLaunch(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = this.getProject(iLaunchConfiguration);
        if (iProject != null) {
            return true;
        }
        throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", 1, "Can't find the project!", null));
    }

    public ILaunch getLaunch(ILaunchConfiguration iLaunchConfiguration, String string) throws CoreException {
        return new AndroidLaunch(iLaunchConfiguration, string, null);
    }

    private IProject getProject(ILaunchConfiguration iLaunchConfiguration) {
        String string;
        try {
            string = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException coreException) {
            return null;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        return iWorkspace.getRoot().getProject(string);
    }

    private boolean checkAndroidProject(IProject iProject) throws CoreException {
        if (!iProject.hasNature("org.eclipse.jdt.core.javanature")) {
            String string = String.format("%1$s is not a Java project!", iProject.getName());
            AdtPlugin.displayError("Android Launch", string);
            return false;
        }
        if (!iProject.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
            String string = String.format("%1$s is not an Android project!", iProject.getName());
            AdtPlugin.displayError("Android Launch", string);
            return false;
        }
        return true;
    }

    private String getActivityName(ILaunchConfiguration iLaunchConfiguration) {
        String string;
        String string2 = "";
        try {
            string = iLaunchConfiguration.getAttribute(ATTR_ACTIVITY, string2);
        }
        catch (CoreException coreException) {
            return null;
        }
        return string != string2 ? string : null;
    }

    private final void revertToNoActionLaunch(IProject iProject, AndroidLaunchConfiguration androidLaunchConfiguration) {
        AdtPlugin.printErrorToConsole(iProject, new Object[]{"No Launcher activity found!", "The launch will only sync the application package on the device!"});
        androidLaunchConfiguration.mLaunchAction = 2;
    }
}

